# Alternate Character Sets (2.3 - 1.0.0) - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alternate Character Sets (2.3 - 1.0.0)**

## CodeSystem: Alternate Character Sets (2.3 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/alternateCharacterSets | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:AlternateCharacterSets |
| *Other Identifiers:*OID:2.16.840.1.113883.18.116 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify the character set(s) in use. Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSalternateCharacterSets](ValueSet-hl7VSalternateCharacterSets.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "alternateCharacterSets",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0211"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/alternateCharacterSets",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.116"
    }
  ],
  "version" : "1.0.0",
  "name" : "AlternateCharacterSets",
  "title" : "Alternate Character Sets (2.3 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify the character set(s) in use.  Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "8859/1",
      "display" : "The printable characters from the ISO 8859/1 Character set",
      "definition" : "The printable characters from the ISO 8859/1 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/2",
      "display" : "The printable characters from the ISO 8859/2 Character set",
      "definition" : "The printable characters from the ISO 8859/2 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/3",
      "display" : "The printable characters from the ISO 8859/3 Character set",
      "definition" : "The printable characters from the ISO 8859/3 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/4",
      "display" : "The printable characters from the ISO 8859/4 Character set",
      "definition" : "The printable characters from the ISO 8859/4 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/5",
      "display" : "The printable characters from the ISO 8859/5 Character set",
      "definition" : "The printable characters from the ISO 8859/5 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/6",
      "display" : "The printable characters from the ISO 8859/6 Character set",
      "definition" : "The printable characters from the ISO 8859/6 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/7",
      "display" : "The printable characters from the ISO 8859/7 Character set",
      "definition" : "The printable characters from the ISO 8859/7 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/8",
      "display" : "The printable characters from the ISO 8859/8 Character set",
      "definition" : "The printable characters from the ISO 8859/8 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8859/9",
      "display" : "The printable characters from the ISO 8859/9 Character set",
      "definition" : "The printable characters from the ISO 8859/9 Character set",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ASCII",
      "display" : "The printable 7-bit ASCII character set",
      "definition" : "The printable 7-bit ASCII character set",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This is the default if this field is omitted"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "JAS2020",
      "display" : "A subset of ISO2020 used for most Kanjii transmissions",
      "definition" : "A subset of ISO2020 used for most Kanjii transmissions",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "JIS X 0202",
      "display" : "ISO 2022 with escape sequences for Kanjii",
      "definition" : "ISO 2022 with escape sequences for Kanjii",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UNICODE",
      "display" : "The world wide character standard from ISO/IEC 10646-1-1993",
      "definition" : "The world wide character standard from ISO/IEC 10646-1-1993",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
