# Artifacts Summary - HL7 v2.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [V2CodeSystem](StructureDefinition-V2CodeSystem.md) | Profile for CodeSystem instances generated in this guide. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abnormal Flags (2.2 - 1.1.0)](ValueSet-hl7VSinterpretationCode.md) | A categorical assessment, providing a rough qualitative interpretation of the observation value, such as “normal”/ “abnormal”,”low” / “high”, “better” / “worse”, “susceptible” / “resistant”, “expected”/ “not expected”. The value set is intended to be for ANY use where coded representation of an interpretation is needed. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. The value set binding is extensible, so codes outside the value set that are needed for interpretation concepts (i.e. particular meanings) that are not included in the value set can be used, and these new codes may also be added to the value set and published in a future version. |
| [Accept/Application Acknowledgment Conditions (2.2 - 1.0.0)](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md) | Concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. |
| [Acknowledgment Code (2.2 - 1.1.0)](ValueSet-hl7VSacknowledgmentCode.md) | Concepts specifying acknowledgment codes used in Version 2.x message. For details of usage, see message processing rules in the published Standard. |
| [Active/Inactive (2.2 - 1.0.0)](ValueSet-hl7VSactive-inactive.md) | Value Set of codes that specify whether a person is currently a valid staff member. |
| [Address Type (2.2 - 1.0.0)](ValueSet-hl7VSaddressType.md) | Concepts specifying types or kinds of addresses. |
| [Administration Device (2.2 - 1.0.0)](ValueSet-hl7VSadministrationDevice.md) | Value Set of codes that specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. |
| [Administration Method (2.2 - 1.0.0)](ValueSet-hl7VSadministrationMethod.md) | Value Set of codes that specify the specific method requested for the administration of the drug or treatment to the patient. |
| [Administrative Site (2.2 - 1.0.0)](ValueSet-hl7VSadministriveSite.md) | Concepts that specify a body site from which a specimen is obtained. |
| [Admission Type (2.2 - 1.0.0)](ValueSet-hl7VSadmissionType.md) | Value Set of codes that specify the circumstances under which the patient was or will be admitted. |
| [Allergy Severity (2.2 - 1.0.0)](ValueSet-hl7VSallergySeverity.md) | Value Set of codes that specify the general severity of an allergy. |
| [Allergy Type (2.2 - 1.0.0)](ValueSet-hl7VSallergyType.md) | Value Set of codes that specify classification of general allergy categories (drug, food, pollen, etc.). |
| [Allow Substitution (2.2 - 1.0.0)](ValueSet-hl7VSallowSubstitution.md) | Value Set of codes that specify whether substitutions are allowed and, if so, the type of substitutions allowed. |
| [Ambulatory Status (2.2 - 1.0.0)](ValueSet-hl7VSambulatoryStatus.md) | Value Set of codes that specify permanent or transient handicapped conditions of a person. |
| [Amount Class (2.2 - 1.0.0)](ValueSet-hl7VSamountClass.md) | Value Set of codes that specify the amount quantity class. |
| [Amount Type (2.2 - 1.0.0)](ValueSet-hl7VSamountType.md) | Value Set of codes that specify amount quantity type. |
| [Assignment of Benefits (2.2 - 1.0.0)](ValueSet-hl7VSassignmentOfBenefits.md) | Value Set of codes which indicate whether an insured person agreed to assign the insurance benefits to a healthcare provider. If so, the insurance will pay the provider directly. |
| [Bed Status (2.2 - 1.1.0)](ValueSet-hl7VSbedStatus.md) | Value Set of codes that specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. |
| [Certification Patient Type (2.2 - 1.0.0)](ValueSet-hl7VSprecertificationPatientType.md) | Value Set of codes that specify the category or type of patient for which this certification is requested. |
| [Charge Type (2.2 - 1.0.0)](ValueSet-hl7VSchargeType.md) | Value Set of codes that specify someone or something other than the patient to be billed for a service. |
| [Check Digit Scheme (2.2 - 1.1.0)](ValueSet-hl7VScheckDigitScheme.md) | Concepts used to identify the check digit scheme employed when a check digit is used in various HL7 Version 2.x datatypes. |
| [Confidentiality Code (2.2 - 1.0.0)](ValueSet-hl7VSconfidentialityCode.md) | Value Set of codes that specify the degree to which special confidentiality protection should be applied to the observation. |
| [Coordination of Benefits (2.2 - 1.0.0)](ValueSet-hl7VScoordinationOfBenefits.md) | Value Set of codes that specify whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. |
| [Date/Time Selection Qualifier (2.2 - 1.0.0)](ValueSet-hl7VSdate-timeSelectionQualifier.md) | Value Set of codes that allow the specification of certain types of values within the date/time range. |
| [Day Type (2.2 - 1.0.0)](ValueSet-hl7VSdayType.md) | Value Set of codes that specify whether the days are denied, pending or approved. |
| [Deferred Response Type (2.2 - 1.0.0)](ValueSet-hl7VSdeferredResponseType.md) | Value Set of codes which specify which type of deferred query resonse is desired, as specified with the query parameters. |
| [Delayed Acknowledgement Type (2.2 - 1.1.0)](ValueSet-hl7VSdelayedAcknowledgmentType.md) | Concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging. |
| [Derived Specimen (2.2 - 1.0.0)](ValueSet-hl7VSderivedSpecimen.md) | Value Set of codes that specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The pro |
| [Diagnostic Service Section ID (2.2 - 1.1.0)](ValueSet-hl7VSdiagnosticServiceSectionId.md) | Concepts which specify a section of a diagnostic service where the observation may be performed. |
| [Diet Code Specification Type (2.2 - 1.0.0)](ValueSet-hl7VSdietType.md) | Value Set of codes that specify the type of diet. |
| [Eligibility Source (2.2 - 1.0.0)](ValueSet-hl7VSeligibilitySource.md) | Value Set of codes that specify the source of information about the insured's eligibility for benefits. |
| [Event (2.2 - 1.1.0)](ValueSet-hl7VSevent.md) | Concepts specifying the trigger event for Version 2.x interface messages. |
| [Event Reason (2.2 - 1.1.0)](ValueSet-hl7VSeventReason.md) | Value Set of codes that specify the reason for an event. |
| [File Level Event Code (2.2 - 1.0.0)](ValueSet-hl7VSfile-levelEventCode.md) | Concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [Invocation Event (2.2 - 1.0.0)](ValueSet-hl7VSwhenToCharge.md) | Value Set of codes that specify codes for an event precipitating/triggering a charge activity. |
| [MFN Record-level Error Return (2.2 - 1.0.0)](ValueSet-hl7VSmfnRecode-levelErrorReturn.md) | Concepts which code status values for requested master file record update operations. |
| [Mail Claim Party (2.2 - 1.0.0)](ValueSet-hl7VSmailClaimParty.md) | Value Set of codes that specify a party to which a claim should be mailed when claims are sent by mail. |
| [Marital Status (2.2 - 1.0.0)](ValueSet-hl7VSmaritalStatus.md) | Value Set of codes that specify a person's marital (civil/legal) status. |
| [Master File Identifier Code (2.2 - 1.0.0)](ValueSet-hl7VSmasterFileIdentifierCode.md) | Concepts which are represented by codes identifying HL7Versions 2.x Master Files. |
| [Message Type (2.2 - 1.1.0)](ValueSet-hl7VSmessageType.md) | Concepts which specify message types for HL7 Version 2.x messaging. |
| [Money or Percentage Indicator (2.2 - 1.0.0)](ValueSet-hl7VSpenaltyType.md) | Value Set of codes that specify whether the amount is currency or a percentage. |
| [Nature of Abnormal Testing (2.2 - 1.0.0)](ValueSet-hl7VSnatureOfAbnormalTesting.md) | Value Set of codes that specify the nature of an abnormal test. |
| [Nature of Service/Test/Observation (2.2 - 1.0.0)](ValueSet-hl7VSnatureOfServiceTestObservation.md) | Concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. |
| [Observation Result Status Codes Interpretation (2.2 - 1.1.0)](ValueSet-hl7VSobservationResultStatus.md) | Concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. |
| [Order Control Codes (2.2 - 1.1.0)](ValueSet-hl7VSorderControl.md) | Concepts which are used to determine the function of the order segment. Depending on the message, the action specifies by one of these control codes may refer to an order or an individual service. |
| [Order Status (2.2 - 1.1.0)](ValueSet-hl7VSorderStatus.md) | Value Set of codes that specify the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is as |
| [Patient Class (2.2 - 1.1.0)](ValueSet-hl7VSpatientClass.md) | Concepts used by systems to categorize patients by sites. |
| [Policy Type (2.2 - 1.0.0)](ValueSet-hl7VSpolicyType.md) | Value Set of codes that specify the policy type. |
| [Preferred Method of Contact (2.2 - 1.0.0)](ValueSet-hl7VSpreferredMethodOfContrct.md) | Value Set of codes that specify which of a group of multiple phone numbers is the preferred method of contact for this person. |
| [Priority (2.2 - 1.1.0)](ValueSet-hl7VSpriority.md) | Value Set of codes that specify the allowed priorities for obtaining the specimen. |
| [Procedure Practitioner Identifier Type (2.2 - 1.0.0)](ValueSet-hl7VSprocedurePractitionerType.md) | Value Set of codes of concepts which specify the different types of practitioners associated with this procedure. This set of codes is known to be incomplete. |
| [Processing ID (2.2 - 1.0.0)](ValueSet-hl7VSprocessingId.md) | Value Set of codes that specify whether the message is part of a production, training or debugging system. |
| [Processing Priority (2.2 - 1.0.0)](ValueSet-hl7VSprocessingPriority.md) | Value Set of codes that specify one or more available priorities for performing the observation or test. |
| [Provider Billing (2.2 - 1.0.0)](ValueSet-hl7VSproviderBilling.md) | Value Set of codes that specify how provider services are billed. |
| [Quantity Limited Request (2.2 - 1.1.0)](ValueSet-hl7VSquantityLimitedRequest.md) | Concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. |
| [Query Priority (2.2 - 1.0.0)](ValueSet-hl7VSqueryPriority.md) | Concepts which specify a time frame in which a querry response is expected. |
| [Query Results Level (2.2 - 1.0.0)](ValueSet-hl7VSqueryResultsLevel.md) | Value Set of codes which are used to control level of detail in query results. |
| [Query/Response Format Code (2.2 - 1.1.0)](ValueSet-hl7VSqueryFormatCode.md) | Value Set of codes which specify which of several types of formats for data to be returned in response to a query. |
| [RX Component Type (2.2 - 1.0.0)](ValueSet-hl7VSrxComponentType.md) | Value Set of codes that specify the RX component type. |
| [Record-level Event Code (2.2 - 1.0.0)](ValueSet-hl7VSmasterfileActionCode.md) | Concepts specifying an action for a master file record. Used in HL7 V2.x messaging in the MFE segment. |
| [Report Priority (2.2 - 1.0.0)](ValueSet-hl7VSreportPriority.md) | Value Set of codes which specify the priority associated with a report or update run using a query. |
| [Reporting Priority (2.2 - 1.0.0)](ValueSet-hl7VSreportingPriority.md) | Value Set of codes that specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. |
| [Response Flag (2.2 - 1.0.0)](ValueSet-hl7VSresponseFlag.md) | Value Set of codes allowing the placer (sending) application to determine the amount of information to be returned from the filler. |
| [Response Level (2.2 - 1.0.0)](ValueSet-hl7VSresponseLevel.md) | Concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. |
| [Result Status (2.2 - 1.1.0)](ValueSet-hl7VSresultStatus-Obr.md) | Concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Room Type (2.2 - 1.0.0)](ValueSet-hl7VSroomType.md) | Value Set of codes that specify the room type. |
| [Route of Administration (2.2 - 1.0.0)](ValueSet-hl7VSrouteOfAdministration.md) | Value Set of codes that specify the route of administration. |
| [STOCK LOCATION (2.2 - 1.0.0)](ValueSet-hl7VSstockLocation.md) | Value Set of codes that specify a stock location. |
| [Sex (2.2 - 1.0.0)](ValueSet-hl7VSsex.md) | Concepts specifying a person's sex. |
| [Source of Comment (2.2 - 1.1.0)](ValueSet-hl7VSsourceOfComment.md) | Concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in the NTE segment. |
| [Specimen Action Code (2.2 - 2.0.0)](ValueSet-hl7VSactionCode.md) | Concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). |
| [Specimen Source Codes (2.2 - 1.1.0)](ValueSet-hl7VSsourceOfSpecimen.md) | Value Set of codes which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in table 0487 Specimen Type and table |
| [Substitution Status (2.2 - 1.0.0)](ValueSet-hl7VSsubstitutionStatus.md) | Value Set of codes that specify the substitution status. |
| [Transportation Mode (2.2 - 1.0.0)](ValueSet-hl7VStransportationMode.md) | Value Set of codes that specify how (or whether) to transport a patient, when applicable, for an ordered service. |
| [Tray Type (2.2 - 1.0.0)](ValueSet-hl7VStrayType.md) | Value Set of codes that specify the type of dietary tray. |
| [Type of Referenced Data (2.2 - 1.0.0)](ValueSet-hl7VStypeOfData.md) | Concepts declaring the general type of media data that is encoded. |
| [Version ID (2.2 - 1.1.0)](ValueSet-hl7VSversionControlTable.md) | Concepts which are used to identify an HL7 version in the Version 2.x family of published standards. |
| [What Subject Filter (2.2 - 1.1.0)](ValueSet-hl7VSwhatSubjectFilter.md) | Value Set of codes which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. |
| [Which Date/Time Qualifier (2.2 - 1.0.0)](ValueSet-hl7VSwhichDate-timeQualifier.md) | Value Set of codes that specify the type of date referred to in the other date fields in the QRF segment. |
| [Which Date/Time Status Qualifier (2.2 - 1.0.0)](ValueSet-hl7VSwhichDate-timeStatusQualifier.md) | Value Set of codes that specify the status type of objects selected in date range defined by QRF-2 and QRF-3. |
| [Yes/No Indicator (2.2 - 1.0.0)](ValueSet-hl7VSyes-no-Indicator.md) | Codes specifying either Yes or No used in fields containing binary answers generally user-specified. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abnormal Flags (2.2 - 1.1.0)](CodeSystem-observationInterpretation.md) | HL7-defined code system of concepts which specify a categorical assessment of an observation value. Used in HL7 Version 2.x messaging in the OBX segment. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. |
| [Accept/Application Acknowledgment Conditions (2.2 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md) | HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment. |
| [Acknowledgment Code (2.2 - 1.1.0)](CodeSystem-acknowledgmentCodes.md) | HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see message processing rules in the published Standard. Used in HL7 Version 2.x messaging in the MSA segment. |
| [Active/Inactive (2.2 - 1.0.0)](CodeSystem-active-inactive.md) | HL7-defined code system of concepts specifying whether a person is currently a valid staff member. Used in HL7 Version 2.x messaging in the STF segment. |
| [Address Type (2.2 - 1.0.0)](CodeSystem-addressType.md) | HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.x messaging in the XAD segment. |
| [Administration Device (2.2 - 1.0.0)](CodeSystem-administrationDevice.md) | Code system of concepts which specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Administration Method (2.2 - 1.0.0)](CodeSystem-administrationMethod.md) | Code system of concepts which specify the specific method requested for the administration of the drug or treatment to the patient. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Administrative Site (2.2 - 1.0.0)](CodeSystem-bodySite.md) | HL7-defined code system of concepts that specify a body site from which a specimen is obtained. Used in HL7 Version 2.x messaging in the OBX and CH7 segments. |
| [Admission Type (2.2 - 1.0.0)](CodeSystem-admissionType.md) | Code system of concepts specifying the circumstances under which the patient was or will be admitted. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Allergy Severity (2.2 - 1.0.0)](CodeSystem-allergySeverity.md) | Code system of concepts which specify the general severity of an allergy. Used in HL7 Version 2.x messaging in the AL1 segment. |
| [Allergy Type (2.2 - 1.0.0)](CodeSystem-allergenType.md) | Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.). Used in HL7 Version 2.x messaging in the AL1 segment. |
| [Allow Substitution (2.2 - 1.0.0)](CodeSystem-allowSubstitution.md) | HL7-defined code system of concepts which specify whether substitutions are allowed and, if so, the type of substitutions allowed. Used in HL7 Version 2.x messaging in the RXO segment. |
| [Ambulatory Status (2.2 - 1.0.0)](CodeSystem-ambulatoryStatus.md) | Code system of concepts specifying permanent or transient handicapped conditions of a person. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Amount Class (2.2 - 1.0.0)](CodeSystem-amountClass.md) | Code system of concepts specifying the amount quantity class. Used in HL7 Version 2.x messaging in the PTA segment. |
| [Amount Type (2.2 - 1.0.0)](CodeSystem-amountType.md) | Code system of concepts which specify amount quantity type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [Assignment of Benefits (2.2 - 1.0.0)](CodeSystem-assignmentOfBenefits.md) | Code system of concepts which indicate whether an insured person agreed to assign the insurance benefits to the healthcare provider. If so, the insurance will pay the provider directly. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [Bed Status (2.2 - 1.1.0)](CodeSystem-bedStatus.md) | Code system of concepts which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. Used in HL7 Version 2.x messaging in the DLD and PV1 segments. |
| [Certification Patient Type (2.2 - 1.0.0)](CodeSystem-certificationPatientType.md) | Code system of concepts which specify the category or type of patient for which this certification is requested. Used in HL7 Version 2.x messaging in the ICD segment. |
| [Charge Type (2.2 - 1.0.0)](CodeSystem-chargeType.md) | HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service. Used in HL7 Version 2.x messaging in the BLG segment. |
| [Check Digit Scheme (2.2 - 1.1.0)](CodeSystem-checkDigitScheme.md) | HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Version 2.x messaging in PPN, XCN and XON segments. |
| [Confidentiality Code (2.2 - 1.0.0)](CodeSystem-confidentialityCodes.md) | Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation. Used in HL7 Version 2.x messaging in the OM1 and ORC segments. |
| [Coordination of Benefits (2.2 - 1.0.0)](CodeSystem-coordinationOfBenefits.md) | Code system of concepts specifying whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [Date/Time Selection Qualifier (2.2 - 1.0.0)](CodeSystem-date-timeSelectionQualifier.md) | HL7-defined code system of conceptss that allow the specification of certain types of values within the date/time range. Used in HL7 Vesion 2 messaging in the QRF segment. |
| [Day Type (2.2 - 1.0.0)](CodeSystem-dayType.md) | Code system of concepts which specify whether the days are denied, pending or approved. Used in HL7 Version 2.x messaging in the DTN segment. |
| [Deferred Response Type (2.2 - 1.0.0)](CodeSystem-deferredResponseType.md) | HL7-defined code system of concepts which specify which type of deferred query resonse is desired, as specified with the query parameters. Used in HL7 Version 2 messaging in the QRD segment. |
| [Delayed Acknowledgement Type (2.2 - 1.1.0)](CodeSystem-delayedAcknowledgmentType.md) | HL7-defined code system of concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging and used in the MSH segment. |
| [Derived Specimen (2.2 - 1.0.0)](CodeSystem-derivedSpecimen.md) | HL7-defined code system of concepts which specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The process also produces new "specimens" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [Diagnostic Service Section ID (2.2 - 1.1.0)](CodeSystem-diagnosticServiceSectionId.md) | HL7-defined code system of concepts which specify a section of a diagnostic service where the observation may be performed. Used in HL7 Version 2.x messaging in the OBR and OM4 segments. |
| [Diet Code Specification Type (2.2 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODS segment. |
| [Eligibility Source (2.2 - 1.0.0)](CodeSystem-eligibilitySource.md) | Code system of concepts which specify the source of information about the insured's eligibility for benefits. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [Event (2.2 - 1.1.0)](CodeSystem-event.md) | HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Event Reason (2.2 - 1.1.0)](CodeSystem-eventReason.md) | Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging in the EVN segment. |
| [File Level Event Code (2.2 - 1.0.0)](CodeSystem-file-levelEvent.md) | HL7-defined code system of concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [Invocation Event (2.2 - 1.0.0)](CodeSystem-invocationEvent.md) | HL7-defined code system of concepts which specify codes for an event precipitating/triggering a charge activity. Used in HL7 Version 2.x messaging in the CCD and BLG segments. |
| [MFN Record-level Error Return (2.2 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md) | Code system of concepts specifying the status of the requested update. Site-defined table, specific to each master file being updated via this transaction. Used in HL7 Version 2.x messaging in the MFA segment. |
| [Mail Claim Party (2.2 - 1.0.0)](CodeSystem-mailClaimParty.md) | Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [Marital Status (2.2 - 1.0.0)](CodeSystem-maritalStatus.md) | Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.x messages in the PID segment. |
| [Master File Identifier Code (2.2 - 1.0.0)](CodeSystem-masterFileIdentifierCodes.md) | HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files. Used in HL7 Version 2.x messaging in the MFI segment. |
| [Message Type (2.2 - 1.1.0)](CodeSystem-messageType.md) | HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Money or Percentage Indicator (2.2 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md) | HL7-defined code system of concepts which specify whether the amount is currency or a percentage. Used in HL7 Version 2.x messaging in the MOP segment. |
| [Nature of Abnormal Testing (2.2 - 1.0.0)](CodeSystem-natureOfAbnormalTesting.md) | HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Nature of Service/Test/Observation (2.2 - 1.0.0)](CodeSystem-natureOfServiceTestObservation.md) | Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Observation Result Status Codes Interpretation (2.2 - 1.1.0)](CodeSystem-observationResultStatusCodesInterpretation.md) | HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Order Control Codes (2.2 - 1.1.0)](CodeSystem-orderControlCodes.md) | HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. |
| [Order Status (2.2 - 1.1.0)](CodeSystem-orderStatus.md) | HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent. Only the filler can originate these values. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Patient Class (2.2 - 1.1.0)](CodeSystem-patientClass.md) | Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment. |
| [Policy Type (2.2 - 1.0.0)](CodeSystem-policyType.md) | Code system of concepts which specify the policy type. Used in HL7 Version 2.x messaging in the PTA segment. |
| [Preferred Method of Contact (2.2 - 1.0.0)](CodeSystem-preferredMethodOfContact.md) | HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person. Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments. |
| [Priority (2.2 - 1.1.0)](CodeSystem-priority.md) | HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [Procedure Practitioner Identifier Type (2.2 - 1.0.0)](CodeSystem-procedurePractitionerIdentifierCodeType.md) | HL7-defined table of concepts which specify the different types of practitioners associated with this procedure. This set of codes is known to be incomplete. Note that as of v2.6, this table and the field(s) it was used in was replaced by table 443 used in the ROL segment. Used in Version 2.x messaging in the PR1 segment, but was discontinued as of 2.6; usage replaced with code system 2.16.840.1.113883.18.283 providerRole. |
| [Processing ID (2.2 - 1.0.0)](CodeSystem-processingId.md) | HL7-defined code system of concepts which specify whether the message is part of a production, training or debugging system. Used in HL7 Version 2.x messaging in the PT datatype. |
| [Processing Priority (2.2 - 1.0.0)](CodeSystem-processingPriority.md) | HL7-defined code system of concepts which specify one or more available priorities for performing the observation or test. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Provider Billing (2.2 - 1.0.0)](CodeSystem-providerBilling.md) | HL7-defined code system of concepts specifying how provider services are billed. Used in HL7 Version 2.x messaging in the PRA segment. |
| [Quantity Limited Request (2.2 - 1.1.0)](CodeSystem-quantityLimitedRequest.md) | HL7-defined code system of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. Used in HL7 Version 2.x messaging in the RCP segment. |
| [Query Priority (2.2 - 1.0.0)](CodeSystem-queryPriority.md) | HL7-defined code system of concepts which specify a time frame in which a querry response is expected. Used in HL7 Verson 2.x messaging in the RCP segment. |
| [Query Results Level (2.2 - 1.0.0)](CodeSystem-queryResultsLevel.md) | HL7-defined code system of concepts which are used to control level of detail in query results. Used in HL7 Version 2 messaging in the URD segment. |
| [Query/Response Format Code (2.2 - 1.1.0)](CodeSystem-queryResponseFormat.md) | HL7-defined code system of concepts which specify which of several types of formats for data to be returned in response to a query. Used in HL7 Version 2 messaging in the EQL segment. |
| [RX Component Type (2.2 - 1.0.0)](CodeSystem-rxComponentType.md) | HL7-defined code system of concepts which specify the RX component type. Used in HL7 Version 2.x messaging in the RXC segment. |
| [Record-level Event Code (2.2 - 1.0.0)](CodeSystem-masterfileActionCode.md) | HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Version 2.x messaging in the MFE segment. |
| [Report Priority (2.2 - 1.0.0)](CodeSystem-reportPriority.md) | HL7-defined code system of concepts which specify the priority associated with a report or update run using a query. Used in HL7 Version 2 messaging in the URD segment. |
| [Reporting Priority (2.2 - 1.0.0)](CodeSystem-reportingPriority.md) | HL7-defined code system of concepts which specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Response Flag (2.2 - 1.0.0)](CodeSystem-responseFlag.md) | HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Response Level (2.2 - 1.0.0)](CodeSystem-responseLevel.md) | HL7-defined code system of concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. Used in HL7 Version 2.x messaging in the MFI segment. |
| [Result Status (2.2 - 1.1.0)](CodeSystem-resultStatus.md) | HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Room Type (2.2 - 1.0.0)](CodeSystem-roomType.md) | Code system of concepts which specify the room type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [Route of Administration (2.2 - 1.0.0)](CodeSystem-routeOfAdministration.md) | Code system of concepts which specify the route of administration. Used in HL7 Version 2.x messaging in the RXR segment. |
| [STOCK LOCATION (2.2 - 1.0.0)](CodeSystem-stockLocation.md) | Code system of concepts specifying a stock location for older Version 2 messaging systems; not used after version 2.2 of the Standard. |
| [Sex (2.2 - 1.0.0)](CodeSystem-sex.md) | HL7-defined code system of concepts specifying a person's sex. |
| [Source of Comment (2.2 - 1.1.0)](CodeSystem-sourceOfComment.md) | HL7-defined code system of concepts which are used to specify the source of a comment. Used in HL7 Version 2.x messaging in the NTE segment. |
| [Specimen Action Code (2.2 - 2.0.0)](CodeSystem-specimenAction.md) | HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). Used in HL7 Version 2.x messaging in the OBR segment. |
| [Specimen Source Codes (2.2 - 1.1.0)](CodeSystem-specimenSourceCodes.md) | HL7-defined code system of concepts which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in code system 2.16.840.1.133883.18.311 specimenType and code system 2.16.840.1.133883.18.312 specimenCollectionMethod as of version 2.5 and thereafter. |
| [Substitution Status (2.2 - 1.0.0)](CodeSystem-substitutionStatus.md) | HL7-defined code system of concepts which specify the substitution status. Used in HL7 Version 2.x messaging in the RXE, RXD, and RXG segments. |
| [Transportation Mode (2.2 - 1.0.0)](CodeSystem-transportationMode.md) | HL7-defined code system of concepts which specify how (or whether) to transport a patient, when applicable, for an ordered service. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Tray Type (2.2 - 1.0.0)](CodeSystem-trayType.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODT segment. |
| [Type of Referenced Data (2.2 - 1.0.0)](CodeSystem-typeOfReferencedData.md) | HL7-defined code system of concepts declaring the general type of media data that is encoded. Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types). More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml |
| [Version ID (2.2 - 1.1.0)](CodeSystem-versionId.md) | HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards. Used in HL7 Version 2.x messaging in the VID segment. |
| [What Subject Filter (2.2 - 1.1.0)](CodeSystem-whatSubjectFilter.md) | HL7-defined code system of concepts which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. Used in HL7 Version 2 messaging in the URD segment. |
| [Which Date/Time Qualifier (2.2 - 1.0.0)](CodeSystem-whichDate-timeQualifier.md) | HL7-defined code system of concepts that specify a type of date referred to in query specifications. Used in HL7 Version 2 messaging in the QRF segment. |
| [Which Date/Time Status Qualifier (2.2 - 1.0.0)](CodeSystem-whichDate-timeStatusQualifier.md) | HL7-defined code system of concepts that specify the status type of objects selected in a date range. Used in HL7 Vesion 2 messaging in the QRF segment. |
| [Yes/No Indicator (2.2 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md) | HL7-defined code system of concepts used to specify an expansion on the original Yes/No indicator table by including "flavors of null". It is intended to be applied to fields where the response is not limited to "yes" or "no". Used in numerous locations in HL7 Version 2.x messaging. |

