# Which Date/Time Status Qualifier (2.2 - 1.0.0) - HL7 v2.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Which Date/Time Status Qualifier (2.2 - 1.0.0)**

## CodeSystem: Which Date/Time Status Qualifier (2.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/whichDate-timeStatusQualifier | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:WhichDate-timeStatusQualifier |
| *Other Identifiers:*OID:2.16.840.1.113883.18.75 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that specify the status type of objects selected in a date range. Used in HL7 Vesion 2 messaging in the QRF segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSwhichDate-timeStatusQualifier](ValueSet-hl7VSwhichDate-timeStatusQualifier.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "whichDate-timeStatusQualifier",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0157"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/whichDate-timeStatusQualifier",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.75"
    }
  ],
  "version" : "1.0.0",
  "name" : "WhichDate-timeStatusQualifier",
  "title" : "Which Date/Time Status Qualifier (2.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:16:46+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that specify the status type of objects selected in a date range.  Used in HL7 Vesion 2 messaging in the QRF segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ANY",
      "display" : "Any status",
      "definition" : "Any status",
      "designation" : [
        {
          "language" : "de",
          "value" : "Beliebiger Status"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "CFN",
      "display" : "Current final value, whether final or corrected",
      "definition" : "Current final value (whether final or corrected)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aktuelles Endergebnis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "COR",
      "display" : "Corrected only (no final with corrections)",
      "definition" : "Corrected only (no final with corrections)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ursprüngliche Ergebnisse, die später korrigiert wurden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "FIN",
      "display" : "Final only (no corrections)",
      "definition" : "Final only (no corrections)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Endergebnisse,  die niemals korrigiert wurden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PRE",
      "display" : "Preliminary",
      "definition" : "Preliminary",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vorläufig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "REP",
      "display" : "Report completion date/time",
      "definition" : "Report completion date / time",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bericht abgeschlossen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
