# Route of Administration (2.2 - 1.0.0) - HL7 v2.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Route of Administration (2.2 - 1.0.0)**

## CodeSystem: Route of Administration (2.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/routeOfAdministration | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:RouteOfAdministration |
| *Other Identifiers:*OID:2.16.840.1.113883.18.80 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the route of administration. Used in HL7 Version 2.x messaging in the RXR segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSrouteOfAdministration](ValueSet-hl7VSrouteOfAdministration.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "routeOfAdministration",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0162"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/routeOfAdministration",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.80"
    }
  ],
  "version" : "1.0.0",
  "name" : "RouteOfAdministration",
  "title" : "Route of Administration (2.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:16:46+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts  which specify the route of administration.  Used in HL7 Version 2.x messaging in the RXR segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AP",
      "display" : "Apply Externally",
      "definition" : "Apply Externally",
      "designation" : [
        {
          "language" : "de",
          "value" : "Externe Applikation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "B",
      "display" : "Buccal",
      "definition" : "Buccal",
      "designation" : [
        {
          "language" : "de",
          "value" : "buccal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "DT",
      "display" : "Dental",
      "definition" : "Dental",
      "designation" : [
        {
          "language" : "de",
          "value" : "dental"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "GTT",
      "display" : "Gastronomy Tube",
      "definition" : "Gastronomy Tube",
      "designation" : [
        {
          "language" : "de",
          "value" : "Magenschlauch"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "GU",
      "display" : "GU Irrigant",
      "definition" : "GU Irrigant",
      "designation" : [
        {
          "language" : "de",
          "value" : "Magenspülung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IA",
      "display" : "Intra-arterial",
      "definition" : "Intra-arterial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intraarteriell"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IC",
      "display" : "Intracardiac",
      "definition" : "Intracardiac",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intracardial"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ID",
      "display" : "Intradermal",
      "definition" : "Intradermal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intradermal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IH",
      "display" : "Inhalation",
      "definition" : "Inhalation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Inhalation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "Intramuscular",
      "definition" : "Intramuscular",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intramuskulär"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "Intranasal",
      "definition" : "Intranasal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intranasal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IO",
      "display" : "Intraocular",
      "definition" : "Intraocular",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intraokular"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IP",
      "display" : "Intraperitoneal",
      "definition" : "Intraperitoneal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intraperitoneal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IS",
      "display" : "Intrasynovial",
      "definition" : "Intrasynovial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intrasynovial"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IT",
      "display" : "Intrathecal",
      "definition" : "Intrathecal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intrathekal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IV",
      "display" : "Intravenous",
      "definition" : "Intravenous",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intravenös"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "NG",
      "display" : "Nasogastric",
      "definition" : "Nasogastric",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nasogastral"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "NS",
      "display" : "Nasal",
      "definition" : "Nasal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nasal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Ophthalmic",
      "definition" : "Ophthalmic",
      "designation" : [
        {
          "language" : "de",
          "value" : "In das Auge"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OT",
      "display" : "Otic",
      "definition" : "Otic",
      "designation" : [
        {
          "language" : "de",
          "value" : "In das Ohr"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PO",
      "display" : "Oral",
      "definition" : "Oral",
      "designation" : [
        {
          "language" : "de",
          "value" : "Oral"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PR",
      "display" : "Rectal",
      "definition" : "Rectal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rektal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "Subcutaneous",
      "definition" : "Subcutaneous",
      "designation" : [
        {
          "language" : "de",
          "value" : "Subkutan"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SL",
      "display" : "Sublingual",
      "definition" : "Sublingual",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sublingual"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "TD",
      "display" : "Transdermal",
      "definition" : "Transdermal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Transdermal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "TL",
      "display" : "Translingual",
      "definition" : "Translingual",
      "designation" : [
        {
          "language" : "de",
          "value" : "Translingual"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "TP",
      "display" : "Topical",
      "definition" : "Topical",
      "designation" : [
        {
          "language" : "de",
          "value" : "Lokal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UR",
      "display" : "Urethral",
      "definition" : "Urethral",
      "designation" : [
        {
          "language" : "de",
          "value" : "Urethral"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "VG",
      "display" : "Vaginal",
      "definition" : "Vaginal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vaginal"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
