# Allow Substitution (2.2 - 1.0.0) - HL7 v2.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Allow Substitution (2.2 - 1.0.0)**

## CodeSystem: Allow Substitution (2.2 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/allowSubstitution | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:AllowSubstitution |
| *Other Identifiers:*OID:2.16.840.1.113883.18.79 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify whether substitutions are allowed and, if so, the type of substitutions allowed. Used in HL7 Version 2.x messaging in the RXO segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSallowSubstitution](ValueSet-hl7VSallowSubstitution.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "allowSubstitution",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0161"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/allowSubstitution",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.79"
    }
  ],
  "version" : "1.0.0",
  "name" : "AllowSubstitution",
  "title" : "Allow Substitution (2.2 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:16:46+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts  which specify whether substitutions are allowed and, if so, the type of substitutions allowed.    Used in HL7 Version 2.x messaging in the RXO segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "G",
      "display" : "Allow generic substitutions",
      "definition" : "Allow generic substitutions",
      "designation" : [
        {
          "language" : "de",
          "value" : "Substitution durch Generika erlaubt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Substitutions are NOT authorized",
      "definition" : "Substitutions are not authorized",
      "designation" : [
        {
          "language" : "de",
          "value" : "Substitution nicht erlaubt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This is the default - null."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Allow therapeutic substitutions",
      "definition" : "Allow therapeutic substitutions",
      "designation" : [
        {
          "language" : "de",
          "value" : "Therapieorientierte Substitution erlaubt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
