# What Subject Filter (2.2 - 1.1.0) - HL7 v2.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **What Subject Filter (2.2 - 1.1.0)**

## CodeSystem: What Subject Filter (2.2 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/whatSubjectFilter | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:WhatSubjectFilter |
| *Other Identifiers:*OID:2.16.840.1.113883.18.20 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. Used in HL7 Version 2 messaging in the URD segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSwhatSubjectFilter](ValueSet-hl7VSwhatSubjectFilter.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "whatSubjectFilter",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0048"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/whatSubjectFilter",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.20"
    }
  ],
  "version" : "1.1.0",
  "name" : "WhatSubjectFilter",
  "title" : "What Subject Filter (2.2 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:16:46+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify the kind of information that is required to satisfy a query request.  The values define the type of transaction inquiry.  Used in HL7 Version 2 messaging in the URD segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "ADV",
      "display" : "Advice/diagnosis",
      "definition" : "Advice / diagnosis",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ratschlag / Diagnose"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "ANU",
      "display" : "Nursing unit lookup (returns patients in beds, excluding empty beds)",
      "definition" : "Nursing unit lookup (returns patients in beds, excluding empty beds)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stationsinformation (ohne freie Betten)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "APA",
      "display" : "Account number query, return matching visit",
      "definition" : "Account number query, return matching visit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Krankenhausaufenthalt (Falldaten) zu gegebener Abrechnungsnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "APM",
      "display" : "Medical record number query, returns visits for a medical record number",
      "definition" : "Medical record number query, returns visits for a medical record number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Krankenhausaufenthalte (Fälle) des spezifizierten Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "APN",
      "display" : "Patient name lookup",
      "definition" : "Patient name lookup",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patientendaten zu gegebenem Patientennamen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "APP",
      "display" : "Physician lookup",
      "definition" : "Physician lookup",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patienten des spezifizierten Arztes"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ARN",
      "display" : "Nursing unit lookup (returns patients in beds, including empty beds)",
      "definition" : "Nursing unit lookup (returns patients in beds, including empty beds)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stationsinformation (einschließlich freier Betten)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "CAN",
      "display" : "Cancel (used to cancel a query)",
      "definition" : "Cancel (used to cancel a query)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage stornieren"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DEM",
      "display" : "Demographics",
      "definition" : "Demographics",
      "designation" : [
        {
          "language" : "de",
          "value" : "Demographische Daten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "FIN",
      "display" : "Financial",
      "definition" : "Financial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Finanzdaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "MRI",
      "display" : "Most recent inpatient",
      "definition" : "Most recent inpatient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Letzter stationärer Patient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "MRO",
      "display" : "Most recent outpatient",
      "definition" : "Most recent outpatient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Letzter ambulanter Patient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "NCK",
      "display" : "Network clock",
      "definition" : "Network clock",
      "designation" : [
        {
          "language" : "de",
          "value" : "Netzwerk-Uhrzeit"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "NSC",
      "display" : "Network status change",
      "definition" : "Network status change",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung des Netzwerkstatus"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "NST",
      "display" : "Network statistic",
      "definition" : "Network statistic",
      "designation" : [
        {
          "language" : "de",
          "value" : "Netzwerkstatistik"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ORD",
      "display" : "Order",
      "definition" : "Order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag / Verordnung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OTH",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "anderes"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "PRO",
      "display" : "Procedure",
      "definition" : "Procedure",
      "designation" : [
        {
          "language" : "de",
          "value" : "Prozedur"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RAR",
      "display" : "Pharmacy administration information",
      "definition" : "Pharmacy administration information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Erfolgte Verabreichung von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RDR",
      "display" : "Pharmacy dispense information",
      "definition" : "Pharmacy dispense information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgabe von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RER",
      "display" : "Pharmacy encoded order information",
      "definition" : "Pharmacy encoded order information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Medikamentenverordnung (Apotheke)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "RES",
      "display" : "Result",
      "definition" : "Result",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ergebnis / Befund"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RGR",
      "display" : "Pharmacy give information",
      "definition" : "Pharmacy give information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verabreichunsgsvorschrift für Medikamente"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ROR",
      "display" : "Pharmacy prescription information",
      "definition" : "Pharmacy prescription information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Medikamentenverordnung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "STA",
      "display" : "Status",
      "definition" : "Status",
      "designation" : [
        {
          "language" : "de",
          "value" : "Status"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
