# Acknowledgment Code (2.2 - 1.1.0) - HL7 v2.2 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Acknowledgment Code (2.2 - 1.1.0)**

## CodeSystem: Acknowledgment Code (2.2 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/acknowledgmentCodes | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:AcknowledgmentCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.10 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see message processing rules in the published Standard. Used in HL7 Version 2.x messaging in the MSA segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSacknowledgmentCode](ValueSet-hl7VSacknowledgmentCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "acknowledgmentCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.2"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0008"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/acknowledgmentCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.10"
    }
  ],
  "version" : "1.1.0",
  "name" : "AcknowledgmentCodes",
  "title" : "Acknowledgment Code (2.2 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:16:46+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying acknowledgment codes.  For details of usage, see message processing rules in the published Standard.  Used in HL7 Version 2.x messaging in the MSA segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "ackType",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#ackType",
      "description" : "ackType",
      "type" : "code"
    },
    {
      "code" : "ackValue",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#ackValue",
      "description" : "ackValue",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AA",
      "display" : "Application accept (original mode) / Application acknowledgement: accept (enhanced mode)",
      "definition" : "Application accept (original mode) / Application acknowledgement: accept (enhanced mode)",
      "designation" : [
        {
          "language" : "de",
          "value" : "akzeptiert durch Anwendung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "ackType",
          "valueCode" : "application"
        },
        {
          "code" : "ackValue",
          "valueCode" : "accept"
        }
      ]
    },
    {
      "code" : "AE",
      "display" : "Application error (original mode) / Application acknowledgement: error (enhanced mode)",
      "definition" : "Application error (original mode) / Application acknowledgement: error (enhanced mode)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fehler in Anwendung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "ackType",
          "valueCode" : "application"
        },
        {
          "code" : "ackValue",
          "valueCode" : "error"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Application reject (original mode) / Application acknowledgement: reject (enhanced mode)",
      "definition" : "Application reject (original mode) / Application acknowledgement: reject (enhanced mode)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgelehnt durch Anwendung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "ackType",
          "valueCode" : "application"
        },
        {
          "code" : "ackValue",
          "valueCode" : "reject"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "Enhanced mode: Accept acknowledgment: Commit Accept",
      "definition" : "Enhanced mode:  Application acknowledgement:  Commit Accept",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bei Eingangsprüfung akzeptiert (\"committed\")"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "ackType",
          "valueCode" : "commit"
        },
        {
          "code" : "ackValue",
          "valueCode" : "accept"
        }
      ]
    },
    {
      "code" : "CE",
      "display" : "Enhanced mode: Accept acknowledgment: Commit Error",
      "definition" : "Enhanced mode:  Application acknowledgement:  Commit Error",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fehler bei Eingangsprüfung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "ackType",
          "valueCode" : "commit"
        },
        {
          "code" : "ackValue",
          "valueCode" : "error"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "Enhanced mode: Accept acknowledgment: Commit Reject",
      "definition" : "Enhanced mode:  Application acknowledgement:  Commit Reject",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bei Eingangsprüfung abgelehnt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "ackType",
          "valueCode" : "commit"
        },
        {
          "code" : "ackValue",
          "valueCode" : "reject"
        }
      ]
    }
  ]
}

```
