# Event Reason (2.1 - 1.0.0) - HL7 v2.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Event Reason (2.1 - 1.0.0)**

## CodeSystem: Event Reason (2.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/eventReason | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:EventReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.23 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging in the EVN segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSeventReason](ValueSet-hl7VSeventReason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "eventReason",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0062"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/eventReason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.23"
    }
  ],
  "version" : "1.0.0",
  "name" : "EventReason",
  "title" : "Event Reason (2.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:20:25+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts which specify the reason for an event.  Used in HL7 Version 2.x messaging in the EVN segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "id" : "364",
      "code" : "01",
      "display" : "Patient Request",
      "definition" : "Patient Request",
      "designation" : [
        {
          "language" : "de",
          "value" : "Veranlassung durch Patient"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "365",
      "code" : "02",
      "display" : "Physician Order",
      "definition" : "Physician Order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verordnung durch Arzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
