# Artifacts Summary - HL7 v2.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [V2CodeSystem](StructureDefinition-V2CodeSystem.md) | Profile for CodeSystem instances generated in this guide. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abnormal Flags (2.1 - 1.0.0)](ValueSet-hl7VSinterpretationCode.md) | A categorical assessment, providing a rough qualitative interpretation of the observation value, such as “normal”/ “abnormal”,”low” / “high”, “better” / “worse”, “susceptible” / “resistant”, “expected”/ “not expected”. The value set is intended to be for ANY use where coded representation of an interpretation is needed. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. The value set binding is extensible, so codes outside the value set that are needed for interpretation concepts (i.e. particular meanings) that are not included in the value set can be used, and these new codes may also be added to the value set and published in a future version. |
| [Acknowledgment Code (2.1 - 1.0.0)](ValueSet-hl7VSacknowledgmentCode.md) | Concepts specifying acknowledgment codes used in Version 2.x message. For details of usage, see message processing rules in the published Standard. |
| [Admission Type (2.1 - 1.0.0)](ValueSet-hl7VSadmissionType.md) | Value Set of codes that specify the circumstances under which the patient was or will be admitted. |
| [Ambulatory Status (2.1 - 1.0.0)](ValueSet-hl7VSambulatoryStatus.md) | Value Set of codes that specify permanent or transient handicapped conditions of a person. |
| [Bed Status (2.1 - 1.0.0)](ValueSet-hl7VSbedStatus.md) | Value Set of codes that specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. |
| [Charge Type (2.1 - 1.0.0)](ValueSet-hl7VSchargeType.md) | Value Set of codes that specify someone or something other than the patient to be billed for a service. |
| [Check Digit Scheme (2.1 - 1.0.0)](ValueSet-hl7VScheckDigitScheme.md) | Concepts used to identify the check digit scheme employed when a check digit is used in various HL7 Version 2.x datatypes. |
| [Deferred Response Type (2.1 - 1.0.0)](ValueSet-hl7VSdeferredResponseType.md) | Value Set of codes which specify which type of deferred query resonse is desired, as specified with the query parameters. |
| [Delayed Acknowledgement Type (2.1 - 1.0.0)](ValueSet-hl7VSdelayedAcknowledgmentType.md) | Concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging. |
| [Diagnostic Service Section ID (2.1 - 1.0.0)](ValueSet-hl7VSdiagnosticServiceSectionId.md) | Concepts which specify a section of a diagnostic service where the observation may be performed. |
| [ETHNIC GROUP (2.1 - 1.0.0)](ValueSet-hl7VSethnicGroup.md) | Concepts specifying the ethnicity of a patient. |
| [Event (2.1 - 1.0.0)](ValueSet-hl7VSevent.md) | Concepts specifying the trigger event for Version 2.x interface messages. |
| [Event Reason (2.1 - 1.0.0)](ValueSet-hl7VSeventReason.md) | Value Set of codes that specify the reason for an event. |
| [Invocation Event (2.1 - 1.0.0)](ValueSet-hl7VSwhenToCharge.md) | Value Set of codes that specify codes for an event precipitating/triggering a charge activity. |
| [Marital Status (2.1 - 1.0.0)](ValueSet-hl7VSmaritalStatus.md) | Value Set of codes that specify a person's marital (civil/legal) status. |
| [Message Type (2.1 - 1.0.0)](ValueSet-hl7VSmessageType.md) | Concepts which specify message types for HL7 Version 2.x messaging. |
| [Nature of Abnormal Testing (2.1 - 1.0.0)](ValueSet-hl7VSnatureOfAbnormalTesting.md) | Value Set of codes that specify the nature of an abnormal test. |
| [Observation Result Status Codes Interpretation (2.1 - 1.0.0)](ValueSet-hl7VSobservationResultStatus.md) | Concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. |
| [Order Control Codes (2.1 - 1.0.0)](ValueSet-hl7VSorderControl.md) | Concepts which are used to determine the function of the order segment. Depending on the message, the action specifies by one of these control codes may refer to an order or an individual service. |
| [Order Status (2.1 - 1.0.0)](ValueSet-hl7VSorderStatus.md) | Value Set of codes that specify the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is as |
| [Patient Class (2.1 - 1.0.0)](ValueSet-hl7VSpatientClass.md) | Concepts used by systems to categorize patients by sites. |
| [Priority (2.1 - 1.0.0)](ValueSet-hl7VSpriority.md) | Value Set of codes that specify the allowed priorities for obtaining the specimen. |
| [Processing ID (2.1 - 1.0.0)](ValueSet-hl7VSprocessingId.md) | Value Set of codes that specify whether the message is part of a production, training or debugging system. |
| [Quantity Limited Request (2.1 - 1.0.0)](ValueSet-hl7VSquantityLimitedRequest.md) | Concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. |
| [Query Priority (2.1 - 1.0.0)](ValueSet-hl7VSqueryPriority.md) | Concepts which specify a time frame in which a querry response is expected. |
| [Query Results Level (2.1 - 1.0.0)](ValueSet-hl7VSqueryResultsLevel.md) | Value Set of codes which are used to control level of detail in query results. |
| [Query/Response Format Code (2.1 - 1.0.0)](ValueSet-hl7VSqueryFormatCode.md) | Value Set of codes which specify which of several types of formats for data to be returned in response to a query. |
| [ROUTE (2.1 - 1.0.0)](ValueSet-hl7VSroute.md) | Value Set of codes that are used to indicate a means of administrating a medication dose. |
| [Religion (2.1 - 1.0.0)](ValueSet-hl7VSreligion.md) | Value Set of codes that specify a person's religion. |
| [Report Priority (2.1 - 1.0.0)](ValueSet-hl7VSreportPriority.md) | Value Set of codes which specify the priority associated with a report or update run using a query. |
| [Response Flag (2.1 - 1.0.0)](ValueSet-hl7VSresponseFlag.md) | Value Set of codes allowing the placer (sending) application to determine the amount of information to be returned from the filler. |
| [Result Status (2.1 - 1.0.0)](ValueSet-hl7VSresultStatus-Obr.md) | Concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [STOCK LOCATION (2.1 - 1.0.0)](ValueSet-hl7VSstockLocation.md) | Value Set of codes that specify a stock location. |
| [Sex (2.1 - 1.0.0)](ValueSet-hl7VSsex.md) | Concepts specifying a person's sex. |
| [Source of Comment (2.1 - 1.0.0)](ValueSet-hl7VSsourceOfComment.md) | Concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in the NTE segment. |
| [Specimen Action Code (2.1 - 1.0.0)](ValueSet-hl7VSactionCode.md) | Concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). |
| [Specimen Source Codes (2.1 - 1.0.0)](ValueSet-hl7VSsourceOfSpecimen.md) | Value Set of codes which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in table 0487 Specimen Type and table |
| [Transportation Mode (2.1 - 1.0.0)](ValueSet-hl7VStransportationMode.md) | Value Set of codes that specify how (or whether) to transport a patient, when applicable, for an ordered service. |
| [Version ID (2.1 - 1.0.0)](ValueSet-hl7VSversionControlTable.md) | Concepts which are used to identify an HL7 version in the Version 2.x family of published standards. |
| [What Subject Filter (2.1 - 1.0.0)](ValueSet-hl7VSwhatSubjectFilter.md) | Value Set of codes which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abnormal Flags (2.1 - 1.0.0)](CodeSystem-observationInterpretation.md) | HL7-defined code system of concepts which specify a categorical assessment of an observation value. Used in HL7 Version 2.x messaging in the OBX segment. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. |
| [Acknowledgment Code (2.1 - 1.0.0)](CodeSystem-acknowledgmentCodes.md) | HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see message processing rules in the published Standard. Used in HL7 Version 2.x messaging in the MSA segment. |
| [Admission Type (2.1 - 1.0.0)](CodeSystem-admissionType.md) | Code system of concepts specifying the circumstances under which the patient was or will be admitted. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Ambulatory Status (2.1 - 1.0.0)](CodeSystem-ambulatoryStatus.md) | Code system of concepts specifying permanent or transient handicapped conditions of a person. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Bed Status (2.1 - 1.0.0)](CodeSystem-bedStatus.md) | Code system of concepts which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. Used in HL7 Version 2.x messaging in the DLD and PV1 segments. |
| [Charge Type (2.1 - 1.0.0)](CodeSystem-chargeType.md) | HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service. Used in HL7 Version 2.x messaging in the BLG segment. |
| [Check Digit Scheme (2.1 - 1.0.0)](CodeSystem-checkDigitScheme.md) | HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Version 2.x messaging in PPN, XCN and XON segments. |
| [Deferred Response Type (2.1 - 1.0.0)](CodeSystem-deferredResponseType.md) | HL7-defined code system of concepts which specify which type of deferred query resonse is desired, as specified with the query parameters. Used in HL7 Version 2 messaging in the QRD segment. |
| [Delayed Acknowledgement Type (2.1 - 1.0.0)](CodeSystem-delayedAcknowledgmentType.md) | HL7-defined code system of concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging and used in the MSH segment. |
| [Diagnostic Service Section ID (2.1 - 1.0.0)](CodeSystem-diagnosticServiceSectionId.md) | HL7-defined code system of concepts which specify a section of a diagnostic service where the observation may be performed. Used in HL7 Version 2.x messaging in the OBR and OM4 segments. |
| [ETHNIC GROUP (2.1 - 1.0.0)](CodeSystem-ethnicGroup.md) | HL7-defined code system of concepts specifying the patient's race for administrative transactions. Note replaced with the CDC code system 2.16.840.1.113883.6.238 as of version 2.2. |
| [Event (2.1 - 1.0.0)](CodeSystem-event.md) | HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Event Reason (2.1 - 1.0.0)](CodeSystem-eventReason.md) | Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging in the EVN segment. |
| [Invocation Event (2.1 - 1.0.0)](CodeSystem-invocationEvent.md) | HL7-defined code system of concepts which specify codes for an event precipitating/triggering a charge activity. Used in HL7 Version 2.x messaging in the CCD and BLG segments. |
| [Marital Status (2.1 - 1.0.0)](CodeSystem-maritalStatus.md) | Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.x messages in the PID segment. |
| [Message Type (2.1 - 1.0.0)](CodeSystem-messageType.md) | HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Nature of Abnormal Testing (2.1 - 1.0.0)](CodeSystem-natureOfAbnormalTesting.md) | HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Observation Result Status Codes Interpretation (2.1 - 1.0.0)](CodeSystem-observationResultStatusCodesInterpretation.md) | HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Order Control Codes (2.1 - 1.0.0)](CodeSystem-orderControlCodes.md) | HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. |
| [Order Status (2.1 - 1.0.0)](CodeSystem-orderStatus.md) | HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent. Only the filler can originate these values. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Patient Class (2.1 - 1.0.0)](CodeSystem-patientClass.md) | Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment. |
| [Priority (2.1 - 1.0.0)](CodeSystem-priority.md) | HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [Processing ID (2.1 - 1.0.0)](CodeSystem-processingId.md) | HL7-defined code system of concepts which specify whether the message is part of a production, training or debugging system. Used in HL7 Version 2.x messaging in the PT datatype. |
| [Quantity Limited Request (2.1 - 1.0.0)](CodeSystem-quantityLimitedRequest.md) | HL7-defined code system of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. Used in HL7 Version 2.x messaging in the RCP segment. |
| [Query Priority (2.1 - 1.0.0)](CodeSystem-queryPriority.md) | HL7-defined code system of concepts which specify a time frame in which a querry response is expected. Used in HL7 Verson 2.x messaging in the RCP segment. |
| [Query Results Level (2.1 - 1.0.0)](CodeSystem-queryResultsLevel.md) | HL7-defined code system of concepts which are used to control level of detail in query results. Used in HL7 Version 2 messaging in the URD segment. |
| [Query/Response Format Code (2.1 - 1.0.0)](CodeSystem-queryResponseFormat.md) | HL7-defined code system of concepts which specify which of several types of formats for data to be returned in response to a query. Used in HL7 Version 2 messaging in the EQL segment. |
| [ROUTE (2.1 - 1.0.0)](CodeSystem-route.md) | HL7-defined code system of concepts that indicate a means of administrating a medication dose. Used in HL7 Version 2 messaging in the RX1 segment (which was withdrawn after version 2.2). As of HL7 version 2.3, it was replaced by 2.16.840.1.113883.18.80 routeOfAdministration and 2.16.840.1.113883.18.83 administrationMethod. Used in the RX1 segment. |
| [Religion (2.1 - 1.0.0)](CodeSystem-religion.md) | HL7-defined code system of concepts specifying a person's religion. Used in HL7 Version 2.x messaging in the PID segment. |
| [Report Priority (2.1 - 1.0.0)](CodeSystem-reportPriority.md) | HL7-defined code system of concepts which specify the priority associated with a report or update run using a query. Used in HL7 Version 2 messaging in the URD segment. |
| [Response Flag (2.1 - 1.0.0)](CodeSystem-responseFlag.md) | HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Result Status (2.1 - 1.0.0)](CodeSystem-resultStatus.md) | HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [STOCK LOCATION (2.1 - 1.0.0)](CodeSystem-stockLocation.md) | Code system of concepts specifying a stock location for older Version 2 messaging systems; not used after version 2.2 of the Standard. |
| [Sex (2.1 - 1.0.0)](CodeSystem-sex.md) | HL7-defined code system of concepts specifying a person's sex. |
| [Source of Comment (2.1 - 1.0.0)](CodeSystem-sourceOfComment.md) | HL7-defined code system of concepts which are used to specify the source of a comment. Used in HL7 Version 2.x messaging in the NTE segment. |
| [Specimen Action Code (2.1 - 1.0.0)](CodeSystem-specimenAction.md) | HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). Used in HL7 Version 2.x messaging in the OBR segment. |
| [Specimen Source Codes (2.1 - 1.0.0)](CodeSystem-specimenSourceCodes.md) | HL7-defined code system of concepts which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in code system 2.16.840.1.133883.18.311 specimenType and code system 2.16.840.1.133883.18.312 specimenCollectionMethod as of version 2.5 and thereafter. |
| [Transportation Mode (2.1 - 1.0.0)](CodeSystem-transportationMode.md) | HL7-defined code system of concepts which specify how (or whether) to transport a patient, when applicable, for an ordered service. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Version ID (2.1 - 1.0.0)](CodeSystem-versionId.md) | HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards. Used in HL7 Version 2.x messaging in the VID segment. |
| [What Subject Filter (2.1 - 1.0.0)](CodeSystem-whatSubjectFilter.md) | HL7-defined code system of concepts which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. Used in HL7 Version 2 messaging in the URD segment. |

