# STOCK LOCATION (2.1 - 1.0.0) - HL7 v2.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **STOCK LOCATION (2.1 - 1.0.0)**

## CodeSystem: STOCK LOCATION (2.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/stockLocation | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:StockLocation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.12 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying a stock location for older Version 2 messaging systems; not used after version 2.2 of the Standard. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSstockLocation](ValueSet-hl7VSstockLocation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "stockLocation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0012"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/stockLocation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.12"
    }
  ],
  "version" : "1.0.0",
  "name" : "StockLocation",
  "title" : "STOCK LOCATION (2.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:20:25+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying a stock location for older Version 2 messaging systems; not used after version 2.2 of the Standard.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AN",
      "display" : "Filled from ancillary department stock",
      "definition" : "Filled from ancillary department stock",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "65",
      "code" : "FL",
      "display" : "Filled from floor stock",
      "definition" : "Filled from floor stock",
      "designation" : [
        {
          "language" : "de",
          "value" : "Etagenlager"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
