# Observation Result Status Codes Interpretation (2.1 - 1.0.0) - HL7 v2.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation Result Status Codes Interpretation (2.1 - 1.0.0)**

## CodeSystem: Observation Result Status Codes Interpretation (2.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/observationResultStatusCodesInterpretation | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ObservationResultStatusCodesInterpretation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.34 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. Used in HL7 Version 2.x messaging in the OBX segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSobservationResultStatus](ValueSet-hl7VSobservationResultStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "observationResultStatusCodesInterpretation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0085"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/observationResultStatusCodesInterpretation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.34"
    }
  ],
  "version" : "1.0.0",
  "name" : "ObservationResultStatusCodesInterpretation",
  "title" : "Observation Result Status Codes Interpretation (2.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:20:25+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier.  Used in HL7 Version 2.x messaging in the OBX segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "id" : "517",
      "code" : "D",
      "display" : "Delete previously transmitted observation",
      "definition" : "Delete previously transmitted observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "gemeldete Ergebnisse löschen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "283",
      "code" : "F",
      "display" : "Complete/final results (entered and verified)",
      "definition" : "Complete/final results (entered and verified)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Endbefund/Endergebnis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "285",
      "code" : "I",
      "display" : "Specimen in lab; results pending",
      "definition" : "Specimen in lab; results pending",
      "designation" : [
        {
          "language" : "de",
          "value" : "Probe im Labor - Ergebnisse stehen an"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "516",
      "code" : "R",
      "display" : "Results entered -- not verified",
      "definition" : "Results entered -- not verified",
      "designation" : [
        {
          "language" : "de",
          "value" : "nicht validierte Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "286",
      "code" : "S",
      "display" : "Partial results",
      "definition" : "Partial results",
      "designation" : [
        {
          "language" : "de",
          "value" : "Teilbefund"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
