# Abnormal Flags (2.1 - 1.0.0) - HL7 v2.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Abnormal Flags (2.1 - 1.0.0)**

## CodeSystem: Abnormal Flags (2.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/observationInterpretation | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ObservationInterpretation |
| *Other Identifiers:*OID:2.16.840.1.113883.5.83 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify a categorical assessment of an observation value. Used in HL7 Version 2.x messaging in the OBX segment. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSinterpretationCode](ValueSet-hl7VSinterpretationCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "observationInterpretation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0078"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/observationInterpretation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.83"
    }
  ],
  "version" : "1.0.0",
  "name" : "ObservationInterpretation",
  "title" : "Abnormal Flags (2.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:20:25+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a categorical assessment of an observation value.  Used in HL7 Version 2.x messaging in the OBX segment.\r\nNotes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "id" : "269",
      "code" : "<",
      "display" : "Below absolute low-off instrument scale",
      "definition" : "Below absolute low-off instrument scale",
      "designation" : [
        {
          "language" : "de",
          "value" : "Unter Meßbereich (Extremwertverletzung)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "272",
      "code" : "A",
      "display" : "Abnormal (applies to non-numeric results)",
      "definition" : "Abnormal (applies to non-numeric results)",
      "designation" : [
        {
          "language" : "de",
          "value" : "pathologisch (nicht numerisch)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "AA",
      "display" : "Very abnormal",
      "definition" : "Very abnormal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Extremwert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "275",
      "code" : "D",
      "display" : "Significant change down",
      "definition" : "Significant change down",
      "designation" : [
        {
          "language" : "de",
          "value" : "deutlicher Trend nach unten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "266",
      "code" : "H",
      "display" : "Above high normal",
      "definition" : "Above high normal",
      "designation" : [
        {
          "language" : "de",
          "value" : "Oberhalb oberer Grenze Referenzbereich"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "268",
      "code" : "HH",
      "display" : "Above upper panic limits",
      "definition" : "Above upper panic limits",
      "designation" : [
        {
          "language" : "de",
          "value" : "Oberhalb oberer pathologischer Grenze"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "515",
      "code" : "I",
      "display" : "Interval",
      "definition" : "Interval",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schwankend"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "267",
      "code" : "LL",
      "display" : "Below lower panic limits",
      "definition" : "Below lower panic limits",
      "designation" : [
        {
          "language" : "de",
          "value" : "Unterhalb unterer pathologischer Grenze"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "572",
      "code" : "MS",
      "display" : "Moderately sensitive",
      "definition" : "Moderately sensitive",
      "designation" : [
        {
          "language" : "de",
          "value" : "mäßig empfindlich"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "514",
      "code" : "R",
      "display" : "Resists",
      "definition" : "Resists",
      "designation" : [
        {
          "language" : "de",
          "value" : "Resistent"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "513",
      "code" : "S",
      "display" : "Sensitive",
      "definition" : "Sensitive",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfindlich"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "274",
      "code" : "U",
      "display" : "Significant change up",
      "definition" : "Significant change up",
      "designation" : [
        {
          "language" : "de",
          "value" : "Deutlicher Trend nach oben"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "573",
      "code" : "VS",
      "display" : "Very sensitive",
      "definition" : "Very sensitive",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sehr empfindlich"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "273",
      "code" : "null",
      "display" : "No range defined, or normal ranges don't apply",
      "definition" : "No range defined,or normal ranges don't apply",
      "designation" : [
        {
          "language" : "de",
          "value" : "kein Referenzbereich / Referenzbereich nicht anwendbar"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
