# Artifacts Summary - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

## Artifacts Summary

Contents:

*  [Structures: Abstract Profiles](#1) 
*  [Structures: Resource Profiles](#2) 
*  [Structures: Extension Definitions](#3) 
*  [Terminology: Value Sets](#4) 
*  [Terminology: Code Systems](#5) 
*  [Example: Example Instances](#6) 
*  [Other](#7) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [FI Base InformationCustodian](StructureDefinition-fi-base-information-custodian.md) | This is a Finnish abstract base profile for the Provenance resource, used to communicate the custodian of information (**rekisterinpitäjä**). |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [An imaginary profile for Kanta system, specifying things apart from the information custodian](StructureDefinition-kanta-document-other-metadata-profile.md) | This is one way in which a system might use the Finnish Base Information Custodian profile. This profile defines other constraints. The profile KantaDocumentMetadata combines the requirements. |
| [An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile](StructureDefinition-kanta-document-metadata-profile.md) | This is one way in which a system might use the Finnish Base Information Custodian profile. Kanta has expressed the wish to have only one big Provenance resource containing all document metadata. This can be accomplished by creating a profile based on the Finnish Base Provenance profile and[imposing](http://hl7.org/fhir/extensions/StructureDefinition-structuredefinition-imposeProfile.html)the Finnish Base Information Custodian profile. |
| [FI Base Appointment](StructureDefinition-fi-base-appointment.md) | This is the Finnish base profile for the Appointment resource. |
| [FI Base Condition](StructureDefinition-fi-base-condition.md) | This is the Finnish base profile for the Condition resource. |
| [FI Base Encounter](StructureDefinition-fi-base-encounter.md) | This is the Finnish base profile for the Encounter resource. |
| [FI Base EpisodeOfCare](StructureDefinition-fi-base-episode-of-care.md) | This is the Finnish base profile for the EpisodeOfCare resource. |
| [FI Base HealthcareService](StructureDefinition-fi-base-healthcare-service.md) | This is the Finnish base profile for the HealthcareService resource. |
| [FI Base Information Custodian (Individual Provider)](StructureDefinition-fi-base-information-custodian-individual.md) | This is the Finnish base profile for the Provenance resource, used to communicate an individual practitioner as the custodian of information (**rekisterinpitäjä**). |
| [FI Base Information Custodian (Private Organization)](StructureDefinition-fi-base-information-custodian-private.md) | This is the Finnish base profile for the Provenance resource, used to communicate a private organization as the custodian of information (**rekisterinpitäjä**). |
| [FI Base Information Custodian (Public Organization)](StructureDefinition-fi-base-information-custodian-public.md) | This is the Finnish base profile for the Provenance resource, used to communicate a public organization as the custodian of information (**rekisterinpitäjä**). |
| [FI Base Location](StructureDefinition-fi-base-location.md) | This is the Finnish base profile for the Location resource. |
| [FI Base Medication](StructureDefinition-fi-base-medication.md) | This is the Finnish base profile for the Medication resource for other than patient access use cases. |
| [FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md) | This is the Finnish base profile for the MedicationAdministration resource. |
| [FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md) | This is the Finnish base profile for the MedicationRequest resource, for other than patient access use cases. |
| [FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md) | This is the Finnish base profile for the MedicationStatement resource. |
| [FI Base Observation](StructureDefinition-fi-base-observation.md) | This is the Finnish base profile for the Observation resource. |
| [FI Base Organization](StructureDefinition-fi-base-organization.md) | This is the Finnish base profile for the Organization resource. |
| [FI Base Patient](StructureDefinition-fi-base-patient.md) | This is the Finnish base profile for the Patient resource. |
| [FI Base Practitioner](StructureDefinition-fi-base-practitioner.md) | This is the Finnish base profile for the Practitioner resource. |
| [FI Base PractitionerRole](StructureDefinition-fi-base-practitioner-role.md) | This is the Finnish base profile for the PractitionerRole resource. |
| [FI Base Provenance](StructureDefinition-fi-base-provenance.md) | This is the Finnish base profile for the Provenance resource. |
| [FI Base Reason for Care (encounter-diagnosis and reason for visit)](StructureDefinition-fi-base-reason-for-care.md) | This is the Finnish base profile for the encounter-diagnosis and (nurse asserted) reason for visit Conditions. |
| [FI Base Schedule](StructureDefinition-fi-base-schedule.md) | This is the Finnish base profile for the Schedule resource. |
| [FI Base Slot](StructureDefinition-fi-base-slot.md) | This is the Finnish base profile for the Slot resource. |
| [Fi Base Immunization](StructureDefinition-fi-base-immunization.md) | This is a base profile for Finnish Immunization resource. |
| [Fi Base Procedure](StructureDefinition-fi-base-procedure.md) | The Base profile for Finnish Procedure resource. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Categorization of the type of accident](StructureDefinition-condition-categorization-of-accident.md) | Encoded categorization of the type of accident leading to injury, illness or death. |
| [Cause of an adverse effect](StructureDefinition-condition-cause-of-adverse-effect.md) | Encoded information on the cause of an adverse effect, when involving a procedure or medication |
| [Endocrinological disorder](StructureDefinition-condition-endocrinological-disorder.md) | Code for Endocrinological disorder. |
| [External cause for diagnosis](StructureDefinition-condition-external-cause.md) | External cause for diagnosis. |
| [Medication that caused this condition](StructureDefinition-condition-caused-by-medication.md) | Encoded information of medication that caused this condition. Uses ATC-coding. |
| [Municipality Code](StructureDefinition-municipality-code.md) | Extension for home municipality. Home municipality is relevant for ex. in billing and listing available healthcare services, and for statistical purposes. It it not necessarily the place where a patient lives, rather closer to where they pay their taxes. |
| [Patient Profession Extension](StructureDefinition-patient-profession.md) | Extension for presenting patient profession. |
| [Permanence of condition](StructureDefinition-condition-permanence.md) | Encoded information of whether this is the permanent. |
| [Primary condition for encounter](StructureDefinition-condition-primary.md) | Encoded information of whether this is the primary/main condition for encounter. |
| [ReleaseDateForPatientViewing](StructureDefinition-ReleaseDateForPatientViewing.md) | The extension indicates the end date of the delay, i.e. the first day when the delayed appointment information can be displayed (e.g Omakanta) /**Laajennuksella ilmoitetaan viivästämisen päättymispäivä eli ensimmäinen päivä, jolloin viivästetty asiakirja voidaan näyttää (esim. Omakannassa)**. |
| [RestrictionParent](StructureDefinition-RestrictionParent.md) | The extension informs, using the THL - Release of minor's patient information to guardians classification, whether guardians have the right to see their minor child's appointment information (e.g. in Omakanta) and whether the disclosure of appointment information to them is permitted in healthcare services. /**Laajennuksella ilmoitetaan THL - Alaikäisen potilastietojen luovuttaminen huoltajille -luokitusta käyttäen, onko huoltajilla oikeus nähdä alaikäisen lapsensa ajanvaraustiedot (esim. Omakannassa) ja onko ajanvaraustietojen luovuttaminen heille sallittu terveydenhuollon palveluissa**. |
| [ServiceEvent](StructureDefinition-service-event.md) | Extension for service event id (**palvelutapahtuman tunniste**). |
| [Type of physical exercise during which injury occurred.](StructureDefinition-condition-physical-excercise.md) | Encoded information of the type of physical exercise during which injury occurred. |
| [Vaccination Recorder](StructureDefinition-vaccination-recorder.md) | Vaccination recorder may not be the same person who performed the addministration. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Example value set for provenance roles](ValueSet-kanta-provenance-agent-role.md) | This example value set contains the systems that can be used for agent roles in Kanta profiles |
| [Finnish ValueSet for security labels in accordance with finnish authorities](ValueSet-fi-base-security-label-vs.md) | This is the ValueSet for security labels in accordance with finnish authorities. |
| [Finnish ValueSet for systems of registry specifiers](ValueSet-fi-base-register-identifier.md) | This value set contains the systems that can be used to identify the registry specifier for information custodianship. |
| [fi-base-restriction-parent-vs](ValueSet-fi-base-restriction-parent-vs.md) | Value set, jota käytetään ilmoittamaan, saako alaikäisen tietoja luovuttaa huoltajille. Value set sisältää koodiston THL - Alaikäisen potilastietojen luovuttaminen huoltajille arvot 1-4. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Finnish CodeSystem for security labels](CodeSystem-fi-base-security-label-cs.md) | This is the CodeSystem for security labels in accordance with finnish authorities. |
| [Tiedon näyttäminen kansalaiselle viivästetty.](CodeSystem-fi-base-release-for-patient-viewing-cs.md) | Tiedon näyttäminen kansalaiselle viivästetty. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [1 tabletti 2 kertaa päivässä](MedicationRequest-medicationrequestesim1.md) | An example MedicationRequest from Kanta Prescription API |
| [1 tabletti 2 kertaa päivässä 5 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7A.md) | An example MedicationRequest from Kanta Prescription API |
| [1 tabletti 2 kertaa päivässä 5-7 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7B.md) | An example MedicationRequest from Kanta Prescription API |
| [1-2 tablettia 1-3 kertaa päivässä](MedicationRequest-medicationrequestesim4.md) | An example MedicationRequest from Kanta Prescription API |
| [1-2 tablettia kerran päivässä](MedicationRequest-medicationrequestesim3.md) | An example MedicationRequest from Kanta Prescription API |
| [2 tablettia aamulla ja 1 tabletti illalla 6 päivän ajan](MedicationRequest-medicationrequestesim2.md) | An example MedicationRequest from Kanta Prescription API |
| [A high level organization](Organization-1.2.246.10.31045308.10002.0.md) | Organization on Wellbeing Services County level |
| [A named bed](Location-id-for-bed-3.md) | Example of a bed recorded with the Location resource. |
| [A simple practitioner role](PractitionerRole-practitionerRoleesim1.md) | An example PractitionerRole instance from Kanta Prescription API |
| [A simple provenance example](Provenance-id-for-provenance-1.md) | An example Provenance resource instance from Kanta |
| [A test example demonstrating that validation works](Provenance-kanta-document-metadata-profile-test-example-1.md) | This example does not have the role for the agent from system urn:oid:1.2.246.537.5.40172, as would be mandated by the Finnish Base Information Custodian profile. QA report is expected to show an error. |
| [An imaginary example of a Provenance resource instance conforming to the imaginary metadata profile for Kanta system](Provenance-kanta-document-metadata-profile-example.md) | This example demonstrates one way in which a system might use the Finnish Base Information Custodian profile. |
| [An imaginary example of a Provenance resource instance conforming to the imaginary metadata profile for Kanta system, using the kanta code also for the custodian agent](Provenance-kanta-document-metadata-profile-example-2.md) | This example demonstrates one way in which a system might use the Finnish Base Information Custodian profile. |
| [Another Encounter that is part of palvelutapahtuma](Encounter-id-for-child-encounter-2.md) | An example of a FI Base encounter which is part of another encounter that corresponds to palvelutapahtuma in Kanta. |
| [Another test example demonstrating that validation works](Provenance-kanta-document-metadata-profile-test-example-2.md) | This example does not have a role with the code system specified by Kanta. QA report is expected to show an error. |
| [Biopsy of Colon procedure example](Procedure-ColonBiopsy.md) | Sub-procedure for Colotomy procedure. |
| [Codified healthcare service](HealthcareService-healthcareService-example.md) | HealthcareService example which describes general practitioner services by using THL code systems. |
| [Condition - an example diagnosis](Condition-id-for-diagnosis-1.md) | An example of a diagnosis using the FiBaseReasonForCare profile. This diagnosis is asserted by a clinician. |
| [Condition - an example diagnosis with an adverse effect.](Condition-id-for-diagnosis-3.md) | An example of a diagnosis using the FiBaseReasonForCare profile. This diagnosis demonstrates a case that has an adverse effect. |
| [Condition - an example diagnosis with external cause, accident and medication information.](Condition-id-for-diagnosis-2.md) | An example of a diagnosis using the FiBaseReasonForCare profile. This diagnosis demonstrates a case that has external cause, accident and medication information. |
| [Custodian of information (rekisterinpitäjä), an individual provider](Provenance-custodian-individual.md) | Example of Provenance that communicates a private individual healthcare provider as the custodian of information for an episode of care. |
| [Custodian of information (rekisterinpitäjä), private occupational healthcare](Provenance-custodian-occupational-healthcare.md) | Example of Provenance that communicates a private occupational healthcare organization as the custodian of information for an episode of care. |
| [Custodian of information (rekisterinpitäjä), public healthcare](Provenance-custodian-public-healthcare.md) | Example of Provenance that communicates a public healthcare organization as the custodian of information for an episode of care. |
| [Encounter - example primary care organization](Organization-1.2.246.10.8286189.10.100012.md) | An example of a FI Base organization, a surgical ward. The partOf reference removed for brevity. |
| [Encounter - patient is currently receiving care at a ward treating surgical patients](Encounter-id-for-ward-encounter.md) | An example of a FI Base encounter where a patient is currently receiving care at a ward. |
| [Encounter - patient primary care visit](Encounter-id-for-visit.md) | An example of a FI Base encounter where a patient has completed a visit in primary care. |
| [Encounter that is a palvelutapahtuma in Kanta registry](Encounter-id-for-palvelutapahtuma.md) | An example of a FI Base encounter which corresponds 1-1 to palvelutapahtuma in Kanta. Identifier with use=official marks the OID of palvelutapahtuma. Has sub-encounters. |
| [Encounter that is part of palvelutapahtuma](Encounter-id-for-child-encounter.md) | An example of a FI Base encounter which is part of another encounter that corresponds palvelutapahtuma in Kanta. |
| [Episode of care - with provenance](EpisodeOfCare-id-for-episode-1.md) | Example of episode of care. A provenance example links to this. |
| [Free slot (kertakäynti yleislääkärillä)](Slot-FreeSlot.md) | Example of a free slot with reference to Schedule and information about service category, service type and appointment type presented in THL code system format. |
| [GP appointment](Appointment-appointment-general-practitioner.md) | Example of an appointment with general practitioner. |
| [Kanta PHR - Insulin dosage mandatory](MedicationAdministration-a4d97476-39fa-46c6-bf2e-1fb153a7bbe2.md) | An example insulin dosage with mandatory elements. |
| [Kanta PHR - Insulin dosage optional](MedicationAdministration-a4d97476-39fa-46c6-bf2e-1fb153a7bbe3.md) | An example insulin dosage with optional elements. |
| [Kanta PHR - MET measurement mandatory](Observation-48983b8b-ead3-4206-9583-fcdd40d762b6.md) | An example MET measurement with mandatory elements. |
| [Kanta PHR - MET measurement optional](Observation-48983b8b-ead3-4206-9583-fcdd40d762b7.md) | An example MET measurement with optional elements. |
| [Kanta PHR - blood glucose mandatory](Observation-bloodglucose-min.md) | An example blood glucose measurement with mandatory elements. |
| [Kanta PHR - blood glucose optional](Observation-bloodglucose-max.md) | An example blood glucose measurement with optional elements. |
| [Kanta PHR - blood glucose result as text](Observation-bloodglucose-as-text.md) | This is an example, where measurement device has failed to measure numerical value for the blood glucose but the device still can store some result in the narrative element. In this case code 'astext' must be used in dataAbsentReason.coding.code. |
| [Kanta PHR - blood glucose with data absent](Observation-bloodglucose-data-absent.md) | This is an example, where measurement device has failed to measure blood glucose reading. In this case 'error' must be used in dataAbsentReason.coding.code. |
| [Kanta PHR - blood pressure mandatory](Observation-bloodpressure-min.md) | An example blood pressure measurement with mandatory elements. |
| [Kanta PHR - blood pressure optional](Observation-bloodpressure-max.md) | An example blood pressure measurement with optional elements. |
| [Kanta PHR - body height optional](Observation-1153859e-0c86-1000-abb8-511d0000b222.md) | An example body height measurement with optional elements. |
| [Kanta PHR - body weight mandatory](Observation-bodyweight-min.md) | An example body weight measurement with mandatory elements. |
| [Kanta PHR - body weight optional](Observation-bodyweight-max.md) | An example body weight measurement with optional elements. |
| [Kanta PHR - calorie intake mandatory](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f7.md) | An example calorie intake measurement with mandatory elements. |
| [Kanta PHR - calorie intake optional](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f8.md) | An example calorie intake measurement with optional elements. |
| [Kanta PHR - carbohydrate intake mandatory](Observation-2894b2e6-7ebf-4c33-93e4-31935effff21.md) | An example estimated carbohydrate intake measurement with mandatory elements. |
| [Kanta PHR - carbohydrate intake optional](Observation-2894b2e6-7ebf-4c33-93e4-31935effff22.md) | An example estimated carbohydrate intake measurement with optional elements. |
| [Kanta PHR - exercise tracking mandatory](Observation-71831b54-1a80-47c5-ba84-0180a5eb784a.md) | An example exercise tracking measurement with mandatory elements. |
| [Kanta PHR - exercise tracking optional](Observation-71831b54-1a80-47c5-ba84-0180a5eb784b.md) | An example exercise tracking measurement with optional elements. |
| [Kanta PHR - patient 3](Patient-36749a02-1710-44e7-aa76-0e934eb7860a.md) | An example patient for Kanta PHR. |
| [Kanta PHR - physical activity mandatory](Observation-mtvpa-min.md) | An example physical activity measurement with mandatory elements. |
| [Kanta PHR - physical activity optional](Observation-mtvpa-max.md) | An example physical activity measurement with optional elements. |
| [Kanta PHR - step count mandatory](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f8.md) | An example step count measurement with mandatory elements. |
| [Kanta PHR - step count optional](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f9.md) | An example step count measurement with optional elements. |
| [Karen van der Hentenryck](Patient-patientesim1.md) | An example patient from Kanta Prescription API |
| [Lars van der Knaapi](Practitioner-practitioneresim1.md) | An example practitioner from Kanta Prescription API |
| [Licenced physician](Practitioner-practitioner-licensed-physician.md) | Example of Licensed Physician from CGI Pegasos EHR. |
| [Licenced physician in primary care](PractitionerRole-PractitionerRoleGP.md) | This is an example of PractitionerRole profile. The example describes the service which practitioner is performing in a specific location. |
| [Lääke tauolla 1.3.2020 - 30.6.2020. Taukoa edeltävä annostus: 25 mg klo 08:00 10 päivän ajan ihon alle](MedicationRequest-medicationrequestesim6.md) | An example MedicationRequest from Kanta Prescription API |
| [Maanantaisin 1 tabletti ja tarvittaessa keskiviikkoisin 0,5 tablettia 01.06.2020 - 31.12.2020](MedicationRequest-medicationrequestesim5.md) | An example MedicationRequest from Kanta Prescription API |
| [MedicationAdministration example of insulin basal dose](MedicationAdministration-medication-administration-insulin-basal-dose-kanta-stu3-sv.md) | A basal dose of fast-acting insulin, administred with an insulin pump. Conforms to the Kanta PHR profile, version STU3. In Swedish. |
| [MedicationAdministration example of insulin dose](MedicationAdministration-medication-administration-insulin-bolus-dose-fi.md) | A bolus dose of fast-acting insulin, administred with an insulin pump. In Finnish. |
| [MedicationAdministration example of temporary basal rate](MedicationAdministration-medication-administration-insulin-dose-temp-basal-rate-kanta-en.md) | A temporarily adjusted basal dose of fast-acting insulin, administred with an insulin pump. Conforms to the Kanta PHR profile. In English. |
| [Myyntiluvallinen lääkevalmiste](Medication-medicationesim1.md) | An example Medication instance from Kanta Prescription API |
| [Myyntiluvallinen lääkevalmiste, joka on PKV-lääke](Medication-medicationesim2.md) | An example Medication instance from Kanta Prescription API |
| [Organization - example of a parent organization](Organization-1.2.246.10.2085212.10.1306.md) | An example of a FI Base organization. Acts as a parent organization for another. |
| [Organization - example primary care organization](Organization-1.2.246.10.2085212.10.1314.md) | An example of a FI Base organization, a doctor's reception office. Data is from national SOTE-Rekisteri. |
| [Outpatient clinic](Location-LocationExample.md) | Example of surgery outpatient clinic with reference to an organization. |
| [Patient - with the MunicipalityCode extension.](Patient-patient-of-municipality.md) | An example of a FI Base patient with the MunicipalityCode extension. |
| [Patient generated glucose observations and insulin administrations as a bundle, in English](Bundle-diabetes-data-bundle-kantaphr-r4-en.md) | A Bundle of resources uploaded by a patient from a insulin delivery system containing both a continuous glucose sensor and an insulin pump. Conforms to Kanta PHR R4 profiles. |
| [Patient generated glucose observations and insulin administrations as a bundle, in Finnish](Bundle-diabetes-data-bundle.md) | A Bundle of resources uploaded by a patient from a insulin delivery system containing both a continuous glucose sensor and an insulin pump. |
| [Patient generated glucose observations and insulin administrations as a bundle, in Swedish](Bundle-diabetes-data-bundle-kantaphr-sv.md) | A Bundle of resources uploaded by a patient from a insulin delivery system containing both a continuous glucose sensor and an insulin pump. Conforms to Kanta PHR STU3 profiles. |
| [Patient with a TURVAKIELTO security label.](Patient-patient-with-turvakielto.md) | An example of a FI Base patient that has the TURVAKIELTO security label indicating non-disclosure for personal safety reasons. |
| [Procedure Colotomy example](Procedure-ProcedureColotomy.md) | This example describes main procedure, colotomy, with reference to sub-procedure. |
| [Provenance example for Kanta](Provenance-custodian-public-healthcare-kela.md) | This example resource shows how information custodianship can be implemented with the support of the Finnish base profiles. It is derived from a provided example. |
| [Provenance example with registy information in reason field](Provenance-ESE-289490.md) | An example Provenance resource instance demonstrating how the custodian registry information is encoded into the`.reason`field. |
| [SNOMED CT coded Schedule](Schedule-ScheduleExample.md) | This is a Schedule example for appointment book. All of the used codes are from SNOMED code system. |
| [Simple Organization example](Organization-organizationesim2.md) | An example Organization from Kanta Prescription API |
| [Simple medication statement example](MedicationStatement-medication-statement-insulin.md) | Patient states they are taking long acting insulin (Lantus), but not the amount. |
| [Tarvittaessa 1-2 tippaa 3-4 tunnin välein](MedicationRequest-medicationrequestesim9.md) | An example MedicationRequest from Kanta Prescription API |
| [Tarvittaessa 2 tablettia 3 kertaa viikossa 16.2.2021 alkaen](MedicationRequest-medicationrequestesim8.md) | An example MedicationRequest from Kanta Prescription API |
| [Testi terveysasema](Organization-organizationesim1.md) | An example Organization from Kanta Prescription API |
| [Vaccination for TBE](Immunization-ImmunizationVaccinationExample.md) | An example vaccination against TBE. |

### Other 

These are resources that are used within this implementation guide that do not fit into one of the other categories.

| | |
| :--- | :--- |
| [A dummy patient entry](Patient-25a53703-27f9-4354-8f1b-a8b2f8f3ee86.md) | A patient id supporting other examples, not included in the guide. |
| [A dummy patient entry](Patient-36749a02-1710-44e7-aa76-0e934eb4321a.md) | A patient id supporting other examples, not included in the guide. |
| [A dummy patient entry](Patient-7257379.md) | A patient id supporting other examples, not included in the guide. |
| [A dummy patient entry](Patient-77c2c8d2-11ce-41d5-8150-75489f8b0b0a.md) | A patient id supporting other examples, not included in the guide. |
| [A dummy patient entry](Patient-bb13623e-2673-4b3e-85d6-5c42f5333cde.md) | A patient id supporting other examples, not included in the guide. |
| [A dummy patient entry](Patient-cafbe8e7-38fe-4807-b995-6770e5390365.md) | A patient id supporting other examples, not included in the guide. |
| [A dummy patient entry](Patient-daf8ca40-b46c-4c6b-99d5-d3a1b77074ad.md) | A patient id supporting other examples, not included in the guide. |
| [A dummy patient entry](Patient-f1fa0b52-eccf-44af-96c7-84a3251bb22c.md) | A patient id supporting other examples, not included in the guide. |
| [Parameters for Terminology selection of Finnish edition of SNOMED CT](Parameters-exp-params.md) | This parameter resource is used to specify the system version of the Finnish edition of SNOMED CT to be used in the terminology service. |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

