# Finnish ValueSet for security labels in accordance with finnish authorities - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Finnish ValueSet for security labels in accordance with finnish authorities**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-fi-base-security-label-vs.xml.md) 
*  [JSON](ValueSet-fi-base-security-label-vs.json.md) 
*  [TTL](ValueSet-fi-base-security-label-vs.ttl.md) 

## ValueSet: Finnish ValueSet for security labels in accordance with finnish authorities 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/ValueSet/fi-base-security-label-vs | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseSecurityLabelVS |

 
This is the ValueSet for security labels in accordance with finnish authorities. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include these codes as defined in [`https://hl7.fi/fhir/finnish-base-profiles/CodeSystem/fi-base-security-label-cs`](CodeSystem-fi-base-security-label-cs.md) version 📦2.0.0

 

### Expansion

Expansion performed internally based on [codesystem Finnish CodeSystem for security labels v2.0.0 (CodeSystem)](CodeSystem-fi-base-security-label-cs.md)

This value set contains 1 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

