# FI Base Slot - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Slot**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-slot-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-slot-mappings.md) 
*  [Examples](StructureDefinition-fi-base-slot-examples.md) 
*  [XML](StructureDefinition-fi-base-slot.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-slot.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-slot.profile.ttl.md) 

## Resource Profile: FI Base Slot 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-slot | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseSlot |

 
This is the Finnish base profile for the Slot resource. 

### Scope and Usage

This implementation guide does not profile scheduling related resources.

However, references to [Appointment](), [Schedule](), and [Slot]() resources are included here in order to draw the readers attention to another implementation guide published by HL7 Finland:

* [Finnish Scheduling](https://hl7.fi/fhir/finnish-scheduling/)

In addition to implementation guides published by HL7 Finland, there is also ongoing work on FHIR APIs for scheduling in the national Kanta system.

Do note also the older implementation guides by HL7 Finland:

* [Finnish Appointment](https://simplifier.net/finnishappointment/)
* [Finnish Scheduling](https://simplifier.net/finnishschedulingr4/)

The contents of both of these older implementation guides are now considered outdated.

The concepts and resources have been used, most notably by [Omaolo](https://www.omaolo.fi) symptom assessment services, [Palveluohjain](https://www.cgi.com/fi/fi/tuoteratkaisut/sahkoinen-asiointialusta) service (previously known *ajanvaraus ja palveluohjain -sovellus* AVPH) scheduling service, and the scheduling API of the [OMNI360](https://www.cgi.com/fi/fi/tuoteratkaisut/omni360) electronic health record system.

Implementers should read these implementation guides with caution and verify the latest state of the art from their customers or from vendors of real world implementations.

HL7 Finland is currently considering updating the published implementation guides.

**Usages:**

* Refer to this Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md) and [FI Base Appointment](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-appointment.html)
* Examples for this Profile: [Slot/FreeSlot](Slot-FreeSlot.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-slot)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Slot](http://hl7.org/fhir/R4/slot.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Slot](http://hl7.org/fhir/R4/slot.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Schedule(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-schedule)](StructureDefinition-fi-base-schedule.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Slot](http://hl7.org/fhir/R4/slot.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Slot](http://hl7.org/fhir/R4/slot.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Schedule(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-schedule)](StructureDefinition-fi-base-schedule.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-slot.csv), [Excel](StructureDefinition-fi-base-slot.xlsx), [Schematron](StructureDefinition-fi-base-slot.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

