# FI Base PractitionerRole - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base PractitionerRole**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-practitioner-role-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-practitioner-role-mappings.md) 
*  [Examples](StructureDefinition-fi-base-practitioner-role-examples.md) 
*  [XML](StructureDefinition-fi-base-practitioner-role.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-practitioner-role.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-practitioner-role.profile.ttl.md) 

## Resource Profile: FI Base PractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBasePractitionerRole |

 
This is the Finnish base profile for the PractitionerRole resource. 

**Usages:**

* Refer to this Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md), [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [FI Base EpisodeOfCare](StructureDefinition-fi-base-episode-of-care.md), [Fi Base Immunization](StructureDefinition-fi-base-immunization.md)...Show 21 more,[FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md),[FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md),[FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md),[FI Base Observation](StructureDefinition-fi-base-observation.md),[FI Base Patient](StructureDefinition-fi-base-patient.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Provenance](StructureDefinition-fi-base-provenance.md),[FI Base Schedule](StructureDefinition-fi-base-schedule.md),[FI Base Appointment](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-appointment.html),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[FI Base EpisodeOfCare](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-episode-of-care.html),[Fi Base Immunization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-immunization.html),[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html),[FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html),[FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html),[FI Base Patient MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication-request.html),[FI Base Patient](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient.html),[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html),[FI Base Provenance](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-provenance.html)and[FI Base Schedule](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-schedule.html)
* Examples for this Profile: [PractitionerRole/PractitionerRoleGP](PractitionerRole-PractitionerRoleGP.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-practitioner-role)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Constraints

This structure is derived from [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base HealthcareService(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-healthcare-service)](StructureDefinition-fi-base-healthcare-service.md)

 **Key Elements View** 

#### Constraints

 **Differential View** 

This structure is derived from [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base HealthcareService(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-healthcare-service)](StructureDefinition-fi-base-healthcare-service.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-practitioner-role.csv), [Excel](StructureDefinition-fi-base-practitioner-role.xlsx), [Schematron](StructureDefinition-fi-base-practitioner-role.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

