# FI Base Organization - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Organization**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-organization-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-organization-mappings.md) 
*  [Examples](StructureDefinition-fi-base-organization-examples.md) 
*  [XML](StructureDefinition-fi-base-organization.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-organization.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-organization.profile.ttl.md) 

## Resource Profile: FI Base Organization 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseOrganization |

 
This is the Finnish base profile for the Organization resource. 

### Scope and Usage

#### Relation to Organizations in National Code Server

[National code server of social welfare and health care](https://koodistopalvelu.kanta.fi/codeserver/pages/classification-list-page.xhtml) contains a [registry](https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=421&versionKey=501) for organizations.

The OID-code in the national registry should be included in the indentifier list.

**Usages:**

* Refer to this Profile: [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [FI Base EpisodeOfCare](StructureDefinition-fi-base-episode-of-care.md), [FI Base HealthcareService](StructureDefinition-fi-base-healthcare-service.md), [Fi Base Immunization](StructureDefinition-fi-base-immunization.md)...Show 28 more,[FI Base Location](StructureDefinition-fi-base-location.md),[FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md),[FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md),[FI Base Medication](StructureDefinition-fi-base-medication.md),[FI Base Observation](StructureDefinition-fi-base-observation.md),[FI Base Organization](StructureDefinition-fi-base-organization.md),[FI Base Patient](StructureDefinition-fi-base-patient.md),[FI Base PractitionerRole](StructureDefinition-fi-base-practitioner-role.md),[FI Base Practitioner](StructureDefinition-fi-base-practitioner.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Provenance](StructureDefinition-fi-base-provenance.md),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[FI Base EpisodeOfCare](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-episode-of-care.html),[FI Base HealthcareService](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-healthcare-service.html),[Fi Base Immunization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-immunization.html),[FI Base Location](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-location.html),[FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html),[FI Base Medication](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication.html),[FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html),[FI Base Organization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-organization.html),[FI Base Patient MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication-request.html),[FI Base Patient Medication](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication.html),[FI Base Patient](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient.html),[FI Base PractitionerRole](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-practitioner-role.html),[FI Base Practitioner](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-practitioner.html),[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html)and[FI Base Provenance](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-provenance.html)
* Examples for this Profile: [Vastaanotot, SoTe kuntayhtymä Saarikka](Organization-1.2.246.10.2085212.10.1306.md), [Kyyjärven lääkärin vastaanotto, Kyyjärven terveysasema, SoTe kuntayhtymä Saarikka](Organization-1.2.246.10.2085212.10.1314.md) and [Kirurgian vuodeosasto 4B, Länsi-Pohjan keskussairaala, LPSHP](Organization-1.2.246.10.8286189.10.100012.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Constraints

This structure is derived from [Organization](http://hl7.org/fhir/R4/organization.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Organization](http://hl7.org/fhir/R4/organization.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)

 **Key Elements View** 

#### Constraints

 **Differential View** 

This structure is derived from [Organization](http://hl7.org/fhir/R4/organization.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Organization](http://hl7.org/fhir/R4/organization.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-organization.csv), [Excel](StructureDefinition-fi-base-organization.xlsx), [Schematron](StructureDefinition-fi-base-organization.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

