# FI Base HealthcareService - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base HealthcareService**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-healthcare-service-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-healthcare-service-mappings.md) 
*  [Examples](StructureDefinition-fi-base-healthcare-service-examples.md) 
*  [XML](StructureDefinition-fi-base-healthcare-service.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-healthcare-service.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-healthcare-service.profile.ttl.md) 

## Resource Profile: FI Base HealthcareService 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-healthcare-service | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseHealthcareService |

 
This is the Finnish base profile for the HealthcareService resource. 

**Usages:**

* Refer to this Profile: [FI Base PractitionerRole](StructureDefinition-fi-base-practitioner-role.md), [FI Base Schedule](StructureDefinition-fi-base-schedule.md), [FI Base PractitionerRole](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-practitioner-role.html) and [FI Base Schedule](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-schedule.html)
* Examples for this Profile: [Vastaanottoaika*](HealthcareService-healthcareService-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-healthcare-service)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Constraints

This structure is derived from [HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)

 **Key Elements View** 

#### Constraints

 **Differential View** 

This structure is derived from [HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-healthcare-service.csv), [Excel](StructureDefinition-fi-base-healthcare-service.xlsx), [Schematron](StructureDefinition-fi-base-healthcare-service.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

