# Permanence of condition - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Permanence of condition**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-condition-permanence-definitions.md) 
*  [Mappings](StructureDefinition-condition-permanence-mappings.md) 
*  [XML](StructureDefinition-condition-permanence.profile.xml.md) 
*  [JSON](StructureDefinition-condition-permanence.profile.json.md) 
*  [TTL](StructureDefinition-condition-permanence.profile.ttl.md) 

## Extension: Permanence of condition 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/condition-permanence | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:Permanence |

Encoded information of whether this is the permanent.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [FI Base Reason for Care (encounter-diagnosis and reason for visit)](StructureDefinition-fi-base-reason-for-care.md) and [FI Base Reason for Care (encounter-diagnosis and reason for visit)](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-reason-for-care.html)
* Examples for this Extension: [Condition/id-for-diagnosis-1](Condition-id-for-diagnosis-1.md), [Condition/id-for-diagnosis-2](Condition-id-for-diagnosis-2.md) and [Condition/id-for-diagnosis-3](Condition-id-for-diagnosis-3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/condition-permanence)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Coding: Encoded information of whether this is the permanent.

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Coding: Encoded information of whether this is the permanent.

 

Other representations of profile: [CSV](StructureDefinition-condition-permanence.csv), [Excel](StructureDefinition-condition-permanence.xlsx), [Schematron](StructureDefinition-condition-permanence.sch) 

#### Constraints

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

