# Licenced physician - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Licenced physician**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Practitioner-practitioner-licensed-physician.xml.md) 
*  [JSON](Practitioner-practitioner-licensed-physician.json.md) 
*  [TTL](Practitioner-practitioner-licensed-physician.ttl.md) 

## Example Practitioner: Licenced physician

This example is from a live system. It does not follow the best practice recommendation from IPA that the name should have the `.text` element populated. Also the identifier type `MNEMONIC` is not recognized in the context of this implementation guide.

Profile: [FI Base Practitioner](StructureDefinition-fi-base-practitioner.md)

**identifier**: `urn:oid:1.2.246.537.26`/00198705840 (use: official, ), `urn:oid:1.2.246.21`/311080-999X (use: official, ), `urn:oid:1.2.246.537.25`/032680 (use: official, ), MNEMONIC/DOCTODAV (use: secondary, ), [URI](http://terminology.hl7.org/5.0.0/NamingSystem-uri.html)/mailto:dave.doctor@cgi.com, user-domain-authority/4ec06bf9-1df1-4336-bf5a-33ba1a2707b2, user-domain-authority/dave.doctor@iurcgifisaas.onmicrosoft.com

**active**: true

**name**: Dave Doctor 

**telecom**: [dave.doctor@cgi.com](mailto:dave.doctor@cgi.com)

**gender**: Male

> **qualification****code**:001

> **qualification****code**:86152-322

> **qualification****code**:2131

> **qualification****code**:MD

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

