# Encounter - patient is currently receiving care at a ward treating surgical patients - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter - patient is currently receiving care at a ward treating surgical patients**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Encounter-id-for-ward-encounter.xml.md) 
*  [JSON](Encounter-id-for-ward-encounter.json.md) 
*  [TTL](Encounter-id-for-ward-encounter.ttl.md) 

## Example Encounter: Encounter - patient is currently receiving care at a ward treating surgical patients

### How to find a patient in a ward?

Many systems have a need to answer the question: "How to find patients/encounters that are at ward X at moment T?".

There are key points to consider when forming the search criteria:

* We are most likely interested only in `IMP` (inpatient encounter) encounters, so we should filter by `class`.
* We are interested only in `in-progress` encounters, so we need to filter by `status`.
* We are most likely interested in querying by organizational hierarchy, the organizational unit (ward) responsible for the patient (not physical location).

Organizational ward should be communicated using the `serviceProvider` property.

FHIR request parameters: `GET /Encounter`

* class = `IMP`
* status = `in-progress`
* period `gt` and `le` filters as per target moment
* serviceProvider = id of the ward organization resource

Historically some systems keep the ward encounter active when the patient is sent to ICU. Leaving the encounter in an `in-progress` state would cause a gotcha: encounter says that it's active but patient is not really there. Using encounter´s `location` elements could be used to express that the patient has no active location in the ward, but this might be difficult to process for client systems and depend heavily on the organizational and location structures of a facility. Because of these problems, the encounter SHOULD not be kept `in-progress` when the patient is in an ICU period (if there is a need for "recycling" the ward period encounter, it should be set to `finished` and then back to `in-progress` upon return from the ICU).

#### Why not use Location.managingOrganization?

`Encounter`s `location` field is a reference to `Location` that has a field `managingOrganization`. Use of this to find the organization responsible for the patient is problematic. `Location.managingOrganization` might change for different reasons (a room is assigned to another organization) and this would have an unexpected effect on the responsibility-concern. `Location.managingOrganization` is "too far" from the encounter to be useful in this context.

#### Querying by physical location

Querying by location is also an option. Here the focus is on the physical location and not the organizational responsibility towards the patient. [This blog post](https://fhirblog.com/2013/10/24/adventures-in-searching-getting-a-list-of-patients-in-a-ward/) will describe the process.

Profile: [FI Base Encounter](StructureDefinition-fi-base-encounter.md)

**identifier**: id-for-ward-encounter (use: usual, )

**status**: In Progress

**class**: [ActCode IMP](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP): inpatient encounter

**subject**: [Testi Henkilö Male, DoB: 1990-01-01 ( National Identifier for Finland (use: official, ))](Patient-patient-of-municipality.md)

**period**: 2022-02-27 01:03:00+0200 --> (ongoing)

### Locations

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Location** | **Status** | **Period** |
| * | [Location Vuode 3](Location-id-for-bed-3.md) | Active | 2022-02-27 01:03:00+0200 --> (ongoing) |

**serviceProvider**: [Organization Kirurgian vuodeosasto 4B, Länsi-Pohjan keskussairaala, LPSHP](Organization-1.2.246.10.8286189.10.100012.md)

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

