# Condition - an example diagnosis - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition - an example diagnosis**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Condition-id-for-diagnosis-1.xml.md) 
*  [JSON](Condition-id-for-diagnosis-1.json.md) 
*  [TTL](Condition-id-for-diagnosis-1.ttl.md) 

## Example Condition: Condition - an example diagnosis

### Identifying that this is a diagnosis

This is an example encounter diagnosis (**käyntidiagnoosi**, even for ward periods).

`category` code `encounter-diagnosis` communicates that is a diagnosis asserted by a clinician.

### No special characters in codes

Diagnosis code (reason) is in `code`. Note that in THL - Tautiluokitus ICD-10 this code has `CodeId` `H36.03*`, but the special character is removed (see `Koodi1`). Evidence code (the symptom) is handled similarly.

Profile: [FI Base Reason for Care (encounter-diagnosis and reason for visit)](StructureDefinition-fi-base-reason-for-care.md)

**Primary condition for encounter**: unknown PAA: Päädiagnoosi tai päätoimenpide (version = 2003 )

**Permanence of condition**: unknown PYS: Pysyväisluonteinen (version = 2003 )

**clinicalStatus**: Active

**category**: Encounter Diagnosis

**code**: Proliferatiivinen diabeettinen retinopatia, vasen, laserhoidettu

**subject**: [Testi Henkilö Male, DoB: 1990-01-01 ( National Identifier for Finland (use: official, ))](Patient-patient-of-municipality.md)

**onset**: 2023-01-05 02:06:24+0300

### Evidences

| | |
| :--- | :--- |
| - | **Code** |
| * | Aikuistyypin diabetes diabeteksen silmäkomplikaatiot |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

