# Patient generated glucose observations and insulin administrations as a bundle, in Swedish - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient generated glucose observations and insulin administrations as a bundle, in Swedish**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Bundle-diabetes-data-bundle-kantaphr-sv.xml.md) 
*  [JSON](Bundle-diabetes-data-bundle-kantaphr-sv.json.md) 
*  [TTL](Bundle-diabetes-data-bundle-kantaphr-sv.ttl.md) 

## Example Bundle: Patient generated glucose observations and insulin administrations as a bundle, in Swedish

This example uses the older [STU3 profile](https://simplifier.net/finnishphr/fiphr-sd-bloodglucose-stu3) of the Finnish PHR.

The example does not validate properly in the context of this implementation guide. Do pay attention to the validation messages in the [QA report](qa.md) of this implementation guide, before using this example.

The example uses a customized `display` value in `valueCodeableConcept.coding.display`, as mandated by Kela (see the [Narrative guide](https://simplifier.net/guide/FinnishPHRImplementationGuideSTU5/FinnishPHRVitalSignsProfiles?version=current#narrative-guide) and the [customized localizations](https://simplifier.net/finnishphr/fiphr-vs-vitalsigns)).

The example also refers to the code system `http://hl7.org/fhir/observation-category` [mandated by the profile](https://simplifier.net/finnishphr/fiphr-sd-bloodglucose-stu3). That system does not resolve.

Bundle diabetes-data-bundle-kantaphr-sv of type batch

-------

Entry 1 - fullUrl = urn:uuid:cd83d9d5-ccfd-4102-872d-11e04c991734

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 16.39:35
Vävnadssocker: 7.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cf344311-efe9-5da8-8a6b-03d17df96142

```

-------

Entry 2 - fullUrl = urn:uuid:15c8c27d-fd18-42d5-890f-8b8ec6722679

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 16.44:36
Vävnadssocker: 7.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4b638ea5-2250-5812-9c00-a07043698628

```

-------

Entry 3 - fullUrl = urn:uuid:6c350796-d901-4fd5-bb8a-9c7871bebc40

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 16.49:37
Vävnadssocker: 7.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ec05b83e-b88d-506b-bdbd-83ff9b57375f

```

-------

Entry 4 - fullUrl = urn:uuid:6be80e77-225d-4d33-8379-59a2c1b52c83

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 16.54:35
Vävnadssocker: 7.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4ef0767b-4983-54e4-b25b-2dcdbcfd99ec

```

-------

Entry 5 - fullUrl = urn:uuid:cc8df487-34e6-401f-8362-96732d88375c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 16.59:35
Vävnadssocker: 7.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a311278a-2bb1-5549-bc25-d86ce0dd4f03

```

-------

Entry 6 - fullUrl = urn:uuid:5d6e4c43-acac-4f29-afa9-513114b9a682

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.04:35
Vävnadssocker: 7.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ccfef070-9ec8-5369-a62d-4c2252bf0afa

```

-------

Entry 7 - fullUrl = urn:uuid:ed05f392-554d-4585-a22d-969040aba23b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.09:35
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e9728fed-978a-5239-9082-82b9a9607c53

```

-------

Entry 8 - fullUrl = urn:uuid:caef7843-e2f8-47b6-aacb-e8a6a64c1ddb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.14:35
Vävnadssocker: 8.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2083ad9b-6fbf-5e06-8ec4-8ee86d197f39

```

-------

Entry 9 - fullUrl = urn:uuid:9298443a-7f0a-4284-a097-9f86c706bbb4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.19:36
Vävnadssocker: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a87378b5-ac65-5933-bfa0-dcdb8f72e9f2

```

-------

Entry 10 - fullUrl = urn:uuid:0482f779-0dc7-434a-844d-7ea74541f04d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 17.23:17 - 17.28:16
Direktverkande insulin 0.07 IE (0.79 IE/t, 1.13 % = 0.89 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c09d0ac8-5076-50db-b4c8-6cbdc88f4751

```

-------

Entry 11 - fullUrl = urn:uuid:8d156f34-c956-43bd-b3c1-c9a405208ac9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.24:35
Vävnadssocker: 8.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a5dbb988-f3b2-5c9b-98ed-8cd584d85533

```

-------

Entry 12 - fullUrl = urn:uuid:6f163423-cf38-4f66-910b-a9a5f7d460c0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 17.28:16 - 17.33:17
Direktverkande insulin 0.07 IE (0.82 IE/t, 1.17 % = 0.95 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8460370d-2c1e-5fc1-a254-911191702912

```

-------

Entry 13 - fullUrl = urn:uuid:441aa0e5-cdf0-4227-815a-bf1b7ad37c82

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.29:34
Vävnadssocker: 9.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:22f48b25-f8dd-57ac-bdc0-d2689d7cfb58

```

-------

Entry 14 - fullUrl = urn:uuid:cea20370-348b-4937-bb95-dd2289a8b925

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 17.33:17 - 17.38:18
Direktverkande insulin 0.16 IE (1.94 IE/t, 2.77 % = 5.37 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:78fdddfb-d966-52ae-a713-2bef97323c75

```

-------

Entry 15 - fullUrl = urn:uuid:29ea2242-a99e-4d0f-b458-c26377463ba4

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 17.33:53
Direktverkande insulin 1.26 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7de8c9c7-1a3c-5277-8017-61e2ddbd45e6

```

-------

Entry 16 - fullUrl = urn:uuid:cbb1d62f-f97c-414a-aaba-bab25ba9cc69

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.34:35
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9e2df578-9dfc-5994-8691-82e5f836aaea

```

-------

Entry 17 - fullUrl = urn:uuid:43a82b6f-a61a-4d32-8bf5-b7ae32d49a47

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 17.38:18 - 18.21:18
Direktverkande insulin 0.50 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ab5ab63d-4ebb-5862-b61e-7142da27a2e1

```

-------

Entry 18 - fullUrl = urn:uuid:fb61beb9-2f55-44ad-a1d5-93f87ab2c34b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.39:34
Vävnadssocker: 9.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a07bd5cc-5cf1-5838-a225-1fa18ba3f5ff

```

-------

Entry 19 - fullUrl = urn:uuid:327f0eab-816a-4f6b-ad2f-a41a0d758e65

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.44:37
Vävnadssocker: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a229d2b2-edcf-594e-970c-d189835463e2

```

-------

Entry 20 - fullUrl = urn:uuid:b75d492b-4ac0-4014-a86a-8328f3581fef

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.49:37
Vävnadssocker: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:982d6ed5-7b67-5723-adc3-6396a8c15020

```

-------

Entry 21 - fullUrl = urn:uuid:70a8bd3d-d743-4979-bd67-417091e947e2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.54:36
Vävnadssocker: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9b8fe110-adf3-532c-b093-a53bbe64e515

```

-------

Entry 22 - fullUrl = urn:uuid:db9abc3c-7976-417f-bbae-3e970336be1a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 17.59:35
Vävnadssocker: 10.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b2dedd8a-d921-579a-af25-4a6a5c6f797f

```

-------

Entry 23 - fullUrl = urn:uuid:80aad37e-fc50-4934-9300-41136ea3ac3f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.04:36
Vävnadssocker: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:57f86f80-63cc-54e1-9f0c-e9ea088c64b5

```

-------

Entry 24 - fullUrl = urn:uuid:1e7c51d8-7998-42f8-8aa1-2efe89323b17

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.09:36
Vävnadssocker: 10.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c2c903b4-74c4-5c9c-9631-0f18f1cf90b9

```

-------

Entry 25 - fullUrl = urn:uuid:cdc95ad7-0338-443d-8e06-8354f06e5ac2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.14:36
Vävnadssocker: 10.93 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8ef1d261-f5e9-5101-ab3c-d1d34c868b93

```

-------

Entry 26 - fullUrl = urn:uuid:8736fec3-f0d4-41cd-acf9-afa8b3009746

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.19:36
Vävnadssocker: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b4f82f76-5940-5ee0-b8cb-9f6ad3d74313

```

-------

Entry 27 - fullUrl = urn:uuid:d197732e-3eea-4184-9a79-568bda2287bd

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 18.21:18 - 18.26:17
Direktverkande insulin 0.06 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8782190b-fecf-512c-a2ba-0a44415b86a1

```

-------

Entry 28 - fullUrl = urn:uuid:0ce17f05-49b2-484f-941c-e195a78c6bd4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.24:36
Vävnadssocker: 10.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8a1e3902-9d1d-5dd7-b6be-9ca41dec9333

```

-------

Entry 29 - fullUrl = urn:uuid:f803b595-0fe7-414c-b47b-b4766b9f3d09

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 18.26:17 - 18.28:26
Direktverkande insulin 0.03 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:83cd6adc-527e-5e2d-a084-35daea3a2319

```

-------

Entry 30 - fullUrl = urn:uuid:5e82f85a-e95c-4fbc-9f0a-c2dc4f92c7ff

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 18.28:26 - 18.33:28
Direktverkande insulin 0.13 IE (1.59 IE/t, 2.27 % = 3.62 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cbffc294-002b-5c2d-a2f3-f4a92a994f3b

```

-------

Entry 31 - fullUrl = urn:uuid:ef332e93-baae-4ff6-8f78-8e4d4761575f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.29:36
Vävnadssocker: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ec3b2497-df78-51f6-8cb0-c8da4488cbcb

```

-------

Entry 32 - fullUrl = urn:uuid:3851ff5b-efdd-4824-81d7-085431e2e8e7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 18.33:28 - 18.58:32
Direktverkande insulin 0.29 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0abc641d-6394-5f7c-ae84-c411ba296ca1

```

-------

Entry 33 - fullUrl = urn:uuid:8ff7565d-cfe7-42a3-8c97-7b0a8298e8c9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.34:34
Vävnadssocker: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:267695e0-4e22-5db7-b583-61fe4fb39f4c

```

-------

Entry 34 - fullUrl = urn:uuid:b0912c9f-d68d-4a57-99e7-5e16a2db538c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.39:34
Vävnadssocker: 9.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0549dd84-e66b-54a7-866a-24a96a23cf41

```

-------

Entry 35 - fullUrl = urn:uuid:8cb8219f-2188-45a0-8911-b03d437d423f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.44:34
Vävnadssocker: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:72565ed8-b996-5413-b1f0-15b9c4502bc5

```

-------

Entry 36 - fullUrl = urn:uuid:a2c6ba43-5ef9-44cb-a278-f16bf6de1935

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.49:37
Vävnadssocker: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a5ae859e-0b7c-57f5-b282-a25995fa58c4

```

-------

Entry 37 - fullUrl = urn:uuid:8a487a2b-0fcd-4761-a0d4-aa8d9c50aa60

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.54:34
Vävnadssocker: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8b91881-f0c5-52d1-8973-9793c2a104ea

```

-------

Entry 38 - fullUrl = urn:uuid:c3f5c47e-894f-4818-8c15-a48f8cb3823e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 18.58:32 - 19.03:33
Direktverkande insulin 0.07 IE (0.85 IE/t, 1.22 % = 1.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:43986f4e-8885-536d-bfc3-6727f9470667

```

-------

Entry 39 - fullUrl = urn:uuid:25216934-317d-49b3-b3df-03133cf00698

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 18.59:34
Vävnadssocker: 9.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b76dfa0a-3654-5d66-8833-945606983389

```

-------

Entry 40 - fullUrl = urn:uuid:c4318e17-1a41-4941-9c09-1c2218c08832

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.03:33 - 19.08:33
Direktverkande insulin 0.07 IE (0.78 IE/t, 1.12 % = 0.87 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:46c5662d-7866-5bbb-b7e1-98d1c2136329

```

-------

Entry 41 - fullUrl = urn:uuid:97d1b4b1-c73a-4047-b125-f8a5f25a4913

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.04:34
Vävnadssocker: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:90004d60-3e65-5d24-bdad-f6128000141f

```

-------

Entry 42 - fullUrl = urn:uuid:4e313013-9e45-4383-a409-202b08c9c60b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.08:33 - 19.13:35
Direktverkande insulin 0.07 IE (0.89 IE/t, 1.27 % = 1.13 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ed3fa6a6-7922-52c1-b076-90b6c10eae55

```

-------

Entry 43 - fullUrl = urn:uuid:539cf438-72f8-4c26-913a-1174e39dc1f9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.09:34
Vävnadssocker: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6800a909-7ff9-5dfd-9737-8b389942ab2f

```

-------

Entry 44 - fullUrl = urn:uuid:7bbf1421-2234-44ca-99af-7f9b1f38111b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.13:35 - 19.18:35
Direktverkande insulin 0.11 IE (1.31 IE/t, 1.87 % = 2.44 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4efdb178-de84-5ff9-8cc3-0eff310d667c

```

-------

Entry 45 - fullUrl = urn:uuid:8770b0b0-b98c-47c2-b9fe-4814e5d42820

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.13:48
Direktverkande insulin 1.07 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6f122374-b9f9-5543-b323-23abc6db46ca

```

-------

Entry 46 - fullUrl = urn:uuid:1d533fbd-2068-461c-a699-de82dc8d6df5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.14:34
Vävnadssocker: 10.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b4961b82-ecd7-5f93-9886-43d4f875f85c

```

-------

Entry 47 - fullUrl = urn:uuid:c5140b3d-df27-407a-94b7-04f1bcfdfa6f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.18:35 - 19.28:37
Direktverkande insulin 0.12 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:60400386-fafa-575d-b351-e686e9babf11

```

-------

Entry 48 - fullUrl = urn:uuid:fb3f4c47-d49e-48d9-89e7-cf208c5053fd

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.19:34
Vävnadssocker: 10.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:24adbb53-f2dc-5aa9-867e-c63d76f1af8c

```

-------

Entry 49 - fullUrl = urn:uuid:6f7b21a5-97d6-48ad-9079-1b6b0db5bfa7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.24:34
Vävnadssocker: 10.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:84e5907c-95f1-5280-b256-1f735f7bb066

```

-------

Entry 50 - fullUrl = urn:uuid:e8cb1223-7262-4fb8-adb6-e10d1f54269f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.28:37 - 19.33:37
Direktverkande insulin 0.09 IE (1.08 IE/t, 1.55 % = 1.67 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a8c5a0ec-3573-5a9c-8f63-600e0bfc3d2b

```

-------

Entry 51 - fullUrl = urn:uuid:b4d3b67e-ff6f-4c0e-8e6a-6912963bcf50

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.29:35
Vävnadssocker: 10.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:86da8383-10e2-5e3e-9abc-24d0cd44f861

```

-------

Entry 52 - fullUrl = urn:uuid:64147237-4089-4811-9c1e-6916678129dc

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.33:37 - 19.38:39
Direktverkande insulin 0.07 IE (0.82 IE/t, 1.17 % = 0.96 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bc203d18-53c2-5244-9363-47aeac82de9e

```

-------

Entry 53 - fullUrl = urn:uuid:b66e994b-0a2d-4b74-a0e9-fcee3078f942

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.34:34
Vävnadssocker: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ce22f63c-34c6-53ed-84e5-e9945492435f

```

-------

Entry 54 - fullUrl = urn:uuid:d99ef8f6-bdde-40f5-abd6-a2d2405cefc8

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.38:39 - 19.43:39
Direktverkande insulin 0.10 IE (1.18 IE/t, 1.68 % = 1.99 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:863015d3-72b3-5da8-846c-28ddce93a2bd

```

-------

Entry 55 - fullUrl = urn:uuid:60510489-7257-4a0d-a2f2-101e731330cb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.39:34
Vävnadssocker: 11.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2d17f11e-ac50-5687-9060-9a8e20baf9ea

```

-------

Entry 56 - fullUrl = urn:uuid:be588032-f0f4-4e04-b4ef-bc85f6bbd0c7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.43:39 - 19.48:40
Direktverkande insulin 0.14 IE (1.68 IE/t, 2.40 % = 4.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b0696def-3737-594d-a7f2-a399cf4517c8

```

-------

Entry 57 - fullUrl = urn:uuid:9bb5d0b0-f434-497a-8412-1e3885c33211

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.44:34
Vävnadssocker: 11.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ed032dd1-12a2-572f-a61e-f24513745bd3

```

-------

Entry 58 - fullUrl = urn:uuid:fdaae873-fcfd-40d2-8c4e-81ba480455c0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.48:40 - 19.53:40
Direktverkande insulin 0.15 IE (1.83 IE/t, 2.62 % = 4.79 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:98aea78b-946f-578b-bd7e-016a48157e72

```

-------

Entry 59 - fullUrl = urn:uuid:99642690-f4ac-4153-aaf5-814718d4be9d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.49:34
Vävnadssocker: 11.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2dbcb5a2-6d39-5009-b2b2-0128adca623c

```

-------

Entry 60 - fullUrl = urn:uuid:ec267339-cd8a-41da-aca0-4f05e42ef3fe

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.53:40 - 19.58:41
Direktverkande insulin 0.15 IE (1.76 IE/t, 2.51 % = 4.41 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b2fa48cc-711a-5504-888b-b0b443426249

```

-------

Entry 61 - fullUrl = urn:uuid:833ea53b-acaf-481c-b1fb-d37d4ec1a770

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.54:34
Vävnadssocker: 11.93 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e69bbc26-fd1f-5e92-9f4a-f2917483faa8

```

-------

Entry 62 - fullUrl = urn:uuid:f59617c8-d612-4847-a8d3-db8476dec2eb

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 19.58:41 - 20.03:43
Direktverkande insulin 0.14 IE (1.70 IE/t, 2.43 % = 4.12 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:65f4ab86-4e76-53c7-85fe-0bf158ea0891

```

-------

Entry 63 - fullUrl = urn:uuid:df21cb83-0eb0-43c0-8d35-9a086887ef2d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 19.59:34
Vävnadssocker: 12.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:23a476c1-c698-55d4-9598-621363521b28

```

-------

Entry 64 - fullUrl = urn:uuid:530e4e1b-85bb-499f-b5f1-049d2d0d012e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 20.03:43 - 20.08:44
Direktverkande insulin 0.14 IE (1.73 IE/t, 2.47 % = 4.28 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:15a8286f-aefd-5090-8cd1-7f2567088e12

```

-------

Entry 65 - fullUrl = urn:uuid:cabeb421-ae40-417c-a8df-1389a89c8b1a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.04:34
Vävnadssocker: 12.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:572338e3-5d06-5e3f-b8db-0a2b1afc4f0d

```

-------

Entry 66 - fullUrl = urn:uuid:0e4f89f3-05d2-44e7-9282-c1e26e975a8c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 20.08:44 - 20.13:43
Direktverkande insulin 0.16 IE (1.94 IE/t, 2.77 % = 5.38 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7374b52e-af7b-525d-a6b6-8ab2f5bb499e

```

-------

Entry 67 - fullUrl = urn:uuid:cf0fd7ec-6911-4f25-95de-38dc596fcbd7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.09:34
Vävnadssocker: 12.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:49cbc345-0323-5603-8fb6-a49fd715a9e7

```

-------

Entry 68 - fullUrl = urn:uuid:58e54474-f869-4d08-9d57-3060b4403c98

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 20.13:43 - 20.18:46
Direktverkande insulin 0.18 IE (2.16 IE/t, 3.09 % = 6.67 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a4a3ed0f-db40-5fc2-871b-a52153a5bb7f

```

-------

Entry 69 - fullUrl = urn:uuid:9fb8d86d-35ad-48b1-8ddb-5912477440a6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.14:34
Vävnadssocker: 12.54 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:46be2b61-5358-5570-a1c2-544b1c328890

```

-------

Entry 70 - fullUrl = urn:uuid:6d131b89-8656-4b9b-83ca-31fbe41a0298

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 20.18:46 - 20.23:46
Direktverkande insulin 0.19 IE (2.33 IE/t, 3.33 % = 7.74 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c265dcd8-e009-5694-95ee-5aea3c83d0a4

```

-------

Entry 71 - fullUrl = urn:uuid:584e71a7-889a-4780-952a-14615e53fd34

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 20.19:00
Direktverkande insulin 1.37 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1135e28e-5fc4-5382-8a80-3a6e31226676

```

-------

Entry 72 - fullUrl = urn:uuid:276119ba-45a1-4495-b1eb-6381158cba7c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.19:34
Vävnadssocker: 12.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a6380549-6b6a-5116-b566-ff8d6c704f81

```

-------

Entry 73 - fullUrl = urn:uuid:4686d88c-cf7e-4f94-84ad-b7e2c6211e15

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 20.23:46 - 22.09:02
Direktverkande insulin 1.23 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9a8ea204-10f3-5a54-9431-1d3680bb607c

```

-------

Entry 74 - fullUrl = urn:uuid:cf992afe-e1d9-42e8-add9-ece6603eff33

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.24:35
Vävnadssocker: 12.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6121a81f-c55c-5e69-8c44-593f4086f536

```

-------

Entry 75 - fullUrl = urn:uuid:990b4992-4458-4d7c-a122-62ed466b88a3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.29:35
Vävnadssocker: 12.54 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d2e418bb-1905-51da-8af4-c9fcecee052e

```

-------

Entry 76 - fullUrl = urn:uuid:639246b9-7100-496e-bac8-49519742eada

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.34:34
Vävnadssocker: 12.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5334a0f0-f13b-540a-af97-63743830a7b0

```

-------

Entry 77 - fullUrl = urn:uuid:fc171607-f058-4141-b5d8-b76a830a6003

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.39:34
Vävnadssocker: 11.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2e03a576-e07c-59e6-b253-8915beb623e9

```

-------

Entry 78 - fullUrl = urn:uuid:ae92ce17-7fe4-471f-aa7e-d810abe77133

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.44:34
Vävnadssocker: 11.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:37019925-a02e-5180-a680-4c316d359385

```

-------

Entry 79 - fullUrl = urn:uuid:b87733e7-d8be-4717-a519-71e37854785f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.49:34
Vävnadssocker: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:02889dcc-0d42-543e-9d2e-ae294aeb5fb4

```

-------

Entry 80 - fullUrl = urn:uuid:566224b3-3dfc-4a0c-9998-60d89b738517

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.54:34
Vävnadssocker: 11.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:781e868e-ad81-5abd-8407-3268a8108943

```

-------

Entry 81 - fullUrl = urn:uuid:df770dc5-603d-4635-b2ad-f443e89753c5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 20.59:34
Vävnadssocker: 11.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d54306cc-07b3-5a18-b893-d433c2951836

```

-------

Entry 82 - fullUrl = urn:uuid:937b1adc-dcd6-4b60-acea-ad23b5de5e5d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.04:34
Vävnadssocker: 10.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:665a41bd-1e35-5cb8-afd9-5efcdb65e701

```

-------

Entry 83 - fullUrl = urn:uuid:0cf60c8a-a394-43c9-9535-a4a007a1d575

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.09:34
Vävnadssocker: 10.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a6d0919c-b0d1-59a0-ad9b-10cd9736b7c2

```

-------

Entry 84 - fullUrl = urn:uuid:73c57cea-17b9-4ca2-b6bc-80a47cbedceb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.14:34
Vävnadssocker: 10.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5d89a84e-63fa-597e-8018-6a2403685e6e

```

-------

Entry 85 - fullUrl = urn:uuid:78829e0e-24f5-4327-bd2d-df870ea271dc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.19:35
Vävnadssocker: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4e44c77c-1d3e-5beb-878a-c0d4829bb40a

```

-------

Entry 86 - fullUrl = urn:uuid:b4fbdf07-f2af-43a0-aa00-4d3f5d76f68b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.24:34
Vävnadssocker: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:504d25e3-4c40-5018-a79f-fda3cb77deff

```

-------

Entry 87 - fullUrl = urn:uuid:540c137b-4fd2-4096-b494-cd767668fd6c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.29:34
Vävnadssocker: 9.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b4bea7d5-4efe-54de-8823-1e3d5909addf

```

-------

Entry 88 - fullUrl = urn:uuid:c9c7ccdc-7cad-4cb6-85c5-c77c17661868

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.34:35
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7b44c956-7abb-5544-a92b-f2ac5d904230

```

-------

Entry 89 - fullUrl = urn:uuid:4c786a26-acea-4842-94c3-e69cc96c02f8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.39:34
Vävnadssocker: 8.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a86cf942-3cb9-5eae-915a-b3a18dbf37a1

```

-------

Entry 90 - fullUrl = urn:uuid:2876e7f3-00bf-4bc8-82fd-9d74b944b5d6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.44:34
Vävnadssocker: 8.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cb9b74db-6b81-5dec-991d-3bd4cebb7c00

```

-------

Entry 91 - fullUrl = urn:uuid:d5af97ed-1543-49b8-8a13-34f198b6a7e3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.49:34
Vävnadssocker: 8.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d753e119-725f-523f-a922-1ef94f8d0fdc

```

-------

Entry 92 - fullUrl = urn:uuid:2e864c7f-15fc-49c4-928a-b51d27ad0e15

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.54:34
Vävnadssocker: 8.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3dbcdc09-aa22-5ea3-b0e0-80c37ca19448

```

-------

Entry 93 - fullUrl = urn:uuid:c5959652-c924-4083-a9b5-179cf290b12e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 21.59:34
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:233ee9b0-9412-5d5a-a665-ad044879f34e

```

-------

Entry 94 - fullUrl = urn:uuid:08c15f5f-d405-4205-abe0-25c5ff42749e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.04:34
Vävnadssocker: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ea62e677-2830-5a12-95f1-c02243c8d435

```

-------

Entry 95 - fullUrl = urn:uuid:cbd5ea8f-5aaa-4d66-b4fc-70bc21b617ba

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.09:02 - 22.14:03
Direktverkande insulin 0.02 IE (0.18 IE/t, 0.26 % = 0.05 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6a3d0a6d-4860-548b-b9e4-771a16b6a724

```

-------

Entry 96 - fullUrl = urn:uuid:4e493107-8e17-4f6c-becf-ec0d63e89e60

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.09:34
Vävnadssocker: 6.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5b632391-2d13-5882-81ec-39306a864b3f

```

-------

Entry 97 - fullUrl = urn:uuid:4b307f0f-9e95-4e77-9471-5914d988741c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.14:03 - 22.24:05
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e58ff466-a46c-5ece-9bb0-ce8a2ef68a9a

```

-------

Entry 98 - fullUrl = urn:uuid:6470f1ec-bde8-4c09-9c81-1f4709ce7162

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.14:34
Vävnadssocker: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f89a8e53-5c0f-5869-a1aa-06772d0275bd

```

-------

Entry 99 - fullUrl = urn:uuid:2a020127-1a4a-4893-baec-f4bd49625a3a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.15:14
Direktverkande insulin 2.50 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7daa6d84-e967-5321-ae29-7939e6b4d1bb

```

-------

Entry 100 - fullUrl = urn:uuid:468b6b1f-fc4a-4995-b6aa-3ca79507fc96

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 4.9.2021 22.15:14
Beräknad mängd kolhydratintag: 30 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:042e1ef4-fd10-592e-961e-bd062349b7e2

```

-------

Entry 101 - fullUrl = urn:uuid:6486b963-e7b8-4a98-b772-46f9031deada

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.19:34
Vävnadssocker: 6.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ea02d451-f7c1-5bd3-848e-9e94621422ad

```

-------

Entry 102 - fullUrl = urn:uuid:16aba3ea-cb9c-47f4-ab2c-4a756c8e994b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.24:05 - 22.29:05
Direktverkande insulin 0.05 IE (0.62 IE/t, 0.88 % = 0.54 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2fe4c908-262b-5a5f-bbd4-ef520d8da803

```

-------

Entry 103 - fullUrl = urn:uuid:eff34d59-cda7-48bc-a79a-c0335c05aa44

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.24:34
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b68e1d90-f8b8-5642-b426-a75f6062d4ae

```

-------

Entry 104 - fullUrl = urn:uuid:3c5a41a3-604e-4b33-af9b-87c5186b477c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.29:05 - 22.34:06
Direktverkande insulin 0.03 IE (0.32 IE/t, 0.46 % = 0.15 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f9fd0f28-de02-5a15-953b-308ab5615543

```

-------

Entry 105 - fullUrl = urn:uuid:641906ae-401c-4166-99f5-3166fb7bd407

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.29:34
Vävnadssocker: 6.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:edca5d11-4d5e-5c6a-babd-eb5b67bf8f13

```

-------

Entry 106 - fullUrl = urn:uuid:6e0ef5a0-b700-408a-bb54-a63b48a05906

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.34:06 - 22.39:07
Direktverkande insulin 0.05 IE (0.64 IE/t, 0.91 % = 0.59 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9727e1e5-9187-5841-b025-e23376a5be23

```

-------

Entry 107 - fullUrl = urn:uuid:b95dd656-df06-4d50-b312-69b688003732

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.34:34
Vävnadssocker: 6.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:030eebe1-0369-5c17-b980-d42d59375082

```

-------

Entry 108 - fullUrl = urn:uuid:60f61847-f345-4ac9-bcd3-16b0c55eccf8

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.39:07 - 22.44:08
Direktverkande insulin 0.06 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4aeed6e4-3038-52d1-b435-dd324d6dbe1c

```

-------

Entry 109 - fullUrl = urn:uuid:de39b330-321e-4995-a313-21656a827e85

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.39:34
Vävnadssocker: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b7123b48-b084-565a-adac-09ef4a4d242c

```

-------

Entry 110 - fullUrl = urn:uuid:6d520fee-cf8e-4a9d-8f62-2d9e7e79da98

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.44:08 - 22.49:09
Direktverkande insulin 0.06 IE (0.69 IE/t, 0.98 % = 0.68 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2d05fb4f-65c5-52ce-8842-bc28bbdfc523

```

-------

Entry 111 - fullUrl = urn:uuid:9ecf014d-7958-4e8f-8d90-0a51dc316e89

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.44:34
Vävnadssocker: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:42e50151-941d-55f6-bf2f-0a9efdf526aa

```

-------

Entry 112 - fullUrl = urn:uuid:e3ba1617-a37e-4a16-b9c4-06bd3dd8736e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.49:09 - 22.54:10
Direktverkande insulin 0.02 IE (0.23 IE/t, 0.33 % = 0.07 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4d918350-4a4f-5ef2-b8ef-5c93a3372500

```

-------

Entry 113 - fullUrl = urn:uuid:624b4279-b85a-4639-8293-f05e6564e96d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.49:34
Vävnadssocker: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5388ae43-2c98-5fc6-9f69-3567d92d79b3

```

-------

Entry 114 - fullUrl = urn:uuid:cb9229b9-f68f-4d5a-816b-7f6dcfcc520f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.54:10 - 22.59:11
Direktverkande insulin 0.02 IE (0.21 IE/t, 0.31 % = 0.07 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:37db93e4-217b-551d-89a2-d44bed613934

```

-------

Entry 115 - fullUrl = urn:uuid:76c8d8de-313b-4490-a275-07cb414ecfe9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.54:34
Vävnadssocker: 5.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d86b59b0-1105-5127-bbf7-0569efd3d5e0

```

-------

Entry 116 - fullUrl = urn:uuid:3cbdaebb-47da-4d21-b57f-24ec3d1e576d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 22.59:11 - 23.04:11
Direktverkande insulin 0.01 IE (0.11 IE/t, 0.16 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:91d16d6c-05f0-5586-ba50-a53ecb611575

```

-------

Entry 117 - fullUrl = urn:uuid:426ccc28-a391-429c-a4a9-e43e064c8a3a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 22.59:34
Vävnadssocker: 4.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:afcce744-24fc-5616-b291-f0cb8b359569

```

-------

Entry 118 - fullUrl = urn:uuid:7272e6ad-674f-408f-9737-5c225757faf2

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.04:11 - 23.24:14
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:248142d9-ec5e-5de9-bd1f-e372447bf16f

```

-------

Entry 119 - fullUrl = urn:uuid:b34ed48a-5cfa-4047-a847-0a043b9a874b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.04:35
Vävnadssocker: 5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e2ef7261-97bf-54fb-8844-00438896ab2f

```

-------

Entry 120 - fullUrl = urn:uuid:1554099d-1062-4756-9369-571b1262cb5d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.09:35
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9f5e9937-82c2-5f89-82f2-51824a7141c8

```

-------

Entry 121 - fullUrl = urn:uuid:968719c6-c1bc-4963-a006-73c68a9d2ff5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.14:35
Vävnadssocker: 5.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1e5173bb-bbe9-5e9e-8bec-2b71a8e79dd1

```

-------

Entry 122 - fullUrl = urn:uuid:5f21a41c-010a-472d-8e02-9df056e68ebc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.19:34
Vävnadssocker: 5.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:91d436e0-26c7-5535-ba3c-f6d87e74f071

```

-------

Entry 123 - fullUrl = urn:uuid:33c6c782-b01b-4943-912d-32a356287746

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.24:14 - 23.29:14
Direktverkande insulin 0.01 IE (0.12 IE/t, 0.16 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1d998cac-b8db-5368-a45a-54fd91f8f0c9

```

-------

Entry 124 - fullUrl = urn:uuid:c8693ebc-2c45-4576-afe5-faf8ebd2e274

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.24:33
Vävnadssocker: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:55f1fa5a-b20d-5062-a537-8494441d93d6

```

-------

Entry 125 - fullUrl = urn:uuid:7cc7f4d8-3a8e-4e62-a76c-9c0cd86805f3

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.29:14 - 23.34:16
Direktverkande insulin 0.01 IE (0.17 IE/t, 0.23 % = 0.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9cf0576a-4f45-5e2b-82cc-f6c3cca52fe1

```

-------

Entry 126 - fullUrl = urn:uuid:04539596-332b-44e9-9548-9f82ec1714cc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.29:33
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:18c34929-5dfb-592c-b6ad-321ba7ab72ab

```

-------

Entry 127 - fullUrl = urn:uuid:fdc90f3e-4a63-4530-991d-cc738cb615dd

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.34:16 - 23.44:17
Direktverkande insulin 0.13 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c969d01b-c102-5fcc-8ddc-5a88eb31e572

```

-------

Entry 128 - fullUrl = urn:uuid:f675a513-fc25-42cd-b0a1-24f11d8b6406

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.34:34
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d4ba2747-aa96-5cc9-adda-9724c972230a

```

-------

Entry 129 - fullUrl = urn:uuid:8543b0f3-8487-4b25-91f1-f5df89204572

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.39:34
Vävnadssocker: 5.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:114082c2-e896-5acd-a1d4-9f11c2ee532f

```

-------

Entry 130 - fullUrl = urn:uuid:9c315e08-90ac-4ea1-9c0f-05fb3f2dfa89

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.44:17 - 23.49:18
Direktverkande insulin 0.04 IE (0.51 IE/t, 0.67 % = 0.34 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6b0f0c5d-6570-500e-80a9-30300015e067

```

-------

Entry 131 - fullUrl = urn:uuid:e6310232-ca15-435f-9ece-faf6542884d9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.44:34
Vävnadssocker: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ea0c1e30-1cf8-587f-bbbb-60889fc23fd3

```

-------

Entry 132 - fullUrl = urn:uuid:a4a90144-765b-488e-b586-6aa5da8b9f66

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.49:18 - 23.54:20
Direktverkande insulin 0.01 IE (0.13 IE/t, 0.17 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6e5df6d5-1a84-55c4-a3a3-86c6307271e3

```

-------

Entry 133 - fullUrl = urn:uuid:069d0060-7df4-4eb5-9438-6276a22f202d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.49:34
Vävnadssocker: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aaeb4679-7917-5561-be5f-205187ddb9e7

```

-------

Entry 134 - fullUrl = urn:uuid:a5f96329-c86e-459d-bce7-bf453b7dc281

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.54:20 - 23.59:20
Direktverkande insulin 0.01 IE (0.12 IE/t, 0.15 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c67b9a42-83e0-5298-976f-635ca8235b56

```

-------

Entry 135 - fullUrl = urn:uuid:435495a9-c0af-455b-82c6-10eda6d41a97

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.54:33
Vävnadssocker: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:63de485f-ef17-572e-ab3a-f586ef5834c3

```

-------

Entry 136 - fullUrl = urn:uuid:13e09cfb-effd-4841-9edd-d18ed94fd42a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 4.9.2021 23.59:20 - 5.9.2021 00.00:00
Direktverkande insulin 0.00 IE (0.13 IE/t, 0.17 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fbff9802-6055-51e4-8246-02b88a20cfee

```

-------

Entry 137 - fullUrl = urn:uuid:971792be-3599-4252-a1c2-33d768784379

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 4.9.2021 23.59:33
Vävnadssocker: 5.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:39937fb4-3225-56cf-8b1a-4bef4683daeb

```

-------

Entry 138 - fullUrl = urn:uuid:52bd2e27-8f4f-4568-b701-00a1e377435c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 00.00:00 - 00.02:30
Direktverkande insulin 0.01 IE (0.12600000202655792 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3bc19263-50d3-5c5a-962d-3ebc7cf4cf59

```

-------

Entry 139 - fullUrl = urn:uuid:0633828a-7911-4223-a3e6-a9c147c6c4f1

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 00.02:30 - 00.22:06
Direktverkande insulin 0.00 IE (0 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5683e305-7764-553d-a130-dbe1c8698e12

```

-------

Entry 140 - fullUrl = urn:uuid:03aaa416-55d5-466c-ad44-a9ff0f3a75ee

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.04:33
Vävnadssocker: 4.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c7652b32-12d3-52ac-a912-f336c9931ba8

```

-------

Entry 141 - fullUrl = urn:uuid:edd31aea-4ed2-44ea-9b8e-9d1f38f370c7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.09:33
Vävnadssocker: 4.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cb267b33-16c3-50d4-a146-dbed263149ea

```

-------

Entry 142 - fullUrl = urn:uuid:78555972-fce8-48c1-bbd5-1febdc9b60ba

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.14:34
Vävnadssocker: 4.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ea5534e3-d1d3-5f78-84e4-a0dcaabec2cd

```

-------

Entry 143 - fullUrl = urn:uuid:24f85e46-af92-4816-a952-6dfb47071bfb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.19:34
Vävnadssocker: 3.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:34f4e352-e876-50f3-b4a3-6ad6e1a298fb

```

-------

Entry 144 - fullUrl = urn:uuid:56d22676-2fa4-46ff-b895-1f87d513e2fd

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 00.22:06 - 01.57:19
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4dfa84c1-f2cb-580b-8b61-f9908b529e16

```

-------

Entry 145 - fullUrl = urn:uuid:71134920-5a23-4f8d-b6e4-8fc42ce8d69b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.24:34
Vävnadssocker: 3.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:350aafcd-0917-5a37-a836-c8269e73985a

```

-------

Entry 146 - fullUrl = urn:uuid:cd0070d9-42f0-4552-a3bb-5bd92e84d00c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.29:33
Vävnadssocker: 2.78 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc5df95b-9ef7-5f48-afb5-5971a6476c9b

```

-------

Entry 147 - fullUrl = urn:uuid:e99a6890-e704-4529-b217-b2c3ac5443aa

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.34:33
Vävnadssocker: 2.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:17c2f124-e6c1-5918-a22f-17b07b7c2331

```

-------

Entry 148 - fullUrl = urn:uuid:5692427a-0b19-49a6-a5ed-ac235c56b35c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.39:33
Vävnadssocker: 3.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b07a7b7d-3aa3-5d12-adcd-6c95919b5282

```

-------

Entry 149 - fullUrl = urn:uuid:d5f51cee-2d76-4ca3-b1a5-d814a6e52b14

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.44:33
Vävnadssocker: 3.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7483b48a-83e8-5b2f-8100-902441938c2c

```

-------

Entry 150 - fullUrl = urn:uuid:d22ef3a2-c4f0-4982-815e-a6a5becc2a2d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.49:33
Vävnadssocker: 3.39 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9c9795c8-109d-5bd4-8e0b-da0106aef323

```

-------

Entry 151 - fullUrl = urn:uuid:1a470306-bbd5-441c-a439-09192ce9a1dc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.54:33
Vävnadssocker: 3.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:47491406-fb13-5fcb-afb3-9c6a1d699d5d

```

-------

Entry 152 - fullUrl = urn:uuid:dec98320-7c1d-48f7-995f-ff5b8ace743f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 00.59:33
Vävnadssocker: 3.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cf5732e5-7cc4-5fe8-8419-9239630f9d96

```

-------

Entry 153 - fullUrl = urn:uuid:ab31f5c1-df74-4c67-8975-462143218360

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.04:33
Vävnadssocker: 3.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3246888a-56d7-5521-bcf3-84aeb3f6786e

```

-------

Entry 154 - fullUrl = urn:uuid:4620a863-1411-4e1a-8c8c-57971f3a5d7e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.09:33
Vävnadssocker: 3.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2b52f13-d8c7-5c13-8240-5786131ece66

```

-------

Entry 155 - fullUrl = urn:uuid:10891935-d77e-4d93-8ea6-b76f2fb54f5a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.14:33
Vävnadssocker: 3.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:90c9b0d3-f8b8-5622-b9f9-15ee95245467

```

-------

Entry 156 - fullUrl = urn:uuid:aa6fc66c-c18f-411e-b3aa-0eb838ea155f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.19:33
Vävnadssocker: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4d11ab55-6784-51ec-90dd-46167ac9b14c

```

-------

Entry 157 - fullUrl = urn:uuid:9dac1d51-f884-4bf4-8223-86b86bdeebfe

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.24:33
Vävnadssocker: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8f557f00-1343-5ab6-bb85-d6b38d88eab9

```

-------

Entry 158 - fullUrl = urn:uuid:c0b4b3fc-6265-4499-b676-0b2f158590b7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.29:33
Vävnadssocker: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:16895fff-ef7d-5862-b884-1b00f6f40f97

```

-------

Entry 159 - fullUrl = urn:uuid:72d7af0e-48c2-4daa-a6ae-6502e179f07b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.34:33
Vävnadssocker: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:190b03cb-4269-5f67-b05a-bc5c2607af3e

```

-------

Entry 160 - fullUrl = urn:uuid:b8d8eaa4-2e43-406d-980a-7ce0ff6e8440

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.39:33
Vävnadssocker: 3.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c06c9e3-2338-5b9a-b336-f698ed6f67ea

```

-------

Entry 161 - fullUrl = urn:uuid:f45bcb40-abf4-4d88-9581-114ca22d8012

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.44:33
Vävnadssocker: 4 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5dd04e11-06b2-5d24-96b1-c567ed5ac8c7

```

-------

Entry 162 - fullUrl = urn:uuid:88f24310-b777-4de2-913d-7e6438c2fc28

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.49:33
Vävnadssocker: 4.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4d49d1f0-8a8a-5c82-a74d-fde3a4b700e6

```

-------

Entry 163 - fullUrl = urn:uuid:a129caf4-59a7-443f-8b90-765da0638728

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.54:33
Vävnadssocker: 4.39 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bafa9e94-1962-5cf9-932c-b01a8579a224

```

-------

Entry 164 - fullUrl = urn:uuid:8c1b590c-e1d7-4b3d-a72a-57efcb07039d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 01.57:19 - 02.02:20
Direktverkande insulin 0.02 IE (0.19 IE/t, 0.25 % = 0.05 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f397dd6a-41cd-5545-8303-1948d3aa7330

```

-------

Entry 165 - fullUrl = urn:uuid:3b71c6b0-255f-49cb-8efe-15584dd88d62

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 01.59:33
Vävnadssocker: 4.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5202eac5-e676-5ea7-abe6-1afb9e3c87fc

```

-------

Entry 166 - fullUrl = urn:uuid:f976367c-96e6-4aa4-bc19-106799a33067

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.02:20 - 02.07:21
Direktverkande insulin 0.02 IE (0.28 IE/t, 0.38 % = 0.11 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9134f825-083e-5a62-a448-35a77e9467c0

```

-------

Entry 167 - fullUrl = urn:uuid:bf66f3ad-bd92-4624-adc9-b8c0f2a8df3c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.04:33
Vävnadssocker: 4.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ec466357-f424-5b14-bed5-4b199fbb75aa

```

-------

Entry 168 - fullUrl = urn:uuid:88d92e81-3291-47a4-a4ab-4b4b8571c61e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.07:21 - 02.12:22
Direktverkande insulin 0.01 IE (0.16 IE/t, 0.22 % = 0.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:944f6b8c-b32d-5455-9b6c-a2e2b9e17768

```

-------

Entry 169 - fullUrl = urn:uuid:4c3694e4-227d-4add-97ba-532aa0e28074

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.09:35
Vävnadssocker: 4.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:701820be-f09c-52d3-aa17-748381fb8678

```

-------

Entry 170 - fullUrl = urn:uuid:a4ddc8e6-ebee-4304-830a-ec3e2e9b034a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.12:22 - 02.27:23
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:db9a9f67-18ae-57ea-bfcd-1cdd7d8f2815

```

-------

Entry 171 - fullUrl = urn:uuid:635c42ca-c9c9-48f0-bc46-ba1c94db9f01

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.14:33
Vävnadssocker: 4.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fbec9387-ac14-5817-8795-2c029b772ba0

```

-------

Entry 172 - fullUrl = urn:uuid:fc8cb1a1-8e39-40f2-9df2-7880f64a259b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.19:33
Vävnadssocker: 4.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9c81c527-3ff7-52b2-aed3-f8cf3760a1df

```

-------

Entry 173 - fullUrl = urn:uuid:c725f81e-b52e-4217-a499-43a9469cc8d6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.24:33
Vävnadssocker: 4.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:edb00f93-832f-5cfd-877f-70509bc469b8

```

-------

Entry 174 - fullUrl = urn:uuid:3f327a57-1001-409c-aacc-362c90dd9f1a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.27:23 - 02.32:24
Direktverkande insulin 0.03 IE (0.33 IE/t, 0.44 % = 0.14 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:55ec0db8-9374-5b6d-ada4-8c705b3d2bfe

```

-------

Entry 175 - fullUrl = urn:uuid:53b8804c-186a-4cc4-b963-705a002886a8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.29:40
Vävnadssocker: 4.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e71fdbc6-6aba-5d4c-a401-657f4d63d136

```

-------

Entry 176 - fullUrl = urn:uuid:3280c895-7fe8-4600-a740-8a22ac179b1f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.32:24 - 02.37:24
Direktverkande insulin 0.03 IE (0.33 IE/t, 0.44 % = 0.14 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a5a3edb5-86e7-5c0a-9a08-78e7fe52199a

```

-------

Entry 177 - fullUrl = urn:uuid:00becd75-27fd-4e28-8763-0f9cf095fbda

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.34:40
Vävnadssocker: 5.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b49b8b15-9ca8-50c8-9cb1-8f8f511de821

```

-------

Entry 178 - fullUrl = urn:uuid:571ebca9-2b15-416f-9da0-300841eec549

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.37:24 - 02.42:25
Direktverkande insulin 0.04 IE (0.46 IE/t, 0.61 % = 0.28 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8d32fd49-d905-579c-817f-b9c3b69fc22e

```

-------

Entry 179 - fullUrl = urn:uuid:fe102e1f-120b-4102-a37a-213e02ef8868

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.39:40
Vävnadssocker: 5.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5f3fae86-d78a-51ae-a343-e5090e8f67c4

```

-------

Entry 180 - fullUrl = urn:uuid:9c162651-8e92-4b3b-8147-ae99638701c7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.42:25 - 02.47:26
Direktverkande insulin 0.05 IE (0.58 IE/t, 0.77 % = 0.45 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4f2c399f-dfb8-5b52-b576-b67f872359c8

```

-------

Entry 181 - fullUrl = urn:uuid:c41bb909-2632-4635-9e1d-6cb0ff8a06c1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.44:34
Vävnadssocker: 5.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1c260c25-e9c2-556c-8dec-bccced1adfef

```

-------

Entry 182 - fullUrl = urn:uuid:b427bb2a-e023-480c-9304-fec7493568e0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.47:26 - 02.52:27
Direktverkande insulin 0.06 IE (0.75 IE/t, 1.00 % = 0.75 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:de6a517f-cf7a-5571-8c5d-3bd55c918e9e

```

-------

Entry 183 - fullUrl = urn:uuid:603c1d64-fe51-414a-a9d7-32621c4e70da

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.49:33
Vävnadssocker: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56865850-933d-5cad-b77d-27065c55d7af

```

-------

Entry 184 - fullUrl = urn:uuid:4ae1e44c-7c6d-4373-b4d7-bdba7b0b3964

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.52:27 - 02.57:28
Direktverkande insulin 0.06 IE (0.76 IE/t, 1.01 % = 0.76 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:269a8d70-06f1-50fe-ab6b-8d29835c0deb

```

-------

Entry 185 - fullUrl = urn:uuid:6e5c3279-d69c-47a2-a33d-85c3ef424735

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.54:33
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:37c92996-45f0-5c47-a6ee-d4ed9c55f387

```

-------

Entry 186 - fullUrl = urn:uuid:a7d82f91-2434-42f3-ad49-f8398e047b01

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 02.57:28 - 03.02:29
Direktverkande insulin 0.09 IE (1.06 IE/t, 1.42 % = 1.51 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3e93041a-85de-5712-83ad-3cac90c7aac0

```

-------

Entry 187 - fullUrl = urn:uuid:70d7bc83-6168-4da5-8b56-3bfdd22c0dd4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 02.59:36
Vävnadssocker: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f9a13339-f445-5d30-91d8-24c038ef476f

```

-------

Entry 188 - fullUrl = urn:uuid:5ce3039e-1398-4850-bb79-425033a9ef15

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.02:29 - 03.07:30
Direktverkande insulin 0.08 IE (1.01 IE/t, 1.35 % = 1.37 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bf53f32f-e545-54f2-b2c2-c7edfa56bb84

```

-------

Entry 189 - fullUrl = urn:uuid:232cdb1c-be70-4bc5-9300-6d61ee14a71f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.04:34
Vävnadssocker: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4e0e8b29-d6e4-5f4e-b948-2a35c88d23f0

```

-------

Entry 190 - fullUrl = urn:uuid:33d3eb0e-85c2-4576-8c9c-984880249762

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.07:30 - 03.12:31
Direktverkande insulin 0.08 IE (1.00 IE/t, 1.34 % = 1.35 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:60e2e180-b055-5e4e-96e5-5e8b53cd4cc7

```

-------

Entry 191 - fullUrl = urn:uuid:1f0bed91-b86f-4737-976e-6d9bc6cdd63f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.09:34
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:41effd62-de57-5d20-bd17-747a9550cf5a

```

-------

Entry 192 - fullUrl = urn:uuid:1d4b572c-2794-4c15-a77e-d170c6fa8f4e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.12:31 - 03.17:30
Direktverkande insulin 0.08 IE (0.99 IE/t, 1.33 % = 1.32 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e3e98120-d037-578b-a602-d15701e726b5

```

-------

Entry 193 - fullUrl = urn:uuid:efbf6998-f43a-4abc-904d-a4c445abad1d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.14:34
Vävnadssocker: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ab571ac3-2ae6-5f46-88f3-f4cf4f5eed89

```

-------

Entry 194 - fullUrl = urn:uuid:68d15876-7593-451d-820e-43a283da2339

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.17:30 - 03.22:31
Direktverkande insulin 0.10 IE (1.25 IE/t, 1.67 % = 2.09 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9f98bef8-dcd8-5fe2-aef3-ca5d19528449

```

-------

Entry 195 - fullUrl = urn:uuid:2242bc5c-ca22-4a31-a396-532f1a832f2d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.19:36
Vävnadssocker: 6.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8971334f-283c-52d2-b983-b6453d060d89

```

-------

Entry 196 - fullUrl = urn:uuid:1ad2983b-ca64-4397-95d2-28e9b7e236bc

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.22:31 - 03.27:31
Direktverkande insulin 0.12 IE (1.50 IE/t, 1.99 % = 2.98 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:65f94c66-9920-5cf7-bba2-4b3957d4b1c6

```

-------

Entry 197 - fullUrl = urn:uuid:f4f30952-e0a7-4c42-ace9-7780fb01fe9f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.24:34
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:42b88593-0981-5464-ac1c-0a59db6d8a5f

```

-------

Entry 198 - fullUrl = urn:uuid:df949b7a-a885-4cbc-b046-0ea1412891ef

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.27:31 - 03.32:33
Direktverkande insulin 0.14 IE (1.66 IE/t, 2.21 % = 3.66 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bfea425f-89df-5a9c-a18a-2b59806ff3cd

```

-------

Entry 199 - fullUrl = urn:uuid:7c9e2a46-fe98-46b4-9afb-e9ff7069ad67

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.29:33
Vävnadssocker: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ad91b52c-7d98-5b0f-9203-f35c67eba4bb

```

-------

Entry 200 - fullUrl = urn:uuid:48bfa121-771d-488f-bd6d-e21645d87d28

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.32:33 - 03.37:35
Direktverkande insulin 0.13 IE (1.52 IE/t, 2.03 % = 3.10 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:47670c2b-08d4-5060-959e-412ad01d0ff7

```

-------

Entry 201 - fullUrl = urn:uuid:35e00efc-9ac3-49c9-87e1-748a82fcfbc4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.34:39
Vävnadssocker: 7.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ae130401-86c2-555c-ba0d-c6f51edd8a07

```

-------

Entry 202 - fullUrl = urn:uuid:4bd3386d-65dc-481b-8d23-38ab034741e7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.37:35 - 03.42:34
Direktverkande insulin 0.16 IE (1.95 IE/t, 2.60 % = 5.06 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a15931a2-f922-5031-bae2-f15aff5cb354

```

-------

Entry 203 - fullUrl = urn:uuid:e7bc0ea7-5048-4ac6-912b-bb3e2e237916

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.39:34
Vävnadssocker: 7.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2462848-8622-5615-9151-b773468e226b

```

-------

Entry 204 - fullUrl = urn:uuid:775d78ba-f186-47e3-9bba-dfc69cc449ee

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.42:34 - 03.47:35
Direktverkande insulin 0.19 IE (2.23 IE/t, 2.98 % = 6.64 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a8f9f5e8-7846-5445-b9ce-f08add98fa1e

```

-------

Entry 205 - fullUrl = urn:uuid:fd39c2f6-91d4-468e-a4c3-68b0866f8dbd

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.44:36
Vävnadssocker: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:81383038-442f-57f3-946e-eccebb88a1c7

```

-------

Entry 206 - fullUrl = urn:uuid:60cb9699-69c5-4d6c-9bfb-49c6fdd698d6

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.47:35 - 03.52:35
Direktverkande insulin 0.16 IE (1.98 IE/t, 2.64 % = 5.21 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e3bb498d-0b38-52e5-805f-eb7fbf7fb59d

```

-------

Entry 207 - fullUrl = urn:uuid:6fd4969f-2958-4ff4-a848-54cf97111e01

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.49:33
Vävnadssocker: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:382aaf36-c09c-533f-8761-8c3566b8be19

```

-------

Entry 208 - fullUrl = urn:uuid:9541f7c6-cffc-46c6-9adc-fbdf76d87e61

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.52:35 - 03.57:38
Direktverkande insulin 0.15 IE (1.76 IE/t, 2.35 % = 4.13 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c206e667-2a94-58e1-95d4-7fcfa43b6edc

```

-------

Entry 209 - fullUrl = urn:uuid:386deaa7-41b5-4c6e-ad1c-828ef37efe87

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.54:33
Vävnadssocker: 7.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eeb2544e-7910-503e-bb6a-7b6e215af3d3

```

-------

Entry 210 - fullUrl = urn:uuid:e8daa954-df60-4cc0-b281-b212cde5b008

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 03.57:38 - 04.55:37
Direktverkande insulin 0.72 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3f5ad035-e5a4-5dcf-886d-afb5594b5563

```

-------

Entry 211 - fullUrl = urn:uuid:daa8cc1b-bf10-45bf-87d8-4a2ea7e7c44a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 03.59:34
Vävnadssocker: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:37474e5f-1502-53c9-a83d-d08e0defb466

```

-------

Entry 212 - fullUrl = urn:uuid:ba9ee1e9-cf5b-44dc-84b2-0fc78d10a09b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.04:33
Vävnadssocker: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:de3c5508-cc10-597c-bc60-d90a3faa265a

```

-------

Entry 213 - fullUrl = urn:uuid:83812c86-7b31-4c64-8c63-39800838d411

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.09:35
Vävnadssocker: 7.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b289891e-4b4a-5c33-b036-ccdcb92cc6c6

```

-------

Entry 214 - fullUrl = urn:uuid:c63b7ae9-831b-4bbb-9fca-22ad052454d0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.14:35
Vävnadssocker: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b466e7f9-df42-5b78-a369-b2afb190c1a1

```

-------

Entry 215 - fullUrl = urn:uuid:b2fff968-eb6f-4ca9-8f96-4bf68a1ebb55

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.19:35
Vävnadssocker: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d94e56de-19cb-5f54-b1fa-0b3d9d4eb701

```

-------

Entry 216 - fullUrl = urn:uuid:58db0dc6-296f-4b26-a683-169a984b9685

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.24:34
Vävnadssocker: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5d347f61-4d2f-5364-a4bf-2d58f7b0d51c

```

-------

Entry 217 - fullUrl = urn:uuid:44e1e885-e36c-4a0d-8036-ed952871bbb8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.29:35
Vävnadssocker: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:de18d954-a48c-5d62-ac1e-1e256b79183e

```

-------

Entry 218 - fullUrl = urn:uuid:17d42262-51ff-402e-b002-3c4f81af1b0f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.34:34
Vävnadssocker: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1b69dc5a-d994-52cc-9940-bb492b42ffea

```

-------

Entry 219 - fullUrl = urn:uuid:f1e811eb-a87e-4674-8371-8b19f6e83f5f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.39:33
Vävnadssocker: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1fd7b36b-e45f-570c-a0b7-7cf855b6a9d4

```

-------

Entry 220 - fullUrl = urn:uuid:71a6fdf0-bdcd-48e5-8f16-11bc4fdb389a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.44:33
Vävnadssocker: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d989cb37-3de8-5969-b3a0-b5d0853d2be3

```

-------

Entry 221 - fullUrl = urn:uuid:e4d9ff07-7ea1-4a57-a254-5a3637b3694b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.49:33
Vävnadssocker: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:28e76791-0653-51d6-841a-3d5272140fde

```

-------

Entry 222 - fullUrl = urn:uuid:e6945fe0-271a-4622-b0c6-59b880e71a6b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.54:33
Vävnadssocker: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:671941dc-e2e3-56a6-98de-d6c7657ec3f4

```

-------

Entry 223 - fullUrl = urn:uuid:67ad074e-cdd3-4bb2-822b-be624dc10800

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 04.55:37 - 05.00:36
Direktverkande insulin 0.06 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:14e62fac-4dd7-5af9-87ec-f6841b8bfcef

```

-------

Entry 224 - fullUrl = urn:uuid:529f8d1f-b0a6-41dc-846c-a1990cbfafdd

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 04.59:33
Vävnadssocker: 6.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3da9b44f-8b46-5a10-bbec-e4a3f68b56b3

```

-------

Entry 225 - fullUrl = urn:uuid:9834e108-3fce-473e-a840-ce0d3781ec77

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.00:36 - 05.02:46
Direktverkande insulin 0.03 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f14f46f6-9a5c-5033-9214-96663b7c4bbf

```

-------

Entry 226 - fullUrl = urn:uuid:568c9134-f6e0-4490-ae3d-9dc1baca4773

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.02:46 - 05.07:47
Direktverkande insulin 0.05 IE (0.65 IE/t, 0.86 % = 0.56 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:43b03358-f01b-51a3-9066-82f94e07b34e

```

-------

Entry 227 - fullUrl = urn:uuid:0876660a-98f1-4b8d-81f4-8aa9f4b701d5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.04:33
Vävnadssocker: 6.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:33188a5d-8bb7-541c-9c17-38958d9d38f8

```

-------

Entry 228 - fullUrl = urn:uuid:39066149-c27d-4e04-becc-593da6d42331

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.07:47 - 05.12:48
Direktverkande insulin 0.03 IE (0.35 IE/t, 0.46 % = 0.16 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1089130f-c55d-5d04-a08d-24cac12e599a

```

-------

Entry 229 - fullUrl = urn:uuid:d6e6c6d3-0aa0-4169-a626-bbcd7fd7c1a4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.09:33
Vävnadssocker: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dcecfec1-ce6d-5589-9ec5-55c2763c34d7

```

-------

Entry 230 - fullUrl = urn:uuid:2ad660e2-edaf-471e-b046-c02d26aa088a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.12:48 - 05.17:48
Direktverkande insulin 0.05 IE (0.56 IE/t, 0.75 % = 0.42 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d5bc77b9-31a3-55a2-8e56-0388dbd989aa

```

-------

Entry 231 - fullUrl = urn:uuid:39d5470b-8486-4a1f-99f5-6d2d94492481

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.14:33
Vävnadssocker: 6.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5cd1c9f9-6dc0-595a-9832-c8eb751a6bea

```

-------

Entry 232 - fullUrl = urn:uuid:cf169b4d-6495-42e3-9824-e3a9ccd31b9b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.17:48 - 05.22:49
Direktverkande insulin 0.06 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:45a0946e-c207-5e73-8cf0-b6dd3704755a

```

-------

Entry 233 - fullUrl = urn:uuid:a49a83db-0b2f-44ba-ae17-4ab2f2e366de

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.19:33
Vävnadssocker: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:71329039-c256-571b-a798-bc4ef105025d

```

-------

Entry 234 - fullUrl = urn:uuid:ae7a0088-e994-4a7d-8a76-da2f9956e967

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.22:49 - 05.27:50
Direktverkande insulin 0.11 IE (1.36 IE/t, 1.82 % = 2.48 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:22197b8d-90d5-5ed8-9b9b-5a6cb39bdf2d

```

-------

Entry 235 - fullUrl = urn:uuid:b40080aa-7429-4261-917c-dfea4b829208

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.24:33
Vävnadssocker: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:df549a28-6551-5a0a-8eb8-8fcc744f3cc8

```

-------

Entry 236 - fullUrl = urn:uuid:9d19397b-fb93-4185-9f99-4073fb9f8a70

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.27:50 - 05.32:50
Direktverkande insulin 0.12 IE (1.41 IE/t, 1.88 % = 2.64 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5bda0831-47e7-5ef9-b562-9366356ee566

```

-------

Entry 237 - fullUrl = urn:uuid:b813dfee-4ff6-420c-beda-040979f9041d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.29:33
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:15050741-774c-564d-b06d-bb22d3b85273

```

-------

Entry 238 - fullUrl = urn:uuid:3aaf2c21-690c-486b-8b08-2b81e6fae484

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.32:50 - 05.37:51
Direktverkande insulin 0.08 IE (0.92 IE/t, 1.08 % = 0.99 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8eac06f8-5e98-5e52-8795-a1a2e2f1de67

```

-------

Entry 239 - fullUrl = urn:uuid:d198001a-5d49-41f9-b68c-b88303da4086

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.34:33
Vävnadssocker: 6.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2a4b07a8-83d7-5ee2-80e8-b6af3786cc5d

```

-------

Entry 240 - fullUrl = urn:uuid:3377a21f-4fb5-4192-a2cc-826613363ad8

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.37:51 - 05.42:52
Direktverkande insulin 0.07 IE (0.85 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d57a5dee-1f1e-5e09-9823-f85ff139755b

```

-------

Entry 241 - fullUrl = urn:uuid:9e9c5940-8b21-49b8-b29f-bf0f29ef2ed9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.39:33
Vävnadssocker: 6.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0ed7ef01-b34d-509e-8c18-1445b807b335

```

-------

Entry 242 - fullUrl = urn:uuid:71fd5fce-18dc-4032-a3f1-b16b1fc158e6

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.42:52 - 05.47:52
Direktverkande insulin 0.05 IE (0.55 IE/t, 0.64 % = 0.35 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:71eedbd8-2a3f-51d2-aa70-aac39bc318f1

```

-------

Entry 243 - fullUrl = urn:uuid:f7a39d8e-95a5-49e2-a428-7f0e7e8f0473

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.44:33
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8299de5b-f80e-5494-89c1-9875cc8ca693

```

-------

Entry 244 - fullUrl = urn:uuid:7f0e927f-84a5-457d-83f4-48e2cf67349f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.47:52 - 05.52:53
Direktverkande insulin 0.02 IE (0.30 IE/t, 0.35 % = 0.10 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c65ccfcd-5078-5782-bb96-60cd3ccc9ae3

```

-------

Entry 245 - fullUrl = urn:uuid:35f7f3ba-10e6-4b0c-802b-b8847459f86e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.49:33
Vävnadssocker: 6.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:84552b56-31d1-54cf-885e-20e012966706

```

-------

Entry 246 - fullUrl = urn:uuid:6062d250-4c39-4594-a774-92f2efd148b4

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.52:53 - 05.57:54
Direktverkande insulin 0.03 IE (0.34 IE/t, 0.40 % = 0.13 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:999bcd3d-2f2f-502e-bc41-52cc90fea6da

```

-------

Entry 247 - fullUrl = urn:uuid:e2d97b37-5499-4e7a-bcc7-65873fbe3c80

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.54:33
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2f281a2d-109d-5fea-8673-35b3f3b225e0

```

-------

Entry 248 - fullUrl = urn:uuid:6d828f30-5623-42b4-b2c3-c5789fbb26fd

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 05.57:54 - 06.02:54
Direktverkande insulin 0.03 IE (0.36 IE/t, 0.42 % = 0.15 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d34207c3-a20d-510b-881e-ec3a75ba978a

```

-------

Entry 249 - fullUrl = urn:uuid:4680348a-5eba-45e6-bca1-30fed98d08ce

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 05.59:33
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:394a2dde-b257-55e6-8b96-82f20f0873bf

```

-------

Entry 250 - fullUrl = urn:uuid:fcf81c22-e8a7-4a4b-9eaf-d434899d8c16

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.02:54 - 06.07:55
Direktverkande insulin 0.02 IE (0.28 IE/t, 0.33 % = 0.09 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:93a4becf-c374-59a8-be8f-43060515d38d

```

-------

Entry 251 - fullUrl = urn:uuid:b4d3fecf-311b-4c2d-b082-7fadade5aa31

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.04:33
Vävnadssocker: 5.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6d29ffa5-3a98-5843-8e9a-a917b12fd82e

```

-------

Entry 252 - fullUrl = urn:uuid:00c73006-0f7c-46a3-8656-3d12528b3071

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.07:55 - 06.12:56
Direktverkande insulin 0.02 IE (0.20 IE/t, 0.23 % = 0.05 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:27e01b70-507a-5176-b508-2c00acd52a20

```

-------

Entry 253 - fullUrl = urn:uuid:041f1d1e-24da-4419-b5fa-4666a16cede2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.09:34
Vävnadssocker: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:67faf787-ad30-59be-aaeb-fa3d9741ea8e

```

-------

Entry 254 - fullUrl = urn:uuid:cfba5afc-8a00-4950-9941-751692aa84ff

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.12:56 - 06.17:58
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1735c842-dc86-5d9d-90d6-09c554b2ad7d

```

-------

Entry 255 - fullUrl = urn:uuid:287240df-3d7b-435c-9f67-1f2259dc6c34

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.14:33
Vävnadssocker: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8af2b95b-eb0a-57e8-b26b-acf33505650e

```

-------

Entry 256 - fullUrl = urn:uuid:f66eb9ce-2fb1-419f-aae7-ee3c7563440d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.17:58 - 06.22:57
Direktverkande insulin 0.02 IE (0.28 IE/t, 0.32 % = 0.09 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:aba7ac98-7d53-538d-acc8-ac75da9514e3

```

-------

Entry 257 - fullUrl = urn:uuid:f34cfbcc-7af0-4499-a949-144af2a488f8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.19:34
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1d99cf28-3169-523c-a9aa-66df9bd3d18a

```

-------

Entry 258 - fullUrl = urn:uuid:493f6b7d-d17b-463e-97da-4dfcd5c63a14

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.22:57 - 06.27:57
Direktverkande insulin 0.11 IE (1.26 IE/t, 1.48 % = 1.87 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b9b72ad1-ddbd-54b3-b76e-1cf54a9a6462

```

-------

Entry 259 - fullUrl = urn:uuid:373ff2b6-5340-4c9b-91d4-a4cc7bce2970

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.24:37
Vävnadssocker: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:72028d3c-26d9-5338-9bdf-1efa2570959e

```

-------

Entry 260 - fullUrl = urn:uuid:77604277-0e56-4bd6-b0e6-b893241cd320

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.27:57 - 06.32:58
Direktverkande insulin 0.14 IE (1.62 IE/t, 1.90 % = 3.08 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:545ef964-cd6b-5daa-a4cf-2c72d6916bfc

```

-------

Entry 261 - fullUrl = urn:uuid:af60a9ef-f42f-446e-8956-9846b4b572e2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.29:34
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5ecd5df9-1963-5c6d-880f-758a014d8f2e

```

-------

Entry 262 - fullUrl = urn:uuid:c020d3ac-e470-4711-bf02-d917f5ae1f54

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.32:58 - 06.38:00
Direktverkande insulin 0.10 IE (1.14 IE/t, 1.34 % = 1.54 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fee536f9-fc9b-59ef-b507-d3ddd1dc70fc

```

-------

Entry 263 - fullUrl = urn:uuid:2b64d5f7-45c0-47c8-b3d8-4702ad44c03c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.34:36
Vävnadssocker: 6.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6af45693-4901-50c8-9374-a3d36fcda44f

```

-------

Entry 264 - fullUrl = urn:uuid:49774c02-531e-42ee-90a8-e5c5d2c33b5e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.38:00 - 06.42:59
Direktverkande insulin 0.07 IE (0.85 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:84e14242-d670-530f-95e8-d4af7e4e6b86

```

-------

Entry 265 - fullUrl = urn:uuid:db7d1815-b032-429c-8f14-e8d631c8e4b1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.39:33
Vävnadssocker: 5.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:688cc2b4-6b76-58bd-83f5-be6b28dc752e

```

-------

Entry 266 - fullUrl = urn:uuid:455e391a-a1cc-4540-85d2-c664e2490b5b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.42:59 - 06.48:00
Direktverkande insulin 0.02 IE (0.20 IE/t, 0.23 % = 0.05 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:08c525e4-c651-5211-b7ca-5b8d8c721a00

```

-------

Entry 267 - fullUrl = urn:uuid:7eaaccf4-0e1e-4a81-84f7-e5f190e705fa

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.44:33
Vävnadssocker: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ef092f6d-d4c4-5b12-8bff-8368923d1eb2

```

-------

Entry 268 - fullUrl = urn:uuid:73cec84c-fefe-4dbb-8c1d-62784f9f9c97

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 06.48:00 - 07.03:02
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1334b868-1677-5ed4-8f73-59dffe492678

```

-------

Entry 269 - fullUrl = urn:uuid:663534b3-297e-416c-8a7a-c29378a17f55

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.49:33
Vävnadssocker: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:288bd215-c2fb-57f0-a451-b3e80b1b4510

```

-------

Entry 270 - fullUrl = urn:uuid:cf3c015e-3f2f-4a28-a9c3-6c3131b8d8ab

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.54:33
Vävnadssocker: 5.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3fb7542a-8eea-5a37-9973-6f5eefe8fa02

```

-------

Entry 271 - fullUrl = urn:uuid:1a780e52-9ad4-48b6-8f03-dd31824a8119

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 06.59:32
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2d9e8f7a-91f9-55b7-912e-16c1e305edc6

```

-------

Entry 272 - fullUrl = urn:uuid:4f05c834-0aa9-4099-8d16-adfc6e32127b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.03:02 - 07.08:03
Direktverkande insulin 0.08 IE (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:17771490-9ebe-5c44-a7c0-6fef82e9f30c

```

-------

Entry 273 - fullUrl = urn:uuid:d37fe416-6310-4e7b-b430-9214bd5b0f1d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.04:33
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:76227e8a-bf3d-50ec-a114-2700abeee0d4

```

-------

Entry 274 - fullUrl = urn:uuid:05b2a092-c5a2-476c-b00e-df7be00f1351

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.08:03 - 07.13:04
Direktverkande insulin 0.09 IE (1.12 IE/t, 1.18 % = 1.32 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2b53e8d6-b539-543f-839c-0b66df8b0360

```

-------

Entry 275 - fullUrl = urn:uuid:12560fd0-4ac2-4c8b-aaee-ebf0f844640a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.09:32
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:23521342-20b6-570e-983f-2267265a4fba

```

-------

Entry 276 - fullUrl = urn:uuid:54d593fd-9d3a-44ea-9264-70fd0e0f98ec

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.13:04 - 07.23:05
Direktverkande insulin 0.16 IE (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:078070d1-640d-58d2-9383-17ad79be5fab

```

-------

Entry 277 - fullUrl = urn:uuid:530c09f9-b249-48ab-a1dd-97cd34a978b0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.14:32
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b7901ebc-527e-5504-9475-c0e742144ab4

```

-------

Entry 278 - fullUrl = urn:uuid:7b584609-0181-4111-a44e-322c5ecce003

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.19:32
Vävnadssocker: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ac8c748b-75a0-5a4a-a18f-2e2da34124c9

```

-------

Entry 279 - fullUrl = urn:uuid:cd4ae257-c55e-46d1-b8a4-40362b87af40

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.23:05 - 07.28:06
Direktverkande insulin 0.08 IE (0.95 IE/t, 1.00 % = 0.94 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:759b4fde-6aab-5b3f-a89d-e1c83c16de14

```

-------

Entry 280 - fullUrl = urn:uuid:bf607653-c4ac-481b-bb8f-d22b8dfc8489

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.24:33
Vävnadssocker: 6.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0122184b-5ea8-5a55-a7c1-c2c14600e9c8

```

-------

Entry 281 - fullUrl = urn:uuid:b43bdbba-006f-486b-bc1c-30fdc0aa5560

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.28:06 - 07.38:08
Direktverkande insulin 0.16 IE (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f8badfe4-befb-59e3-bf8b-4ab78413ff6d

```

-------

Entry 282 - fullUrl = urn:uuid:f3802ca9-7cca-46bf-9c14-22ab2b772a72

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.29:33
Vävnadssocker: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dd65364c-2b69-5d7e-8b0e-4417fdc8d4dd

```

-------

Entry 283 - fullUrl = urn:uuid:22fd2c7f-67a4-4c8b-bd17-dcb66a9a8c12

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.34:33
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c45e896c-f89f-5606-bd0d-01352697d4ff

```

-------

Entry 284 - fullUrl = urn:uuid:c4243df6-8e05-4eaf-a976-0a9f4223ab71

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.38:08 - 07.43:07
Direktverkande insulin 0.18 IE (2.21 IE/t, 2.33 % = 5.16 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:88295acc-f273-5da5-92bf-3195a5f4d101

```

-------

Entry 285 - fullUrl = urn:uuid:0e5bd8eb-8ff9-4071-9534-610220adc414

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.39:32
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6840a706-9ab0-5d23-87e7-7954e6208c94

```

-------

Entry 286 - fullUrl = urn:uuid:3ff748df-f440-48db-a5da-8ca0466c547b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.43:07 - 07.48:08
Direktverkande insulin 0.13 IE (1.60 IE/t, 1.69 % = 2.70 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9db79757-b7e9-5ef3-b2ea-9e2a2e10adb7

```

-------

Entry 287 - fullUrl = urn:uuid:b32bee2c-5a10-495c-ab1e-d423d9dcd8ed

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.44:32
Vävnadssocker: 7.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d8844b69-1f6c-5c5b-b227-fda4ff2070af

```

-------

Entry 288 - fullUrl = urn:uuid:f420f9b4-889a-464d-b9d3-31657f464e7f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.48:08 - 07.53:09
Direktverkande insulin 0.12 IE (1.44 IE/t, 1.51 % = 2.18 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:79f27856-f25f-505f-a81c-4f4efab56e4e

```

-------

Entry 289 - fullUrl = urn:uuid:16e918fa-67d4-442c-86c7-0359be243e2d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.49:33
Vävnadssocker: 7.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80c32387-5836-558e-be90-cd612c94c782

```

-------

Entry 290 - fullUrl = urn:uuid:caa39372-01e3-4017-8224-2bd992316e82

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.53:09 - 07.58:11
Direktverkande insulin 0.09 IE (1.06 IE/t, 1.11 % = 1.18 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5667ab97-12cc-5c47-9e53-5d32f0c65376

```

-------

Entry 291 - fullUrl = urn:uuid:b7c18eb4-9d9d-487d-b667-857df06528f9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.54:33
Vävnadssocker: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8b56238f-1c98-55ce-ae52-195b9eb3d26b

```

-------

Entry 292 - fullUrl = urn:uuid:83d6b27b-9b6a-49e5-a913-f80a9b6d1fac

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 07.58:11 - 08.03:11
Direktverkande insulin 0.08 IE (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c272e3aa-04d9-56f3-ac01-e2a2809f8e3c

```

-------

Entry 293 - fullUrl = urn:uuid:4b258ec3-b1d9-4ecd-9a22-e59e9fb1a8f6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 07.59:32
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2ba9fec5-8c08-54ff-a55d-c39c5a5d1879

```

-------

Entry 294 - fullUrl = urn:uuid:d087935a-3801-44e9-bd33-8df27a0a0535

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 08.03:11 - 08.08:12
Direktverkande insulin 0.08 IE (0.96 IE/t, 1.01 % = 0.97 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1ca8f6a4-5dce-5327-bfe8-b6769902cbf5

```

-------

Entry 295 - fullUrl = urn:uuid:68fa06ec-ee32-4112-9743-3cb39c709827

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.04:32
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:93c2e8a4-21c8-5e76-b331-a7276e2ab546

```

-------

Entry 296 - fullUrl = urn:uuid:1f5164df-9bac-44b3-83d9-effa043e8c0d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 08.08:12 - 08.13:13
Direktverkande insulin 0.11 IE (1.36 IE/t, 1.44 % = 1.96 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cfe21ad5-a87a-5421-9388-7a8e2693972f

```

-------

Entry 297 - fullUrl = urn:uuid:a4882745-970a-43f4-9287-f4cc1328617b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.09:33
Vävnadssocker: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc6ef87f-c007-5271-ba3e-a8bfa49e2657

```

-------

Entry 298 - fullUrl = urn:uuid:9b158c82-edeb-4fb8-a9ca-9fcc27fc02b7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 08.13:13 - 08.18:13
Direktverkande insulin 0.16 IE (1.94 IE/t, 2.04 % = 3.95 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:97eb6c28-7146-549f-b892-0cac2c074b0b

```

-------

Entry 299 - fullUrl = urn:uuid:62a42a98-433d-4cfb-8929-df626a1ceccf

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.14:32
Vävnadssocker: 8.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4daccfcc-4def-504a-8c93-a681d27a13fd

```

-------

Entry 300 - fullUrl = urn:uuid:744003e3-f888-4087-bace-cf1c0c694f6e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 08.18:13 - 08.23:14
Direktverkande insulin 0.14 IE (1.73 IE/t, 1.82 % = 3.14 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:83a9495e-6831-513e-abdc-1ba78dec547a

```

-------

Entry 301 - fullUrl = urn:uuid:86de7463-7360-4250-bb5f-759c8849bc12

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.19:32
Vävnadssocker: 8.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2529377d-e27e-5c6a-b78e-81a5c4531371

```

-------

Entry 302 - fullUrl = urn:uuid:c79ec255-d9fd-4eaf-acb5-e538ebf6e286

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 08.23:14 - 08.28:15
Direktverkande insulin 0.11 IE (1.28 IE/t, 1.35 % = 1.74 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:63a7e181-a098-5612-b5c2-703fd26dc1d9

```

-------

Entry 303 - fullUrl = urn:uuid:6660b28a-d9dc-400e-a1ae-7362739491ce

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.24:32
Vävnadssocker: 8.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ad4c091b-b9eb-53d7-94d8-b979f0f6032e

```

-------

Entry 304 - fullUrl = urn:uuid:f4c4db9b-eb06-4c63-a3d8-be77d4780ba0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 08.28:15 - 09.03:21
Direktverkande insulin 0.56 IE (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:135f6c23-1676-54c8-bef6-3e34a80b9436

```

-------

Entry 305 - fullUrl = urn:uuid:9a40d3b8-c309-4093-9d3b-100c73a5995b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.29:32
Vävnadssocker: 8.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3e91abdf-23b9-544c-aa1a-89501f7a8772

```

-------

Entry 306 - fullUrl = urn:uuid:1fcecdb0-2b3d-47ee-99d2-d6eeb65d6118

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.34:32
Vävnadssocker: 8.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:105a014a-edaf-5a42-9966-867540c730a4

```

-------

Entry 307 - fullUrl = urn:uuid:82fe2799-7183-4f7b-b0fb-b63fe104885f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.39:32
Vävnadssocker: 8.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c7291bf2-2b60-5602-9716-ed6280ffcb60

```

-------

Entry 308 - fullUrl = urn:uuid:58813f9f-23fb-4e58-8b4c-f25bd7844140

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.44:32
Vävnadssocker: 8.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:546b67ab-9eef-5137-b990-1ebc19ba53b1

```

-------

Entry 309 - fullUrl = urn:uuid:dd0b3925-1553-4a74-a365-f2ff13fbe231

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.49:32
Vävnadssocker: 8.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:870a24ec-6e2b-5248-88c1-556e79d87938

```

-------

Entry 310 - fullUrl = urn:uuid:c57bd21f-4fa6-49ed-a66b-aa3fc8806aec

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.54:32
Vävnadssocker: 8.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1313dd10-7a6b-59a0-a88b-a6deeb62148c

```

-------

Entry 311 - fullUrl = urn:uuid:3435416f-ebd5-4a7b-8b67-8b3d2a478b89

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 08.59:32
Vävnadssocker: 8.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b4099905-5c8e-54cc-adaf-f8633f454bbf

```

-------

Entry 312 - fullUrl = urn:uuid:ce830415-36cc-4654-9ac0-136079a04c12

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 09.03:21 - 09.45:16
Direktverkande insulin 0.49 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2a036cbc-1496-5051-87dc-148c4adfe0fb

```

-------

Entry 313 - fullUrl = urn:uuid:84e8eda5-7d6c-4c80-a098-9154b4000723

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.04:32
Vävnadssocker: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:63f17390-93d0-5ba4-adc6-8cd5c121b293

```

-------

Entry 314 - fullUrl = urn:uuid:7cbb8396-abfa-4faf-9608-707ca2a51b1f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.09:32
Vävnadssocker: 8.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0fbb3aeb-e147-5e32-9fd1-529ca917683b

```

-------

Entry 315 - fullUrl = urn:uuid:ca3b5871-1cdb-4a3a-a503-d1201f5aa7eb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.14:32
Vävnadssocker: 8.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c9448561-3b73-5e0f-bf88-25362a3c7fdb

```

-------

Entry 316 - fullUrl = urn:uuid:4729a818-a168-455a-88ba-180a8031c048

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.19:32
Vävnadssocker: 8.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a2f312b1-9ffa-59f3-b9e6-645fcc939286

```

-------

Entry 317 - fullUrl = urn:uuid:de8b38bc-b0f1-4b6d-9eb0-e6ea85564ebf

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.24:32
Vävnadssocker: 8.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:14cd0888-e24f-5e8a-bdf7-c73f22ba5f26

```

-------

Entry 318 - fullUrl = urn:uuid:cb5a840a-2045-4e5b-a41c-d4a6be44f09b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.29:32
Vävnadssocker: 8.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:10e9568a-63a2-5c83-a2e6-a3b45481e9e6

```

-------

Entry 319 - fullUrl = urn:uuid:d6efe59d-cc95-4f60-bed9-cbae0f9e61f1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.34:34
Vävnadssocker: 8.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:40d364f0-2de8-580d-8fa3-6e982b2648ef

```

-------

Entry 320 - fullUrl = urn:uuid:35a68208-dade-48a9-b066-4c7b3a87a728

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.39:32
Vävnadssocker: 8.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7e42b6c0-ccb7-58f7-af28-5e775490261b

```

-------

Entry 321 - fullUrl = urn:uuid:eda5d853-6e78-4b30-8b2f-78969ec5ed00

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.44:32
Vävnadssocker: 8.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7316c9a7-edd9-52ec-9f06-c03c3a08f5ea

```

-------

Entry 322 - fullUrl = urn:uuid:4d4ae0a3-98af-4395-adf4-837406f0d452

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 09.45:16 - 10.28:20
Direktverkande insulin 0.00 IE (0 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6e5d6873-5113-5fd4-a029-b6072c9f5ef7

```

-------

Entry 323 - fullUrl = urn:uuid:ba7f138e-ea7d-4fd3-9935-49bddfa64a7d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.49:33
Vävnadssocker: 8.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6e26dffb-9a33-5b4d-b459-dd3e5c8e21bb

```

-------

Entry 324 - fullUrl = urn:uuid:812443ef-90d5-4d76-8459-3e06a73aad39

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.54:35
Vävnadssocker: 7.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7190100a-00a1-5daa-bd77-5f3e23335d6a

```

-------

Entry 325 - fullUrl = urn:uuid:10295363-1c53-4f6f-acb6-1a0f77d6f052

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 09.59:35
Vävnadssocker: 7.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:61e9d819-6d64-5429-8a08-f23af34525c7

```

-------

Entry 326 - fullUrl = urn:uuid:96c422f3-4786-4d6e-8df3-48cc032af031

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.04:35
Vävnadssocker: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7c0518a5-6db2-5dc1-bcc8-592a306843dd

```

-------

Entry 327 - fullUrl = urn:uuid:8693e9a1-0965-43d9-bdf2-32c77f9cbd1e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.09:33
Vävnadssocker: 5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eac56dca-2379-5b0d-be2e-49f4fbdaa74d

```

-------

Entry 328 - fullUrl = urn:uuid:9658c06e-7fd2-4e19-b27e-1d61f176a5f4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.14:35
Vävnadssocker: 5.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c0e6e1b-f9da-5ef8-9504-0b7be398800d

```

-------

Entry 329 - fullUrl = urn:uuid:20d18f36-5c37-4845-aa9b-7298479b0fdc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.19:32
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a401fbb4-1169-5c95-85d1-ba9f1a94f4a7

```

-------

Entry 330 - fullUrl = urn:uuid:5547ca95-649c-4081-be21-da4e81ac763f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.24:33
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0ce69091-4d01-5188-a5d0-67c13f452842

```

-------

Entry 331 - fullUrl = urn:uuid:08013a28-0819-4e64-bf48-e546eea2329c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 10.28:20 - 10.33:20
Direktverkande insulin 0.06 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fea9862f-7080-56bf-a740-af9a8d1838f7

```

-------

Entry 332 - fullUrl = urn:uuid:86c93598-cd67-4b5b-8c4c-165f8b0478ae

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.29:33
Vävnadssocker: 7.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8323084c-61b5-5a30-baa6-516515f99f3f

```

-------

Entry 333 - fullUrl = urn:uuid:bbcfd316-845b-4fe5-8a5c-d30d40fb53d3

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 10.33:20 - 10.38:21
Direktverkande insulin 0.18 IE (2.17 IE/t, 3.10 % = 6.75 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c30a47ff-378b-53dd-8c14-fdbd85aa1ac4

```

-------

Entry 334 - fullUrl = urn:uuid:6e2b5fed-722f-457e-bdd4-fc387cea7cd6

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 10.33:56
Direktverkande insulin 1.61 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b88877c8-bc89-53a9-8d05-b035b19f8486

```

-------

Entry 335 - fullUrl = urn:uuid:b76f7aca-01c2-4970-b763-b49449a1b4eb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.34:35
Vävnadssocker: 7.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dd626205-bfea-510b-9c45-4a4b44af8c9b

```

-------

Entry 336 - fullUrl = urn:uuid:457d5901-5a75-4f5d-afa4-fcb409a22016

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 10.38:21 - 11.43:32
Direktverkande insulin 0.76 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c21ac34a-4f59-5943-b17b-cceef5dfdd13

```

-------

Entry 337 - fullUrl = urn:uuid:0e0579ca-3825-432c-aab2-d04d1abcd4d8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.39:34
Vävnadssocker: 8.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b93a6a50-95df-5f0a-9543-78e6b8fdd7bd

```

-------

Entry 338 - fullUrl = urn:uuid:ba86db5c-f8a7-463b-a548-9e4e11450302

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.44:32
Vävnadssocker: 8.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc1c0862-f760-52fa-866e-4397b5353e73

```

-------

Entry 339 - fullUrl = urn:uuid:374be165-9ab9-46ef-a89a-0e6367d90904

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.49:34
Vävnadssocker: 8.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3130a4a-4489-5f3c-968b-02df971fefae

```

-------

Entry 340 - fullUrl = urn:uuid:669e73ee-c83c-4704-8b8c-03cce75da3dc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.54:32
Vävnadssocker: 8.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fe8e0623-61aa-5806-a32f-0aa8cbb61fe3

```

-------

Entry 341 - fullUrl = urn:uuid:6281540e-b4c1-4754-abdc-121f8d12a292

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 10.59:32
Vävnadssocker: 8.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e9721696-01d7-5e71-80c9-bf3373d680b8

```

-------

Entry 342 - fullUrl = urn:uuid:46ad44aa-5495-4e55-93d2-5cb3e8b2149e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.04:32
Vävnadssocker: 8.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3400428c-872c-5c89-bf2a-5634e39b81ef

```

-------

Entry 343 - fullUrl = urn:uuid:19a7100b-a7ef-449a-9311-a6ac97ad2bf0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 11.04:50
Direktverkande insulin 9.58 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:08d16058-bb3b-5d18-9943-a2b5fac840e6

```

-------

Entry 344 - fullUrl = urn:uuid:34353330-5da4-4127-b1cb-61ca826423ff

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 5.9.2021 11.04:50
Beräknad mängd kolhydratintag: 95 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:54861030-ecae-5023-a15f-f1198605f958

```

-------

Entry 345 - fullUrl = urn:uuid:7100a021-46e6-419b-9675-51139c9a5b7d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.09:33
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:efdda600-c901-5f23-8b44-fe662f3cfb99

```

-------

Entry 346 - fullUrl = urn:uuid:501759de-5933-4ee9-a82d-59f37d5578ec

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.14:33
Vävnadssocker: 7.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fb22d823-67d1-5b3b-95a2-d1fc4a5696b1

```

-------

Entry 347 - fullUrl = urn:uuid:05d3d349-c21d-4317-8987-044cb4580e6e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.19:36
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:21e7eb48-1c58-51f0-81ad-57d75cb7b8bf

```

-------

Entry 348 - fullUrl = urn:uuid:928909ff-5870-49f4-a423-809a9fa82a08

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.24:34
Vävnadssocker: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:46c50bdd-212f-50cf-951c-e0c2078a2d31

```

-------

Entry 349 - fullUrl = urn:uuid:7afab29d-0980-43cb-868b-42402539c0ce

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.29:32
Vävnadssocker: 7.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:37cd8ef3-23ff-5c96-a023-8ce7eae707b8

```

-------

Entry 350 - fullUrl = urn:uuid:c5d15a33-dbfb-4adb-be13-ed34bc7f10d6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.34:33
Vävnadssocker: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:456924f8-9fea-5c50-bf2f-561cbf6ed734

```

-------

Entry 351 - fullUrl = urn:uuid:558a04c7-3017-49bb-b75e-e25e51b52e0f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.39:33
Vävnadssocker: 7.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1771b598-4154-5eaf-8c58-bd1a94e4fc25

```

-------

Entry 352 - fullUrl = urn:uuid:9ee848ca-c25e-4e7d-b4da-d24001237dd3

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 11.43:32 - 11.48:32
Direktverkande insulin 0.05 IE (0.65 IE/t, 0.93 % = 0.61 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f2651b51-bd2e-5a91-b15a-54ed9d884ab8

```

-------

Entry 353 - fullUrl = urn:uuid:0c06eed2-c529-4dd4-8243-6dfe3d2b5c65

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.44:32
Vävnadssocker: 6.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cc5a6751-906f-59e4-bc6f-3e5dd58365fc

```

-------

Entry 354 - fullUrl = urn:uuid:4cbbb690-bdcb-4ab1-aab3-0b389514b56e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 11.48:32 - 11.53:34
Direktverkande insulin 0.02 IE (0.23 IE/t, 0.34 % = 0.08 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9fe489b9-9940-5b7d-8c3a-c1277f132787

```

-------

Entry 355 - fullUrl = urn:uuid:b420bbf8-c5dc-476f-a64f-f0409039a145

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.49:32
Vävnadssocker: 6.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:28b19a14-de95-50d5-9240-b9e1a1c4b995

```

-------

Entry 356 - fullUrl = urn:uuid:44ba2b86-fff2-4747-a89b-a14214871d88

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 11.53:34 - 11.58:35
Direktverkande insulin 0.01 IE (0.13 IE/t, 0.18 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:779d852e-34f4-51c7-806a-3af4918c8bea

```

-------

Entry 357 - fullUrl = urn:uuid:28a9d1ea-d93b-44d3-887f-2dedc7266646

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.54:32
Vävnadssocker: 6.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:400415df-90b8-52c9-b489-bb3b67c20b46

```

-------

Entry 358 - fullUrl = urn:uuid:6bd3fec6-11b6-428c-bca0-3e4b6acabc88

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 11.58:35 - 12.03:34
Direktverkande insulin 0.02 IE (0.23 IE/t, 0.33 % = 0.07 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d8cd14ba-d21d-57dc-9ee8-6f6b71ef82f7

```

-------

Entry 359 - fullUrl = urn:uuid:e83eeed1-e5b8-4809-b66c-1909e35ac379

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 11.59:34
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1657538b-950d-57a4-a1ec-1bff4323cbf8

```

-------

Entry 360 - fullUrl = urn:uuid:e2dc76ae-d5bb-4e72-baed-d58091ce5bbc

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 12.03:34 - 12.08:35
Direktverkande insulin 0.06 IE (0.70 IE/t, 1.00 % = 0.70 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:367a3543-fdc4-58ab-9a08-633e05ff497b

```

-------

Entry 361 - fullUrl = urn:uuid:305364f1-5302-4fcd-8f6e-043138f93d7d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.04:36
Vävnadssocker: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:289f5c55-084f-5597-824b-73d62478a5fa

```

-------

Entry 362 - fullUrl = urn:uuid:5bbf9d07-2117-4637-97cf-5e4dd7e43605

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 12.08:35 - 14.03:52
Direktverkande insulin 1.34 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:70b38d98-8e2d-5c6d-bc51-23780685adb7

```

-------

Entry 363 - fullUrl = urn:uuid:09a5dab2-1685-4a9a-84fa-b9c201f090f3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.09:32
Vävnadssocker: 7.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b7774ddb-960a-59a5-a230-c78d2e3c1fb2

```

-------

Entry 364 - fullUrl = urn:uuid:becdb99a-0048-49ba-b1be-01c7c84452f0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.14:32
Vävnadssocker: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:61f880ed-7e74-5972-a300-343b3f9bf0f4

```

-------

Entry 365 - fullUrl = urn:uuid:184cc167-7974-41f5-90be-36a3adee0813

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.19:33
Vävnadssocker: 9.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8576b951-29b8-5e04-9428-43a2a41d0398

```

-------

Entry 366 - fullUrl = urn:uuid:c84dd9fc-6046-4bf6-8a22-50283d9dadb8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.24:32
Vävnadssocker: 9.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:795ae6f6-ee9a-5574-94c1-be30be4ac879

```

-------

Entry 367 - fullUrl = urn:uuid:80cdbb86-e202-43d6-886f-3b12652c88d9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.29:33
Vävnadssocker: 9.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:39712d69-af60-5eda-945e-a846b70037a0

```

-------

Entry 368 - fullUrl = urn:uuid:4b986318-389c-4b01-8a3c-a9bad6619ed0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.34:32
Vävnadssocker: 9.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8663fdfe-4ba5-5a30-b837-0e2df0df845b

```

-------

Entry 369 - fullUrl = urn:uuid:0ea089af-5209-4341-aafb-0ef482c9f92c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.39:36
Vävnadssocker: 9.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fd2e5e20-89d0-53da-8785-a78090fa21d4

```

-------

Entry 370 - fullUrl = urn:uuid:0bb8b777-4d91-4c99-b945-727e8cfe5b81

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.44:32
Vävnadssocker: 9.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:880c6824-675a-58b6-9be5-09ea6245e95d

```

-------

Entry 371 - fullUrl = urn:uuid:7a5878cc-053b-474c-85c4-74bced132434

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.49:33
Vävnadssocker: 9.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d7223d3e-2476-5947-8bf3-500ee3315d23

```

-------

Entry 372 - fullUrl = urn:uuid:4b56cf7d-e993-4663-b51e-56c150fdfec4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.54:32
Vävnadssocker: 9.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b3349cf8-cd5f-5ced-be1c-6e6369bc9a6a

```

-------

Entry 373 - fullUrl = urn:uuid:f9f587bf-2d6b-4ddb-a81f-318027b9b5db

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 12.59:32
Vävnadssocker: 9.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b06079bf-521f-548b-b4fa-b5ef727d627c

```

-------

Entry 374 - fullUrl = urn:uuid:8cc1f0b6-505e-4fe5-9d66-765ec7cdfc82

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.04:32
Vävnadssocker: 9.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c5a050fc-5173-5e99-9f68-cd2383b68fbc

```

-------

Entry 375 - fullUrl = urn:uuid:aec1fc38-595b-4513-a7f7-a14962ebda0e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.09:32
Vävnadssocker: 9.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ac312be0-9038-5341-b15b-ee05bc8259e5

```

-------

Entry 376 - fullUrl = urn:uuid:d9e3b21a-f83a-4b17-b0d2-2857c0d8cdb8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.14:32
Vävnadssocker: 9.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2bc56fde-9d9f-596b-8d09-8300ced41baf

```

-------

Entry 377 - fullUrl = urn:uuid:6f3623b5-2557-43cb-9701-4c8138f01e39

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.19:32
Vävnadssocker: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:627d9bf2-8d4e-537d-85a4-3f17ebd2a863

```

-------

Entry 378 - fullUrl = urn:uuid:0db4a21b-2f8b-4273-b0a8-7777bca5d730

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 13.24:00
Direktverkande insulin 0.68 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:26c41a16-3439-5b71-8a5e-681229250673

```

-------

Entry 379 - fullUrl = urn:uuid:59c3a18b-8d3f-4333-bf4b-d88a3d5bc810

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.24:32
Vävnadssocker: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:926acf4a-d0bc-54e6-83b4-6cec0589c25d

```

-------

Entry 380 - fullUrl = urn:uuid:412b5065-c4f1-4b67-8d6f-01112602781a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.29:34
Vävnadssocker: 10.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2d1a83a8-2159-5df9-a93a-287b954d1e06

```

-------

Entry 381 - fullUrl = urn:uuid:a3fbc394-17fd-4da1-a750-6102beeef6db

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.34:34
Vävnadssocker: 10.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:31ea9abf-fb0c-5a27-b9f9-e74c57b5c05a

```

-------

Entry 382 - fullUrl = urn:uuid:8e2969d3-a22d-43e2-8bd9-6c08ba37fbe4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.39:33
Vävnadssocker: 10.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:456fadb7-bf0e-5048-9591-352080902fdd

```

-------

Entry 383 - fullUrl = urn:uuid:1d3a377c-3c67-4be9-af8c-19ee53f77498

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.44:32
Vävnadssocker: 10.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2f3dcf92-0754-5611-b2c6-7b275c9e1d2b

```

-------

Entry 384 - fullUrl = urn:uuid:c8e2d42c-e40f-4780-b158-c3cb57562ba6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.49:32
Vävnadssocker: 10.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7f23ac29-7043-51d4-af19-d1060c649f72

```

-------

Entry 385 - fullUrl = urn:uuid:7d8428b2-01ac-4890-bd07-78002fed649b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.54:33
Vävnadssocker: 10.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:430b0566-775e-5fcc-8f9a-90b9638e1837

```

-------

Entry 386 - fullUrl = urn:uuid:05bbd416-a469-4846-8977-39ce07060a59

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 13.59:32
Vävnadssocker: 10.93 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:801cd9c4-7015-54da-8f9f-4e7881d26f7f

```

-------

Entry 387 - fullUrl = urn:uuid:69a70e47-2409-498d-b8e5-7ce4bb25291f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.03:52 - 14.08:53
Direktverkande insulin 0.11 IE (1.29 IE/t, 1.84 % = 2.37 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8cd2880e-9565-51b3-ac37-495e179ea509

```

-------

Entry 388 - fullUrl = urn:uuid:627b4729-3310-4839-8496-2b27bd7af44e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.04:32
Vävnadssocker: 11.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8649691f-f609-5d45-939c-701e8724f049

```

-------

Entry 389 - fullUrl = urn:uuid:8cdaa68b-4ab2-459b-94b7-5c3ea8d6fa6f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.08:53 - 14.13:54
Direktverkande insulin 0.17 IE (2.02 IE/t, 2.89 % = 5.83 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c1b7633c-99ed-5805-8e13-90c3a5067942

```

-------

Entry 390 - fullUrl = urn:uuid:2a3244d8-e2ba-43c4-94c4-92780131c413

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.09:32
Vävnadssocker: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d0c1c1bf-81e8-5ace-826e-8f7dc003cccb

```

-------

Entry 391 - fullUrl = urn:uuid:4c3a8bfa-edc6-458a-8099-1020e9e5e3e5

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.13:54 - 14.18:55
Direktverkande insulin 0.17 IE (2.00 IE/t, 2.85 % = 5.69 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bafcfefd-d008-56b1-8108-52111131b4db

```

-------

Entry 392 - fullUrl = urn:uuid:67cf1f2f-c33f-4cbc-a709-1987efd0d06e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.14:34
Vävnadssocker: 10.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1fecc6d1-1aae-5861-b5d1-d7fc5eaf6c3e

```

-------

Entry 393 - fullUrl = urn:uuid:968920c4-5164-42c9-9986-b89771c3e454

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.18:55 - 14.23:56
Direktverkande insulin 0.06 IE (0.71 IE/t, 1.02 % = 0.72 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:826cd99f-c775-5a08-93ae-86427dfcf499

```

-------

Entry 394 - fullUrl = urn:uuid:a5b56bbc-d9cf-48fe-9f63-4c63255323dc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.19:32
Vävnadssocker: 11.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:459ff13b-1cf6-50e0-b2b8-60237d947efd

```

-------

Entry 395 - fullUrl = urn:uuid:7217f6f6-e905-4362-bd4d-8a8878a89cef

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.23:56 - 14.28:58
Direktverkande insulin 0.08 IE (0.93 IE/t, 1.32 % = 1.23 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9e3ada12-f853-55b8-a794-bb125ca49c7a

```

-------

Entry 396 - fullUrl = urn:uuid:09c81040-6256-4d56-9c11-0d7cd9a7165a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.24:33
Vävnadssocker: 11.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5cf14223-8562-5792-9ca8-6bb2e58c2732

```

-------

Entry 397 - fullUrl = urn:uuid:8b2733dc-0ce8-4552-8907-1bcf19bbcc91

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.28:58 - 14.33:59
Direktverkande insulin 0.09 IE (1.04 IE/t, 1.48 % = 1.53 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b4063008-73bb-5e22-971e-dc5dbaa63e5e

```

-------

Entry 398 - fullUrl = urn:uuid:49933594-5c00-4465-8f84-474a987f9974

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.29:32
Vävnadssocker: 11.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f1d95de0-dac5-569e-b711-f020e58cbce9

```

-------

Entry 399 - fullUrl = urn:uuid:7d264bdf-27c7-4fa0-a59e-4f273a173a18

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.29:33
Direktverkande insulin 0.98 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:213ad488-d3c4-50cc-95df-8a7860516db5

```

-------

Entry 400 - fullUrl = urn:uuid:f9b4f8df-e705-489c-b7e0-f39bb34f1fff

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.33:59 - 14.43:59
Direktverkande insulin 0.12 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d24886c3-e489-5de3-ae73-860e7f925d8e

```

-------

Entry 401 - fullUrl = urn:uuid:7d634cd8-f6f9-4a94-95e4-c7e522c3826b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.34:35
Vävnadssocker: 11.32 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:531893b0-7a30-5019-b26b-d35396defd76

```

-------

Entry 402 - fullUrl = urn:uuid:f8139029-54f2-4dbe-942f-a916a5ed94e8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.39:32
Vävnadssocker: 11.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1d919c3b-b196-5c8c-93c8-0a56f5bc1e54

```

-------

Entry 403 - fullUrl = urn:uuid:fb84b259-be5d-43c4-9cef-57c231920319

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.43:59 - 14.49:01
Direktverkande insulin 0.06 IE (0.77 IE/t, 1.11 % = 0.86 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9434c7a4-56d2-5f40-8edc-b597a854e6f6

```

-------

Entry 404 - fullUrl = urn:uuid:6b369cc1-c836-4fec-83c9-ecc208437232

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.44:34
Vävnadssocker: 11.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a9d25cd7-2cc5-50b1-a7ca-68286a1c393e

```

-------

Entry 405 - fullUrl = urn:uuid:84b71e72-2bdc-4b57-86d3-3122646d2665

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.49:01 - 14.54:00
Direktverkande insulin 0.11 IE (1.38 IE/t, 1.97 % = 2.72 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:db5edd5f-ac17-5187-b7cb-2d0ca5733e10

```

-------

Entry 406 - fullUrl = urn:uuid:cb9f5bfd-b3c6-4895-a2e9-c27dd3d7e16b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.49:32
Vävnadssocker: 11.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:62ae640d-3eb5-5a15-8339-f01e0064e232

```

-------

Entry 407 - fullUrl = urn:uuid:efbca365-5be2-4f36-acb4-6a889ad1beb9

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.54:00 - 14.59:03
Direktverkande insulin 0.15 IE (1.80 IE/t, 2.58 % = 4.64 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8fb2f47c-c10d-54a4-a9f7-7a414c2ab5bb

```

-------

Entry 408 - fullUrl = urn:uuid:a39553ed-06a9-48fb-ad1a-668c61783db4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.54:32
Vävnadssocker: 12.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bd315014-3f00-5083-a7e2-f3c04e7927cb

```

-------

Entry 409 - fullUrl = urn:uuid:ec978755-e5ed-4d36-9531-6140db46abc3

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 14.59:03 - 15.04:03
Direktverkande insulin 0.19 IE (2.22 IE/t, 3.17 % = 7.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b1ebaf21-e7b9-549a-bbf8-827679be8ad7

```

-------

Entry 410 - fullUrl = urn:uuid:aff4c619-a529-4de4-965e-f9db1b9af17e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 14.59:32
Vävnadssocker: 12.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80c90c77-8f9e-5a1f-ad2b-c30725836b1e

```

-------

Entry 411 - fullUrl = urn:uuid:c792069b-ac5e-4636-88d5-deba135c2f88

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 15.04:03 - 15.39:09
Direktverkande insulin 1.48 IE (2.53 IE/t, 3.62 % = 9.17 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:db2c42f4-ac22-599a-8be0-4d2f52206ffd

```

-------

Entry 412 - fullUrl = urn:uuid:e7896718-313a-4ce1-8ec6-793d90864a5f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.04:31
Vävnadssocker: 12.93 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c4ae8db3-8b06-5886-9cdf-1daa8173bbf8

```

-------

Entry 413 - fullUrl = urn:uuid:eb4905bb-d9ec-4283-9e7f-3ee34cb20be6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.09:32
Vävnadssocker: 13.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ae0ed449-111c-5874-98f1-a270f79739fd

```

-------

Entry 414 - fullUrl = urn:uuid:fa74a14c-275e-40d5-b4a4-d4348936d902

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.14:32
Vävnadssocker: 13.43 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fab4147e-6c57-5ceb-b825-8752b74c9cb9

```

-------

Entry 415 - fullUrl = urn:uuid:c9abd90b-8921-40cb-bad7-041cf0bf7987

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.19:31
Vävnadssocker: 13.65 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:293bb7a7-e761-5b21-892b-369f3e0feadf

```

-------

Entry 416 - fullUrl = urn:uuid:88570398-2fed-45b6-ba7d-5f5a8024a95f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.24:32
Vävnadssocker: 13.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f55a13ef-9bad-5726-ad7c-bf9b1b976dd9

```

-------

Entry 417 - fullUrl = urn:uuid:56366872-a526-4517-9207-19337891280f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.29:32
Vävnadssocker: 13.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5780814a-31fe-529f-980a-91cba4035dca

```

-------

Entry 418 - fullUrl = urn:uuid:103dc74f-3166-4414-9d46-fbc36f1a1f09

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 15.34:21
Direktverkande insulin 1.55 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9ec48764-a4d8-5d88-b636-d6c2b1d52277

```

-------

Entry 419 - fullUrl = urn:uuid:410c6e4f-4df0-42f1-b078-071378544bd1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.34:32
Vävnadssocker: 13.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:685ad506-85fd-57a7-8ff6-0011858874d6

```

-------

Entry 420 - fullUrl = urn:uuid:7592c042-fe39-4645-ad79-91c133b76312

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 15.39:09 - 16.09:12
Direktverkande insulin 0.35 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d41df571-9e6f-59bc-9465-752e34c459ff

```

-------

Entry 421 - fullUrl = urn:uuid:3c1ecddc-29a7-4aaa-a2e4-6e13801f2990

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.39:32
Vävnadssocker: 14.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aa54fbea-b265-5302-b43f-67db38c5d9fa

```

-------

Entry 422 - fullUrl = urn:uuid:8d1fd066-c903-4ae4-9ba4-8e2083a3efaf

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.44:33
Vävnadssocker: 14.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b1e09e5d-30d8-5af8-8cb7-d82d5ccb0f34

```

-------

Entry 423 - fullUrl = urn:uuid:c6720c28-13ff-45cb-8acd-6d29c33a4f86

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.49:33
Vävnadssocker: 14.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:54fb45bc-f192-5fd4-9ef7-53a39696a640

```

-------

Entry 424 - fullUrl = urn:uuid:c26e9fc2-c45b-40aa-8a1f-138c5408753e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.54:33
Vävnadssocker: 14.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d5926cf9-b58d-5b79-bd96-81833710a87b

```

-------

Entry 425 - fullUrl = urn:uuid:41cca00e-5a74-45a1-b9aa-acc2bd876889

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 15.59:33
Vävnadssocker: 14.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5979c4b5-d737-5655-a086-5f0a7d14d3cc

```

-------

Entry 426 - fullUrl = urn:uuid:5dd2907c-d6bf-4e78-8306-426da163238c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.04:33
Vävnadssocker: 13.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d0838a36-9712-58ff-aaf1-d3390db81c25

```

-------

Entry 427 - fullUrl = urn:uuid:ee619373-d402-4fb0-862e-7b1889429fd2

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 16.09:12 - 16.14:14
Direktverkande insulin 0.08 IE (0.91 IE/t, 1.30 % = 1.18 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:93731b75-c16d-5300-b850-b164005d9c8f

```

-------

Entry 428 - fullUrl = urn:uuid:354e003f-5006-4d13-bf6c-edc36011941a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.09:32
Vävnadssocker: 13.43 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5bba497f-3b4b-53e9-a992-e0f804014f6e

```

-------

Entry 429 - fullUrl = urn:uuid:f00abf38-6155-4d58-aaf1-0f339cf4fb0c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 16.14:14 - 18.04:31
Direktverkande insulin 1.29 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:09b1dda8-18ec-5eac-b790-8c440ff431cf

```

-------

Entry 430 - fullUrl = urn:uuid:42541d9a-666c-467d-9d99-02f07f01d919

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.14:38
Vävnadssocker: 13.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cdb63055-dc7a-54e1-bb1c-11831cfab035

```

-------

Entry 431 - fullUrl = urn:uuid:fbd32b95-7992-4f57-8a4a-e83782999c5b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.19:31
Vävnadssocker: 12.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d5adf7e7-612b-5e4c-8db5-6fc409c69c1f

```

-------

Entry 432 - fullUrl = urn:uuid:32a0ac32-c981-44d0-8a2e-045b99374d05

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 16.21:46
Direktverkande insulin 6.04 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:483a87ca-7fc0-5496-b0f6-b7cc57026c92

```

-------

Entry 433 - fullUrl = urn:uuid:1f37e419-0ff4-4859-a967-921051bdbdce

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 5.9.2021 16.21:46
Beräknad mängd kolhydratintag: 65 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5451c93d-d1da-5bbd-81f7-ff417243ddb8

```

-------

Entry 434 - fullUrl = urn:uuid:6c5e2340-61d9-410c-97eb-10a664abe4aa

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.24:32
Vävnadssocker: 12.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6fd799b3-9952-563f-8a02-65c7a499d01a

```

-------

Entry 435 - fullUrl = urn:uuid:4564d206-5f69-4086-a704-2e451b26377e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.29:32
Vävnadssocker: 11.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:64609bc0-54e5-5f20-89c0-67f8b2203242

```

-------

Entry 436 - fullUrl = urn:uuid:5df47517-b881-4a89-8607-a5ee984e0a62

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.34:32
Vävnadssocker: 11.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cfd43973-5224-582a-9c41-e269b43da6fc

```

-------

Entry 437 - fullUrl = urn:uuid:0872f654-b2b1-437b-b583-78b9af30b2e8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.39:31
Vävnadssocker: 10.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e097d785-df80-5fcd-a7a1-67e9d71a3cb2

```

-------

Entry 438 - fullUrl = urn:uuid:e0f6b4e5-1b49-4266-97cc-6ae5f73f6da2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.44:33
Vävnadssocker: 10.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eea9c596-8b38-5365-ba4b-51d95b22a68e

```

-------

Entry 439 - fullUrl = urn:uuid:dadbc84e-476c-4bfb-9517-04073ea9ccdb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.49:32
Vävnadssocker: 9.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ebe26ef0-a998-5016-b9bb-7933d4991450

```

-------

Entry 440 - fullUrl = urn:uuid:9acbea43-7925-41c9-b30a-c4bcd4ff1060

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.54:33
Vävnadssocker: 9.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b2914538-64a5-5ba3-92df-73d72cc3742e

```

-------

Entry 441 - fullUrl = urn:uuid:af719514-c76f-4cc2-a1f3-af810ca34bb8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 16.59:31
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:47336db2-1e00-53d6-82d0-810a3508caa1

```

-------

Entry 442 - fullUrl = urn:uuid:f700af7e-eb4a-42f6-9e9a-774d5e38b7b2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.04:31
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a555b7a7-9d83-53e8-8c30-e2f916854646

```

-------

Entry 443 - fullUrl = urn:uuid:785bae56-dd45-462d-8c04-47567e1a8b4a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.09:31
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:188546a4-d544-53f6-8b6e-0cb67fcfa51e

```

-------

Entry 444 - fullUrl = urn:uuid:69aed245-e134-4063-af31-a221bc5c2eed

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.14:32
Vävnadssocker: 9.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:81584899-4550-5d5d-8d95-9f71325c94ef

```

-------

Entry 445 - fullUrl = urn:uuid:d0d7056c-f010-4381-80ce-89cb7db4efbb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.19:32
Vävnadssocker: 9.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7bc4590f-3f85-5be5-b0aa-1ab22ea57db8

```

-------

Entry 446 - fullUrl = urn:uuid:97d2aea5-402f-4be2-a7af-9e5cb987410d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.24:31
Vävnadssocker: 9.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2e83b3e9-1de7-5aa9-a831-eded79b2ea83

```

-------

Entry 447 - fullUrl = urn:uuid:736a674b-79b3-43a9-a482-b0ecb57f9929

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.29:32
Vävnadssocker: 9.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dbb97eaa-16b5-5a81-a19c-4a5996847340

```

-------

Entry 448 - fullUrl = urn:uuid:971c2611-3c76-4e9d-897e-16a2df9fe848

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.34:38
Vävnadssocker: 8.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:943b8009-48a1-5a3f-956b-724041c3388b

```

-------

Entry 449 - fullUrl = urn:uuid:c718556e-bfe3-45c3-b5cb-395200a9c005

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.39:34
Vävnadssocker: 8.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56d75d87-aba5-59df-a537-aaaf5dca729e

```

-------

Entry 450 - fullUrl = urn:uuid:0e9f8438-d714-4263-b17f-9957a516d7de

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.44:33
Vävnadssocker: 8.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a5235b5e-05b1-58d3-babc-98a16e31ed8e

```

-------

Entry 451 - fullUrl = urn:uuid:95ec2f0b-371b-44ef-a5a0-cabd49bfc4b9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.49:36
Vävnadssocker: 8.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3e3cead7-5c48-5f72-99a7-f9df4d367dfe

```

-------

Entry 452 - fullUrl = urn:uuid:8976198e-b719-4667-aebb-8583140a75b4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.54:35
Vävnadssocker: 7.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5a79bbcb-a635-5f4d-8e33-ba04e0f59bb7

```

-------

Entry 453 - fullUrl = urn:uuid:1f12d7da-980e-4d35-b9bb-aeb2df31eeab

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 17.59:35
Vävnadssocker: 7.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9e7f418d-202d-58c9-b65c-1b14584cc456

```

-------

Entry 454 - fullUrl = urn:uuid:e6441cf7-9993-44b7-8b4e-0551183bfa4d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.04:31
Vävnadssocker: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:65253e65-335e-596d-9d41-a2e8725c2f40

```

-------

Entry 455 - fullUrl = urn:uuid:d814c32a-75fe-4f66-8592-02efa3e8e6e6

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.04:31 - 18.09:33
Direktverkande insulin 0.04 IE (0.44 IE/t, 0.62 % = 0.27 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8c231619-f241-5051-9c51-23619c3d7ec8

```

-------

Entry 456 - fullUrl = urn:uuid:b36ea247-581a-4a12-a251-b8678401e5eb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.09:33
Vävnadssocker: 6.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a7a682e0-92c6-5a50-9f75-3f27a320c1fd

```

-------

Entry 457 - fullUrl = urn:uuid:6fe20654-2163-49e7-a3dc-5ca8b920fc38

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.09:33 - 18.14:33
Direktverkande insulin 0.01 IE (0.15 IE/t, 0.22 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3352a377-5cbe-561e-b1cc-40a0c68d119e

```

-------

Entry 458 - fullUrl = urn:uuid:f4b94f6f-a760-4a8c-b0a5-a8dc32f37e07

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.14:31
Vävnadssocker: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:63c3c4a9-b141-597d-99e1-8eb3724915fa

```

-------

Entry 459 - fullUrl = urn:uuid:0be98886-2278-4e20-9869-6e952fef211b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.14:33 - 18.19:34
Direktverkande insulin 0.01 IE (0.15 IE/t, 0.21 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:162c032f-3c22-546e-a09b-e4876f1d9049

```

-------

Entry 460 - fullUrl = urn:uuid:313ef009-0b40-40ba-97ce-df8f1c60e2fe

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.19:31
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3cc8762d-4e35-5d9f-86f4-d800582a1f2d

```

-------

Entry 461 - fullUrl = urn:uuid:acb25354-b8d5-4d4a-ad88-64c4c8db99e3

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.19:34 - 18.24:35
Direktverkande insulin 0.01 IE (0.14 IE/t, 0.20 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4a0e1534-2ee7-5e51-9674-0beefd9a3cce

```

-------

Entry 462 - fullUrl = urn:uuid:59d5f68c-4b1d-46c9-b39f-152ca2032cbb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.24:31
Vävnadssocker: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d58dd2a4-aa6b-5703-a6b6-7bc62b4be832

```

-------

Entry 463 - fullUrl = urn:uuid:fd48331d-0964-40c6-8c67-386b3bf94ee4

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.24:35 - 18.29:35
Direktverkande insulin 0.01 IE (0.14 IE/t, 0.21 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:29494eca-b342-58b0-91d4-9bf5c9728ac5

```

-------

Entry 464 - fullUrl = urn:uuid:e427b938-6a54-4b34-bf00-b6c31401aba0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.29:31
Vävnadssocker: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0db9a09c-4574-5fab-8931-9067234527ec

```

-------

Entry 465 - fullUrl = urn:uuid:72da89b2-d4e2-43a0-99f0-15ba8b82136d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.29:35 - 18.34:36
Direktverkande insulin 0.01 IE (0.13 IE/t, 0.19 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:812a98a2-c505-5b94-8ff7-4ba195445e4d

```

-------

Entry 466 - fullUrl = urn:uuid:e19e0430-dfef-4622-a59c-956b619639aa

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.34:31
Vävnadssocker: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2c2fe568-b1ba-5e5a-8a48-a76bbf25f57a

```

-------

Entry 467 - fullUrl = urn:uuid:c7c906d4-1da2-4326-980a-a349b0ecd0fb

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.34:36 - 18.39:42
Direktverkande insulin 0.01 IE (0.11 IE/t, 0.16 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c70c2db0-53a6-576e-9b40-af06fb968c71

```

-------

Entry 468 - fullUrl = urn:uuid:823b642d-94f1-471f-92e6-c9b0ea149bfa

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.37:43
Direktverkande insulin 4.92 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7bca2598-2439-5c3f-a194-b02686fb78fd

```

-------

Entry 469 - fullUrl = urn:uuid:2da92344-1c99-40fc-8300-f56cf6ec06a0

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 5.9.2021 18.37:43
Beräknad mängd kolhydratintag: 80 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:307e644b-50b4-56c5-a5fc-757f2babc37e

```

-------

Entry 470 - fullUrl = urn:uuid:68575c18-d077-4191-aea8-988fe21dd9f8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.39:32
Vävnadssocker: 5.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:05e89031-4852-54e8-8229-1dee154387df

```

-------

Entry 471 - fullUrl = urn:uuid:d4f3dd06-2f62-4afa-8e6c-38965e3b6efa

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.39:42 - 18.44:38
Direktverkande insulin 0.01 IE (0.12 IE/t, 0.17 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8539f8fc-0d9e-5720-afcc-c7e8a3ce289e

```

-------

Entry 472 - fullUrl = urn:uuid:720a84b6-0e6f-474f-be7d-a1c56f839764

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.44:31
Vävnadssocker: 5.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:99d370f9-076a-528a-83e8-dc57a8ddf91a

```

-------

Entry 473 - fullUrl = urn:uuid:9b766ede-8907-4e51-a634-d7c8ec0d6eab

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.44:38 - 18.49:39
Direktverkande insulin 0.02 IE (0.27 IE/t, 0.38 % = 0.10 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d6ceca46-6f64-5b83-8fdf-5f41dfe88229

```

-------

Entry 474 - fullUrl = urn:uuid:0f0c2dc8-e1c0-4433-bc86-ffe826e07fb9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.49:33
Vävnadssocker: 5.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:19664f21-83db-55cd-93f3-e6c8bcee0b95

```

-------

Entry 475 - fullUrl = urn:uuid:fd678037-6c95-4043-b64b-7b0467ec6a56

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.49:39 - 18.54:40
Direktverkande insulin 0.05 IE (0.60 IE/t, 0.85 % = 0.51 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:530abf9a-6051-5c73-bc94-f6a87692dd63

```

-------

Entry 476 - fullUrl = urn:uuid:673373ee-ad8d-4ecb-9b58-f73fb9fc0546

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.54:32
Vävnadssocker: 5.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:75525292-3b88-5815-910a-deff790fa4f4

```

-------

Entry 477 - fullUrl = urn:uuid:6621a482-2c0e-4a46-8e2f-1dace5144251

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.54:40 - 18.58:56
Direktverkande insulin 0.05 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bc6dac93-74f6-538a-b6dc-00618effd6b9

```

-------

Entry 478 - fullUrl = urn:uuid:0b93b29c-a39f-4e73-872f-6f26d8582c6f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 18.58:56 - 20.54:58
Direktverkande insulin 0.00 IE (0 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:22f1ca8e-3c79-5f7a-9d7b-948687ef1d19

```

-------

Entry 479 - fullUrl = urn:uuid:0c642f7d-a7ba-46fc-a332-fcc6a32b7538

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 18.59:31
Vävnadssocker: 5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:888e10ad-e53f-58f7-b705-19f3182f2ba1

```

-------

Entry 480 - fullUrl = urn:uuid:7db71a97-2134-4191-bf2e-68ed9cae3054

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.04:32
Vävnadssocker: 4.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7064a91a-5ff1-546c-a5b8-5ff93acf4ca3

```

-------

Entry 481 - fullUrl = urn:uuid:c9a0c067-e6c9-4fc9-82fa-e83e9a94b838

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.09:33
Vävnadssocker: 4.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1682e651-2fac-532a-8f93-e58c51566c50

```

-------

Entry 482 - fullUrl = urn:uuid:2dafeaab-b984-4193-9a8e-e11b712852ad

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.14:31
Vävnadssocker: 4.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:88a74457-7498-5c8e-9d5f-b2e4e599d6a5

```

-------

Entry 483 - fullUrl = urn:uuid:7af31e11-b396-4391-8fa9-370ca1f0fc88

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.19:31
Vävnadssocker: 4.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:45d67afa-5adb-5fbc-be3d-3d7b38b56c00

```

-------

Entry 484 - fullUrl = urn:uuid:1b188c10-95bb-4012-8cc9-937d25f51329

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.24:31
Vävnadssocker: 4.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9e4a6ef5-621a-5f71-a793-32f4070364f6

```

-------

Entry 485 - fullUrl = urn:uuid:26381c45-4fb2-43a9-8af8-b4ab28b8bd92

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.29:31
Vävnadssocker: 4.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4f49faf9-55eb-5717-af80-3b203ab32d00

```

-------

Entry 486 - fullUrl = urn:uuid:b7befe56-433c-404b-9353-c47832622985

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.34:31
Vävnadssocker: 4.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:13bd8d9b-d98d-5d1a-8d05-d68c315378eb

```

-------

Entry 487 - fullUrl = urn:uuid:4171fa5f-0657-40e6-986f-94268575c143

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.39:31
Vävnadssocker: 4.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9a55522b-e915-5be4-8bc0-0b845f4c0db9

```

-------

Entry 488 - fullUrl = urn:uuid:811b2e76-88e6-45ee-b1f4-824b8b409364

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.44:31
Vävnadssocker: 4.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:21f41eaf-fb1d-5c52-b31a-2c199d1f1d9c

```

-------

Entry 489 - fullUrl = urn:uuid:a673a810-dc85-475f-84e6-65fd98940ff2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.49:31
Vävnadssocker: 4.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:390c2d76-7562-5385-b426-0de2d61747c6

```

-------

Entry 490 - fullUrl = urn:uuid:f6ed4bc5-566c-410f-855b-b987257d655d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.54:31
Vävnadssocker: 4.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:78a62c4a-39a8-5c22-8f8f-173aea5f7735

```

-------

Entry 491 - fullUrl = urn:uuid:019ac93a-8f7a-4add-91eb-5c2e9bf2869d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 19.59:31
Vävnadssocker: 4.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d7d4ec4c-d2a5-5c6d-bcbf-eec0e33e9822

```

-------

Entry 492 - fullUrl = urn:uuid:a6220bae-412a-4364-ad51-9432d6f942d8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.04:31
Vävnadssocker: 3.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:abdb3999-e139-5f14-b4b4-b47f93f5604e

```

-------

Entry 493 - fullUrl = urn:uuid:0db5d351-cdcf-4287-9288-e3ffdd09b4d2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.09:31
Vävnadssocker: 3.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:df7735d1-5eb3-59aa-a373-a8107fec18b0

```

-------

Entry 494 - fullUrl = urn:uuid:ec672739-86d1-4342-962d-84b4d9ddba94

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.14:31
Vävnadssocker: 3.39 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d3cd68dc-a812-5911-8e5d-375074109368

```

-------

Entry 495 - fullUrl = urn:uuid:4e309479-df75-465d-aa62-0376f80566d3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.19:31
Vävnadssocker: 3.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eb41bdd4-9f26-5c02-856a-51c09d56d986

```

-------

Entry 496 - fullUrl = urn:uuid:1100a625-3656-44ff-878e-56a6ea58eb0e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.24:31
Vävnadssocker: 3.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3d4c2c4e-889c-52cf-9cf8-3419ef5ec4c3

```

-------

Entry 497 - fullUrl = urn:uuid:a08717c8-7cce-42be-bae4-fa75026a52bc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.29:31
Vävnadssocker: 3.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:079c49a6-1e00-5aad-b166-8cea4cda4f8e

```

-------

Entry 498 - fullUrl = urn:uuid:a839467f-bcfe-4cb7-b7f1-f38f7d77548f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.34:31
Vävnadssocker: 3.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5855a294-9ea3-5777-b8e7-5e17c424c27e

```

-------

Entry 499 - fullUrl = urn:uuid:4b7c6516-100c-4b4e-9664-b06a293119b2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.39:31
Vävnadssocker: 4.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:60f6ad0c-7acf-595e-a851-12c47a7e02c8

```

-------

Entry 500 - fullUrl = urn:uuid:9c67480c-7675-4f40-adad-d36f4c855cc6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.44:31
Vävnadssocker: 4.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8feddb56-5f2d-56fc-8b86-a42c2b7ec20b

```

-------

Entry 501 - fullUrl = urn:uuid:af5b325e-7f02-41a3-b32f-211b7406a38f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.49:31
Vävnadssocker: 5.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3fea7837-a59d-5835-9d55-3b0d21791d41

```

-------

Entry 502 - fullUrl = urn:uuid:f406ebf2-4c10-4663-9fdc-cd23751ffce0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.54:31
Vävnadssocker: 5.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d32d044b-a844-51ed-a354-7fb71c727144

```

-------

Entry 503 - fullUrl = urn:uuid:d31bda92-660e-4f7d-917f-cce946e34bc7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 20.54:58 - 20.57:37
Direktverkande insulin 0.00 IE (0.10 IE/t, 0.15 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b0d0a3b9-22ee-5811-8a66-be7559639b9a

```

-------

Entry 504 - fullUrl = urn:uuid:f28a208b-f5ba-451d-90d0-a5ca3fe154c6

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 20.55:18
Direktverkande insulin 2.20 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6b4c9f57-9cd6-59d2-a88e-e8303715b54f

```

-------

Entry 505 - fullUrl = urn:uuid:98cd713c-b341-481f-82df-d934e891c4fe

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 20.57:37 - 21.40:29
Direktverkande insulin 0.00 IE (0 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1eafb206-dac5-5cf2-8b05-8a768a9fdc56

```

-------

Entry 506 - fullUrl = urn:uuid:a2e7f929-f7b6-4b63-a9cd-6a2010c747cc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 20.59:31
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8ee0630-0d68-5606-81c6-e75dd881a630

```

-------

Entry 507 - fullUrl = urn:uuid:65d2ee19-00b1-4ed9-ab5d-67ca6957583a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.04:31
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:faaa1b80-9e8a-5cff-8ff1-765f696b55dc

```

-------

Entry 508 - fullUrl = urn:uuid:7647906d-04a7-4185-a838-c880beeaaf46

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.09:31
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eec225b8-cf22-5291-a38f-344332fc2ec1

```

-------

Entry 509 - fullUrl = urn:uuid:e1a54e25-a8b5-43d6-86b7-ae03c955f9d4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.14:31
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c66b3324-63ee-58a6-99e8-dc67316ac0e6

```

-------

Entry 510 - fullUrl = urn:uuid:3a5ddf72-ea0a-4eea-9d8a-fcf37530d63a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.19:31
Vävnadssocker: 6.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7fb0ffae-4052-5de5-b3b5-72007fc6de2d

```

-------

Entry 511 - fullUrl = urn:uuid:73239285-939d-42ad-999a-c4dd294c1c24

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.24:31
Vävnadssocker: 6.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:afa6157a-c249-5aa3-851c-d48926926204

```

-------

Entry 512 - fullUrl = urn:uuid:2936432c-4c62-4c2b-9ec3-5d16b15bb305

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.29:31
Vävnadssocker: 6.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c25024d-76c4-5873-91a7-9c0b196d8ea9

```

-------

Entry 513 - fullUrl = urn:uuid:eefe7aca-b7c1-433a-971b-792e9c3c4252

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.34:31
Vävnadssocker: 6.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fbe300e2-7bf5-515b-9312-7503858d4bea

```

-------

Entry 514 - fullUrl = urn:uuid:46677388-ab76-4aa1-a37f-d098eae4fdbf

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.39:31
Vävnadssocker: 6.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:77089f3a-5841-5ebc-9d3f-b42bc7d9296b

```

-------

Entry 515 - fullUrl = urn:uuid:dc779648-c56d-417f-bd64-a46018d7afd2

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 21.40:29 - 21.41:33
Direktverkande insulin 0.01 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fc60089d-4605-5d5e-9051-4e08e63d83f9

```

-------

Entry 516 - fullUrl = urn:uuid:b5b9f19f-59ae-489e-b37b-d48bc2e429dd

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 21.40:46
Direktverkande insulin 0.85 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ef41ee58-106d-5d03-8df9-30e7433c48ee

```

-------

Entry 517 - fullUrl = urn:uuid:ec905782-dc01-4f77-86d9-a7d938cade5d

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 5.9.2021 21.40:46
Beräknad mängd kolhydratintag: 25 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:adbb4ac0-f2dc-51d7-afc7-661a2b76c9c6

```

-------

Entry 518 - fullUrl = urn:uuid:f9b0a98c-d403-41fd-8565-164dff93059c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 21.41:33 - 22.46:35
Direktverkande insulin 0.00 IE (0 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:16d0a89f-a2d1-5e98-9e5d-7e6b2d9c29a1

```

-------

Entry 519 - fullUrl = urn:uuid:26411a65-93c4-4bbc-9f70-ae95a632ac91

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.44:31
Vävnadssocker: 6.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:67429add-dcd5-5672-8877-083ca5ba9309

```

-------

Entry 520 - fullUrl = urn:uuid:d437662c-08b6-40bd-af5f-03ac06294e3a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.49:31
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ef9be62c-ca46-58b6-be89-a129bd2b0fa5

```

-------

Entry 521 - fullUrl = urn:uuid:d8721859-83bb-4b82-b663-24eafdedd5ca

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.54:31
Vävnadssocker: 5.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:300cbf6b-587c-57c5-89da-8b6d58d5e5eb

```

-------

Entry 522 - fullUrl = urn:uuid:aac39377-0523-4110-a30a-6a7668eb726c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 21.59:30
Vävnadssocker: 5.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a19ecaab-32e6-5e60-b124-3c7ada8bef91

```

-------

Entry 523 - fullUrl = urn:uuid:2693b701-00d5-4108-b8db-3fb2af141e36

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.04:30
Vävnadssocker: 4.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:60fdb880-d7eb-5549-b2e6-51a9f00a054d

```

-------

Entry 524 - fullUrl = urn:uuid:47b86931-dceb-4208-989b-3286a0234e05

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.09:30
Vävnadssocker: 4.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:07f7f9ca-f9e9-53b4-af6a-ee57cb8a502f

```

-------

Entry 525 - fullUrl = urn:uuid:66f0ceaa-39dc-4418-90f2-85b4d606402b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.14:30
Vävnadssocker: 4.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8d41500-2449-5d9b-aa39-2efbc205088d

```

-------

Entry 526 - fullUrl = urn:uuid:1339700b-40ed-4f74-bc93-18c138205eb4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.19:30
Vävnadssocker: 4.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a07591dc-292a-5fd4-b438-ed88f2a6c037

```

-------

Entry 527 - fullUrl = urn:uuid:ed633a7c-27e3-489e-a00d-4128963bdfa6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.24:30
Vävnadssocker: 4.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cb2ec451-ca54-55d8-ad30-590ffe181bb5

```

-------

Entry 528 - fullUrl = urn:uuid:69d8e3eb-05fe-4ca2-801b-fa58710b065e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.29:30
Vävnadssocker: 4.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ca04a997-e568-56b3-8929-6313a4a69431

```

-------

Entry 529 - fullUrl = urn:uuid:67da769a-d215-48cd-bd73-f94df2bdf623

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.34:32
Vävnadssocker: 4.39 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9e7023a3-c393-594f-933a-b1c54928eeef

```

-------

Entry 530 - fullUrl = urn:uuid:70b77a71-d6b0-4539-b670-a18b851e90dc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.39:31
Vävnadssocker: 4.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3aee5511-00be-5077-b6ba-d71fbb65430d

```

-------

Entry 531 - fullUrl = urn:uuid:ff6297cf-1664-4970-acee-17579c5f1df7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.44:32
Vävnadssocker: 4.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1b20e3e7-d6c8-5581-afad-fd1d7690403e

```

-------

Entry 532 - fullUrl = urn:uuid:53645ba6-c0ba-43db-99ca-08706a000a80

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 22.46:35 - 23.01:56
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2acc9058-00c1-535e-8fe8-8dee6fe5656d

```

-------

Entry 533 - fullUrl = urn:uuid:bff2f2ec-17bf-4a8c-94ac-b22e60543d7c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.49:30
Vävnadssocker: 3.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:98906652-0726-59ab-a5d1-a978319ec1b0

```

-------

Entry 534 - fullUrl = urn:uuid:12e2e338-3e27-45d0-a17f-bb7128923e6c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 22.49:45
Direktverkande insulin 2.68 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:09cb46f6-4802-515c-a620-2e660747a78e

```

-------

Entry 535 - fullUrl = urn:uuid:bba25943-907f-417e-9566-947b01822d62

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 5.9.2021 22.49:45
Beräknad mängd kolhydratintag: 50 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7a614b27-e235-545f-918c-814c22b43585

```

-------

Entry 536 - fullUrl = urn:uuid:57d93cb5-5029-4dc6-9338-5dc61e723f9d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.54:30
Vävnadssocker: 3.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:70d02dcf-62a3-5b2a-b454-4191fefdbb00

```

-------

Entry 537 - fullUrl = urn:uuid:96a16c4d-e180-47f2-92b0-20cb820dc9d3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 22.59:31
Vävnadssocker: 2.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5258f594-a398-5492-b116-017b2be77937

```

-------

Entry 538 - fullUrl = urn:uuid:fd0e293f-1a0f-4935-9ba3-59539b513d9a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 23.01:56 - 23.16:57
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:399b7ff2-706f-542f-a573-b3eeacdb0aab

```

-------

Entry 539 - fullUrl = urn:uuid:b41d1187-72e7-49f7-9688-898c7613ea25

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.04:31
Vävnadssocker: 2.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:412bfaaa-0be9-5850-977a-0893fdfbcbf3

```

-------

Entry 540 - fullUrl = urn:uuid:41ee422a-2335-4d71-848b-a2c8e182087f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.09:31
Vävnadssocker: 3.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a3d0e479-cdd2-5463-bbcf-37397cc2488c

```

-------

Entry 541 - fullUrl = urn:uuid:67f5f21e-ead2-4577-aecc-a172b27441e8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.14:31
Vävnadssocker: 3.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a9d44145-e5b4-59f3-a446-babf7385d751

```

-------

Entry 542 - fullUrl = urn:uuid:629663e3-c624-4938-8d2a-d2b25b1be68b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 23.16:57 - 23.21:59
Direktverkande insulin 0.04 IE (0.45 IE/t, 0.59 % = 0.27 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:93a4c48e-5bc1-5ba1-af28-c20dac9477c4

```

-------

Entry 543 - fullUrl = urn:uuid:7c374ea8-59ce-4973-8f53-053146856973

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.19:30
Vävnadssocker: 4.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a8063eb2-81d5-5eb5-a7d7-af8207737265

```

-------

Entry 544 - fullUrl = urn:uuid:c8e2f6af-32da-425c-b000-86319b5bf7bc

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 23.21:59 - 23.27:00
Direktverkande insulin 0.06 IE (0.75 IE/t, 0.99 % = 0.74 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:65beebe0-6716-5f21-bcf7-2389889f2595

```

-------

Entry 545 - fullUrl = urn:uuid:a89e31fd-4aee-43e8-a48f-bd6539b25a9e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.24:30
Vävnadssocker: 4.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bdc3d288-ed0e-56c5-b639-a804da53e79d

```

-------

Entry 546 - fullUrl = urn:uuid:83022ad7-86c2-4121-b334-8432bfc20475

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 23.27:00 - 23.32:00
Direktverkande insulin 0.05 IE (0.57 IE/t, 0.76 % = 0.44 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:edb27035-f574-50d5-929c-97b9daceb91a

```

-------

Entry 547 - fullUrl = urn:uuid:c0286c07-2392-4380-9740-a609915ff1e6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.29:37
Vävnadssocker: 5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2c577564-8b51-5ba1-886b-c3ace436eb85

```

-------

Entry 548 - fullUrl = urn:uuid:7be95e97-e30f-4d4e-b62f-77a15f3364bd

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 5.9.2021 23.32:00 - 6.9.2021 00.00:00
Direktverkande insulin 0.35 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:31e19b61-9fe9-5ad0-8c6a-207d08120c34

```

-------

Entry 549 - fullUrl = urn:uuid:98f1ec77-505b-4ff0-b2b3-e94042e92336

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.34:30
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:30d9b39c-89e6-50fc-ac67-5b4388f24373

```

-------

Entry 550 - fullUrl = urn:uuid:25e3048a-f1cf-4254-bdfd-41791ccb9100

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.39:30
Vävnadssocker: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:487fd8e8-f814-57d4-9d0e-cf4c80d37ad4

```

-------

Entry 551 - fullUrl = urn:uuid:600c7620-c89f-47e7-89f8-2ae9e3ea69c7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.44:30
Vävnadssocker: 6.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1bb35c98-e2c2-56ca-a559-c984b34b7fad

```

-------

Entry 552 - fullUrl = urn:uuid:8056c887-a423-4ec9-9406-68eeef446a56

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.49:30
Vävnadssocker: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:05e85391-a03e-5221-a141-e716ea057976

```

-------

Entry 553 - fullUrl = urn:uuid:f7c7711a-4310-42bc-8c83-f64029ecd801

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.54:30
Vävnadssocker: 7.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e7d525e3-f819-5889-8500-3b7d98c93c6d

```

-------

Entry 554 - fullUrl = urn:uuid:a5ec87dc-8e57-42e0-9742-d1f23c7399cd

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 5.9.2021 23.59:30
Vävnadssocker: 7.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8976865c-a8ea-5cb9-a97b-c6f7786929c4

```

-------

Entry 555 - fullUrl = urn:uuid:80f1d6c7-c4f4-4954-adc4-4382debed19f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.00:00 - 00.17:07
Direktverkande insulin 0.21 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5a10af56-7992-5a94-ad8c-83d3510af326

```

-------

Entry 556 - fullUrl = urn:uuid:5070a243-d02d-48aa-823d-7d42cf370f66

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.04:30
Vävnadssocker: 7.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5b209cde-5caf-503f-86ed-19983c4fe100

```

-------

Entry 557 - fullUrl = urn:uuid:26a9e8f8-c340-42b8-b212-d4c036ff5e7a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.09:30
Vävnadssocker: 7.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e89e25f5-36ba-5719-98eb-6c7526819ed0

```

-------

Entry 558 - fullUrl = urn:uuid:adff6bc8-2281-4f51-af3c-030158a5be8f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.14:32
Vävnadssocker: 7.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d7924f0a-84ad-5943-8f4b-57bbd59469b3

```

-------

Entry 559 - fullUrl = urn:uuid:d4ec0c0d-84ef-4426-b2f5-5093066b6936

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.17:07 - 00.22:08
Direktverkande insulin 0.08 IE (0.99 IE/t, 1.32 % = 1.31 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b285ff4b-ef0a-5465-ad24-3259d61e2e97

```

-------

Entry 560 - fullUrl = urn:uuid:25a0ebac-3671-4c19-94f9-6d71f194a9d9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.19:32
Vävnadssocker: 8.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0a5ad4dd-30ce-5cd1-9bdb-b6524f55faa0

```

-------

Entry 561 - fullUrl = urn:uuid:87cd4b20-0c45-492a-8a89-f9ead53cfbce

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.22:08 - 00.27:09
Direktverkande insulin 0.12 IE (1.42 IE/t, 1.89 % = 2.67 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:348df345-ccee-5010-b93d-505ceda8d349

```

-------

Entry 562 - fullUrl = urn:uuid:0cb321cd-d738-4a01-bc16-024dc540b091

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.24:33
Vävnadssocker: 8.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:40b50d9d-0b54-5f42-acd1-9378fe3e59d3

```

-------

Entry 563 - fullUrl = urn:uuid:c8d9f0e4-1c3e-45b5-a562-17a8347be35e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.27:09 - 00.32:09
Direktverkande insulin 0.14 IE (1.72 IE/t, 2.29 % = 3.93 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1f00f365-b3cc-5b69-a3be-3ff6d7f1cd1c

```

-------

Entry 564 - fullUrl = urn:uuid:6a303f28-0f56-4e78-9fac-e783eb921606

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.29:31
Vävnadssocker: 8.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56ac4cc1-78e5-5325-8222-ad2a9fa95ed5

```

-------

Entry 565 - fullUrl = urn:uuid:104326a1-a9de-4587-a7d7-ebf36ab6dec8

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.32:09 - 00.37:11
Direktverkande insulin 0.18 IE (2.17 IE/t, 2.89 % = 6.27 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5b107abf-a517-511d-9f13-54d187f1500b

```

-------

Entry 566 - fullUrl = urn:uuid:26b7b276-f324-4fd8-87e5-7609b4216a30

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.34:32
Vävnadssocker: 8.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8475b752-42ae-5637-9ebe-205ffcec4c29

```

-------

Entry 567 - fullUrl = urn:uuid:a1cf816b-7edf-474f-9383-4a00b297d5dd

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.37:11 - 00.42:11
Direktverkande insulin 0.20 IE (2.39 IE/t, 3.19 % = 7.63 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e8e205d1-7905-5f88-abda-b18283f52455

```

-------

Entry 568 - fullUrl = urn:uuid:536559a4-7f72-4f85-a3f4-308c4c3f9392

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.39:32
Vävnadssocker: 9.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fa27d2ae-6883-51ca-94e1-db6788e5ef82

```

-------

Entry 569 - fullUrl = urn:uuid:d6f2f1c7-d98e-43bb-9bf2-19f0bae678e9

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.42:11 - 00.47:12
Direktverkande insulin 0.21 IE (2.50 IE/t, 3.33 % = 8.30 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c8dd5172-4948-55fc-bad2-811f804fa866

```

-------

Entry 570 - fullUrl = urn:uuid:61e9190f-9baa-4941-87df-b3162e71c0d7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.44:35
Vävnadssocker: 9.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c6e1763a-7ae4-556b-88a1-1c43b4bf7636

```

-------

Entry 571 - fullUrl = urn:uuid:6bbdc988-260e-46a6-92f8-b10c3674feb7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.47:12 - 00.52:13
Direktverkande insulin 0.20 IE (2.42 IE/t, 3.23 % = 7.80 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:75db8c20-765f-5afc-9e93-dbd254586c3d

```

-------

Entry 572 - fullUrl = urn:uuid:6ca2dcb9-6578-431b-9ccd-d8125bd2483e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.49:31
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b2d5a4ae-667e-5f14-8198-f31a9b75627e

```

-------

Entry 573 - fullUrl = urn:uuid:43f84077-c7dc-4153-9598-b64a5c728b94

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.52:13 - 00.57:15
Direktverkande insulin 0.17 IE (2.05 IE/t, 2.73 % = 5.60 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5589a548-8b64-52dd-8d2d-2b14102cd8f4

```

-------

Entry 574 - fullUrl = urn:uuid:dcb47482-6b05-4e92-8ac6-f0a759c6d90e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.54:31
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c9d59051-afe9-583e-b182-64a03aa34ef7

```

-------

Entry 575 - fullUrl = urn:uuid:e0446610-6297-4bcf-b22a-19096357ed0b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 00.57:15 - 01.02:16
Direktverkande insulin 0.16 IE (1.90 IE/t, 2.53 % = 4.79 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ae05adf2-87f8-5c6b-a927-8edae8ea1e03

```

-------

Entry 576 - fullUrl = urn:uuid:bf868adf-4420-4ac5-9bfa-804d4a1f64cc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 00.59:31
Vävnadssocker: 9.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6d6df7f0-ad7e-5c96-86d4-d93acafedb17

```

-------

Entry 577 - fullUrl = urn:uuid:a569dfe8-b643-4bd9-9227-7ce4f0b504ea

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.02:16 - 01.07:15
Direktverkande insulin 0.15 IE (1.82 IE/t, 2.43 % = 4.41 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a7f78eb6-f362-5b47-8c59-aabbe485cda7

```

-------

Entry 578 - fullUrl = urn:uuid:7afc7f2f-d449-4b53-a642-bc90eaff7c21

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.04:31
Vävnadssocker: 9.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:752306bf-0282-5384-84a2-187aff0cfb2e

```

-------

Entry 579 - fullUrl = urn:uuid:ba2228a0-8a2d-47b8-9c35-95821d468b76

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.07:15 - 01.12:16
Direktverkande insulin 0.15 IE (1.76 IE/t, 2.35 % = 4.13 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c757e821-46ee-5d66-b62e-4c70747f4333

```

-------

Entry 580 - fullUrl = urn:uuid:48faf693-a336-4e22-b578-0eccb587ce05

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.09:31
Vävnadssocker: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2274806e-2820-5004-afd6-870ff2571e69

```

-------

Entry 581 - fullUrl = urn:uuid:5054696d-d990-4d28-a069-622b1989ee66

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.12:16 - 01.15:26
Direktverkande insulin 0.09 IE (1.72 IE/t, 2.29 % = 3.94 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:882d5624-4963-5f53-94fe-8a016102f520

```

-------

Entry 582 - fullUrl = urn:uuid:05bd9981-7877-4d67-ad7d-449408eed597

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.14:31
Vävnadssocker: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a71597e5-1e18-5029-91f6-91d28bb6af45

```

-------

Entry 583 - fullUrl = urn:uuid:5c97e549-9c25-4115-ba24-f4e9774eb308

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.15:26 - 01.17:17
Direktverkande insulin 0.05 IE (1.72 IE/t, 2.29 % = 3.94 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fb9162f6-7e8f-5f93-a51f-b6825d6b1034

```

-------

Entry 584 - fullUrl = urn:uuid:1ebdea8f-5da0-4925-a20b-efa7c03566ab

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.17:17 - 01.35:26
Direktverkande insulin 0.23 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c92130ee-2bc4-57ee-b9d5-20a66c5fd4bf

```

-------

Entry 585 - fullUrl = urn:uuid:99c0713f-37af-47b1-a96a-de91f7f32a22

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.19:31
Vävnadssocker: 10.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e439e9b9-c198-554f-b0dc-737ae48f0c76

```

-------

Entry 586 - fullUrl = urn:uuid:59250b6c-89ff-4dbf-aaa5-7d7b8c169b36

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.24:31
Vävnadssocker: 10.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a0cc2605-5921-5401-86aa-3cd32752ae60

```

-------

Entry 587 - fullUrl = urn:uuid:945c2a90-a9a7-4598-b29d-1273f7e490ed

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.29:31
Vävnadssocker: 10.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2c12232b-21a2-5913-8bef-f708bfa7be3e

```

-------

Entry 588 - fullUrl = urn:uuid:001543dd-67cd-4b9d-bccb-56e9296e8462

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.34:31
Vävnadssocker: 11.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4011426a-3f49-5da1-a998-875a420da86d

```

-------

Entry 589 - fullUrl = urn:uuid:1b2dce50-39bb-48cc-b8b3-329180586cc0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.35:26 - 01.37:21
Direktverkande insulin 0.02 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cd6c5b26-03eb-56de-8fd8-c1657e735805

```

-------

Entry 590 - fullUrl = urn:uuid:b34d6e8a-7e5b-4a80-9b72-1309c2e11655

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.37:21 - 01.42:21
Direktverkande insulin 0.29 IE (3.50 IE/t, 4.67 % = 16.35 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5765ab46-37fa-5176-ac9c-96a3346d2506

```

-------

Entry 591 - fullUrl = urn:uuid:dc9e6534-1e4e-4546-b9a1-02082dbd79a9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.39:31
Vävnadssocker: 11.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:65a085cc-f44a-52b7-8637-7bfda6590e59

```

-------

Entry 592 - fullUrl = urn:uuid:1b244d4d-2f8d-4750-93d6-8680c0d2178e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.42:21 - 01.52:23
Direktverkande insulin 0.59 IE (3.51 IE/t, 4.68 % = 16.45 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7cfdd866-7e63-5f53-923e-fb411566100e

```

-------

Entry 593 - fullUrl = urn:uuid:ae6397af-771d-440f-a19f-826bb469ae04

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.44:35
Vävnadssocker: 11.32 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cadeea4e-8271-552a-8640-2affffe60fdd

```

-------

Entry 594 - fullUrl = urn:uuid:832b0db6-2ad6-4bb3-933a-f25297a5257d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.49:31
Vävnadssocker: 11.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fc226fbf-7878-5e48-ae11-b153e72ecf9c

```

-------

Entry 595 - fullUrl = urn:uuid:61350ce8-7ea6-40c0-a323-33a1b99c22a0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.52:23 - 01.57:25
Direktverkande insulin 0.22 IE (2.59 IE/t, 3.46 % = 8.96 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cf5d6356-e7da-5fba-a6e7-76892eea7b72

```

-------

Entry 596 - fullUrl = urn:uuid:dacf64f8-6428-49ee-ab20-5eff83103568

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.54:30
Vävnadssocker: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ee92392e-a60e-5545-a836-af1e6f6138a0

```

-------

Entry 597 - fullUrl = urn:uuid:136211d8-dfde-4f87-9fc2-d3ed87dea483

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 01.57:25 - 02.02:26
Direktverkande insulin 0.21 IE (2.55 IE/t, 3.40 % = 8.65 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:89f07805-f2c8-511d-8c2d-aaba12a2d792

```

-------

Entry 598 - fullUrl = urn:uuid:bf5c5bb5-b972-4653-a3b9-9a5852828088

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 01.59:30
Vävnadssocker: 11.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:84c5f9f4-70cd-578e-a4fa-fcd28003d258

```

-------

Entry 599 - fullUrl = urn:uuid:fa247545-d825-4955-9926-1c557bb58498

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.02:26 - 02.07:26
Direktverkande insulin 0.18 IE (2.12 IE/t, 2.83 % = 6.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:22de0ac8-7df6-5702-8f15-7749f5b18f91

```

-------

Entry 600 - fullUrl = urn:uuid:13e7c0d7-6003-47c8-a308-00225697c0cd

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.04:30
Vävnadssocker: 11.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c8282e8-62df-567a-ab3f-e7389ab6fcf0

```

-------

Entry 601 - fullUrl = urn:uuid:c536d7f8-6dce-4cf7-a650-f2790149e84a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.07:26 - 02.12:27
Direktverkande insulin 0.15 IE (1.78 IE/t, 2.37 % = 4.23 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:40dcded5-204f-5b89-b3db-dadb47e391a9

```

-------

Entry 602 - fullUrl = urn:uuid:ab67898f-e8a2-434d-835f-7313decabd47

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.09:30
Vävnadssocker: 11.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:175e6247-bc4d-57a6-91d8-49ad8263a869

```

-------

Entry 603 - fullUrl = urn:uuid:b4249b07-a41c-40e9-b924-dfa1fb6aef11

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.12:27 - 02.17:28
Direktverkande insulin 0.14 IE (1.70 IE/t, 2.27 % = 3.87 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b83b8181-e0a9-544f-8eae-8550afe91153

```

-------

Entry 604 - fullUrl = urn:uuid:e5b425a2-54ae-4f28-b753-3bb894ecca39

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.14:30
Vävnadssocker: 10.93 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:da663a76-3ad5-5799-b867-d9a84fd91270

```

-------

Entry 605 - fullUrl = urn:uuid:61544d15-4efc-4e05-8a59-8abd31b13582

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.17:28 - 02.22:29
Direktverkande insulin 0.13 IE (1.58 IE/t, 2.11 % = 3.35 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:498b19e7-e6ff-5386-96db-85aa6f72501c

```

-------

Entry 606 - fullUrl = urn:uuid:41af0e8a-d99c-457f-9eca-25ad0d845978

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.19:30
Vävnadssocker: 10.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:461c2537-f6b4-5f93-ad7f-c877c7f3c97b

```

-------

Entry 607 - fullUrl = urn:uuid:976b870b-5f32-4224-ac65-4b05ebb60241

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.22:29 - 02.27:30
Direktverkande insulin 0.12 IE (1.48 IE/t, 1.98 % = 2.94 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dba42e1c-81be-5511-8bf9-22eea95ded5f

```

-------

Entry 608 - fullUrl = urn:uuid:f86d5789-edac-497e-aa5e-836b4a999f16

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.24:30
Vävnadssocker: 10.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d0a3280d-4cc5-5bdd-95e1-6423a6b6cf12

```

-------

Entry 609 - fullUrl = urn:uuid:8386febc-710f-4ff9-8283-6d17f9da4d95

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.27:30 - 02.32:29
Direktverkande insulin 0.12 IE (1.42 IE/t, 1.89 % = 2.68 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5eaaba3e-6a94-5cd6-a307-174d6c996c89

```

-------

Entry 610 - fullUrl = urn:uuid:c57679aa-7a44-4823-a2e6-211543177319

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.29:32
Vävnadssocker: 10.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:588eceee-eb3e-5869-a9be-827a536de468

```

-------

Entry 611 - fullUrl = urn:uuid:2f0df2ed-350e-4f71-a87b-405b1d86f750

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.32:29 - 02.37:31
Direktverkande insulin 0.10 IE (1.25 IE/t, 1.66 % = 2.07 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9ff8a833-3e3a-58c3-bba0-668b41b2507a

```

-------

Entry 612 - fullUrl = urn:uuid:2765468a-e0b1-44b2-845f-2b7e6a25ecc6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.34:31
Vävnadssocker: 10.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8c4d3460-111e-54dd-b6dc-b6cf66dfe185

```

-------

Entry 613 - fullUrl = urn:uuid:71c254ff-00da-48ab-9a37-289c367e0d7e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.37:31 - 02.42:32
Direktverkande insulin 0.09 IE (1.10 IE/t, 1.47 % = 1.62 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4726ac03-ad36-599d-b7dd-4ca8da97508d

```

-------

Entry 614 - fullUrl = urn:uuid:5caaa7a4-b6ef-4ae9-97e0-9afcd4017714

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.39:30
Vävnadssocker: 10.32 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d5aef148-81d0-5426-821a-1a86e1d54075

```

-------

Entry 615 - fullUrl = urn:uuid:393d0cef-a633-49c9-a567-fea81099a47f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.42:32 - 02.47:33
Direktverkande insulin 0.11 IE (1.29 IE/t, 1.72 % = 2.21 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:714ec453-3990-5a68-8f1a-87ef215ab995

```

-------

Entry 616 - fullUrl = urn:uuid:35030e45-50a0-49db-8175-ecbd0cde227e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.44:31
Vävnadssocker: 10.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8e352acf-c760-5618-aa69-887db180fc61

```

-------

Entry 617 - fullUrl = urn:uuid:b134ce8a-07ba-4293-91fd-2f3294bef339

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.47:33 - 02.52:33
Direktverkande insulin 0.12 IE (1.49 IE/t, 1.99 % = 2.97 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8e148e99-52f5-5295-bd2e-f89894283d29

```

-------

Entry 618 - fullUrl = urn:uuid:55d011c4-1a7d-4bfa-b153-42c0f15ef952

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.49:30
Vävnadssocker: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:222022bf-7c46-5497-9751-44b5c72e082e

```

-------

Entry 619 - fullUrl = urn:uuid:301a9fab-c155-480c-9534-b82be0ddef96

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.52:33 - 02.57:34
Direktverkande insulin 0.13 IE (1.61 IE/t, 2.15 % = 3.47 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1e26add9-231c-5d0e-aa7d-36d9abc9b8ff

```

-------

Entry 620 - fullUrl = urn:uuid:b0a276a3-7571-49b9-8972-2734abca2b17

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.54:30
Vävnadssocker: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e92c584e-34be-5551-a0f0-b7917b21f5b3

```

-------

Entry 621 - fullUrl = urn:uuid:8ab9fb94-57d3-4610-ba24-8e94a1536671

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 02.57:34 - 03.02:34
Direktverkande insulin 0.08 IE (0.97 IE/t, 1.30 % = 1.27 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:145f8e58-a3f5-5294-923f-8dc7828e9fdb

```

-------

Entry 622 - fullUrl = urn:uuid:f54fc7c6-1557-42b4-8c1d-e8527aacafde

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 02.59:30
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a21fd0db-6b94-5d62-9e68-dc4ac2743d49

```

-------

Entry 623 - fullUrl = urn:uuid:9abd64ed-3960-402d-9762-0bbfaad3c470

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.02:34 - 03.27:40
Direktverkande insulin 0.31 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bdd12964-b5ac-58e1-ac72-5d17a8c5d090

```

-------

Entry 624 - fullUrl = urn:uuid:9c8dfd9f-88f9-4966-aff1-902067e8f327

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.04:36
Vävnadssocker: 9.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:711fb387-2723-5fb2-bb94-fb404fe41589

```

-------

Entry 625 - fullUrl = urn:uuid:ea70dcf6-5781-4ac5-9569-37b06d738e64

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.09:36
Vävnadssocker: 9.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7d393372-3bef-5a2a-94eb-029c31fc62fd

```

-------

Entry 626 - fullUrl = urn:uuid:6ad40dbd-11b4-4d93-9ea7-d9b99022f085

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.14:35
Vävnadssocker: 8.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d2d93fa6-5d9e-56f6-923a-78952369ac4d

```

-------

Entry 627 - fullUrl = urn:uuid:5db25538-3f77-4792-8175-b16452f0cb09

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.19:30
Vävnadssocker: 8.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:64edf877-1e79-51eb-9dad-70d0b3ae7d54

```

-------

Entry 628 - fullUrl = urn:uuid:6059b5af-1c62-4cda-8378-3d379a69173b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.24:30
Vävnadssocker: 8.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6f79c169-aee6-53f5-a99b-8eab6a0eab47

```

-------

Entry 629 - fullUrl = urn:uuid:f3dca51f-ece9-4a84-9751-b42c076b6cef

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.27:40 - 03.32:39
Direktverkande insulin 0.07 IE (0.82 IE/t, 1.10 % = 0.91 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:44c53b6a-367b-59d2-a773-3611fe28bde8

```

-------

Entry 630 - fullUrl = urn:uuid:b4d71fdc-2ff7-4868-8ec3-055919a004bd

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.29:30
Vävnadssocker: 8.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4177ce00-b82e-5601-891f-bd86ece2ea39

```

-------

Entry 631 - fullUrl = urn:uuid:656aa40b-9a63-477b-bdcb-4b3fe983813d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.32:39 - 03.37:40
Direktverkande insulin 0.08 IE (0.95 IE/t, 1.26 % = 1.20 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0ff15aa6-ca6b-5d19-84a2-91c1ab4a056f

```

-------

Entry 632 - fullUrl = urn:uuid:70214ed1-580d-4451-ae53-532170c48d91

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.34:30
Vävnadssocker: 8.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f17e91f4-b7f9-5742-afd1-639a1c513dad

```

-------

Entry 633 - fullUrl = urn:uuid:4a6fb713-277f-4b30-8d3c-50e385b85543

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.37:40 - 03.42:41
Direktverkande insulin 0.06 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:40a2a427-8e95-57fc-9e01-584ac51a7c83

```

-------

Entry 634 - fullUrl = urn:uuid:de1c7d77-2e82-47f9-9045-c7f24c7b5fce

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.39:30
Vävnadssocker: 8.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ce50941d-7f0f-503a-b974-47acfa57d9ba

```

-------

Entry 635 - fullUrl = urn:uuid:edf5ce83-d5c4-4769-8023-1fbc58bac082

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.42:41 - 03.47:41
Direktverkande insulin 0.07 IE (0.81 IE/t, 1.08 % = 0.87 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:73b75d9e-45d3-56e7-a64e-ba4689802a11

```

-------

Entry 636 - fullUrl = urn:uuid:96e9bd07-da5a-4e55-a66d-71d1b0b3e64e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.44:30
Vävnadssocker: 8.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc6c214d-3cde-57e8-a590-c871800690c8

```

-------

Entry 637 - fullUrl = urn:uuid:8bd1133e-57ca-4826-9f74-e0eba69066a8

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.47:41 - 03.52:42
Direktverkande insulin 0.07 IE (0.87 IE/t, 1.15 % = 1.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e16864a8-a208-55b5-aea9-d05443faa15e

```

-------

Entry 638 - fullUrl = urn:uuid:b7f8e56a-89dc-42a6-9185-c40953e7af2f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.49:30
Vävnadssocker: 8.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2ab8b864-d62e-50df-bea6-51f46e9c891b

```

-------

Entry 639 - fullUrl = urn:uuid:31da963b-df2a-4951-bee6-08b872b7ffcb

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.52:42 - 03.57:43
Direktverkande insulin 0.07 IE (0.85 IE/t, 1.13 % = 0.96 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c6681cc8-d508-5f91-b1e0-4517e6f9425b

```

-------

Entry 640 - fullUrl = urn:uuid:3264ff9b-709c-43db-a029-fb425f70e919

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.54:30
Vävnadssocker: 7.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:117dd9fb-c29e-590a-9457-b7530148171b

```

-------

Entry 641 - fullUrl = urn:uuid:d9b1c23e-06df-418f-89ef-b9f7b22870d9

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 03.57:43 - 04.17:48
Direktverkande insulin 0.25 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:281e66b9-8209-51ec-a3a7-58e2718cf5b6

```

-------

Entry 642 - fullUrl = urn:uuid:0fb0f780-23c9-4dff-8fd4-84e8f34a0f4b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 03.59:30
Vävnadssocker: 7.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bd82f873-452f-5c05-98e5-72a9066c4cd5

```

-------

Entry 643 - fullUrl = urn:uuid:b08dcdb4-69e7-4ba1-9e23-332a7cd5c3dc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.04:31
Vävnadssocker: 7.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2a7c61a2-7018-5984-b28d-d552b79051cb

```

-------

Entry 644 - fullUrl = urn:uuid:1357de10-7cbb-4b2a-97a4-92f4592c1e97

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.09:30
Vävnadssocker: 7.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4cb86812-cd73-5488-a794-94b9c4de6bcb

```

-------

Entry 645 - fullUrl = urn:uuid:ba26f922-3239-41e2-b4c5-896c83f85e7b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.14:30
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ae5babda-b426-5402-88b6-dc07c8211d8b

```

-------

Entry 646 - fullUrl = urn:uuid:293a19af-9eaf-407d-bd8e-b1eebc521e3e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 04.17:48 - 04.22:48
Direktverkande insulin 0.10 IE (1.17 IE/t, 1.57 % = 1.84 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8b27fa17-d242-594f-bdca-d352c5e50b8c

```

-------

Entry 647 - fullUrl = urn:uuid:1f42ec8b-a90f-4a15-84be-52f0fba8f804

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.19:30
Vävnadssocker: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7f5319ff-7794-5a03-8b8a-6f2e521a0665

```

-------

Entry 648 - fullUrl = urn:uuid:2eaba6b1-f7a7-4430-9ca5-e5d8650350c8

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 04.22:48 - 04.27:48
Direktverkande insulin 0.10 IE (1.16 IE/t, 1.55 % = 1.81 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fb217580-113f-54b9-9a47-5afad144a599

```

-------

Entry 649 - fullUrl = urn:uuid:27326df4-e2e3-4ff3-88f5-e81ab0ea9ee5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.24:30
Vävnadssocker: 7.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:68012d5b-c398-56e2-b1fe-c6cad06e6a1a

```

-------

Entry 650 - fullUrl = urn:uuid:ca9216ab-7974-4e19-bf42-0512cd24807f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 04.27:48 - 04.32:49
Direktverkande insulin 0.06 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d9bbd5bd-384d-5aee-bf64-28ad5468fd80

```

-------

Entry 651 - fullUrl = urn:uuid:97cb8d1f-8bdd-4ae1-bbac-e4707bcb00a3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.29:32
Vävnadssocker: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c8caffb-fb71-5b79-bcd0-997807ec39a4

```

-------

Entry 652 - fullUrl = urn:uuid:ab995fe3-6f84-4fc2-8b7b-529135b59c07

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 04.32:49 - 04.37:50
Direktverkande insulin 0.04 IE (0.42 IE/t, 0.56 % = 0.24 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d4eb22fd-a645-5707-9cd1-0275689bade9

```

-------

Entry 653 - fullUrl = urn:uuid:fa091104-baa3-4f97-b2b2-2c77416de40d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.34:31
Vävnadssocker: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4ffd699d-4f2b-5a6c-bf9a-8eb33da539c2

```

-------

Entry 654 - fullUrl = urn:uuid:0bdf49f3-853a-470c-9a10-854bc954b34e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 04.37:50 - 05.12:55
Direktverkande insulin 0.44 IE (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f5c46ed0-e981-5c36-ba4a-3678d3c8191b

```

-------

Entry 655 - fullUrl = urn:uuid:d36e3fe3-f4ba-4c98-92cd-07962c9360b2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.39:31
Vävnadssocker: 7.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ec9b418d-9469-5a6d-b3b6-305c73d61108

```

-------

Entry 656 - fullUrl = urn:uuid:83b5e31b-905d-4023-a421-6e18bc77bbba

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.44:31
Vävnadssocker: 7.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8eb80259-1012-5282-902e-0fa447b0cc6a

```

-------

Entry 657 - fullUrl = urn:uuid:ef47d416-0675-4ce7-9175-6426e6d4470d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.49:32
Vävnadssocker: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:05ee96ea-5a92-52a7-b4a5-e8e022053de4

```

-------

Entry 658 - fullUrl = urn:uuid:b3894fa1-5a87-4693-bbcd-df8d25fe7b9f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.54:30
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b653dd35-bd68-5819-a4b4-fc94ab69e204

```

-------

Entry 659 - fullUrl = urn:uuid:cfb7f1e6-e349-4a75-a7c4-bde8f155e22a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 04.59:30
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d8f9171f-04d4-5455-871f-b7d7fe0bead9

```

-------

Entry 660 - fullUrl = urn:uuid:f99638f0-25aa-4045-84fd-a99b74325cd7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.04:29
Vävnadssocker: 6.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1532850e-acc1-5b8a-9b3d-bec866a28c2e

```

-------

Entry 661 - fullUrl = urn:uuid:55c4a8ad-78c4-477f-a0b5-ce0e988d360a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.09:29
Vävnadssocker: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d304cc9c-b5da-582f-b3a4-746b9677d453

```

-------

Entry 662 - fullUrl = urn:uuid:972064c0-13c6-4cb2-b06a-9f932cc68183

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.12:55 - 05.17:55
Direktverkande insulin 0.03 IE (0.34 IE/t, 0.46 % = 0.16 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e1a987fa-c6a4-596f-b3ab-3af5eae34c5c

```

-------

Entry 663 - fullUrl = urn:uuid:c0140f9d-ca8b-439e-90b5-c02b4af22936

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.14:29
Vävnadssocker: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d61f984b-8d13-5eb0-9016-bd17e118c43b

```

-------

Entry 664 - fullUrl = urn:uuid:a5ac9bd5-97e6-4354-95f2-57e0b91cef3b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.17:55 - 05.22:56
Direktverkande insulin 0.03 IE (0.37 IE/t, 0.49 % = 0.18 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:08b2772d-929e-571d-b93b-5bdd884c5cbc

```

-------

Entry 665 - fullUrl = urn:uuid:8eea4ab2-80f7-4a73-9509-15ae7012eecf

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.19:29
Vävnadssocker: 6.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:25de420b-b535-5fad-a6f9-6a9dd5507f7b

```

-------

Entry 666 - fullUrl = urn:uuid:1c7d07e1-97dd-4c63-8734-f8a4d131f647

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.22:56 - 05.27:56
Direktverkande insulin 0.03 IE (0.32 IE/t, 0.42 % = 0.13 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3edb0d54-e3be-57ce-b983-8adb3ba8bb1f

```

-------

Entry 667 - fullUrl = urn:uuid:08b0c208-2abc-4899-b478-e68829e28363

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.24:30
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c834d9e6-8ae7-58b1-83f7-a73fbe21d1f6

```

-------

Entry 668 - fullUrl = urn:uuid:89c8cb41-11b2-43bc-b250-b5082d44d274

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.27:56 - 05.32:58
Direktverkande insulin 0.03 IE (0.37 IE/t, 0.49 % = 0.18 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:443e0ac5-5d3f-56b9-bf73-b3acc618f4ab

```

-------

Entry 669 - fullUrl = urn:uuid:3d3e97ce-9896-4873-810f-56aea484290a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.29:29
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8a5f0de-7dfd-5c59-8a41-1c8c08b52856

```

-------

Entry 670 - fullUrl = urn:uuid:b4330b2a-b194-4053-92ae-db0469cbdf51

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.32:58 - 05.37:58
Direktverkande insulin 0.05 IE (0.60 IE/t, 0.70 % = 0.42 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d7a33191-cf0e-5a64-b533-fdf55e46e9fb

```

-------

Entry 671 - fullUrl = urn:uuid:af2d84cd-3228-4743-83b8-df95960cab90

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.34:29
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:17df91be-9834-5c3f-9e86-5a9104c433bc

```

-------

Entry 672 - fullUrl = urn:uuid:061db6ee-3559-48dd-a03a-88ebd3750899

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.37:58 - 05.43:00
Direktverkande insulin 0.06 IE (0.75 IE/t, 0.88 % = 0.66 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8f49226a-3758-5f37-ad33-0a1baabdbc48

```

-------

Entry 673 - fullUrl = urn:uuid:8ba76f50-1583-481f-8907-959cad27ffac

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.39:29
Vävnadssocker: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:03dd788e-b8fd-57fa-879b-e62a720879d9

```

-------

Entry 674 - fullUrl = urn:uuid:90269973-dbd0-4c98-befe-4863e6f5154c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.43:00 - 05.48:01
Direktverkande insulin 0.06 IE (0.72 IE/t, 0.85 % = 0.61 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a552a0f3-2155-5092-b585-28f7726db1e7

```

-------

Entry 675 - fullUrl = urn:uuid:8233cdb5-a7dc-42ef-831a-1b1458d3bb95

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.44:30
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0f9281ba-4a4f-5ca8-8de1-4e936b2220ff

```

-------

Entry 676 - fullUrl = urn:uuid:c10459dd-cdc4-459d-8dc0-55ab928515e4

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.48:01 - 05.53:01
Direktverkande insulin 0.05 IE (0.63 IE/t, 0.74 % = 0.47 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e7213fe8-0223-5d4a-bc65-738519b43f13

```

-------

Entry 677 - fullUrl = urn:uuid:1c675f46-188d-417b-b258-f886e2e447b4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.49:29
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0e08d7b0-5cd4-5b42-9030-e7dd885ad37c

```

-------

Entry 678 - fullUrl = urn:uuid:e85b0071-e894-47df-8f6a-26f78baed0fc

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.53:01 - 05.58:01
Direktverkande insulin 0.05 IE (0.54 IE/t, 0.64 % = 0.34 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3223bd71-0c36-5647-a178-8fb43538286c

```

-------

Entry 679 - fullUrl = urn:uuid:9a769d58-ddf4-4f77-b475-35349d84b295

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.54:29
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dffb8f52-129b-5f1b-aab0-f2b981bf5ae3

```

-------

Entry 680 - fullUrl = urn:uuid:8ced6097-5763-4425-8179-255dcaa88595

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 05.58:01 - 06.03:02
Direktverkande insulin 0.04 IE (0.47 IE/t, 0.56 % = 0.26 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e25f24ad-4140-5128-8fd2-340ec9d0e316

```

-------

Entry 681 - fullUrl = urn:uuid:60c4e718-284f-4601-9038-b1da320014ec

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 05.59:29
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2fd7a6df-a138-566a-a235-6e00afdbfc8e

```

-------

Entry 682 - fullUrl = urn:uuid:faaeb0f8-6dfe-4b40-b882-665a0f7eaa17

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.03:02 - 06.08:03
Direktverkande insulin 0.04 IE (0.52 IE/t, 0.62 % = 0.32 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9d8ce376-4a65-59a3-9689-2b9844cff573

```

-------

Entry 683 - fullUrl = urn:uuid:6ad67b8d-2a1b-4bb1-ad9e-3dfc2b2ee804

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.04:29
Vävnadssocker: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:45adb204-479e-5c12-a32b-7500f593aade

```

-------

Entry 684 - fullUrl = urn:uuid:0e8470ff-09d0-46ee-84a7-af8ffdf6eaf2

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.08:03 - 06.13:04
Direktverkande insulin 0.04 IE (0.49 IE/t, 0.57 % = 0.28 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e1091830-5784-5980-ab81-c92ed872e626

```

-------

Entry 685 - fullUrl = urn:uuid:fd884410-a6fa-4cd4-9c2e-ff855bef5df1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.09:29
Vävnadssocker: 5.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dc5f6944-9a49-5fd9-bfaf-0d6c575656b7

```

-------

Entry 686 - fullUrl = urn:uuid:c5f1faea-b525-474f-acf2-0b0f3c40fcac

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.13:04 - 06.18:05
Direktverkande insulin 0.04 IE (0.43 IE/t, 0.50 % = 0.22 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7fae0c18-c1d6-5793-895c-8f065093c52d

```

-------

Entry 687 - fullUrl = urn:uuid:5f1bf17a-f13e-4745-b44e-9663d4f6d9fe

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.14:29
Vävnadssocker: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:06b57f60-6054-57b9-a135-e2264f2f6e8f

```

-------

Entry 688 - fullUrl = urn:uuid:4e0dc439-9ab0-460d-a98d-67df82b4cad0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.18:05 - 06.23:07
Direktverkande insulin 0.03 IE (0.38 IE/t, 0.44 % = 0.17 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fdd11335-2562-5e6e-8e5a-16b6762e5371

```

-------

Entry 689 - fullUrl = urn:uuid:3594e38c-728b-495e-81e5-a334090dd8a5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.19:29
Vävnadssocker: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f0952b6d-a6cf-5693-a24f-60d435855c1b

```

-------

Entry 690 - fullUrl = urn:uuid:f4cabb08-f2c6-4f51-aed6-2d6bde223485

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.23:07 - 06.28:07
Direktverkande insulin 0.05 IE (0.62 IE/t, 0.73 % = 0.45 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:984ba5ed-197e-5fd2-81a9-88823e134d00

```

-------

Entry 691 - fullUrl = urn:uuid:c3d450f6-be90-4714-8ba7-6e4a71195e56

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.24:29
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3d4b6c92-60d5-598e-bca9-a336ce6f5c2d

```

-------

Entry 692 - fullUrl = urn:uuid:2eeb13b3-8b92-44fb-a074-fe2b44eeb372

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.28:07 - 06.33:08
Direktverkande insulin 0.07 IE (0.84 IE/t, 0.99 % = 0.84 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:db7c0b49-959d-56e2-9927-657e326a9615

```

-------

Entry 693 - fullUrl = urn:uuid:ae1445fc-9c2e-44fd-afab-f9efaf1ed212

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.29:29
Vävnadssocker: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2819d099-25d4-5c64-8ad8-aef4d9b70980

```

-------

Entry 694 - fullUrl = urn:uuid:f070f8d3-801b-45a1-8b3c-fde8c331333b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.33:08 - 06.38:09
Direktverkande insulin 0.07 IE (0.85 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d04594f1-f152-50ab-92d9-d7c39accb2fb

```

-------

Entry 695 - fullUrl = urn:uuid:d162f157-3979-473f-9d03-b01eb3c22f92

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.34:31
Vävnadssocker: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2b8515a4-b55d-59d5-9f03-9de20028e968

```

-------

Entry 696 - fullUrl = urn:uuid:464b76e2-3ca6-4f50-8643-62d17571a7fa

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.38:09 - 06.43:09
Direktverkande insulin 0.05 IE (0.64 IE/t, 0.75 % = 0.48 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:aba0eff3-4a5b-5b90-977d-02e283dc6f1f

```

-------

Entry 697 - fullUrl = urn:uuid:9d819581-5095-45ab-87dc-6118908bbd71

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.39:29
Vävnadssocker: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a1faf212-1502-54e8-931a-bc73b9357e7e

```

-------

Entry 698 - fullUrl = urn:uuid:d35f8639-6477-41ac-964a-fc96125915ae

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.43:09 - 06.48:11
Direktverkande insulin 0.03 IE (0.34 IE/t, 0.40 % = 0.13 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dfe887f7-55ac-5b98-9f51-79e6a852d7b9

```

-------

Entry 699 - fullUrl = urn:uuid:75768ad0-8808-4b8a-bccb-3ad325511318

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.44:29
Vävnadssocker: 5.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:75860c6a-c8fe-5d21-9028-c0f2b6917542

```

-------

Entry 700 - fullUrl = urn:uuid:c81d6c09-4546-4113-a675-ba4280ab08fb

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.48:11 - 06.53:11
Direktverkande insulin 0.03 IE (0.41 IE/t, 0.48 % = 0.19 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c0605d1d-9231-593e-98a4-8c819e5d8dd4

```

-------

Entry 701 - fullUrl = urn:uuid:aba85078-c6ad-4807-b17f-f3a865a2b209

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.49:31
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:da6b8536-c36a-5898-853b-4edf1bfaf247

```

-------

Entry 702 - fullUrl = urn:uuid:ed370fb9-fd28-497b-917a-7d95be72d418

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.53:11 - 06.58:13
Direktverkande insulin 0.06 IE (0.71 IE/t, 0.84 % = 0.59 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0928074c-18b3-5d39-9b0c-82c455969918

```

-------

Entry 703 - fullUrl = urn:uuid:81eed2fc-7ae8-4b0a-9ae6-9348c6e6ad91

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.53:48
Direktverkande insulin 7.38 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:21631fe2-1563-50c2-9697-266c2c404895

```

-------

Entry 704 - fullUrl = urn:uuid:8ad5e0c3-a5bc-4f97-818b-16de9bcdce57

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 6.9.2021 06.53:48
Beräknad mängd kolhydratintag: 75 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:141fe178-e614-5565-b075-ff9679d946d8

```

-------

Entry 705 - fullUrl = urn:uuid:86a0726c-3aa1-465b-9ba3-b7ba08bbdb70

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.54:31
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:86fb583e-0d26-5872-98b7-2fc0d11ca2fe

```

-------

Entry 706 - fullUrl = urn:uuid:1fffb37d-29d4-4e58-bf69-08131ee71873

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 06.58:13 - 07.03:14
Direktverkande insulin 0.07 IE (0.84 IE/t, 0.99 % = 0.83 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0216c1c8-eb1b-59e2-99de-4604c9f49aff

```

-------

Entry 707 - fullUrl = urn:uuid:d1c388b3-34e7-45f6-9495-7f8b3d708f66

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 06.59:31
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c2a0b5fe-2b19-50e7-91a6-ca2ee2d3b3c7

```

-------

Entry 708 - fullUrl = urn:uuid:96421d7b-939e-4ca7-8a24-529c830969f2

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 07.03:14 - 07.28:18
Direktverkande insulin 0.40 IE (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:19f0cecb-e61e-592d-95d2-5f926f399a62

```

-------

Entry 709 - fullUrl = urn:uuid:91d33a86-3745-4cd7-8928-e2c2fc68bab8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.04:29
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d16ab617-2252-5402-87e8-abce999136ec

```

-------

Entry 710 - fullUrl = urn:uuid:ee6d22f2-b441-4dda-a6e8-0b803e18eeec

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.09:31
Vävnadssocker: 6.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fff31267-11f9-5557-93aa-626a96a9269f

```

-------

Entry 711 - fullUrl = urn:uuid:281d39a7-4455-46ee-8943-357d53bbba69

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.14:29
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:55e5f618-d888-5137-99e9-f819d6cbc8ac

```

-------

Entry 712 - fullUrl = urn:uuid:476453da-9002-41a2-b673-4306fcff7ee9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.19:29
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3194cba9-aaa2-5474-9dff-eaee8145eaed

```

-------

Entry 713 - fullUrl = urn:uuid:23429158-380c-4276-a65d-603a395093f8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.24:29
Vävnadssocker: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:090c7458-accd-5c4a-8cd1-4bbb68e99e7b

```

-------

Entry 714 - fullUrl = urn:uuid:9215fd14-bd31-4a36-89c0-12ab7be45fbe

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 07.28:18 - 07.33:18
Direktverkande insulin 0.08 IE (0.95 IE/t, 1.00 % = 0.94 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dc748b31-089c-56a5-9c44-6818616db629

```

-------

Entry 715 - fullUrl = urn:uuid:db626bba-8039-43af-b68b-deed0285b48d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.29:29
Vävnadssocker: 6.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a62ff16d-6bd1-5435-a5fc-6e1a3c91a7f4

```

-------

Entry 716 - fullUrl = urn:uuid:cbe8fb5e-0928-47a2-bca1-79507264daf0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 07.33:18 - 08.28:28
Direktverkande insulin 0.87 IE (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8f62170a-b7df-523f-b885-dfbf70934a27

```

-------

Entry 717 - fullUrl = urn:uuid:20cda9f4-0859-4acc-9184-ddf790db82ea

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.34:31
Vävnadssocker: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3860cf22-406b-521a-90ac-21f1d45ed0b7

```

-------

Entry 718 - fullUrl = urn:uuid:3963dbcb-5a81-4089-ad34-7b599a4a8a60

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.39:30
Vävnadssocker: 7.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:31273893-0d71-5bf5-9dcf-00a4fead0153

```

-------

Entry 719 - fullUrl = urn:uuid:5d38a691-780c-4cb4-a84a-97a2d26432df

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.44:29
Vävnadssocker: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3d1802a1-141a-52c3-a3d6-00a26eb77b01

```

-------

Entry 720 - fullUrl = urn:uuid:36db6d4c-4e26-48b2-b421-86f34ab7f3db

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.49:29
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c116e0c3-ae6d-58af-b447-e8d3c2afd5a9

```

-------

Entry 721 - fullUrl = urn:uuid:1c4f11f2-9b2a-4086-b884-438b089d65ce

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.54:29
Vävnadssocker: 8.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:295a9bab-8228-58be-90fd-bcc937b8942a

```

-------

Entry 722 - fullUrl = urn:uuid:240a47bc-3cf7-4d52-9294-cf33ea406dde

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 07.59:29
Vävnadssocker: 8.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:92604d9c-db6e-5b57-9eb9-88e3e2f5f4db

```

-------

Entry 723 - fullUrl = urn:uuid:adba5900-21f5-4295-a578-f2f7203a7892

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.04:29
Vävnadssocker: 7.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:343bd434-5348-5ff4-a504-f2bdf762a857

```

-------

Entry 724 - fullUrl = urn:uuid:c6411eaf-02ca-4e85-8bf4-9a712c85177c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.09:30
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2c8e827-ad4e-53d3-aa99-c8a88591fd89

```

-------

Entry 725 - fullUrl = urn:uuid:62078d0c-f65d-4d66-833a-ea378470aae2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.14:31
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f19f1d24-0a99-5ea0-9c32-d9edcbcf5afe

```

-------

Entry 726 - fullUrl = urn:uuid:55da9875-5108-4f4d-a772-29dc406d0a57

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.19:29
Vävnadssocker: 7.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:15cfc39a-8340-5766-92d5-88d3f0ad7780

```

-------

Entry 727 - fullUrl = urn:uuid:3d055dc1-8513-4164-89ec-1744d62dbd8f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.24:29
Vävnadssocker: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dfc0941e-73bb-57e6-82c7-1a292646145c

```

-------

Entry 728 - fullUrl = urn:uuid:bd3be3e0-c95d-465b-95bc-e9d6baeadf43

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 08.28:28 - 08.33:28
Direktverkande insulin 0.08 IE (0.94 IE/t, 0.99 % = 0.94 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:89ba3b4e-cb73-5a44-9573-90392a25a50b

```

-------

Entry 729 - fullUrl = urn:uuid:1d8b3ce8-4420-478d-8eb9-1697f0695f23

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.29:29
Vävnadssocker: 6.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:12e0c121-d186-55dd-9b00-e9ef384fc5cd

```

-------

Entry 730 - fullUrl = urn:uuid:ceac471c-8953-48e3-b86e-cb2d390c0672

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 08.33:28 - 08.38:28
Direktverkande insulin 0.02 IE (0.20 IE/t, 0.21 % = 0.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2c92898d-e1a1-5674-a73f-7674f7e271f9

```

-------

Entry 731 - fullUrl = urn:uuid:15fd009e-b6a4-47e4-8250-56845ee7600c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.34:29
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dadbeb54-c220-5823-a67b-109b2f78a4a3

```

-------

Entry 732 - fullUrl = urn:uuid:65330991-cfb6-496a-b0d2-9b80c7e2ec86

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 08.38:28 - 09.03:33
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:81675269-0f79-5f25-8253-c3738d6c81a5

```

-------

Entry 733 - fullUrl = urn:uuid:c9d91526-841a-4c7b-9b30-cf9635b568f0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.39:29
Vävnadssocker: 5.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1d2a5f0e-4e58-5413-8c15-627fcef82115

```

-------

Entry 734 - fullUrl = urn:uuid:89ae6abc-4d5c-4051-a531-ac191a947a38

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.44:29
Vävnadssocker: 4.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:83c48062-fa02-56ce-a183-9355c8748487

```

-------

Entry 735 - fullUrl = urn:uuid:bfc0ec82-2433-4ad1-95cc-cb264cb59dd3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.49:30
Vävnadssocker: 4.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:14d720a9-9165-5d13-8313-dfcd5139258f

```

-------

Entry 736 - fullUrl = urn:uuid:8851f184-cf94-4d5e-ae1d-56cc517e847d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.54:29
Vävnadssocker: 5.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2c2613c2-8c22-5fcc-b689-a95995afb6f6

```

-------

Entry 737 - fullUrl = urn:uuid:f2e97175-9e4e-450c-9296-66821423250a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 08.59:29
Vävnadssocker: 5.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:696513c9-ae4e-5e56-91c9-513bd01f27e3

```

-------

Entry 738 - fullUrl = urn:uuid:321db36d-8488-40cc-bb57-d51979bf209a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.03:33 - 09.08:33
Direktverkande insulin 0.01 IE (0.14 IE/t, 0.20 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1871edb7-fa5b-5931-8ba8-e51f70de6686

```

-------

Entry 739 - fullUrl = urn:uuid:0a406cad-7c0f-4d0d-aa16-9b198218cbc9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.04:29
Vävnadssocker: 5.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8ede4fb-fcea-58bc-9e1d-32c0cc3e89a8

```

-------

Entry 740 - fullUrl = urn:uuid:51e26199-a92a-4bf9-8c56-44408d4ec86e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.08:33 - 09.13:34
Direktverkande insulin 0.06 IE (0.66 IE/t, 0.95 % = 0.63 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fcc8f652-d6d4-5645-864b-a7cb04226402

```

-------

Entry 741 - fullUrl = urn:uuid:753eed73-8018-423d-813e-8e4f702f8977

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.09:29
Vävnadssocker: 6.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3f4ac64b-4d53-5b62-b11e-8eba9fa8cb59

```

-------

Entry 742 - fullUrl = urn:uuid:c474ddb5-873b-403d-a79d-2f70d40851b7

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.13:34 - 09.18:35
Direktverkande insulin 0.06 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e9eeff1d-aa50-52b8-a15b-1ee49e6260fc

```

-------

Entry 743 - fullUrl = urn:uuid:f25d20e4-91b5-4899-bab0-94fdad1eaacc

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.14:29
Vävnadssocker: 7.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8eca8611-adc3-5e4d-be94-89da906c73dc

```

-------

Entry 744 - fullUrl = urn:uuid:1edb6d9c-4e35-429e-91fa-42e2422e2554

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.18:35 - 09.23:36
Direktverkande insulin 0.09 IE (1.06 IE/t, 1.52 % = 1.61 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:14633c0f-fa74-5891-aab4-e61e81902781

```

-------

Entry 745 - fullUrl = urn:uuid:8cfbea01-fb27-4ebf-894f-1484bc6a2fe1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.19:31
Vävnadssocker: 7.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ac71da75-fca2-5cca-a2f6-31a005620fad

```

-------

Entry 746 - fullUrl = urn:uuid:f2a53a85-c8f4-4070-80bd-5d0a8fa58242

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.23:36 - 09.28:36
Direktverkande insulin 0.18 IE (2.21 IE/t, 3.16 % = 6.97 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d5253230-4361-5c07-9153-ae652e99c71c

```

-------

Entry 747 - fullUrl = urn:uuid:eb5f32e3-2786-4678-a19b-1df7615b753b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.23:50
Direktverkande insulin 1.62 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a012b9cf-b910-5aec-86ff-04682fe23341

```

-------

Entry 748 - fullUrl = urn:uuid:5a6da7fc-d488-4516-a85f-1c42c2a51c0c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.24:31
Vävnadssocker: 7.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8d513d58-3f5d-5284-be9a-9875f9278829

```

-------

Entry 749 - fullUrl = urn:uuid:e78fea2e-487c-43de-9e82-58787e8e55a9

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.28:36 - 09.58:40
Direktverkande insulin 0.35 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1f298579-b85a-5507-ad09-bb68a2f86d4a

```

-------

Entry 750 - fullUrl = urn:uuid:0ca76b28-7cc5-4103-a850-5d801a765713

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.29:29
Vävnadssocker: 8.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0c54d2a7-fee0-566a-8b1c-6eebc212ecd9

```

-------

Entry 751 - fullUrl = urn:uuid:39b371c8-8a02-4847-9cfb-d964f354984f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.34:29
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1d6e424f-2b86-504f-90f7-fce167d931ce

```

-------

Entry 752 - fullUrl = urn:uuid:73d8069a-8085-48d2-900c-5b1e4cd6d9c7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.39:29
Vävnadssocker: 7.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:95849caf-53fa-5f1e-a419-253b7ec6e746

```

-------

Entry 753 - fullUrl = urn:uuid:e961e1e3-c7c5-483a-9168-425d535dc3cb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.44:29
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eee2f68a-f90f-5f04-a40e-ab6e9d615ad5

```

-------

Entry 754 - fullUrl = urn:uuid:98428130-0320-4d22-bada-25dde3e63aeb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.49:29
Vävnadssocker: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c15b05c-a320-5f8b-b320-524b9c9d2804

```

-------

Entry 755 - fullUrl = urn:uuid:eea8b4ba-a28d-48ea-9fa6-2eb1a363b338

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.54:29
Vävnadssocker: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b95809ea-2c12-5781-b60f-fcb854815c70

```

-------

Entry 756 - fullUrl = urn:uuid:dee3e900-04d7-4b81-9241-2683ec6eadec

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 09.58:40 - 10.03:43
Direktverkande insulin 0.05 IE (0.64 IE/t, 0.91 % = 0.59 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:174db018-0ee5-5484-abb3-8c8f32101880

```

-------

Entry 757 - fullUrl = urn:uuid:bba47a60-9ac8-41a0-aa0e-a8335ad32567

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 09.59:29
Vävnadssocker: 7.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1eb9770-1f37-5da8-8f04-76f1ff2fff01

```

-------

Entry 758 - fullUrl = urn:uuid:146be013-952d-4770-b539-5ad3666aaaa3

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.03:43 - 10.08:43
Direktverkande insulin 0.05 IE (0.63 IE/t, 0.90 % = 0.57 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dbbcb3dd-30cb-5e60-a44f-429410235b89

```

-------

Entry 759 - fullUrl = urn:uuid:3c410245-3d19-4b74-b055-66ac17fd700c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.04:29
Vävnadssocker: 7.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:68b8b984-8afc-5405-9f9f-51b860898ee9

```

-------

Entry 760 - fullUrl = urn:uuid:1053b5af-7b23-4ce7-9891-cfa30731619d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.08:43 - 10.18:44
Direktverkande insulin 0.12 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:737080f9-ed32-5f1f-8fbf-ebb45b41e48b

```

-------

Entry 761 - fullUrl = urn:uuid:3a1befeb-4f80-4a96-bcd7-db9799972f45

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.09:29
Vävnadssocker: 7.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56a061f9-f26d-5b5e-bfbf-a09409ea4e96

```

-------

Entry 762 - fullUrl = urn:uuid:ebe5c8fb-3ebd-4095-a5b4-25d16d8d18b6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.14:30
Vävnadssocker: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1ce92d0f-a345-5f35-a0e3-e8518b35c974

```

-------

Entry 763 - fullUrl = urn:uuid:16e029cd-7f29-42f4-a3df-2965e1430ce8

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.18:44 - 10.23:45
Direktverkande insulin 0.06 IE (0.68 IE/t, 0.97 % = 0.66 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ca1b01b9-86c3-56ff-a8d7-46ccc7814359

```

-------

Entry 764 - fullUrl = urn:uuid:c445bf85-a507-483e-b171-5afa1d57eb4d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.19:29
Vävnadssocker: 6.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bb02ecd2-df74-57cc-b38f-5d359004a08d

```

-------

Entry 765 - fullUrl = urn:uuid:b0b38e16-03bc-42ba-bd09-dabe006f44d3

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.23:45 - 10.28:46
Direktverkande insulin 0.05 IE (0.63 IE/t, 0.90 % = 0.57 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:63ee7c03-d38d-5aed-8f2a-6c0bb2aaa344

```

-------

Entry 766 - fullUrl = urn:uuid:2ce6cbf8-23e3-463a-b67b-760ea00fa15f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.24:29
Vävnadssocker: 6.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:43c689a4-b7df-524d-8481-3b62ca6a61f9

```

-------

Entry 767 - fullUrl = urn:uuid:50ebc9c7-eec6-417d-9494-3055436a8325

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.28:46 - 10.33:46
Direktverkande insulin 0.05 IE (0.58 IE/t, 0.83 % = 0.48 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:02f67fb7-1ae5-590f-9d8b-f58e7e6773fd

```

-------

Entry 768 - fullUrl = urn:uuid:feb3c513-6153-4999-b4eb-c9aa34a0bdf2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.29:29
Vävnadssocker: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:14fd1ff3-5f0c-544e-bd97-ab5139d31a60

```

-------

Entry 769 - fullUrl = urn:uuid:744f4240-21b9-4723-afd9-dc125e55d38c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.33:46 - 10.38:48
Direktverkande insulin 0.04 IE (0.44 IE/t, 0.62 % = 0.27 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d0a2be88-c7fc-5949-b4b1-c7a62cae5c1f

```

-------

Entry 770 - fullUrl = urn:uuid:c1e37f7e-99ef-4847-8141-e8049791a2b5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.34:32
Vävnadssocker: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9de8710c-b0ca-5bf0-bbdb-83297e18dd7b

```

-------

Entry 771 - fullUrl = urn:uuid:f869d441-2dbe-452c-8ea7-6d5f4507270b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.38:48 - 10.43:48
Direktverkande insulin 0.04 IE (0.45 IE/t, 0.64 % = 0.29 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:44241f91-3143-5340-82b4-14997e5ae82b

```

-------

Entry 772 - fullUrl = urn:uuid:44560274-6969-4673-93d5-d453b5c841c7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.39:32
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:983a7533-2384-596d-8c2d-69d9bc8c50f4

```

-------

Entry 773 - fullUrl = urn:uuid:d0327972-45d7-4daa-a4b4-13924f0ed614

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.43:48 - 10.48:49
Direktverkande insulin 0.01 IE (0.18 IE/t, 0.26 % = 0.05 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c3dd02d9-aa2b-5988-a226-58e7c2ebec6d

```

-------

Entry 774 - fullUrl = urn:uuid:f78fd004-6d20-48d2-9580-e02c88089e47

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.44:29
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc2b8b40-1e68-572b-b861-b9a1f0ae58fe

```

-------

Entry 775 - fullUrl = urn:uuid:f5ca41fe-43a6-47d8-a48e-d8cca1f63f0d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.48:49 - 10.53:51
Direktverkande insulin 0.01 IE (0.14 IE/t, 0.21 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:729250b1-f753-5c3e-bf8a-cb7d80b498ab

```

-------

Entry 776 - fullUrl = urn:uuid:5a5d289d-4223-4888-9bd3-28c353d8d404

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.49:31
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:32c52b26-f9e1-56b4-b390-b7d03ad69583

```

-------

Entry 777 - fullUrl = urn:uuid:befebbe3-d74d-42a9-9174-7e9eb53ca76f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.53:51 - 10.58:51
Direktverkande insulin 0.01 IE (0.15 IE/t, 0.21 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3e666d34-48d7-542d-bd3c-0ff3ca73b2db

```

-------

Entry 778 - fullUrl = urn:uuid:434cc8fa-d985-4f23-b4eb-cc566540cd00

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.54:31
Vävnadssocker: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:527e9847-d4d7-51db-a28f-fd9bad74d71d

```

-------

Entry 779 - fullUrl = urn:uuid:fc106e9b-dfe6-420f-a519-efedbfadef94

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 10.58:51 - 11.03:51
Direktverkande insulin 0.02 IE (0.28 IE/t, 0.40 % = 0.11 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bd73128a-e710-5a31-8595-e0b9d7702783

```

-------

Entry 780 - fullUrl = urn:uuid:1760f771-68d4-49b1-b0aa-5a30a662e101

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 10.59:29
Vävnadssocker: 5.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:591b651c-4771-5d93-b3f5-2f03f4ada538

```

-------

Entry 781 - fullUrl = urn:uuid:a0f9a20e-3fca-486f-82a2-609257bc8d48

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.03:51 - 11.08:52
Direktverkande insulin 0.02 IE (0.26 IE/t, 0.38 % = 0.10 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2e67f5b2-c1b5-52ee-b4be-40a778774cb7

```

-------

Entry 782 - fullUrl = urn:uuid:696cf09b-e292-4872-a783-ef7ae31b0c00

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.04:29
Vävnadssocker: 5.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:159a37dd-1a6b-5885-a409-fd7f14cbc6d9

```

-------

Entry 783 - fullUrl = urn:uuid:e10d5065-a6e5-41c1-bc86-86122f193128

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.08:52 - 11.13:54
Direktverkande insulin 0.01 IE (0.17 IE/t, 0.24 % = 0.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:03a5d668-39f1-5761-aa97-0be15b0ed363

```

-------

Entry 784 - fullUrl = urn:uuid:a7137643-1d86-465a-9153-64ea6124734d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.09:29
Vävnadssocker: 5.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:27bfd690-a51e-5bd0-94dd-8a360662605d

```

-------

Entry 785 - fullUrl = urn:uuid:4b884454-0510-4490-b148-a05c993843c6

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.13:54 - 11.18:54
Direktverkande insulin 0.01 IE (0.17 IE/t, 0.24 % = 0.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0f8df539-ba9c-53bb-a8e5-6c34d192adce

```

-------

Entry 786 - fullUrl = urn:uuid:6a2c3607-3a47-4fe8-a7e3-73bd8a7c1740

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.14:29
Vävnadssocker: 5.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a86c57cd-3432-5b9a-99bf-b7d57483a3e8

```

-------

Entry 787 - fullUrl = urn:uuid:68bee747-3d84-4b0b-8630-bef22bfa3e4a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.18:54 - 11.23:56
Direktverkande insulin 0.01 IE (0.13 IE/t, 0.19 % = 0.02 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c44e43b2-892b-51a5-afd7-eee06cc3db1e

```

-------

Entry 788 - fullUrl = urn:uuid:598c54a6-b695-4c6c-87b3-d453d6b71332

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.19:29
Vävnadssocker: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:48d5d4ed-a7b4-523d-8a79-ca0d98adbcc1

```

-------

Entry 789 - fullUrl = urn:uuid:3222b3ed-d49b-44fa-95b8-dcf94b04ff90

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.23:56 - 11.28:56
Direktverkande insulin 0.01 IE (0.13 IE/t, 0.19 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9e776b3b-80dc-5d57-811b-6e4f56b2d432

```

-------

Entry 790 - fullUrl = urn:uuid:34c30d0e-f2a3-4037-8db1-6654c4387597

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.24:29
Vävnadssocker: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ff41529d-eefe-54f3-92f1-b9de9ebfcc99

```

-------

Entry 791 - fullUrl = urn:uuid:314d4869-42de-4281-87ab-137a4f8d068e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.28:56 - 11.33:56
Direktverkande insulin 0.01 IE (0.15 IE/t, 0.21 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8cf92c0f-e927-5c10-bf07-60f8bddadc4b

```

-------

Entry 792 - fullUrl = urn:uuid:439ce86d-dfde-464a-be35-2590c033d992

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.29:30
Vävnadssocker: 5.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fba144c9-5b01-59b6-b0e6-f0b33d47d890

```

-------

Entry 793 - fullUrl = urn:uuid:2890732e-4e04-4500-a0dd-c6e12ade5b4e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.33:56 - 11.38:58
Direktverkande insulin 0.01 IE (0.14 IE/t, 0.21 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:68fb5cc8-00ba-570e-9fc9-6f86468b7ac3

```

-------

Entry 794 - fullUrl = urn:uuid:6e542a7b-d1c8-43f5-9999-4d24822982f0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.34:31
Vävnadssocker: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3b3c4d91-5cf1-5772-a482-a3bba64e609a

```

-------

Entry 795 - fullUrl = urn:uuid:b9a331e8-9aa5-473c-80ee-ad19fbc47c6b

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.38:58 - 11.43:58
Direktverkande insulin 0.02 IE (0.20 IE/t, 0.29 % = 0.06 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:75a44842-357e-5631-9ebb-1a70b1a77c79

```

-------

Entry 796 - fullUrl = urn:uuid:0a677f78-2cb9-40d9-8008-b6a38f67d7f9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.39:28
Vävnadssocker: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0108f8d9-4766-5de5-b846-731277a1b824

```

-------

Entry 797 - fullUrl = urn:uuid:9bcde3e8-314b-47bb-8a95-fafb02a0b337

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.43:58 - 11.48:59
Direktverkande insulin 0.02 IE (0.24 IE/t, 0.34 % = 0.08 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:78b34a26-b906-50f8-a21f-1b8a0e0b8867

```

-------

Entry 798 - fullUrl = urn:uuid:246935a7-82d3-450d-8e95-c22031281150

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.44:29
Vävnadssocker: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c316b00-2288-5eb6-8ad3-a4b894105a99

```

-------

Entry 799 - fullUrl = urn:uuid:ab339f5f-da62-4e34-acfd-9df8bec2e36c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.48:59 - 11.53:59
Direktverkande insulin 0.03 IE (0.31 IE/t, 0.44 % = 0.14 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e848913a-c925-505c-9540-3e219bdb2a87

```

-------

Entry 800 - fullUrl = urn:uuid:0c1d30ae-f6d6-4b9f-9d7a-b62cf07c9c6d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.49:31
Vävnadssocker: 5.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e2ffb15e-5325-545f-970b-4431f2c369b4

```

-------

Entry 801 - fullUrl = urn:uuid:ebe701c5-fc33-4470-bf85-72b2d7f6d930

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.53:59 - 11.59:01
Direktverkande insulin 0.05 IE (0.56 IE/t, 0.81 % = 0.45 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:471aca9d-8d27-5a1c-8e90-fd2e9aed8f72

```

-------

Entry 802 - fullUrl = urn:uuid:eebe5de6-2534-44f2-8786-0d44d320f27f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.54:29
Vävnadssocker: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:df18b34a-5094-5d3d-9407-486e71e3ccf0

```

-------

Entry 803 - fullUrl = urn:uuid:95016af0-5532-4e87-967a-36d1832d7bac

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 11.59:01 - 13.29:15
Direktverkande insulin 1.05 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fe826b84-d1a1-56fd-a3b2-c6ad37edfe39

```

-------

Entry 804 - fullUrl = urn:uuid:d357ff78-fffd-40aa-aa79-2bc4ed465854

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 11.59:29
Vävnadssocker: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:21dbed49-14dc-54cf-bebf-02bedf5627ce

```

-------

Entry 805 - fullUrl = urn:uuid:d1a2561a-e57b-485f-ae4f-b5cd76761fc6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.04:29
Vävnadssocker: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:da7a0d8e-b401-553c-bd08-42994da74dd4

```

-------

Entry 806 - fullUrl = urn:uuid:fa2d8e34-f5b1-4ce9-b57c-d7c50fe81e36

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.09:28
Vävnadssocker: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:53362eaa-97a1-5396-acfb-0b1b7a84841b

```

-------

Entry 807 - fullUrl = urn:uuid:1fa0ef1c-3faf-4dd8-8466-a053ea4a555d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.14:28
Vävnadssocker: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ff13cc8e-0f8f-5f5d-a653-d0f36763d2b3

```

-------

Entry 808 - fullUrl = urn:uuid:6f6ae2c5-73ff-40cc-852e-6719c1263ed2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.19:29
Vävnadssocker: 6.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0b223614-db4a-5795-8cbd-47c3cab93945

```

-------

Entry 809 - fullUrl = urn:uuid:b31c9bd6-a065-4613-a0bb-474007841070

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.24:28
Vävnadssocker: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:48c7fd24-e5bb-5554-b102-473da0619e03

```

-------

Entry 810 - fullUrl = urn:uuid:ab15d871-1c90-4310-bfe1-8c6b539b826b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.29:29
Vävnadssocker: 7.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:87e6f8c5-abd0-57d7-a19b-970ba1fee2af

```

-------

Entry 811 - fullUrl = urn:uuid:b1933595-cb68-4d37-ad8f-bbfe83f48166

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.34:29
Vävnadssocker: 7.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6165bcce-f6b8-5251-aa17-161441af864a

```

-------

Entry 812 - fullUrl = urn:uuid:ac30a49b-826c-449f-8863-cd883e197922

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.39:29
Vävnadssocker: 7.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e1c210cd-719f-5bca-870c-1a33a7aae4a8

```

-------

Entry 813 - fullUrl = urn:uuid:81ac85f4-ccaf-43e6-8800-9d6d9deeba76

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.44:29
Vävnadssocker: 7.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5e07378c-542a-5702-ae26-de5ea102b0cd

```

-------

Entry 814 - fullUrl = urn:uuid:10264260-e21a-4837-8db8-f41e19f8fbd7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.49:29
Vävnadssocker: 7.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:32eebcc6-8eab-5e37-ae61-00a09461bb9a

```

-------

Entry 815 - fullUrl = urn:uuid:fa119025-154c-4dc0-92af-66909e857042

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.54:29
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b9c35d5b-7900-5a74-ad8f-3b437785385c

```

-------

Entry 816 - fullUrl = urn:uuid:0d0687cb-4f54-4755-9e07-8bf11bd80302

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 12.59:28
Vävnadssocker: 7.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:272a9908-1a86-5f14-861f-f42e0d87ba29

```

-------

Entry 817 - fullUrl = urn:uuid:f5d191a9-d3b1-425a-81f0-d8d002a90e08

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.04:28
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c08f8999-10ce-5a1b-9f11-debdc4e53d74

```

-------

Entry 818 - fullUrl = urn:uuid:d4a2297b-3259-4d06-9842-7ed9a65c69c0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.09:29
Vävnadssocker: 8.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:18664c59-9d0f-5154-a46c-4e0bc50dfe91

```

-------

Entry 819 - fullUrl = urn:uuid:35d00f4e-1333-4a93-9672-a3f996482004

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.14:28
Vävnadssocker: 8.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:66f119db-75f2-50c9-915b-046d76eeb718

```

-------

Entry 820 - fullUrl = urn:uuid:dae084cd-70bc-4067-9389-9796664a85ae

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.19:29
Vävnadssocker: 8.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:407e081c-b888-5f82-833d-c772c230d7cf

```

-------

Entry 821 - fullUrl = urn:uuid:49a0a7fc-d83a-4558-93b0-3e346205b924

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.24:29
Vävnadssocker: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b0adf6df-927f-5c55-846e-dd91292c3265

```

-------

Entry 822 - fullUrl = urn:uuid:78799fb4-acfb-44c9-84c2-071916727ecb

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 13.29:15 - 13.34:16
Direktverkande insulin 0.06 IE (0.78 IE/t, 1.11 % = 0.86 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:26826659-a23d-5d17-ad2b-1ce53a7fd7df

```

-------

Entry 823 - fullUrl = urn:uuid:69677e94-7a4d-40c3-8250-5b4200c5f788

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.29:29
Vävnadssocker: 8.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bb8acd23-dcdb-5a1d-adb1-a9e050f10823

```

-------

Entry 824 - fullUrl = urn:uuid:2792a29b-401a-48dc-90d6-23257908a051

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 13.34:16 - 13.39:16
Direktverkande insulin 0.08 IE (1.00 IE/t, 1.43 % = 1.43 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:70ad3bf0-5ec7-59f6-b2ec-e74da5ecca27

```

-------

Entry 825 - fullUrl = urn:uuid:9ac3a6be-f262-4dfb-825b-516d4958fb07

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.34:28
Vävnadssocker: 8.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7c18c83e-338e-5b75-975b-6ba665f229e4

```

-------

Entry 826 - fullUrl = urn:uuid:a2a72aee-adfb-4d3d-97f5-0f34c7ed5bfa

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 13.39:16 - 13.44:17
Direktverkande insulin 0.09 IE (1.10 IE/t, 1.57 % = 1.72 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5c6129f1-37a0-5a87-88d5-38218ff988d3

```

-------

Entry 827 - fullUrl = urn:uuid:9082592a-a1a6-4538-8aac-d2bc939c8b28

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.39:29
Vävnadssocker: 8.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:55259972-6a7a-5db3-9a5b-9c8f6c30ca5d

```

-------

Entry 828 - fullUrl = urn:uuid:4aeae447-188b-4c79-a4b2-5d27a5511f85

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 13.44:17 - 13.50:52
Direktverkande insulin 0.13 IE (1.14 IE/t, 1.63 % = 1.86 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5c2bb2af-e0d5-568d-9c2b-da419d89ae2f

```

-------

Entry 829 - fullUrl = urn:uuid:58d2b111-0c5a-4a57-a0eb-82449c81069a

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.44:29
Vävnadssocker: 9.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cc6873ff-fc14-5c80-af5f-b0d63390e108

```

-------

Entry 830 - fullUrl = urn:uuid:abfc471c-ef97-44a3-b8a9-733c0bdeac8f

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 13.47:16
Direktverkande insulin 9.50 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3ce545fe-f681-5b18-9421-75d6b9056609

```

-------

Entry 831 - fullUrl = urn:uuid:9b891bbf-d415-4a3f-a9e1-e84ff65577bc

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 6.9.2021 13.47:16
Beräknad mängd kolhydratintag: 95 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2b91e6cc-3b41-5ab2-800a-9c28b38987d2

```

-------

Entry 832 - fullUrl = urn:uuid:c0a9be45-5a27-4375-9ff1-3226990ffe1b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.49:29
Vävnadssocker: 9.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a174ced7-6333-55c0-99b2-e32b45044df4

```

-------

Entry 833 - fullUrl = urn:uuid:600c2ef2-83d2-4626-b5fb-f9e0dfa8c378

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 13.50:52 - 13.55:51
Direktverkande insulin 0.11 IE (1.33 IE/t, 1.90 % = 2.53 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a10c9754-a3d1-5456-be05-abb49fe5d029

```

-------

Entry 834 - fullUrl = urn:uuid:f30a48c2-d2b2-464e-90a4-ddf159dd68f8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.54:30
Vävnadssocker: 9.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ec2ec958-ee15-5870-a3f3-d7e16f71c940

```

-------

Entry 835 - fullUrl = urn:uuid:b3d0128d-d863-4699-8a98-446ca2f62aff

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 13.55:51 - 15.56:11
Direktverkande insulin 1.40 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:69dc25de-3891-5095-9a3c-89858a5c4e7a

```

-------

Entry 836 - fullUrl = urn:uuid:d0aed07b-3bcc-460c-802c-5d135929b690

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 13.59:31
Vävnadssocker: 9.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2def810b-4d75-5b5b-af30-c8fe5cf94c67

```

-------

Entry 837 - fullUrl = urn:uuid:289b3bc5-cfdb-425d-81fb-4fb0b1f5c4b1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.04:28
Vävnadssocker: 9.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:61855f75-e9cf-53a2-b7f0-560b08f769bf

```

-------

Entry 838 - fullUrl = urn:uuid:91264e8c-1015-4e30-acde-bafbbeec5b7b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.09:29
Vävnadssocker: 9.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:48dbcb27-797e-505d-8c8f-028bf99ae877

```

-------

Entry 839 - fullUrl = urn:uuid:57bcaa4c-3f7f-4c28-bb7f-d4f556f09043

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.14:29
Vävnadssocker: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:61bd7706-8a16-57f8-8f05-c1917ab5feeb

```

-------

Entry 840 - fullUrl = urn:uuid:a06e23d1-7283-48c9-bdab-1be38f383c49

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.19:29
Vävnadssocker: 9.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:88f351ff-420a-5e0d-b8e7-7d6bcad78ea9

```

-------

Entry 841 - fullUrl = urn:uuid:6f46ae83-9840-4207-a86a-73c87cea64d2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.24:28
Vävnadssocker: 9.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5a54ab5e-35ba-5768-b270-05ec756ed8cd

```

-------

Entry 842 - fullUrl = urn:uuid:1515a3bd-466c-4dd5-a2ab-737ed038aa38

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.29:28
Vävnadssocker: 9.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:59f8a849-283b-539d-9b43-2d42eef6c392

```

-------

Entry 843 - fullUrl = urn:uuid:d493ac64-e699-4e25-8c72-837758d2461d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.34:28
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ec709d43-d1f0-532f-95ce-7816c9112f6b

```

-------

Entry 844 - fullUrl = urn:uuid:d9b63799-5b68-42b1-a4c1-2f4786c8b5d8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.39:28
Vävnadssocker: 9.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2bd0658b-b4dc-5d10-a0f1-21a341108cd0

```

-------

Entry 845 - fullUrl = urn:uuid:aa041bbf-4094-456e-a2ad-2b35fdecd682

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.44:28
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a2e4648b-5023-5b4e-ac8f-e17fe9a75d91

```

-------

Entry 846 - fullUrl = urn:uuid:e0c0ba09-4ca8-45ae-b113-298c8530fca0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.49:28
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:69a2eb2a-bbf3-5638-9981-139fcb45d02a

```

-------

Entry 847 - fullUrl = urn:uuid:bfaf0333-41a7-4c5e-be67-2c48f052aa2c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.54:28
Vävnadssocker: 9.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6f629814-54f1-59ce-bdb7-a20f13682fc4

```

-------

Entry 848 - fullUrl = urn:uuid:5b13fd7d-e2fb-4341-9b9f-e15fb9bdd9d9

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 14.59:28
Vävnadssocker: 9.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1fb8b5e7-c4f3-5c75-b236-368a4f76e4cf

```

-------

Entry 849 - fullUrl = urn:uuid:f484353f-5bcf-4e6f-99db-a634c4a85c87

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.04:28
Vävnadssocker: 9.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1594ad85-3c40-51a3-a14c-603b645b3a2c

```

-------

Entry 850 - fullUrl = urn:uuid:b905e53e-a1ff-4101-a3d6-5c1aba69d203

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.09:28
Vävnadssocker: 8.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ebd5705d-2367-5978-b739-251002ebf866

```

-------

Entry 851 - fullUrl = urn:uuid:91c73923-18fd-48e6-b9f4-aa084718d2f2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.14:28
Vävnadssocker: 8.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9507983b-9e8e-5698-8109-8a2a0daea857

```

-------

Entry 852 - fullUrl = urn:uuid:25339e72-3764-4148-9cd6-d6e7b6c69523

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.19:28
Vävnadssocker: 9.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c2b272d8-03e1-59f9-a1b2-8942106bc7e2

```

-------

Entry 853 - fullUrl = urn:uuid:5846eeec-033a-4c7e-b078-84779c59aa43

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.24:28
Vävnadssocker: 9.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:83338af8-ac50-5e9d-93b5-241f5d602b65

```

-------

Entry 854 - fullUrl = urn:uuid:91e7f4d9-dc60-42ab-bf92-a9ad23b48f13

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.29:28
Vävnadssocker: 9.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5b03d8c0-8687-5d3d-941c-04a9a773c778

```

-------

Entry 855 - fullUrl = urn:uuid:924a7068-ad76-4b06-bc4c-f0cc76b98d35

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.34:28
Vävnadssocker: 9.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f0e79299-6815-5dd8-b1b4-18f440868b1d

```

-------

Entry 856 - fullUrl = urn:uuid:0e626577-2cef-403d-87ab-e8c9f6f71a71

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.39:30
Vävnadssocker: 8.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ace31d4a-1079-5bc0-bfcb-e1f163eac7ce

```

-------

Entry 857 - fullUrl = urn:uuid:2cba4af7-222f-4e12-8f7a-d77f04bce391

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.44:28
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80c59ff8-226d-515e-a9bb-333efec6470e

```

-------

Entry 858 - fullUrl = urn:uuid:16ce68c9-c9d6-4448-a9d8-194b13d879e8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.49:28
Vävnadssocker: 7.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6315a496-5984-593e-b02d-400b9317fd8a

```

-------

Entry 859 - fullUrl = urn:uuid:918a777a-709b-4c8f-828c-0b1a830b3082

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.54:28
Vävnadssocker: 7.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:82d3cccd-e74a-5dfb-9cb3-de4a003d485e

```

-------

Entry 860 - fullUrl = urn:uuid:d9bb00fe-de22-4e14-bacd-f6ac149e2e74

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 15.56:11 - 16.01:12
Direktverkande insulin 0.03 IE (0.34 IE/t, 0.48 % = 0.16 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:da57fe4f-d608-5e4f-aa1c-88c73a0c8f3c

```

-------

Entry 861 - fullUrl = urn:uuid:53f9835d-52f7-46ea-aec8-d31b3a6bd820

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 15.59:29
Vävnadssocker: 7.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:71158606-5f36-50a7-b057-0f05676f2881

```

-------

Entry 862 - fullUrl = urn:uuid:bc664991-8ceb-4a98-9ae1-aa083cc0a216

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 16.01:12 - 16.06:12
Direktverkande insulin 0.02 IE (0.26 IE/t, 0.37 % = 0.10 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:735b9726-4358-51fc-a3bb-7c35a1128afc

```

-------

Entry 863 - fullUrl = urn:uuid:35030064-13e0-40aa-b4ef-11e0d2af4a2f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.04:28
Vävnadssocker: 7.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:01fe3af3-925d-5830-8c6f-2250c4bb5fdf

```

-------

Entry 864 - fullUrl = urn:uuid:dd9ea9e4-abea-4d72-a0a7-4a0b37fc7343

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 16.06:12 - 16.26:15
Direktverkande insulin 0.23 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2976a6ba-cb00-5be0-9858-67a286e24a87

```

-------

Entry 865 - fullUrl = urn:uuid:0a4ab4fc-e17e-498d-9bae-407e1f5ebb44

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.09:28
Vävnadssocker: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aa5c1ee1-002e-5fec-a95d-83f99766e362

```

-------

Entry 866 - fullUrl = urn:uuid:5fd3ee5d-4f86-4494-a811-7f55501385a3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.14:28
Vävnadssocker: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a004f0a5-064e-5ddd-9a7c-f86c81af5492

```

-------

Entry 867 - fullUrl = urn:uuid:13946866-cdc1-4e87-9561-afee95a2d951

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.19:28
Vävnadssocker: 8.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f542c066-8240-51b3-8651-897cb7b69df3

```

-------

Entry 868 - fullUrl = urn:uuid:9134e529-bf3b-4402-a27b-3117124321b1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.24:28
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bf6bb09b-c7e6-543a-8168-31f45cca5074

```

-------

Entry 869 - fullUrl = urn:uuid:11a988eb-22b4-4784-b885-31abdbc349ac

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 16.26:15 - 16.31:16
Direktverkande insulin 0.11 IE (1.29 IE/t, 1.84 % = 2.36 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:725df3f6-ccf1-516b-97d9-c211da2e4b28

```

-------

Entry 870 - fullUrl = urn:uuid:da81ca8a-8b57-438c-87c7-3fd91509913a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 16.26:29
Direktverkande insulin 1.06 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8875cbad-4192-5758-8698-c71e8046738a

```

-------

Entry 871 - fullUrl = urn:uuid:d0822aeb-562b-48e4-a6ea-2bd4db659882

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.29:28
Vävnadssocker: 9.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:51f57e4d-d8de-5df7-befa-2cef63d3b165

```

-------

Entry 872 - fullUrl = urn:uuid:ee8d5140-7c83-4757-813a-077e5308b72a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 16.31:16 - 16.51:19
Direktverkande insulin 0.23 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1835a227-1cf6-53a4-9385-411607227b54

```

-------

Entry 873 - fullUrl = urn:uuid:2b705a95-a8e1-48c7-8142-2ad809af67d7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.34:28
Vävnadssocker: 10.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ab17558c-09a6-54fd-897c-bbf131a22452

```

-------

Entry 874 - fullUrl = urn:uuid:417e4c45-4574-4653-aa19-bda21ea7a5e0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.39:28
Vävnadssocker: 10.32 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c10bd1a8-afc9-599e-8349-086d79b28183

```

-------

Entry 875 - fullUrl = urn:uuid:e5bb1042-976e-4ec0-93bd-601cf5c81cb3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.44:28
Vävnadssocker: 10.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8e84a518-84ab-54ee-93d1-44cb024a38e5

```

-------

Entry 876 - fullUrl = urn:uuid:cedcacb7-9a90-40ff-95b8-109d8d305ac1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.49:28
Vävnadssocker: 10.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b8a061e0-f9aa-56f5-8145-8b54e7f592dd

```

-------

Entry 877 - fullUrl = urn:uuid:3833fabe-36a0-487e-a5e7-66b8c779379a

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 16.51:19 - 16.56:20
Direktverkande insulin 0.08 IE (0.92 IE/t, 1.32 % = 1.21 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b290796a-d67d-596a-b518-23f0ce571742

```

-------

Entry 878 - fullUrl = urn:uuid:d1ef4003-1bf7-400a-b170-962da503076b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.54:28
Vävnadssocker: 11.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:444581db-9046-539c-9b34-294fd5e1c50b

```

-------

Entry 879 - fullUrl = urn:uuid:ae827ad6-a037-4455-ad4a-dcd2749c9874

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 16.56:20 - 17.01:21
Direktverkande insulin 0.13 IE (1.58 IE/t, 2.26 % = 3.57 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8e6e35ca-5091-58b3-8e41-53150e18b987

```

-------

Entry 880 - fullUrl = urn:uuid:83750eaf-547c-4978-8c85-63660bb8b3bb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 16.59:28
Vävnadssocker: 11.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:96254f86-8779-592a-9d5d-bd5c22f0573a

```

-------

Entry 881 - fullUrl = urn:uuid:f577462e-e1ba-46df-9067-4c40b31fa6ba

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.01:21 - 17.06:23
Direktverkande insulin 0.19 IE (2.21 IE/t, 3.16 % = 6.97 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d75b0832-23f3-57c6-b837-122ff63cd28e

```

-------

Entry 882 - fullUrl = urn:uuid:5a7e6256-5d57-4c64-a4b2-9bcc656339ae

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.04:29
Vävnadssocker: 11.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:78de6826-b0ae-5a00-9e4d-2ec34512b619

```

-------

Entry 883 - fullUrl = urn:uuid:e9f5b999-0c7f-42a8-8275-bd50e4b8000c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.06:23 - 17.11:23
Direktverkande insulin 0.20 IE (2.41 IE/t, 3.45 % = 8.32 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8b849ea0-c7e4-5070-b76b-3439405dbb31

```

-------

Entry 884 - fullUrl = urn:uuid:33e9e3d0-eeb6-4cdf-a12d-85b5c44f6a50

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.09:28
Vävnadssocker: 11.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b6153736-37a8-5f77-94b0-4b4056cd11ef

```

-------

Entry 885 - fullUrl = urn:uuid:cbcd2aaf-16ee-4fd1-b5c5-35cc4ef5d11e

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.11:23 - 17.16:23
Direktverkande insulin 0.19 IE (2.31 IE/t, 3.30 % = 7.63 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d98e6540-8431-554b-b8e0-8a42fae93ed7

```

-------

Entry 886 - fullUrl = urn:uuid:3373b00e-36cc-4c6c-8c44-d2dc6309dc31

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.14:29
Vävnadssocker: 12.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6d00cf34-d122-55c0-a913-063c4e80d496

```

-------

Entry 887 - fullUrl = urn:uuid:50260960-4fcd-4002-8157-461a64ab664d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.16:23 - 17.21:24
Direktverkande insulin 0.15 IE (1.78 IE/t, 2.54 % = 4.51 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6494e2e3-0e38-5098-8ff3-83b956afb14c

```

-------

Entry 888 - fullUrl = urn:uuid:e64a0ca3-eb15-41da-a0e4-7e44bfd6add8

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.19:28
Vävnadssocker: 12.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3a50b4e6-d597-5508-a36b-42c6b5ecd55b

```

-------

Entry 889 - fullUrl = urn:uuid:81be84a7-0496-4ce0-b4df-fb8cc1e74e45

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.21:24 - 17.26:25
Direktverkande insulin 0.14 IE (1.73 IE/t, 2.46 % = 4.25 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c307f1d5-b84c-5d4c-b64b-5a2c6b4dde2f

```

-------

Entry 890 - fullUrl = urn:uuid:8f3b0cdc-74fd-4922-9d9e-a1f94ad3ab45

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.24:28
Vävnadssocker: 12.54 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:02414cb6-2d66-5773-9cfb-66eac3680a30

```

-------

Entry 891 - fullUrl = urn:uuid:42442bad-15b5-493c-97ff-22fc4e59635c

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.26:25 - 17.31:27
Direktverkande insulin 0.17 IE (2.04 IE/t, 2.91 % = 5.93 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d86cce92-29bd-50b8-9a01-8e8de0066d3a

```

-------

Entry 892 - fullUrl = urn:uuid:413d5017-a0c5-4590-86f9-9c9e886e4b4d

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.29:30
Vävnadssocker: 12.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2d02e6cf-298d-5dc3-ad2a-83ba773b678d

```

-------

Entry 893 - fullUrl = urn:uuid:42db7d12-12d8-42b0-a773-153fb3e74968

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.31:27 - 17.36:27
Direktverkande insulin 0.21 IE (2.52 IE/t, 3.59 % = 9.04 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:534dc1b8-9a1f-56ae-8b48-86edbd65979c

```

-------

Entry 894 - fullUrl = urn:uuid:9820be42-89ff-4842-ac0d-844925b76041

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.31:41
Direktverkande insulin 1.43 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a9c444f7-d89b-5fb2-a10d-460a79e69f31

```

-------

Entry 895 - fullUrl = urn:uuid:c1beae4a-bf49-4546-a549-3feb0190f8b6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.34:29
Vävnadssocker: 13.04 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1cb0a20-71ca-5aaf-97fc-2ce061bcf9a9

```

-------

Entry 896 - fullUrl = urn:uuid:ebd761a3-d6c4-4f56-8cf2-ae16060867cf

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.36:27 - 17.46:27
Direktverkande insulin 0.12 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:171edc5d-dc45-53bd-ad81-d86cac88d2e5

```

-------

Entry 897 - fullUrl = urn:uuid:99abf78f-f470-4f55-a3b9-56c188da91a7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.39:28
Vävnadssocker: 13.32 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f964fc68-020c-5fba-99dc-12b00d40c767

```

-------

Entry 898 - fullUrl = urn:uuid:42880f8e-868a-4fb7-a6d9-98eb635a11eb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.44:31
Vävnadssocker: 13.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:acfe1c1b-c465-5353-bcd9-6e433b5b32fa

```

-------

Entry 899 - fullUrl = urn:uuid:9a2a7e58-a15e-4489-96fe-32958fc99dc0

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.46:27 - 17.51:29
Direktverkande insulin 0.09 IE (1.12 IE/t, 1.60 % = 1.79 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7f437d06-b4c9-58cc-8fb3-7086a334028a

```

-------

Entry 900 - fullUrl = urn:uuid:7e481140-58e6-43ad-ab61-cb3af35b226f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.49:28
Vävnadssocker: 13.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:05cf52e7-65d7-598f-8568-bfa85e42876e

```

-------

Entry 901 - fullUrl = urn:uuid:05260f00-498e-45c3-bbb0-19ca9623fe35

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.51:29 - 17.56:30
Direktverkande insulin 0.09 IE (1.10 IE/t, 1.57 % = 1.73 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:81c2f7e5-23b6-54fe-a463-d74bd522bad4

```

-------

Entry 902 - fullUrl = urn:uuid:c8a82524-8b57-449e-9628-d07854b9ccb7

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.54:28
Vävnadssocker: 13.04 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4b22bf53-d9f1-57b1-8724-a4c654a4da4b

```

-------

Entry 903 - fullUrl = urn:uuid:2f0d95ed-e26d-4715-892e-af4000243327

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 17.56:30 - 18.36:35
Direktverkande insulin 0.47 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:446fddfc-21e6-5112-8c89-388e42157397

```

-------

Entry 904 - fullUrl = urn:uuid:838f06b8-194b-473a-a7b2-1b90ba0a8fe3

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 17.59:30
Vävnadssocker: 12.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9e494840-98bf-52f3-89ad-9f8d57c1befe

```

-------

Entry 905 - fullUrl = urn:uuid:92077552-b0b9-4e67-9fc2-f77fb02f46f2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.04:28
Vävnadssocker: 12.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:42ef82b3-d7db-5b88-9ed7-7f4931744112

```

-------

Entry 906 - fullUrl = urn:uuid:87ca9ddf-5b42-443e-a9e4-0bda4468d3d6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.09:28
Vävnadssocker: 12.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d7524178-00a7-5eeb-a2db-61dd5a327767

```

-------

Entry 907 - fullUrl = urn:uuid:a6b484fd-47ed-4697-ae46-6d8f368ed83b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.14:28
Vävnadssocker: 12.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d0b82c99-78e5-5549-8815-86e9e451ed45

```

-------

Entry 908 - fullUrl = urn:uuid:ff552219-0188-4990-9881-43b36d891bd1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.19:28
Vävnadssocker: 12.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a076cff7-a154-5b7a-b442-4752f58bca6d

```

-------

Entry 909 - fullUrl = urn:uuid:372c9ede-7183-43b5-b9b0-6d07b5e35c35

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.24:28
Vävnadssocker: 11.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:23e6799a-1e00-509f-8c2d-f5d8bde07acc

```

-------

Entry 910 - fullUrl = urn:uuid:4d00257f-ea7c-4d14-85f7-d9e8fcd6f39c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.29:28
Vävnadssocker: 11.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ed25f8c9-d870-5724-b760-39622ce47297

```

-------

Entry 911 - fullUrl = urn:uuid:cd3e4c01-777b-4d32-9a78-e90a5ccfe905

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.34:28
Vävnadssocker: 11.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3abdc2ad-9d1d-57e2-80bf-ef98a7af7206

```

-------

Entry 912 - fullUrl = urn:uuid:b746deed-1c10-4d23-b5ff-9586711776ab

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 18.36:35 - 18.41:38
Direktverkande insulin 0.07 IE (0.86 IE/t, 1.23 % = 1.06 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:974bf0dd-a8e5-545d-be13-f46b8845d0ef

```

-------

Entry 913 - fullUrl = urn:uuid:07d1ad25-68a3-4cc8-baf0-16c6ae885206

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 18.37:12
Direktverkande insulin 0.93 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:88ea0de5-afcc-53ae-858c-c3e11d14a89c

```

-------

Entry 914 - fullUrl = urn:uuid:77aff8ab-46e8-4d4e-b5be-ba5082708ca6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.39:28
Vävnadssocker: 11.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fc001eb9-b3f5-516b-9f23-9a951872ea0b

```

-------

Entry 915 - fullUrl = urn:uuid:edfb4d8b-2863-4ea8-9ba9-3dd3e9dd3302

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 18.41:38 - 21.12:01
Direktverkande insulin 1.75 IE (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:319cdae9-e324-5abb-82b4-fc375dc68406

```

-------

Entry 916 - fullUrl = urn:uuid:bf13c901-57d9-43b9-822c-ab3af3c5062e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.44:29
Vävnadssocker: 11.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:64586759-7b25-5fd4-8816-3bf0f8afc86f

```

-------

Entry 917 - fullUrl = urn:uuid:93966e07-fbda-48e0-87b4-35aee9e8a839

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.49:28
Vävnadssocker: 11.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:13497cc6-f3ca-59ea-b56b-1ec3ce244b20

```

-------

Entry 918 - fullUrl = urn:uuid:1a3013a7-2ff8-4ac5-aa33-11e515780f84

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.54:28
Vävnadssocker: 11.43 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bcd96567-9e03-5edb-9a92-a13139a073b8

```

-------

Entry 919 - fullUrl = urn:uuid:3610b9dc-8e43-475a-b27f-43afa6011b39

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 18.59:28
Vävnadssocker: 11.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:418ef41f-b16e-5bb9-8a27-ed87aef20917

```

-------

Entry 920 - fullUrl = urn:uuid:bfc0d035-dc05-4bb5-9a92-a5861b2a209f

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.04:27
Vävnadssocker: 10.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e48fe7f0-23ae-5c52-b8f3-518e58c7cd95

```

-------

Entry 921 - fullUrl = urn:uuid:be4f507b-2e75-48e1-aba9-00eed8de339e

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.09:28
Vävnadssocker: 10.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:10486c85-d18c-5f5f-8048-0872cae10a47

```

-------

Entry 922 - fullUrl = urn:uuid:3ad80c65-de42-4df2-b23c-ea50cd6e8ca6

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.14:27
Vävnadssocker: 10.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d2394e07-0d96-5250-9035-ea5a222df6a7

```

-------

Entry 923 - fullUrl = urn:uuid:3ffad0a3-1688-4846-90b1-800fc76f0c81

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.19:28
Vävnadssocker: 10.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4cf259ff-bceb-5024-bfe5-4ff49c644a97

```

-------

Entry 924 - fullUrl = urn:uuid:a3bf86fa-1b95-445c-b7a6-f17b12c7cd40

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.24:27
Vävnadssocker: 10.32 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:11cbe2cd-9018-561c-a3b6-a916b29d5937

```

-------

Entry 925 - fullUrl = urn:uuid:ea66b0a7-d88a-4cf3-9e70-e5b3efa1baf4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.29:27
Vävnadssocker: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:09e43b2d-ca0e-5747-b0c9-686e957bda47

```

-------

Entry 926 - fullUrl = urn:uuid:9807bcef-c8d6-4c8e-a905-3a52edd39f73

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.34:28
Vävnadssocker: 10.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5a9646ca-c75b-56d2-b287-a38a0dd0e4d9

```

-------

Entry 927 - fullUrl = urn:uuid:e0bc3ed4-3834-4987-9845-7463a3c47eb4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.39:28
Vävnadssocker: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eb5421ba-bc6c-5b6f-afef-d35b0327edb3

```

-------

Entry 928 - fullUrl = urn:uuid:15949a49-3830-4da7-a098-5ef8cd63d3ea

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.44:28
Vävnadssocker: 9.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:23be8e3c-8b3f-568a-88ed-c8b57c2c949a

```

-------

Entry 929 - fullUrl = urn:uuid:41bfc039-e222-4ce9-8c8e-a1e6a4c013a1

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.49:27
Vävnadssocker: 9.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:facad9cc-bce5-5f97-ae54-14575b20b490

```

-------

Entry 930 - fullUrl = urn:uuid:dff9351e-adb9-42aa-b354-942af7190c6b

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.54:31
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:16d36557-c64c-5c91-91c3-9a1a9f4db92f

```

-------

Entry 931 - fullUrl = urn:uuid:8ae2550e-e050-40ce-bb00-7708cba94505

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 19.59:27
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:88e84ac6-28de-5b3e-8f64-d936b0260b63

```

-------

Entry 932 - fullUrl = urn:uuid:5a5ab6f9-5bf7-4db8-923a-d59fa0d20c00

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.04:27
Vävnadssocker: 9.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:598701f8-ee67-5675-b3cb-55acaf4a9b0b

```

-------

Entry 933 - fullUrl = urn:uuid:7627dabe-e05f-4c87-a9aa-c9b75509710c

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.09:27
Vävnadssocker: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:45b34736-1c70-5234-bba2-7436c6217bb2

```

-------

Entry 934 - fullUrl = urn:uuid:f698fc24-cbee-4764-b213-8ec72c4b8580

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 20.12:18
Direktverkande insulin 7.06 IE

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cf82de91-ee90-5d37-b0d7-3be23535574a

```

-------

Entry 935 - fullUrl = urn:uuid:ca1d59c4-0713-4be9-b243-c6de79ac0048

Resource Observation:

> Kod: LOINC 9059-7 (Beräknad mängd kolhydratintag)
Tid: 6.9.2021 20.12:18
Beräknad mängd kolhydratintag: 75 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8aa64f85-0f22-5a3f-bd10-3c78dda3994b

```

-------

Entry 936 - fullUrl = urn:uuid:1108676f-7087-4f66-82a5-d72c5e4e50bb

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.14:34
Vävnadssocker: 9.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a2855967-484d-5a6f-b5f8-2f91ebc3317b

```

-------

Entry 937 - fullUrl = urn:uuid:3dff0902-bcdd-439d-a52f-841e0fedcc74

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.19:29
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:10614f26-e5ed-5328-a1cb-3730ec1c6826

```

-------

Entry 938 - fullUrl = urn:uuid:32eb5102-5700-414c-a2df-a9111e21c1d5

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.24:27
Vävnadssocker: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:436b8bed-bee1-5298-a9fd-b246faccf835

```

-------

Entry 939 - fullUrl = urn:uuid:32670387-33f3-4f82-a5d5-ceb64572eefe

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.29:28
Vävnadssocker: 9.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a2d84185-8c11-58ee-8186-0e1885350460

```

-------

Entry 940 - fullUrl = urn:uuid:e0dd5424-4e8f-4d20-a794-7ff0bca65327

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.34:27
Vävnadssocker: 9.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cd540815-11b2-5deb-9c6f-b9723f52ca39

```

-------

Entry 941 - fullUrl = urn:uuid:5b0e45f1-4bad-4da0-94ee-1f5cc5137430

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.39:28
Vävnadssocker: 9.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e318a4b2-030e-5826-b26b-ebbff3fc6940

```

-------

Entry 942 - fullUrl = urn:uuid:8a384a89-dc67-44b0-a171-e74c3ad25bea

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.44:28
Vävnadssocker: 9.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7eef952c-7f79-50f3-b329-0cd899d0b3e9

```

-------

Entry 943 - fullUrl = urn:uuid:05329e61-13c8-499c-93a2-ed694b9f2aac

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.49:29
Vävnadssocker: 9.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6fcabd6b-9952-5a64-ad00-f3bdb9b12973

```

-------

Entry 944 - fullUrl = urn:uuid:bac2b7a3-d584-4096-aa73-c3fad008e726

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.54:27
Vävnadssocker: 8.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3e580aa2-8dc7-504f-9cfa-a7d798c542fa

```

-------

Entry 945 - fullUrl = urn:uuid:84d05e9b-a0c5-426b-abcd-7da073d05eb2

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 20.59:27
Vävnadssocker: 8.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e54f45c2-af11-5f95-a696-421ff19f60eb

```

-------

Entry 946 - fullUrl = urn:uuid:7f5839e3-5bf6-497a-89f8-06e415eb55f0

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.04:27
Vävnadssocker: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a07b2b4e-560c-5278-8b14-c878578b39dd

```

-------

Entry 947 - fullUrl = urn:uuid:e0910c87-c013-4fed-a428-3c3976ad9940

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.09:32
Vävnadssocker: 7.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3fbc46f5-895d-5014-8fdf-ea92c1313e85

```

-------

Entry 948 - fullUrl = urn:uuid:6daac643-1759-4f14-b431-d6748e509754

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 21.12:01 - 21.17:02
Direktverkande insulin 0.02 IE (0.28 IE/t, 0.41 % = 0.12 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c59544a9-8f43-56ab-ae17-5d1820b27cc2

```

-------

Entry 949 - fullUrl = urn:uuid:bc8619b3-c923-478a-9104-abc2eb546734

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.14:27
Vävnadssocker: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9d5acfcf-82c3-5609-b17a-9719c87c4a65

```

-------

Entry 950 - fullUrl = urn:uuid:07b6f25c-85c9-4942-920f-ed10affd2677

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 21.17:02 - 21.32:03
Direktverkande insulin 0.00 IE (0.00 IE/t, 1.00 % = 0.00 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d7503284-245d-5934-b432-8393d4915112

```

-------

Entry 951 - fullUrl = urn:uuid:e8aca63d-3d59-4b01-b0dd-195b69b5e559

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.19:27
Vävnadssocker: 6.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7d8c68b1-22f7-5a91-be5e-8bcbe8a8f6c5

```

-------

Entry 952 - fullUrl = urn:uuid:27971417-96dc-43f4-b833-b9c36e488ef4

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.24:27
Vävnadssocker: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1fd2bdf-7204-52d9-bd80-7788c6f5839f

```

-------

Entry 953 - fullUrl = urn:uuid:ddfeb8b8-c1dd-459b-b03e-15d15a356459

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.29:29
Vävnadssocker: 6.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6cd95c9d-5e98-57b0-b09b-55f2a51046de

```

-------

Entry 954 - fullUrl = urn:uuid:f8dfb132-42b8-4e8c-a2cf-cef913aedb23

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 21.32:03 - 21.37:05
Direktverkande insulin 0.01 IE (0.14 IE/t, 0.19 % = 0.03 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4863d576-7c4e-539b-a14f-0763c0993c62

```

-------

Entry 955 - fullUrl = urn:uuid:0263ee53-bbc5-4d50-8907-d9636b562b59

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.34:27
Vävnadssocker: 6.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8ac7143a-d1bf-50d8-a4e8-2ad9e3eb82f2

```

-------

Entry 956 - fullUrl = urn:uuid:a0fdec85-b056-43f3-afeb-56619d93136d

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 21.37:05 - 21.42:06
Direktverkande insulin 0.02 IE (0.27 IE/t, 0.39 % = 0.11 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:aae34ed4-79df-51ff-affa-a60f0b04356a

```

-------

Entry 957 - fullUrl = urn:uuid:67518ca0-4a57-4bdf-ba34-eef05d0cc622

Resource Observation:

> Kod: LOINC 14745-4 (Vävnadssocker)
Tid: 6.9.2021 21.39:28
Vävnadssocker: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3057cf59-1600-56ef-a9e3-50948bf13b47

```

-------

Entry 958 - fullUrl = urn:uuid:4f752004-94ec-4ff2-b3ad-6b2413a7c2da

Resource MedicationAdministration:

> Typ av insulin: Direktverkande insulin
Kod: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Direktverkande insulin), SNOMED 67866001 (Insulin (substance))
Tid: 6.9.2021 21.42:06 - 21.47:06
Direktverkande insulin 0.04 IE (0.53 IE/t, 0.76 % = 0.41 IE/t)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:86e325e1-7a2e-5fe5-9020-1d6e8ee6ddb9

```

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

