# Examples - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* **Examples**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

## Examples

* [Appointment](#Appointment)
* [Bundle](#Bundle)
* [Condition](#Condition)
* [Encounter](#Encounter)
* [EpisodeOfCare](#EpisodeOfCare)
* [HealthcareService](#HealthcareService)
* [Immunization](#Immunization)
* [Location](#Location)
* [Medication](#Medication)
* [MedicationAdministration](#MedicationAdministration)
* [MedicationRequest](#MedicationRequest)
* [MedicationStatement](#MedicationStatement)
* [Observation](#Observation)
* [Organization](#Organization)
* [Patient](#Patient)
* [Practitioner](#Practitioner)
* [PractitionerRole](#PractitionerRole)
* [Procedure](#Procedure)
* [Provenance](#Provenance)
* [Schedule](#Schedule)
* [Slot](#Slot)

This list includes the examples included in this implementation guide. Please note that the list contains examples of FI Base resources as well as examples from other known implementations from Finland. We hope listing many examples here promotes awareness of what has already been done and thereby increases interoperability.

These example instances show what data produced and consumed by systems conforming with this implementation guide might look like. Every effort has been made to ensure that the examples are correct and useful, but they are not a normative part of the specification nor are they fully representative of real world examples.

### Appointment

* [GP appointment](Appointment-appointment-general-practitioner.md)

### Bundle

* [Patient generated glucose observations and insulin administrations as a bundle, in English](Bundle-diabetes-data-bundle-kantaphr-r4-en.md)
* [Patient generated glucose observations and insulin administrations as a bundle, in Swedish](Bundle-diabetes-data-bundle-kantaphr-sv.md)
* [Patient generated glucose observations and insulin administrations as a bundle, in Finnish](Bundle-diabetes-data-bundle.md)

### Condition

* [Condition - an example diagnosis](Condition-id-for-diagnosis-1.md)
* [Condition - an example diagnosis with external cause, accident and medication information.](Condition-id-for-diagnosis-2.md)
* [Condition - an example diagnosis with an adverse effect.](Condition-id-for-diagnosis-3.md)

### Encounter

* [Another Encounter that is part of palvelutapahtuma](Encounter-id-for-child-encounter-2.md)
* [Encounter that is part of palvelutapahtuma](Encounter-id-for-child-encounter.md)
* [Encounter that is a palvelutapahtuma in Kanta registry](Encounter-id-for-palvelutapahtuma.md)
* [Encounter - patient primary care visit](Encounter-id-for-visit.md)
* [Encounter - patient is currently receiving care at a ward treating surgical patients](Encounter-id-for-ward-encounter.md)

### EpisodeOfCare

* [Episode of care - with provenance](EpisodeOfCare-id-for-episode-1.md)

### HealthcareService

* [Codified healthcare service](HealthcareService-healthcareService-example.md)

### Immunization

* [Vaccination for TBE](Immunization-ImmunizationVaccinationExample.md)

### Location

* [Outpatient clinic](Location-LocationExample.md)
* [A named bed](Location-id-for-bed-3.md)

### Medication

* [Myyntiluvallinen lääkevalmiste](Medication-medicationesim1.md)
* [Myyntiluvallinen lääkevalmiste, joka on PKV-lääke](Medication-medicationesim2.md)

### MedicationAdministration

* [Kanta PHR - Insulin dosage mandatory](MedicationAdministration-a4d97476-39fa-46c6-bf2e-1fb153a7bbe2.md)
* [Kanta PHR - Insulin dosage optional](MedicationAdministration-a4d97476-39fa-46c6-bf2e-1fb153a7bbe3.md)
* [MedicationAdministration example of insulin basal dose](MedicationAdministration-medication-administration-insulin-basal-dose-kanta-stu3-sv.md)
* [MedicationAdministration example of insulin dose](MedicationAdministration-medication-administration-insulin-bolus-dose-fi.md)
* [MedicationAdministration example of temporary basal rate](MedicationAdministration-medication-administration-insulin-dose-temp-basal-rate-kanta-en.md)

### MedicationRequest

* [1 tabletti 2 kertaa päivässä](MedicationRequest-medicationrequestesim1.md)
* [2 tablettia aamulla ja 1 tabletti illalla 6 päivän ajan](MedicationRequest-medicationrequestesim2.md)
* [1-2 tablettia kerran päivässä](MedicationRequest-medicationrequestesim3.md)
* [1-2 tablettia 1-3 kertaa päivässä](MedicationRequest-medicationrequestesim4.md)
* [Maanantaisin 1 tabletti ja tarvittaessa keskiviikkoisin 0,5 tablettia 01.06.2020 - 31.12.2020](MedicationRequest-medicationrequestesim5.md)
* [Lääke tauolla 1.3.2020 - 30.6.2020. Taukoa edeltävä annostus: 25 mg klo 08:00 10 päivän ajan ihon alle](MedicationRequest-medicationrequestesim6.md)
* [1 tabletti 2 kertaa päivässä 5 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7A.md)
* [1 tabletti 2 kertaa päivässä 5-7 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7B.md)
* [Tarvittaessa 2 tablettia 3 kertaa viikossa 16.2.2021 alkaen](MedicationRequest-medicationrequestesim8.md)
* [Tarvittaessa 1-2 tippaa 3-4 tunnin välein](MedicationRequest-medicationrequestesim9.md)

### MedicationStatement

* [Simple medication statement example](MedicationStatement-medication-statement-insulin.md)

### Observation

* [Kanta PHR - body height optional](Observation-1153859e-0c86-1000-abb8-511d0000b222.md)
* [Kanta PHR - carbohydrate intake mandatory](Observation-2894b2e6-7ebf-4c33-93e4-31935effff21.md)
* [Kanta PHR - carbohydrate intake optional](Observation-2894b2e6-7ebf-4c33-93e4-31935effff22.md)
* [Kanta PHR - step count mandatory](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f8.md)
* [Kanta PHR - step count optional](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f9.md)
* [Kanta PHR - MET measurement mandatory](Observation-48983b8b-ead3-4206-9583-fcdd40d762b6.md)
* [Kanta PHR - MET measurement optional](Observation-48983b8b-ead3-4206-9583-fcdd40d762b7.md)
* [Kanta PHR - calorie intake mandatory](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f7.md)
* [Kanta PHR - calorie intake optional](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f8.md)
* [Kanta PHR - exercise tracking mandatory](Observation-71831b54-1a80-47c5-ba84-0180a5eb784a.md)
* [Kanta PHR - exercise tracking optional](Observation-71831b54-1a80-47c5-ba84-0180a5eb784b.md)
* [Kanta PHR - blood glucose result as text](Observation-bloodglucose-as-text.md)
* [Kanta PHR - blood glucose with data absent](Observation-bloodglucose-data-absent.md)
* [Kanta PHR - blood glucose optional](Observation-bloodglucose-max.md)
* [Kanta PHR - blood glucose mandatory](Observation-bloodglucose-min.md)
* [Kanta PHR - blood pressure optional](Observation-bloodpressure-max.md)
* [Kanta PHR - blood pressure mandatory](Observation-bloodpressure-min.md)
* [Kanta PHR - body weight optional](Observation-bodyweight-max.md)
* [Kanta PHR - body weight mandatory](Observation-bodyweight-min.md)
* [Kanta PHR - physical activity optional](Observation-mtvpa-max.md)
* [Kanta PHR - physical activity mandatory](Observation-mtvpa-min.md)

### Organization

* [Organization - example of a parent organization](Organization-1.2.246.10.2085212.10.1306.md)
* [Organization - example primary care organization](Organization-1.2.246.10.2085212.10.1314.md)
* [A high level organization](Organization-1.2.246.10.31045308.10002.0.md)
* [Encounter - example primary care organization](Organization-1.2.246.10.8286189.10.100012.md)
* [Testi terveysasema](Organization-organizationesim1.md)
* [Simple Organization example](Organization-organizationesim2.md)

### Patient

* [Kanta PHR - patient 3](Patient-36749a02-1710-44e7-aa76-0e934eb7860a.md)
* [Patient - with the MunicipalityCode extension.](Patient-patient-of-municipality.md)
* [Patient with a TURVAKIELTO security label.](Patient-patient-with-turvakielto.md)
* [Karen van der Hentenryck](Patient-patientesim1.md)

### Practitioner

* [Licenced physician](Practitioner-practitioner-licensed-physician.md)
* [Lars van der Knaapi](Practitioner-practitioneresim1.md)

### PractitionerRole

* [Licenced physician in primary care](PractitionerRole-PractitionerRoleGP.md)
* [A simple practitioner role](PractitionerRole-practitionerRoleesim1.md)

### Procedure

* [Biopsy of Colon procedure example](Procedure-ColonBiopsy.md)
* [Procedure Colotomy example](Procedure-ProcedureColotomy.md)

### Provenance

* [Provenance example with registy information in reason field](Provenance-ESE-289490.md)
* [Custodian of information (rekisterinpitäjä), an individual provider](Provenance-custodian-individual.md)
* [Custodian of information (rekisterinpitäjä), private occupational healthcare](Provenance-custodian-occupational-healthcare.md)
* [Provenance example for Kanta](Provenance-custodian-public-healthcare-kela.md)
* [Custodian of information (rekisterinpitäjä), public healthcare](Provenance-custodian-public-healthcare.md)
* [A simple provenance example](Provenance-id-for-provenance-1.md)
* [An imaginary example of a Provenance resource instance conforming to the imaginary metadata profile for Kanta system, using the kanta code also for the custodian agent](Provenance-kanta-document-metadata-profile-example-2.md)
* [An imaginary example of a Provenance resource instance conforming to the imaginary metadata profile for Kanta system](Provenance-kanta-document-metadata-profile-example.md)
* [A test example demonstrating that validation works](Provenance-kanta-document-metadata-profile-test-example-1.md)
* [Another test example demonstrating that validation works](Provenance-kanta-document-metadata-profile-test-example-2.md)

### Schedule

* [SNOMED CT coded Schedule](Schedule-ScheduleExample.md)

### Slot

* [Free slot (kertakäynti yleislääkärillä)](Slot-FreeSlot.md)

Before deriving any conclusions from the examples alone, please do check the [quality asssurance report](qa.md) of this implementation guide to learn about the identified issues and non-conformities of each of the examples.

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

