# ServiceEvent - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceEvent**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-service-event-definitions.md) 
*  [Mappings](StructureDefinition-service-event-mappings.md) 
*  [XML](StructureDefinition-service-event.profile.xml.md) 
*  [JSON](StructureDefinition-service-event.profile.json.md) 
*  [TTL](StructureDefinition-service-event.profile.ttl.md) 

## Extension: ServiceEvent 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/service-event | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:ServiceEvent |

Extension for service event id (**palvelutapahtuman tunniste**).

**Context of Use**

### Scope and Usage

ServiceEvent extension defines related service event identifier (**palvelutapahtuman tunniste**). When the service event id is included into the resource, it SHALL be done with this extension.

The scope of **palvelutapahtuma** is described in the description pf the [Fi Base Encounter](StructureDefinition-fi-base-encounter.md#relation-to-finnish-palvelutapahtuma) profile.

The Fi Base Encounter profile also describes how the **palvelutapahtuma** Encounter can be referred to using the link from the resource.

**Usage info**

**Usages:**

* Examples for this Extension: [Appointment/appointment-general-practitioner](Appointment-appointment-general-practitioner.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/service-event)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type oid: Extension for service event id (**palvelutapahtuman tunniste**).

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type oid: Extension for service event id (**palvelutapahtuman tunniste**).

 

Other representations of profile: [CSV](StructureDefinition-service-event.csv), [Excel](StructureDefinition-service-event.xlsx), [Schematron](StructureDefinition-service-event.sch) 

#### Constraints

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

