# Municipality Code - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Municipality Code**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-municipality-code-definitions.md) 
*  [Mappings](StructureDefinition-municipality-code-mappings.md) 
*  [XML](StructureDefinition-municipality-code.profile.xml.md) 
*  [JSON](StructureDefinition-municipality-code.profile.json.md) 
*  [TTL](StructureDefinition-municipality-code.profile.ttl.md) 

## Extension: Municipality Code 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/municipality-code | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:MunicipalityCode |

Extension for home municipality. Home municipality is relevant for ex. in billing and listing available healthcare services, and for statistical purposes. It it not necessarily the place where a patient lives, rather closer to where they pay their taxes.

**Context of Use**

### Scope and Usage

The purpose of Municipality code is to represent the [municipality of residence](https://dvv.fi/en/municipality-of-residence) which is always registered by the Digital and Population Data Services Agency. The municipality of residence indicates that the person has right to use certain services provided by municipality or wellbeing services county. Municipalities are part of wellbeing services counties. Municipality of residence will also indicate in which municipality the person pays taxes.

> **NOTE:**The responsibility for organising primary care services was transferred from municipalities to wellbeing services counties on January 1, 2023. This means that the municipality code would not be sufficient information in a case of billing wellbeing services county from using secondary care services via referral. Nevertheless the municipality code does offer one way of deducing the correct wellbeing services county, when needed.

Municipality of residence differs from address information which represents the contact address of the patient. In most cases the contact address is at the municipality of residence but for instance due to work location one might have separate residence which serves as a contact address. The address which corresponds to municipality of residence is in a different location.

At the time this profile has been created, use cases for using municipality code focus on billing and deducing the correct wellbeing services county. Although municipality is not the responsible party of producing wellbeing services, most billing systems still handle invoices on municipality level. The base profiles do not yet contain a seperate profile to represent wellbeing services county, so even in other than billing use cases the deducing of the correct county will have to be done through the municipality. Once all systems are capable of handling counties and there is a mature national profile for county, the municipality code extension may be deprecated.

**Usage info**

**Usages:**

* Use this Extension: [FI Base Patient](StructureDefinition-fi-base-patient.md) and [FI Base Patient](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient.html)
* Examples for this Extension: [Patient/patient-of-municipality](Patient-patient-of-municipality.md) and [Patient/patient-with-turvakielto](Patient-patient-with-turvakielto.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/municipality-code)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Coding: Extension for home municipality. Home municipality is relevant for ex. in billing and listing available healthcare services, and for statistical purposes. It it not necessarily the place where a patient lives, rather closer to where they pay their taxes.

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Coding: Extension for home municipality. Home municipality is relevant for ex. in billing and listing available healthcare services, and for statistical purposes. It it not necessarily the place where a patient lives, rather closer to where they pay their taxes.

 

Other representations of profile: [CSV](StructureDefinition-municipality-code.csv), [Excel](StructureDefinition-municipality-code.xlsx), [Schematron](StructureDefinition-municipality-code.sch) 

#### Constraints

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

