# FI Base MedicationRequest - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base MedicationRequest**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-medication-request-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-medication-request-mappings.md) 
*  [Examples](StructureDefinition-fi-base-medication-request-examples.md) 
*  [XML](StructureDefinition-fi-base-medication-request.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-medication-request.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-medication-request.profile.ttl.md) 

## Resource Profile: FI Base MedicationRequest 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-request | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseMedicationRequest |

 
This is the Finnish base profile for the MedicationRequest resource, for other than patient access use cases. 

### Scope and Usage

The FI Base MedicationRequest profile requires that references from the MedicationRequest resource to other resources are to resources that also conform to the Finnish Base Profiles.

This profile can be used to ensure greater compatibility, but it should not be expected that all MedicationRequests within the Finnish healthcare IT ecosystem conform to this profile.

This implementation guide does present examples of the MedicationRequest resource being used in Finnish context.

For patient access use cases, please see the [FI SMART MedicationRequest](https://hl7.fi/fhir/finnish-smart/StructureDefinition-fi-smart-medicationRequest.html) profile of the Finnish SMART implementation guide.

See also the [Medication Codes](terminology.md#medication-codes) section on the terminology page of this guide, and the [Medications Module](https://www.hl7.org/fhir/medications-module.html) of the main FHIR specification.

For all medication related resources (Medication, MedicationAdministration, MedicationRequest, MedicationStatement), please also see the [Prescription project](https://www.kanta.fi/en/system-developers/prescription) and the related [implementation guide](https://simplifier.net/guide/finnishkantamedicationr4) of the Kanta system. That project contains useful definitions, examples, and sequence descriptions (mostly in Finnish).

**Usages:**

* Refer to this Profile: [FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md), [FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md), [FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md), [FI Base Observation](StructureDefinition-fi-base-observation.md)...Show 4 more,[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html),[FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html)and[FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-medication-request)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Medication(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication)](StructureDefinition-fi-base-medication.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base MedicationRequest(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-request)](StructureDefinition-fi-base-medication-request.md)
* [FI Base Provenance(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-provenance)](StructureDefinition-fi-base-provenance.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of MedicationRequest.reported[x]
* The element 1 is sliced based on the value of MedicationRequest.medication[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Medication(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication)](StructureDefinition-fi-base-medication.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base MedicationRequest(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-request)](StructureDefinition-fi-base-medication-request.md)
* [FI Base Provenance(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-provenance)](StructureDefinition-fi-base-provenance.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of MedicationRequest.reported[x]
* The element 1 is sliced based on the value of MedicationRequest.medication[x]

 

Other representations of profile: [CSV](StructureDefinition-fi-base-medication-request.csv), [Excel](StructureDefinition-fi-base-medication-request.xlsx), [Schematron](StructureDefinition-fi-base-medication-request.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

