# FI Base MedicationRequest - Examples - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base MedicationRequest**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](StructureDefinition-fi-base-medication-request.md) 
*  [Detailed Descriptions](StructureDefinition-fi-base-medication-request-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-medication-request-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-fi-base-medication-request.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-medication-request.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-medication-request.profile.ttl.md) 

## Resource Profile: FiBaseMedicationRequest - Examples

| |
| :--- |
| Active as of 2025-10-05 |

Examples for the fi-base-medication-request Profile.

| |
| :--- |
| [1 tabletti 2 kertaa päivässä](MedicationRequest-medicationrequestesim1.md) |
| [2 tablettia aamulla ja 1 tabletti illalla 6 päivän ajan](MedicationRequest-medicationrequestesim2.md) |
| [1-2 tablettia kerran päivässä](MedicationRequest-medicationrequestesim3.md) |
| [1-2 tablettia 1-3 kertaa päivässä](MedicationRequest-medicationrequestesim4.md) |
| [Maanantaisin 1 tabletti ja tarvittaessa keskiviikkoisin 0,5 tablettia 01.06.2020 - 31.12.2020](MedicationRequest-medicationrequestesim5.md) |
| [Lääke tauolla 1.3.2020 - 30.6.2020. Taukoa edeltävä annostus: 25 mg klo 08:00 10 päivän ajan ihon alle](MedicationRequest-medicationrequestesim6.md) |
| [1 tabletti 2 kertaa päivässä 5 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7A.md) |
| [1 tabletti 2 kertaa päivässä 5-7 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7B.md) |
| [Tarvittaessa 2 tablettia 3 kertaa viikossa 16.2.2021 alkaen](MedicationRequest-medicationrequestesim8.md) |
| [Tarvittaessa 1-2 tippaa 3-4 tunnin välein](MedicationRequest-medicationrequestesim9.md) |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

