# FI Base Location - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Location**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-location-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-location-mappings.md) 
*  [Examples](StructureDefinition-fi-base-location-examples.md) 
*  [XML](StructureDefinition-fi-base-location.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-location.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-location.profile.ttl.md) 

## Resource Profile: FI Base Location 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseLocation |

 
This is the Finnish base profile for the Location resource. 

**Usages:**

* Refer to this Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md), [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [FI Base HealthcareService](StructureDefinition-fi-base-healthcare-service.md), [Fi Base Immunization](StructureDefinition-fi-base-immunization.md)...Show 14 more,[FI Base Location](StructureDefinition-fi-base-location.md),[FI Base PractitionerRole](StructureDefinition-fi-base-practitioner-role.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Provenance](StructureDefinition-fi-base-provenance.md),[FI Base Schedule](StructureDefinition-fi-base-schedule.md),[FI Base Appointment](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-appointment.html),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[FI Base HealthcareService](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-healthcare-service.html),[Fi Base Immunization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-immunization.html),[FI Base Location](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-location.html),[FI Base PractitionerRole](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-practitioner-role.html),[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html),[FI Base Provenance](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-provenance.html)and[FI Base Schedule](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-schedule.html)
* Examples for this Profile: [Kirurgian poliklinikka](Location-LocationExample.md) and [Vuode 3](Location-id-for-bed-3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-location.csv), [Excel](StructureDefinition-fi-base-location.xlsx), [Schematron](StructureDefinition-fi-base-location.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

