# FI Base InformationCustodian - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base InformationCustodian**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-information-custodian-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-information-custodian-mappings.md) 
*  [Examples](StructureDefinition-fi-base-information-custodian-examples.md) 
*  [XML](StructureDefinition-fi-base-information-custodian.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-information-custodian.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-information-custodian.profile.ttl.md) 

## Resource Profile: FI Base InformationCustodian ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-information-custodian | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseInformationCustodian |

 
This is a Finnish abstract base profile for the Provenance resource, used to communicate the custodian of information (**rekisterinpitäjä**). 

### Scope and Usage

#### How to communicate Kanta information custodian and register information

The Finnish national healthcare infrastructure uses the concept of the information custodian (**rekisterinpitäjä**), also known as the data controller or register keeper.

Most of the information in the Kanta system needs to be tagged with information of the information custodian and of the specific register.

For details, please refer to the [Kanta CDA R2 Header](https://www.kanta.fi/en/jarjestelmakehittajat/potilastiedon-arkiston-cda-r2-header) specification, version 4.66 or later, chapters 2.2.17, 2.4.21, and 2.4.22.

These details are expressed with the Provenance resource conforming to this profile. Information custodian is the `.agent`.

The working group was not able to reach consensus on how to present the details of the register (the type of register, *rekisterin tyyppi* and the register specifier, *rekisterin tarkenne*).

Proposed alternatives are:

1. use extensions either to the`.agent`field or to the root of the Provenance resource (see the[proposal in the first ballot version](https://hl7.fi/fhir/finnish-base-profiles/1.0-rc15/Provenance-id-for-provenance-1.html)and the[example from Kanta](Provenance-id-for-provenance-1.md))
1. encode the information in`.entity`fields of Provenance instances (see examples for[public healthcare](https://hl7.fi/fhir/finnish-base-profiles/1.0-rc21/Provenance-custodian-public-healthcare.html)and for[private healthcare](https://hl7.fi/fhir/finnish-base-profiles/1.0-rc21/Provenance-custodian-occupational-healthcare.html))
1. include the register information in the`.reason`field of the Provenance resource (see[example from CGI](Provenance-ESE-289490.md))

See also the [discussion thread](https://chat.fhir.org/#narrow/stream/179247-Security-and-Privacy/topic/Specific.20register.20in.20Provenance/near/385117093) on chat.fhir.org and the GitHub issues [#88](https://github.com/fhir-fi/finnish-base-profiles/issues/88), [#135](https://github.com/fhir-fi/finnish-base-profiles/issues/135), [#141](https://github.com/fhir-fi/finnish-base-profiles/issues/141), and [#163](https://github.com/fhir-fi/finnish-base-profiles/issues/163).

Implementer feedback is appreciated on how to continue work on the topic.

**Usages:**

* Derived from this Profile: [FI Base Information Custodian (Individual Provider)](StructureDefinition-fi-base-information-custodian-individual.md), [FI Base Information Custodian (Private Organization)](StructureDefinition-fi-base-information-custodian-private.md), [FI Base Information Custodian (Public Organization)](StructureDefinition-fi-base-information-custodian-public.md), [FI Base Information Custodian (Individual Provider)](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-information-custodian-individual.html)...Show 2 more,[FI Base Information Custodian (Private Organization)](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-information-custodian-private.html)and[FI Base Information Custodian (Public Organization)](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-information-custodian-public.html)
* Impose this profile Profile: [An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-kanta-document-metadata-profile.html)
* Examples for this Profile: [Provenance/id-for-provenance-1](Provenance-id-for-provenance-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-information-custodian)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

**Summary**

Mandatory: 9 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Provenance.agent
* The element 1 is sliced based on the value of Provenance.agent.role
* The element 1 is sliced based on the value of Provenance.agent.role.coding

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

**Summary**

Mandatory: 9 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Provenance.agent
* The element 1 is sliced based on the value of Provenance.agent.role
* The element 1 is sliced based on the value of Provenance.agent.role.coding

 

Other representations of profile: [CSV](StructureDefinition-fi-base-information-custodian.csv), [Excel](StructureDefinition-fi-base-information-custodian.xlsx), [Schematron](StructureDefinition-fi-base-information-custodian.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

