# FI Base Condition - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Condition**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-condition-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-condition-mappings.md) 
*  [XML](StructureDefinition-fi-base-condition.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-condition.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-condition.profile.ttl.md) 

## Resource Profile: FI Base Condition 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseCondition |

 
This is the Finnish base profile for the Condition resource. 

### Scope and Usage

`FiBaseReasonForCare` resource, FI Base Reason for Care (encounter-diagnosis and reason for visit), SHOULD be used for Diagnosis based conditions and Finnish **kayntisyy** conditions instead of this.

This profile MAY be used for describing reason given by patient for requesting/acquiring healthcare service (Finnish **tulosyy**).

**Usages:**

* Derived from this Profile: [FI Base Reason for Care (encounter-diagnosis and reason for visit)](StructureDefinition-fi-base-reason-for-care.md) and [FI Base Reason for Care (encounter-diagnosis and reason for visit)](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-reason-for-care.html)
* Refer to this Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md), [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [FI Base EpisodeOfCare](StructureDefinition-fi-base-episode-of-care.md), [Fi Base Immunization](StructureDefinition-fi-base-immunization.md)...Show 13 more,[FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md),[FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md),[FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Appointment](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-appointment.html),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[FI Base EpisodeOfCare](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-episode-of-care.html),[Fi Base Immunization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-immunization.html),[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html),[FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html),[FI Base Patient MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication-request.html)and[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-condition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-condition.csv), [Excel](StructureDefinition-fi-base-condition.xlsx), [Schematron](StructureDefinition-fi-base-condition.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

