# Provenance example for Kanta - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Provenance example for Kanta**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Provenance-custodian-public-healthcare-kela.xml.md) 
*  [JSON](Provenance-custodian-public-healthcare-kela.json.md) 
*  [TTL](Provenance-custodian-public-healthcare-kela.ttl.md) 

## Example Provenance: Provenance example for Kanta

This example has numerous errors. Please see the [QA report](qa.md) for a detailed explanation.

This example has been included into the implementation guide to demonstrate how the Provenance resource can be used in the way it is planned to be used in Kanta system, still basing the implementation on the Finnish base profile definitions.

**Generated Narrative: Provenance**

Resource Provenance "custodian-public-healthcare" 

Profile: [FI Base Information Custodian (Public Organization)](StructureDefinition-fi-base-information-custodian-public.md)

**target**: [EpisodeOfCare/id-for-episode-1](EpisodeOfCare-id-for-episode-1.md)

**recorded**: Aug 25, 2023, 1:42:17 PM

### Agents

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Role** | **Who** |
| * | Rekisterinpitäjä([ParticipationType](http://terminology.hl7.org/5.0.0/CodeSystem-v3-ParticipationType.html)#CST "custodian") | Julkinen(unknown#1) | : Pirkanmaan hyvinvointialueen rekisterinpitäjä |

### Entities

| | | |
| :--- | :--- | :--- |
| - | **Role** | **What** |
| * | source | : Julkinen terveydenhuolto |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

