# Licenced physician in primary care - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Licenced physician in primary care**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](PractitionerRole-PractitionerRoleGP.xml.md) 
*  [JSON](PractitionerRole-PractitionerRoleGP.json.md) 
*  [TTL](PractitionerRole-PractitionerRoleGP.ttl.md) 

## Example PractitionerRole: Licenced physician in primary care

Profile: [FI Base PractitionerRole](StructureDefinition-fi-base-practitioner-role.md)

**identifier**: `http://www.acme.org/practitioners`/23

**active**: true

**period**: 2023-01-01 --> 2023-12-31

**practitioner**: [Practitioner Dave Doctor](Practitioner-practitioner-licensed-physician.md)

**organization**: [Organization Kyyjärven lääkärin vastaanotto, Kyyjärven terveysasema, SoTe kuntayhtymä Saarikka](Organization-1.2.246.10.2085212.10.1314.md)

**code**: Referring Provider

**specialty**: General medical practice

**location**: [Location Kirurgian poliklinikka](Location-LocationExample.md)

**healthcareService**: [HealthcareService Vastaanottoaika*](HealthcareService-healthcareService-example.md)

> **availableTime****daysOfWeek**: Monday, Tuesday, Wednesday**availableStartTime**: 09:00:00**availableEndTime**: 16:30:00

> **availableTime****daysOfWeek**: Thursday, Friday**availableStartTime**: 09:00:00**availableEndTime**: 12:00:00

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

