# Finnish CodeSystem for security labels - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Finnish CodeSystem for security labels**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](CodeSystem-fi-base-security-label-cs.xml.md) 
*  [JSON](CodeSystem-fi-base-security-label-cs.json.md) 
*  [TTL](CodeSystem-fi-base-security-label-cs.ttl.md) 

## CodeSystem: Finnish CodeSystem for security labels 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/CodeSystem/fi-base-security-label-cs | *Version*:2.0.0 |
| Active as of 2025-10-05 | *Computable Name*:FiBaseSecurityLabelCS |

 
This is the CodeSystem for security labels in accordance with finnish authorities. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FiBaseSecurityLabelVS](ValueSet-fi-base-security-label-vs.md)

This case-insensitive code system `https://hl7.fi/fhir/finnish-base-profiles/CodeSystem/fi-base-security-label-cs` defines the following code:

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

