# Patient generated glucose observations and insulin administrations as a bundle, in Finnish - Finnish Base Profiles v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient generated glucose observations and insulin administrations as a bundle, in Finnish**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Bundle-diabetes-data-bundle.xml.md) 
*  [JSON](Bundle-diabetes-data-bundle.json.md) 
*  [TTL](Bundle-diabetes-data-bundle.ttl.md) 

## Example Bundle: Patient generated glucose observations and insulin administrations as a bundle, in Finnish

Bundle diabetes-data-bundle of type batch

-------

Entry 1 - fullUrl = urn:uuid:95f4ead5-0b1e-49aa-a484-53becbdd8c4d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 16.39:35
Kudossokeri: 7.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b22ac1c1-3c79-5960-bbce-5b93f12b64fa

```

-------

Entry 2 - fullUrl = urn:uuid:76f49e96-d5e8-4944-8427-2e6ee66c9d24

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 16.44:36
Kudossokeri: 7.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:de87d73b-6028-53a5-82f8-ea15524827d7

```

-------

Entry 3 - fullUrl = urn:uuid:728c019c-3d64-472f-b09b-9a455376ce8a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 16.49:37
Kudossokeri: 7.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:57193058-ae41-5f64-8d8f-cff9f07ee4e8

```

-------

Entry 4 - fullUrl = urn:uuid:d4f11039-d4f8-43cc-9c68-3a1088cce17d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 16.54:35
Kudossokeri: 7.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e757936f-bcbb-5f2d-9aa7-154c38514f89

```

-------

Entry 5 - fullUrl = urn:uuid:a5e87c1a-8045-42ea-a07f-234607fcf1e0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 16.59:35
Kudossokeri: 7.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:82b92c71-86e2-50d3-ac86-0f03663f9db8

```

-------

Entry 6 - fullUrl = urn:uuid:35fd88e0-72da-4a24-a1b5-6f213bce3b87

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.04:35
Kudossokeri: 7.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c43b64a4-6994-59b6-bd4e-faeab504243f

```

-------

Entry 7 - fullUrl = urn:uuid:6ea2fda9-e1f7-4e31-8f19-4fb5ba2ec76f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.09:35
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:137129b8-307a-5ee1-abf1-2c013845ae43

```

-------

Entry 8 - fullUrl = urn:uuid:03a52d70-c7f4-4d9b-a8bd-c98b1c6b55ac

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.14:35
Kudossokeri: 8.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9242b8e6-2801-511c-9c90-f244f1935a5d

```

-------

Entry 9 - fullUrl = urn:uuid:0fc01a96-e50d-4064-ae18-764ef8b89a4c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.19:36
Kudossokeri: 8.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:25948206-2a36-5f08-8fbb-4df594d042bd

```

-------

Entry 10 - fullUrl = urn:uuid:10715973-69b9-4e07-a882-c4e206e8512f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 17.23:17 - 17.28:16
Lyhytvaikutteinen insuliini 0.07 ky (0.79 ky/t, 1.13 % = 0.89 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6d6425e4-5f32-5db2-a8bf-dd4370983619

```

-------

Entry 11 - fullUrl = urn:uuid:35082cce-e7c0-48dd-abd3-a4a1fafeb922

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.24:35
Kudossokeri: 8.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56077fc9-0be9-5108-9a03-e95172c02a77

```

-------

Entry 12 - fullUrl = urn:uuid:ba10a72b-8844-4502-80f5-c46de9115251

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 17.28:16 - 17.33:17
Lyhytvaikutteinen insuliini 0.07 ky (0.82 ky/t, 1.17 % = 0.95 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d4f18bf1-f677-508a-a797-c0b2897b8c45

```

-------

Entry 13 - fullUrl = urn:uuid:3477b8d3-428e-441b-8036-9b168c3aec25

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.29:34
Kudossokeri: 9.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9c8845cd-8c19-50cb-9ab0-06c1f7d9171c

```

-------

Entry 14 - fullUrl = urn:uuid:af6304ac-6366-4679-a600-6c97fa5fddd0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 17.33:17 - 17.38:18
Lyhytvaikutteinen insuliini 0.16 ky (1.94 ky/t, 2.77 % = 5.37 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cf58a48c-ab45-5a75-ac17-ff831693854f

```

-------

Entry 15 - fullUrl = urn:uuid:280d4016-9759-41f1-8331-ebe6233db976

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 17.33:53
Lyhytvaikutteinen insuliini 1.26 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b6cbb1f5-e3c6-53d8-9410-0ed95332b3b6

```

-------

Entry 16 - fullUrl = urn:uuid:98a39689-e51c-4228-b4ea-79c6e71360ec

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.34:35
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0bad311e-8b20-5a82-8400-34536b2ae697

```

-------

Entry 17 - fullUrl = urn:uuid:df68e3e4-c033-441e-8856-35f8d16ce566

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 17.38:18 - 18.21:18
Lyhytvaikutteinen insuliini 0.50 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dcdc2c26-fdce-58d3-bee2-281fda1b8759

```

-------

Entry 18 - fullUrl = urn:uuid:f0996faa-2c7c-4f97-8fc9-9243847afa5b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.39:34
Kudossokeri: 9.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:19240cdb-2f8f-5b03-9ff9-73431cbb5782

```

-------

Entry 19 - fullUrl = urn:uuid:c6cb2f26-65a4-4e80-9480-b68832716d48

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.44:37
Kudossokeri: 9.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:23d0d2e3-7573-54b8-95a1-65ce2abf7354

```

-------

Entry 20 - fullUrl = urn:uuid:496c6725-8b01-47f4-aebc-de3723b15575

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.49:37
Kudossokeri: 10.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4a95e1f8-fcc2-5507-a1aa-566b89d50952

```

-------

Entry 21 - fullUrl = urn:uuid:dd5966e0-055a-4239-bc97-d6729e9c1dce

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.54:36
Kudossokeri: 10.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fd04ff40-a1b3-5d9f-a317-0b409c155774

```

-------

Entry 22 - fullUrl = urn:uuid:78bc3367-5e76-44ce-a7a2-4b919ebf8b7b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 17.59:35
Kudossokeri: 10.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ba5da950-df73-5ce5-9618-e5802b119ba9

```

-------

Entry 23 - fullUrl = urn:uuid:27be5ae9-b7b2-454e-9dd2-362e718ea491

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.04:36
Kudossokeri: 10.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:71c84605-3b9b-5991-86b0-df28b5565eee

```

-------

Entry 24 - fullUrl = urn:uuid:ef422192-af94-4040-ac21-f69efc26f02e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.09:36
Kudossokeri: 10.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:50957470-e531-5498-88ed-b011f7583d50

```

-------

Entry 25 - fullUrl = urn:uuid:c9706d1d-c29b-40ef-bd99-ef5c5be68f34

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.14:36
Kudossokeri: 10.93 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:40b9ea49-248b-541b-a214-619165daf618

```

-------

Entry 26 - fullUrl = urn:uuid:84c37f9c-608a-4a59-84b6-233b3b33f3c6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.19:36
Kudossokeri: 11.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6435bc83-e6f8-58c5-babb-f1c460f821db

```

-------

Entry 27 - fullUrl = urn:uuid:3bddc501-82bc-47d1-825a-c29082eb1df9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 18.21:18 - 18.26:17
Lyhytvaikutteinen insuliini 0.06 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:198f1ce1-4ecd-5858-a150-0a35da6dedde

```

-------

Entry 28 - fullUrl = urn:uuid:5443cae5-94f6-465d-aee6-b3a33c94697b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.24:36
Kudossokeri: 10.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:86d5cb04-806f-53ad-92af-b43f090d580e

```

-------

Entry 29 - fullUrl = urn:uuid:d7d9793e-19ef-403b-9d10-1c31a75eecd6

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 18.26:17 - 18.28:26
Lyhytvaikutteinen insuliini 0.03 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fbc1dcfa-08d9-516a-ae47-b76f98b5c261

```

-------

Entry 30 - fullUrl = urn:uuid:479cf2ee-5e38-44bc-a2dc-ca43be929e73

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 18.28:26 - 18.33:28
Lyhytvaikutteinen insuliini 0.13 ky (1.59 ky/t, 2.27 % = 3.62 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ead16013-e020-5088-919d-a0b301017ec6

```

-------

Entry 31 - fullUrl = urn:uuid:cd55a9a3-5d86-4b1d-985d-d62616c388e3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.29:36
Kudossokeri: 10.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b529f5d7-0112-5609-83ff-fcf649bb5b54

```

-------

Entry 32 - fullUrl = urn:uuid:cdd003c6-e6a1-4da7-9549-8169bff30fc5

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 18.33:28 - 18.58:32
Lyhytvaikutteinen insuliini 0.29 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:28729ec0-5b6b-5307-bfd6-2313a3d2197d

```

-------

Entry 33 - fullUrl = urn:uuid:4bf74a0d-a581-4eb5-9ad9-c82796bb4fb2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.34:34
Kudossokeri: 9.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:89e54fce-acfa-5995-b49a-7041038a8942

```

-------

Entry 34 - fullUrl = urn:uuid:a6165d09-d193-40b7-acb2-6fb98c2f49ec

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.39:34
Kudossokeri: 9.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bbf06ad2-fec3-5e72-8510-a2ec16eebbea

```

-------

Entry 35 - fullUrl = urn:uuid:10685e42-cb16-4a20-9c23-fa8381c28d52

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.44:34
Kudossokeri: 9.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a9d380d1-36e0-59b5-ab65-2ca080a327d4

```

-------

Entry 36 - fullUrl = urn:uuid:710c9644-eab9-4bf9-b0c3-2f6050b100fb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.49:37
Kudossokeri: 9.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d90e4f8c-73e3-50f5-9808-15006924bcb0

```

-------

Entry 37 - fullUrl = urn:uuid:d9dfdad2-a9a2-41d2-b011-f810e6385408

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.54:34
Kudossokeri: 9.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:51a0788c-0b74-5d34-a784-6864a95fd143

```

-------

Entry 38 - fullUrl = urn:uuid:fb3f634a-ad6a-4588-b329-37ba28471e0a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 18.58:32 - 19.03:33
Lyhytvaikutteinen insuliini 0.07 ky (0.85 ky/t, 1.22 % = 1.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2539547a-8cbf-566d-af15-1bd43a9082b5

```

-------

Entry 39 - fullUrl = urn:uuid:463bb484-01f1-4777-bbde-e21857b3ef45

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 18.59:34
Kudossokeri: 9.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:92277535-83fc-540d-8908-3a442b0fab77

```

-------

Entry 40 - fullUrl = urn:uuid:dbaba8dd-230a-443d-bc7b-ee95d048d7c6

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.03:33 - 19.08:33
Lyhytvaikutteinen insuliini 0.07 ky (0.78 ky/t, 1.12 % = 0.87 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:daeebcff-6789-5079-8fe6-f0b80e9c0d63

```

-------

Entry 41 - fullUrl = urn:uuid:0349b469-c322-4495-873d-f4748c5f90fd

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.04:34
Kudossokeri: 9.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e89217df-ac4e-5a9a-9ced-7ff977afe53f

```

-------

Entry 42 - fullUrl = urn:uuid:263478b7-7dc9-48fb-ab98-193974fb4280

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.08:33 - 19.13:35
Lyhytvaikutteinen insuliini 0.07 ky (0.89 ky/t, 1.27 % = 1.13 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3ed836cc-58cf-56ed-a335-bfd3fd27b2a3

```

-------

Entry 43 - fullUrl = urn:uuid:65fc8f5f-e005-4745-b9eb-a035295f458c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.09:34
Kudossokeri: 10.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0de2ca67-1c08-53fe-9b68-3c2d3fd7e3dd

```

-------

Entry 44 - fullUrl = urn:uuid:f2f42838-d5f2-4738-ba98-476abfbc9d5d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.13:35 - 19.18:35
Lyhytvaikutteinen insuliini 0.11 ky (1.31 ky/t, 1.87 % = 2.44 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dbab71d3-db2b-5aca-8be4-dedccdc4f26f

```

-------

Entry 45 - fullUrl = urn:uuid:d079a907-4ded-45c4-b73d-90467ed1e47d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.13:48
Lyhytvaikutteinen insuliini 1.07 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a41e3987-cb6f-5224-8ea2-2a5a35125a22

```

-------

Entry 46 - fullUrl = urn:uuid:bde29e64-5a01-424f-bc19-6dd922d3936c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.14:34
Kudossokeri: 10.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c2de2886-fa1c-56b4-a25c-787f650037b5

```

-------

Entry 47 - fullUrl = urn:uuid:0e46d228-09af-43c2-a0c8-edcf6bb98d56

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.18:35 - 19.28:37
Lyhytvaikutteinen insuliini 0.12 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8da5d5b6-8736-5cc6-8dec-820677e6d360

```

-------

Entry 48 - fullUrl = urn:uuid:827b33a0-7298-4e04-9ded-debe26445354

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.19:34
Kudossokeri: 10.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d3e4926c-fe12-59e7-a53d-9936cac28a3e

```

-------

Entry 49 - fullUrl = urn:uuid:c9ee244f-3c5b-4a18-a8b3-25c70800200f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.24:34
Kudossokeri: 10.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:146ffbd2-f121-5943-ab19-40b5aefbff1f

```

-------

Entry 50 - fullUrl = urn:uuid:110566f1-2e88-4d10-b730-9e99a1dba004

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.28:37 - 19.33:37
Lyhytvaikutteinen insuliini 0.09 ky (1.08 ky/t, 1.55 % = 1.67 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:52ef3f56-b790-586e-8ca2-73829fabc251

```

-------

Entry 51 - fullUrl = urn:uuid:51b68602-96d4-47de-991c-659b80fe2211

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.29:35
Kudossokeri: 10.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:33c463e0-f877-529b-9165-bdcc04b3cc72

```

-------

Entry 52 - fullUrl = urn:uuid:fa4a4e58-36d6-4a07-8a8c-d5af73d1a245

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.33:37 - 19.38:39
Lyhytvaikutteinen insuliini 0.07 ky (0.82 ky/t, 1.17 % = 0.96 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6e67f774-48c7-591a-9086-1f505e9c2521

```

-------

Entry 53 - fullUrl = urn:uuid:0adf008d-51b3-4445-b35f-bfe87a938650

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.34:34
Kudossokeri: 11.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:205adcb7-1055-519a-8df5-c44ed577d6ad

```

-------

Entry 54 - fullUrl = urn:uuid:d88954da-fa50-4cb9-b75c-a233fa5c2d48

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.38:39 - 19.43:39
Lyhytvaikutteinen insuliini 0.10 ky (1.18 ky/t, 1.68 % = 1.99 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d5cb4843-5a55-5085-9040-eda372ae2eb3

```

-------

Entry 55 - fullUrl = urn:uuid:38d7491d-0779-48ef-a25a-151ee22bde58

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.39:34
Kudossokeri: 11.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b2ae855e-02f9-5f13-8e7d-f3e06928eea4

```

-------

Entry 56 - fullUrl = urn:uuid:c622212f-0e35-4b0e-8f87-b9eb485f8a36

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.43:39 - 19.48:40
Lyhytvaikutteinen insuliini 0.14 ky (1.68 ky/t, 2.40 % = 4.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f0a9655b-7f68-5873-bb5b-4254dc1c52f9

```

-------

Entry 57 - fullUrl = urn:uuid:cb883415-f1c9-4c23-bc30-8844250fbf67

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.44:34
Kudossokeri: 11.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5b23bc60-c910-56b6-9359-be3053582c1c

```

-------

Entry 58 - fullUrl = urn:uuid:0aabd6fa-c69d-4ba6-9758-cbcbe4a2c942

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.48:40 - 19.53:40
Lyhytvaikutteinen insuliini 0.15 ky (1.83 ky/t, 2.62 % = 4.79 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a88c9c92-bf06-5aa6-9c5a-d2156ef29cce

```

-------

Entry 59 - fullUrl = urn:uuid:1215e4d2-c3fe-4485-ba17-70cd6209ed11

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.49:34
Kudossokeri: 11.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:42f3440b-a3cb-5162-8773-fe4114054e48

```

-------

Entry 60 - fullUrl = urn:uuid:abc79a1c-c527-4a12-91a0-785ae3cc8ae2

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.53:40 - 19.58:41
Lyhytvaikutteinen insuliini 0.15 ky (1.76 ky/t, 2.51 % = 4.41 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a7b319c8-9f36-5463-8db2-db606652419e

```

-------

Entry 61 - fullUrl = urn:uuid:54734618-9f8f-4b0a-890b-49862b417796

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.54:34
Kudossokeri: 11.93 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0ddc323e-a402-5e21-94f7-98270b5d20a3

```

-------

Entry 62 - fullUrl = urn:uuid:06698d1c-8c11-4a57-aa05-d9acc61bfebc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 19.58:41 - 20.03:43
Lyhytvaikutteinen insuliini 0.14 ky (1.70 ky/t, 2.43 % = 4.12 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3acd8fea-4c47-50eb-8a03-e170f5a5e824

```

-------

Entry 63 - fullUrl = urn:uuid:f9925a2a-c063-493a-91f8-bbcf9a6cc39f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 19.59:34
Kudossokeri: 12.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ca952fb3-9a8b-5d88-b2f0-10a46bf7ad5c

```

-------

Entry 64 - fullUrl = urn:uuid:ed532873-9ea3-48d5-96f3-26d82725a088

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 20.03:43 - 20.08:44
Lyhytvaikutteinen insuliini 0.14 ky (1.73 ky/t, 2.47 % = 4.28 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:19150195-4ad7-51db-8790-6f9c7c8119d3

```

-------

Entry 65 - fullUrl = urn:uuid:0220906c-416c-44de-8590-5401361dc4bf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.04:34
Kudossokeri: 12.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a342f423-a9a0-5b78-8a28-2683eea4f50e

```

-------

Entry 66 - fullUrl = urn:uuid:ae3d7ce1-6efc-4f95-a214-d4706ce0c798

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 20.08:44 - 20.13:43
Lyhytvaikutteinen insuliini 0.16 ky (1.94 ky/t, 2.77 % = 5.38 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e67f4df8-025c-5fbf-ab54-0d3f56681b3f

```

-------

Entry 67 - fullUrl = urn:uuid:b31e936d-5c6e-4b0b-a2c0-58fc9a325277

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.09:34
Kudossokeri: 12.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ad7c8d13-4df5-59cd-b0b7-8e5559071f8e

```

-------

Entry 68 - fullUrl = urn:uuid:26939fb3-bb04-493f-8453-b5b90cbc2644

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 20.13:43 - 20.18:46
Lyhytvaikutteinen insuliini 0.18 ky (2.16 ky/t, 3.09 % = 6.67 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:48327d62-10c6-52f6-b6d5-45406a3a27ad

```

-------

Entry 69 - fullUrl = urn:uuid:ec79515d-265e-44e0-94f6-073bd8362e8c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.14:34
Kudossokeri: 12.54 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9236a1fd-161a-581b-a40d-52f0f862e719

```

-------

Entry 70 - fullUrl = urn:uuid:eec1b737-95dd-46fc-80f8-1a528bb15d03

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 20.18:46 - 20.23:46
Lyhytvaikutteinen insuliini 0.19 ky (2.33 ky/t, 3.33 % = 7.74 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2ef2468b-00df-55b9-919d-5cc5beddfde5

```

-------

Entry 71 - fullUrl = urn:uuid:71c3a347-1ca1-4488-b59e-f045cd3acbff

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 20.19:00
Lyhytvaikutteinen insuliini 1.37 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:52a9d252-299d-58b5-b2d6-d8840970abe2

```

-------

Entry 72 - fullUrl = urn:uuid:0bc0e54d-6006-4667-9547-7c045c15c419

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.19:34
Kudossokeri: 12.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ef4606cc-f1ec-5fe3-9efc-81167c6dc5bb

```

-------

Entry 73 - fullUrl = urn:uuid:0ba688cd-ac8a-4ffc-b2f9-62c6b808a44d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 20.23:46 - 22.09:02
Lyhytvaikutteinen insuliini 1.23 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1ea93203-9da2-56c4-be45-513e3049e67b

```

-------

Entry 74 - fullUrl = urn:uuid:d85497a8-2243-4210-80ab-ee0a0e8e0ee1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.24:35
Kudossokeri: 12.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a9c9f6e0-d5a0-56d1-bbe1-236434ce1b2b

```

-------

Entry 75 - fullUrl = urn:uuid:accb8f24-f4a8-42f8-9aeb-e3bb74d06476

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.29:35
Kudossokeri: 12.54 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8ff2c94c-2d2f-5c0c-a851-db8a52cdfc65

```

-------

Entry 76 - fullUrl = urn:uuid:d968c1ab-1b23-46c1-a57d-83e5fe5f2049

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.34:34
Kudossokeri: 12.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9dbe562e-17f5-55a1-a10d-43a1649a76a3

```

-------

Entry 77 - fullUrl = urn:uuid:0d969c19-91c7-4310-9237-3dfe62b14953

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.39:34
Kudossokeri: 11.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bd505b9d-daec-5cfe-a7c5-51b99e30bb11

```

-------

Entry 78 - fullUrl = urn:uuid:f17d1177-2280-4018-94e3-c387c6cfd826

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.44:34
Kudossokeri: 11.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5955f7c1-c8a7-549c-84fe-9386fe01b1df

```

-------

Entry 79 - fullUrl = urn:uuid:346b52f4-d825-4741-9544-b32c9113f0fa

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.49:34
Kudossokeri: 11.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:abbafa46-2b3f-5d7f-bda0-8009a522916a

```

-------

Entry 80 - fullUrl = urn:uuid:078233bc-0de9-4d55-a5ce-60de48697dc2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.54:34
Kudossokeri: 11.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:92579942-ff36-5632-8ee1-1db0bd73631f

```

-------

Entry 81 - fullUrl = urn:uuid:075d9fa5-b1a6-4468-bb84-402b141106bb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 20.59:34
Kudossokeri: 11.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:21e61914-8ccf-5c0b-b2aa-b5a232924d3f

```

-------

Entry 82 - fullUrl = urn:uuid:1201bedd-6db3-450a-93d5-0c2511019d1f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.04:34
Kudossokeri: 10.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c17b2a60-057d-5e1e-88f7-c85f80b97c17

```

-------

Entry 83 - fullUrl = urn:uuid:dd28bbfb-dcbf-48ee-b8f7-2a8f95b35ea7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.09:34
Kudossokeri: 10.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e26a7c7b-5289-57af-aa9b-bf582079650a

```

-------

Entry 84 - fullUrl = urn:uuid:d06fcf4f-cadb-44a5-9835-df3317e14156

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.14:34
Kudossokeri: 10.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f9774981-b655-5fc1-9f56-eaf671dcb4c6

```

-------

Entry 85 - fullUrl = urn:uuid:d460b442-0a18-41c4-b342-8adca54e1524

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.19:35
Kudossokeri: 10.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:13fa32e9-aff5-5d3a-ba7f-c16ccf26506b

```

-------

Entry 86 - fullUrl = urn:uuid:af48bde7-5ae8-4f32-b5d6-9d92b3c76364

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.24:34
Kudossokeri: 9.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9ea99a3d-e9e3-5a56-89fc-26dad8836e8d

```

-------

Entry 87 - fullUrl = urn:uuid:7e5dc833-8ef0-4808-9cac-243acb038143

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.29:34
Kudossokeri: 9.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e0ff561e-7df9-5dec-96c3-2b51e7b0247a

```

-------

Entry 88 - fullUrl = urn:uuid:85e64276-c634-4d64-bf06-0f25aa509d44

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.34:35
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3b6dad7a-429b-5688-8c68-0d4d03316957

```

-------

Entry 89 - fullUrl = urn:uuid:5bf1f1c8-6b5a-40a5-bd8b-075f2299b741

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.39:34
Kudossokeri: 8.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a6c1b45a-115a-5c51-a78e-56a19fbfb062

```

-------

Entry 90 - fullUrl = urn:uuid:be7f70e3-66be-44ba-837c-09aaf8a28182

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.44:34
Kudossokeri: 8.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:139bc904-7a78-544a-8205-1d738176cbcd

```

-------

Entry 91 - fullUrl = urn:uuid:a01456a0-0580-4f6d-9cb9-02aab3f20219

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.49:34
Kudossokeri: 8.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f5efb224-00a4-55e1-8cc6-b840406f7bcc

```

-------

Entry 92 - fullUrl = urn:uuid:15bee9fb-b4ed-4f1d-90b8-7c191d5fe854

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.54:34
Kudossokeri: 8.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5cce1f68-0daa-5c36-9347-72153acefba6

```

-------

Entry 93 - fullUrl = urn:uuid:3c8da328-ae66-4889-a03d-1f97557ece29

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 21.59:34
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eb15c525-dc5b-5114-b27e-39832e8054b3

```

-------

Entry 94 - fullUrl = urn:uuid:e8742462-ee8f-41fa-8e72-fcdc41ef7ed3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.04:34
Kudossokeri: 7.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c276ae2b-8994-59d0-a105-ad3d5a482c2b

```

-------

Entry 95 - fullUrl = urn:uuid:ab63a2c5-e28e-47eb-8c0b-faf797f759f4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.09:02 - 22.14:03
Lyhytvaikutteinen insuliini 0.02 ky (0.18 ky/t, 0.26 % = 0.05 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b8de4969-d09f-5ad0-ab09-740ec461ae96

```

-------

Entry 96 - fullUrl = urn:uuid:a76cbea9-e69f-4ba8-8ffa-949e42b1fcbb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.09:34
Kudossokeri: 6.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e335d048-bdd4-55a0-869c-2c6d37b880ec

```

-------

Entry 97 - fullUrl = urn:uuid:44f84091-0190-4805-8124-87d37b9ba332

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.14:03 - 22.24:05
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:33d06453-01c3-5352-ada2-69572cb9a744

```

-------

Entry 98 - fullUrl = urn:uuid:785b0504-45e4-462b-bd12-3381fde7e5f8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.14:34
Kudossokeri: 6.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:22a9153a-e0f2-53b5-94fd-a3f4ca142249

```

-------

Entry 99 - fullUrl = urn:uuid:5c0dad83-2394-4c1c-a773-b9ae7661d1c5

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.15:14
Lyhytvaikutteinen insuliini 2.50 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9c049fa0-900d-54d9-8bd5-a552b4f09760

```

-------

Entry 100 - fullUrl = urn:uuid:8d6f8eaf-ad53-4781-954e-1e42ad03b53a

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 4.9.2021 22.15:14
Arvioitu hiilihydraattimäärä: 30 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:120a2e07-33dc-5fe6-a92b-2d348c5d7665

```

-------

Entry 101 - fullUrl = urn:uuid:75f4c8ad-c2de-4627-88c4-a57e6308cba4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.19:34
Kudossokeri: 6.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:78accb51-8dc1-575f-96bc-47af2eaac724

```

-------

Entry 102 - fullUrl = urn:uuid:e9869d7a-c129-40d8-b3f8-5a02ff52bc94

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.24:05 - 22.29:05
Lyhytvaikutteinen insuliini 0.05 ky (0.62 ky/t, 0.88 % = 0.54 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:80ce2b35-7779-50c5-b3b2-6a1eaf37dedf

```

-------

Entry 103 - fullUrl = urn:uuid:69282133-f484-478c-a311-d6a1c37cc320

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.24:34
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1ced58ad-5526-5d46-846c-12f644568cfc

```

-------

Entry 104 - fullUrl = urn:uuid:a79ce6b0-3a7f-41d0-8977-ab3ad910840d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.29:05 - 22.34:06
Lyhytvaikutteinen insuliini 0.03 ky (0.32 ky/t, 0.46 % = 0.15 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2a4f0c40-9293-5262-b06e-6457ef239a3b

```

-------

Entry 105 - fullUrl = urn:uuid:58fac10b-7974-4241-a08f-b8d2bb1ccec0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.29:34
Kudossokeri: 6.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e91e8283-9b83-5f11-a9b1-f708a2cb57e3

```

-------

Entry 106 - fullUrl = urn:uuid:aa152dab-00be-4599-875e-27ec9043fbaa

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.34:06 - 22.39:07
Lyhytvaikutteinen insuliini 0.05 ky (0.64 ky/t, 0.91 % = 0.59 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ff1cb5d8-56dc-55f7-93d9-cefe33cc6311

```

-------

Entry 107 - fullUrl = urn:uuid:9fb5655b-2059-444a-899e-90a0a07f2937

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.34:34
Kudossokeri: 6.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2d26424-23eb-5b7e-9b61-c2450ebb062f

```

-------

Entry 108 - fullUrl = urn:uuid:9777de80-62fc-484e-9317-b24fe2b70c57

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.39:07 - 22.44:08
Lyhytvaikutteinen insuliini 0.06 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:50a603cb-d1f8-5120-ae22-a6be2f48603c

```

-------

Entry 109 - fullUrl = urn:uuid:1513b27e-2502-4a94-a268-965937f5aefd

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.39:34
Kudossokeri: 6.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:08081a53-439a-5a77-a463-dedff51e7c6f

```

-------

Entry 110 - fullUrl = urn:uuid:84daa7f4-009b-43d9-b75a-774707a9fc6d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.44:08 - 22.49:09
Lyhytvaikutteinen insuliini 0.06 ky (0.69 ky/t, 0.98 % = 0.68 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:946b8c74-76d4-5c2e-b3dd-2888c26ef8cd

```

-------

Entry 111 - fullUrl = urn:uuid:dcd8d95c-58d5-4f20-87b2-f0cf5ebfe30c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.44:34
Kudossokeri: 5.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:74799fe8-2dad-5f0b-8cb6-9dd37f92dad5

```

-------

Entry 112 - fullUrl = urn:uuid:dd2f9d0a-bdce-484a-8298-734c63769c18

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.49:09 - 22.54:10
Lyhytvaikutteinen insuliini 0.02 ky (0.23 ky/t, 0.33 % = 0.07 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bf2df4c9-3163-580e-bf9e-a58d297dc77e

```

-------

Entry 113 - fullUrl = urn:uuid:2002085e-b66f-4bd2-b593-4a07fddffbba

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.49:34
Kudossokeri: 5.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dc9aac9b-21ae-554d-9b2c-0e1066e75565

```

-------

Entry 114 - fullUrl = urn:uuid:2deaa79f-a179-4239-9ffa-ea99a35d201d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.54:10 - 22.59:11
Lyhytvaikutteinen insuliini 0.02 ky (0.21 ky/t, 0.31 % = 0.07 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e5f36fb3-4edb-5bed-9a86-a9b29f7b96aa

```

-------

Entry 115 - fullUrl = urn:uuid:0e976933-447f-4d78-9637-899fa5ba38bc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.54:34
Kudossokeri: 5.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:90ff3fca-5b5c-5f67-828d-cbd49011491d

```

-------

Entry 116 - fullUrl = urn:uuid:7ae3f77e-b955-41de-a898-07692e546628

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 22.59:11 - 23.04:11
Lyhytvaikutteinen insuliini 0.01 ky (0.11 ky/t, 0.16 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:63a8979c-ea77-59b4-92b2-b791b4634916

```

-------

Entry 117 - fullUrl = urn:uuid:57c0eb01-b0a8-4c7c-aa7c-11098f01614c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 22.59:34
Kudossokeri: 4.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:578be8c0-0e9b-5f44-8d81-3f3e058349a3

```

-------

Entry 118 - fullUrl = urn:uuid:cef2f932-4efa-4187-bb70-b2221ec4418c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.04:11 - 23.24:14
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:645988d3-55b0-5db2-892f-7294da632753

```

-------

Entry 119 - fullUrl = urn:uuid:1e012e9d-7c67-40d0-9db8-7e2d0ad3c15a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.04:35
Kudossokeri: 5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d8a9cd85-d3d5-5817-8ef7-013a711b19a7

```

-------

Entry 120 - fullUrl = urn:uuid:99087c4e-79f7-49c0-aeae-a0b112b140a2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.09:35
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9d4be3c4-2b35-5f6b-8f97-a9833ad1c952

```

-------

Entry 121 - fullUrl = urn:uuid:1bebc55c-02a6-4fc9-a398-e446869a52a1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.14:35
Kudossokeri: 5.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:88f6f2ce-7cf6-5dc2-8628-1235ada2b112

```

-------

Entry 122 - fullUrl = urn:uuid:75d7a1fc-53e4-415e-9a87-2c2b86b72702

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.19:34
Kudossokeri: 5.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2041b661-bcf4-5f3a-8e28-2e93312c54db

```

-------

Entry 123 - fullUrl = urn:uuid:c20b2dd8-cb3a-4cfa-abac-aeafa561f02d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.24:14 - 23.29:14
Lyhytvaikutteinen insuliini 0.01 ky (0.12 ky/t, 0.16 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4cc06781-b967-51ea-8290-cf8cbbae7241

```

-------

Entry 124 - fullUrl = urn:uuid:2dcb78d9-959b-43a0-85fd-6887e50b008d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.24:33
Kudossokeri: 5.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:87cb3abd-c7ed-5a86-acb7-e9f2f4772770

```

-------

Entry 125 - fullUrl = urn:uuid:8684d294-510b-4ba4-adb7-173b14739fb1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.29:14 - 23.34:16
Lyhytvaikutteinen insuliini 0.01 ky (0.17 ky/t, 0.23 % = 0.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bab925fa-fa66-5001-994b-39ecf07abdb3

```

-------

Entry 126 - fullUrl = urn:uuid:d4be4e79-196b-404d-afc3-01427e6441b3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.29:33
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7b745a27-45b2-56b8-ad66-d0ec033895ff

```

-------

Entry 127 - fullUrl = urn:uuid:20b7fa0f-2b6d-47e3-bc03-6a510a6e90bc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.34:16 - 23.44:17
Lyhytvaikutteinen insuliini 0.13 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f585c764-e00b-5a02-a6e0-c973a420e54e

```

-------

Entry 128 - fullUrl = urn:uuid:3af38f35-adc7-4925-85ff-cb575a3f98c4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.34:34
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cf37cb2c-6e67-5403-bd60-9b280b82d262

```

-------

Entry 129 - fullUrl = urn:uuid:38ed14cf-b855-40b6-8f6c-5ac0484e9345

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.39:34
Kudossokeri: 5.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fba4de74-00f1-5ff3-8449-c67e95caf0b4

```

-------

Entry 130 - fullUrl = urn:uuid:76038395-1cac-44bd-915a-c5f5a06999f9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.44:17 - 23.49:18
Lyhytvaikutteinen insuliini 0.04 ky (0.51 ky/t, 0.67 % = 0.34 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8342531d-d9d5-5a4f-9d67-552db242f4bd

```

-------

Entry 131 - fullUrl = urn:uuid:5c8b2bc5-9144-40bf-a991-d89611ba26b1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.44:34
Kudossokeri: 5.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:65516149-3cc9-597c-8f66-102c47e6da4d

```

-------

Entry 132 - fullUrl = urn:uuid:4831449e-08c9-40d8-add9-1b91278c291a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.49:18 - 23.54:20
Lyhytvaikutteinen insuliini 0.01 ky (0.13 ky/t, 0.17 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e1cf2bb5-eedc-5584-aee5-3bf752199e20

```

-------

Entry 133 - fullUrl = urn:uuid:c6f09997-a3fa-4352-9971-7cf8df5d3b55

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.49:34
Kudossokeri: 5.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0713498c-19f2-5ac6-bc84-9be784b3dbc8

```

-------

Entry 134 - fullUrl = urn:uuid:0195f748-7287-4be0-bfb9-44afae77eb95

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.54:20 - 23.59:20
Lyhytvaikutteinen insuliini 0.01 ky (0.12 ky/t, 0.15 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:53fa6958-efa2-50d1-9185-83eb643c81a3

```

-------

Entry 135 - fullUrl = urn:uuid:52693a8c-a51f-4011-ab6e-84134fc4ec00

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.54:33
Kudossokeri: 5.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:89b8cc8b-2510-5d9d-affb-c36b69486c65

```

-------

Entry 136 - fullUrl = urn:uuid:a71d48ce-48b9-4d1b-a294-ae95309dfe96

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 4.9.2021 23.59:20 - 5.9.2021 00.00:00
Lyhytvaikutteinen insuliini 0.00 ky (0.13 ky/t, 0.17 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:78b76d7f-47aa-5874-95b0-30b6951d6ec9

```

-------

Entry 137 - fullUrl = urn:uuid:2315ec63-abb5-4e5b-8a0a-2438afe488f7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 4.9.2021 23.59:33
Kudossokeri: 5.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f3548ca0-1003-593f-a559-88f98c574b7e

```

-------

Entry 138 - fullUrl = urn:uuid:f6ac2129-89d3-4382-87b1-6318ab298ccf

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 00.00:00 - 00.02:30
Lyhytvaikutteinen insuliini 0.01 ky (0.12600000202655792 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ac6a047e-558c-5c55-b1de-7645c21b5319

```

-------

Entry 139 - fullUrl = urn:uuid:5a7085ce-83d6-4839-8609-1fce3530758a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 00.02:30 - 00.22:06
Lyhytvaikutteinen insuliini 0.00 ky (0 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9f2541ff-15f7-5a8a-9df8-de826874f67b

```

-------

Entry 140 - fullUrl = urn:uuid:01981957-691c-4c0f-8ee0-8f8d1fc80e29

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.04:33
Kudossokeri: 4.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:54367329-2dc5-5d17-9d79-e9696869516b

```

-------

Entry 141 - fullUrl = urn:uuid:e85ebcb9-4430-47e5-988e-42eabdfe0d4a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.09:33
Kudossokeri: 4.5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1c6973b-05a0-5582-992e-c77606b6a7cd

```

-------

Entry 142 - fullUrl = urn:uuid:0ea09022-1643-4604-8b99-963944527898

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.14:34
Kudossokeri: 4.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80a5462d-1f2e-5983-bfec-006afe32ec80

```

-------

Entry 143 - fullUrl = urn:uuid:f5c980bc-660e-48f1-a4f8-0961fa37b1c3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.19:34
Kudossokeri: 3.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c6d576d-00ec-5afd-a7e6-46dd55885645

```

-------

Entry 144 - fullUrl = urn:uuid:1f78645d-eeb6-456a-9a88-6440c59a1bc5

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 00.22:06 - 01.57:19
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bc3db4d7-b9bc-5412-9e45-e515498245ae

```

-------

Entry 145 - fullUrl = urn:uuid:288cf7cc-579e-483f-8b95-c622fd55e79c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.24:34
Kudossokeri: 3.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a62d032a-1001-5687-80b7-39901b1c459f

```

-------

Entry 146 - fullUrl = urn:uuid:27a8ccf1-b14b-4f7f-be2c-429051d30cef

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.29:33
Kudossokeri: 2.78 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5d931fef-3d57-5fe4-aa02-9f54bb58a012

```

-------

Entry 147 - fullUrl = urn:uuid:b126d957-6047-40c8-be31-ca626ebbb0a1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.34:33
Kudossokeri: 2.89 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:698c5e9c-c9d2-5e7d-a7bb-80e8f9dab963

```

-------

Entry 148 - fullUrl = urn:uuid:f0918db2-a6b4-4fe9-8822-57b24ad43ff3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.39:33
Kudossokeri: 3.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f3633d78-79a1-5e81-9aad-cd1a07959943

```

-------

Entry 149 - fullUrl = urn:uuid:1d0622c5-a7b0-425c-a5da-2833264e4768

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.44:33
Kudossokeri: 3.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:becb09b6-b763-5395-88a5-b65717ac73ec

```

-------

Entry 150 - fullUrl = urn:uuid:9d2199f3-9ca0-4134-9e3a-09fd244e5985

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.49:33
Kudossokeri: 3.39 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9b320788-c7f0-55b7-9af5-1e809515a96a

```

-------

Entry 151 - fullUrl = urn:uuid:b74b3b5f-e579-41a5-a24c-1418519412f2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.54:33
Kudossokeri: 3.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:51b5a580-767a-59be-816b-814206cf4ce2

```

-------

Entry 152 - fullUrl = urn:uuid:f9a3937a-bd3c-4b3c-89c4-093104c2933b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 00.59:33
Kudossokeri: 3.5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:26ed3be4-7c4a-5cca-85d5-37f87dd5ef3c

```

-------

Entry 153 - fullUrl = urn:uuid:77256546-b421-44b1-902d-b0d4ab50aa44

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.04:33
Kudossokeri: 3.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0cc6b59e-001d-5111-89a9-6de800ae4aab

```

-------

Entry 154 - fullUrl = urn:uuid:ed075db0-214f-4179-bba5-b34712526b6d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.09:33
Kudossokeri: 3.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:414f203f-ffd6-5fd9-921e-3723359e9dab

```

-------

Entry 155 - fullUrl = urn:uuid:efc155ec-6a1c-4e51-a310-c058a553b337

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.14:33
Kudossokeri: 3.89 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8b7009e1-65ab-5ef1-9037-b63debcfb301

```

-------

Entry 156 - fullUrl = urn:uuid:2dbefa6c-74a5-4017-869d-56f4a768cf84

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.19:33
Kudossokeri: 3.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80b3bc63-c4a6-52be-9e2e-64b443d58a1b

```

-------

Entry 157 - fullUrl = urn:uuid:23233a5d-83cb-400e-a74c-739dd718ab02

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.24:33
Kudossokeri: 3.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f3a323dd-7864-54df-820e-ea04344c748a

```

-------

Entry 158 - fullUrl = urn:uuid:a6e382b1-1610-4231-88ba-c050d10810bf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.29:33
Kudossokeri: 3.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2ad5c87f-c047-5f99-be56-30945ca5aef1

```

-------

Entry 159 - fullUrl = urn:uuid:6bbe5508-79f2-40ac-affe-ec68243ab71c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.34:33
Kudossokeri: 3.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4b8e0b20-4b16-5e7e-b868-9a6279e5f964

```

-------

Entry 160 - fullUrl = urn:uuid:66f77546-5e43-45e5-9e39-8eac2bd3d9ce

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.39:33
Kudossokeri: 3.89 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b14bb568-c650-5d97-86f5-2ef15d9755ad

```

-------

Entry 161 - fullUrl = urn:uuid:ee5815b1-a08e-4561-bbba-bb6720ba6d40

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.44:33
Kudossokeri: 4 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:047d1647-6f14-5fb3-bce3-58a04e858e79

```

-------

Entry 162 - fullUrl = urn:uuid:e09a046f-3ae4-4247-82d4-d70397deb7f9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.49:33
Kudossokeri: 4.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:12ce84f3-fc85-5b87-a093-7e948b812deb

```

-------

Entry 163 - fullUrl = urn:uuid:aea9bbb4-9e0a-4e58-bd94-6dddc3a4a069

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.54:33
Kudossokeri: 4.39 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c912cc1-3e92-5b98-9458-ed15d15ac680

```

-------

Entry 164 - fullUrl = urn:uuid:fde1773a-5cc8-4903-9e84-68870dd392b7

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 01.57:19 - 02.02:20
Lyhytvaikutteinen insuliini 0.02 ky (0.19 ky/t, 0.25 % = 0.05 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dc6922e0-76f0-520e-9cc9-b556557339ec

```

-------

Entry 165 - fullUrl = urn:uuid:83b19f5b-cf32-4e6b-b17c-720351bcb1ee

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 01.59:33
Kudossokeri: 4.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:672138fa-155f-51ce-86ac-88388325bd06

```

-------

Entry 166 - fullUrl = urn:uuid:efe5810f-5628-418f-a6db-534e38363a63

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.02:20 - 02.07:21
Lyhytvaikutteinen insuliini 0.02 ky (0.28 ky/t, 0.38 % = 0.11 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1361bc4b-dbd8-5357-8ee2-1881c91a8c0d

```

-------

Entry 167 - fullUrl = urn:uuid:293bf99c-1e4f-488b-b79e-a84e517f97c5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.04:33
Kudossokeri: 4.5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c91df5cc-c997-50eb-b0be-8cbdf50ae64c

```

-------

Entry 168 - fullUrl = urn:uuid:28f56d55-93e5-490f-bfa4-a12ff338d3fd

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.07:21 - 02.12:22
Lyhytvaikutteinen insuliini 0.01 ky (0.16 ky/t, 0.22 % = 0.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a746ec5b-2436-5494-bba7-6ef9f89af4c0

```

-------

Entry 169 - fullUrl = urn:uuid:fee35fbc-3f4a-4218-95db-4d02109962dc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.09:35
Kudossokeri: 4.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0cc0dd81-90bc-50bd-94f5-549bba9c0bee

```

-------

Entry 170 - fullUrl = urn:uuid:28478602-f93d-4a92-bdf5-5f7cbfd03ec0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.12:22 - 02.27:23
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fed3ab1c-f877-572b-8369-8af16ab45e03

```

-------

Entry 171 - fullUrl = urn:uuid:3c18eae0-1db2-4835-b5e5-688773d99a0b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.14:33
Kudossokeri: 4.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e79f8c22-48ff-5bc9-8a50-2bdf26527928

```

-------

Entry 172 - fullUrl = urn:uuid:5245b132-7b0f-42d6-9fa4-0191b98e4f3b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.19:33
Kudossokeri: 4.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d865ddc1-ae2d-5c3b-8b85-766de9259c48

```

-------

Entry 173 - fullUrl = urn:uuid:6d74264d-ad0e-4b19-995e-b08afd1f3780

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.24:33
Kudossokeri: 4.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a65e0abe-d617-522a-9d31-2b3df778be85

```

-------

Entry 174 - fullUrl = urn:uuid:51c02233-fb8f-450e-8328-41bd7c75e224

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.27:23 - 02.32:24
Lyhytvaikutteinen insuliini 0.03 ky (0.33 ky/t, 0.44 % = 0.14 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:58019166-b05c-5284-830e-869b4035e15a

```

-------

Entry 175 - fullUrl = urn:uuid:d889e862-be18-431f-8b77-3bcfc093df76

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.29:40
Kudossokeri: 4.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c7c8b555-13ed-5d11-87fa-8f8b127db868

```

-------

Entry 176 - fullUrl = urn:uuid:4ab5ece0-f856-4a6d-8a66-cf5db1a5c71c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.32:24 - 02.37:24
Lyhytvaikutteinen insuliini 0.03 ky (0.33 ky/t, 0.44 % = 0.14 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b5738eec-908c-5f36-8c13-fd1eec98ac97

```

-------

Entry 177 - fullUrl = urn:uuid:67c9f0cb-782d-44be-ae44-db888de4ff05

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.34:40
Kudossokeri: 5.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:925dd7bf-4093-596a-a0cb-5a263f768746

```

-------

Entry 178 - fullUrl = urn:uuid:28b3f8ed-1ba6-4f9e-ae60-7be15c9cc024

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.37:24 - 02.42:25
Lyhytvaikutteinen insuliini 0.04 ky (0.46 ky/t, 0.61 % = 0.28 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:84d20309-3686-5a2d-87de-78a4f85f4980

```

-------

Entry 179 - fullUrl = urn:uuid:fa8150df-d1ca-4e67-aab5-311f81ced896

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.39:40
Kudossokeri: 5.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0b65e66e-aa1c-557a-ad2b-42dbee11f32b

```

-------

Entry 180 - fullUrl = urn:uuid:ed04afee-4b3e-4fcc-bb55-54c1fdff89b7

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.42:25 - 02.47:26
Lyhytvaikutteinen insuliini 0.05 ky (0.58 ky/t, 0.77 % = 0.45 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b3290e4d-4113-5a3a-9616-c5f38ee52916

```

-------

Entry 181 - fullUrl = urn:uuid:b52ff2d4-ea4a-41bc-9d43-2fb6fb83a968

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.44:34
Kudossokeri: 5.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:673ebfb4-ee16-5def-9f26-85e62c7895d8

```

-------

Entry 182 - fullUrl = urn:uuid:b7bb2224-9d9c-420e-b2ac-49bafb853897

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.47:26 - 02.52:27
Lyhytvaikutteinen insuliini 0.06 ky (0.75 ky/t, 1.00 % = 0.75 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5be15d43-7b7a-5692-b402-b1f2698091c3

```

-------

Entry 183 - fullUrl = urn:uuid:6b2c7a75-521b-481d-bce8-d86b902372a4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.49:33
Kudossokeri: 5.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6a8284f7-517b-5317-a058-bea482831166

```

-------

Entry 184 - fullUrl = urn:uuid:52dd6f51-3776-4785-a3f5-e17c425eccda

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.52:27 - 02.57:28
Lyhytvaikutteinen insuliini 0.06 ky (0.76 ky/t, 1.01 % = 0.76 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fcb707f9-ddbd-5438-8589-7b3e66d9399e

```

-------

Entry 185 - fullUrl = urn:uuid:e2c6f068-5f05-4a8a-9882-8486385c65dc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.54:33
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8d3bc921-1564-580a-964c-74d312b5cd14

```

-------

Entry 186 - fullUrl = urn:uuid:d2b316dc-f02f-45be-bed6-bc27653d003f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 02.57:28 - 03.02:29
Lyhytvaikutteinen insuliini 0.09 ky (1.06 ky/t, 1.42 % = 1.51 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:00f01914-3b1a-534d-8992-19cc8c4b4393

```

-------

Entry 187 - fullUrl = urn:uuid:581be346-597f-4fe2-94d3-b5c7a7bbdd80

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 02.59:36
Kudossokeri: 6.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:961215ed-6377-50af-bc1e-f6c0f7627496

```

-------

Entry 188 - fullUrl = urn:uuid:e596a17c-0e76-43a1-a19c-66ef377bd1cd

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.02:29 - 03.07:30
Lyhytvaikutteinen insuliini 0.08 ky (1.01 ky/t, 1.35 % = 1.37 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e37cfef8-1181-5a6d-9d96-c471b0c5ea05

```

-------

Entry 189 - fullUrl = urn:uuid:84735038-e26e-46c1-9b22-7365a3802733

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.04:34
Kudossokeri: 6.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dbe2905b-7a28-5144-96da-aa2cb9f80b10

```

-------

Entry 190 - fullUrl = urn:uuid:7660195b-83b7-4d74-afaf-6c63f26d6161

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.07:30 - 03.12:31
Lyhytvaikutteinen insuliini 0.08 ky (1.00 ky/t, 1.34 % = 1.35 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2eb4a5cc-2d28-5ed7-823c-d845010fe867

```

-------

Entry 191 - fullUrl = urn:uuid:63db79be-20db-4e22-95e7-4a685ad3c142

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.09:34
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1deed150-c224-5a29-85cf-7c76eaa67b6d

```

-------

Entry 192 - fullUrl = urn:uuid:46df5040-46ed-4e56-9a8a-9fd6468c9370

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.12:31 - 03.17:30
Lyhytvaikutteinen insuliini 0.08 ky (0.99 ky/t, 1.33 % = 1.32 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:50d42f98-7839-5f65-91ad-bb41c0762d4c

```

-------

Entry 193 - fullUrl = urn:uuid:525c86de-3e62-4290-a42d-9597481b1a95

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.14:34
Kudossokeri: 6.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:98356f32-c53c-5156-a961-ddffea70eb53

```

-------

Entry 194 - fullUrl = urn:uuid:08ea6622-8a86-480c-8fa3-07266bab7af7

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.17:30 - 03.22:31
Lyhytvaikutteinen insuliini 0.10 ky (1.25 ky/t, 1.67 % = 2.09 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d0e488a2-11bd-5b3c-840b-0cee3bd49c16

```

-------

Entry 195 - fullUrl = urn:uuid:07e1ff77-37e5-49be-841b-b4baf20ab3b3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.19:36
Kudossokeri: 6.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cfa45489-6453-5369-935f-d5983f31c5a9

```

-------

Entry 196 - fullUrl = urn:uuid:f0f3c5ca-62d1-4837-aaed-37c8680ee99e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.22:31 - 03.27:31
Lyhytvaikutteinen insuliini 0.12 ky (1.50 ky/t, 1.99 % = 2.98 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:113f25ab-21e0-5bec-99bd-c71245a16a78

```

-------

Entry 197 - fullUrl = urn:uuid:828ac7ea-c48c-4c52-9934-477e5814e909

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.24:34
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5f24f38b-d02e-50ab-bdb2-c64c8a391fcb

```

-------

Entry 198 - fullUrl = urn:uuid:a6163547-a7bd-4c67-aad8-946ebb409537

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.27:31 - 03.32:33
Lyhytvaikutteinen insuliini 0.14 ky (1.66 ky/t, 2.21 % = 3.66 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8f0e85ac-803c-54cd-a508-ad9b550bc1e9

```

-------

Entry 199 - fullUrl = urn:uuid:bf5b8e12-a36e-48d5-8474-603e4f9def13

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.29:33
Kudossokeri: 6.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0295e42b-33a3-5d16-87ca-c3f010bb347c

```

-------

Entry 200 - fullUrl = urn:uuid:62d9b5c9-5f8e-4b9a-b5a8-de34fb0684f5

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.32:33 - 03.37:35
Lyhytvaikutteinen insuliini 0.13 ky (1.52 ky/t, 2.03 % = 3.10 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:25d0d283-cfba-5ce4-94f7-458d367409d1

```

-------

Entry 201 - fullUrl = urn:uuid:9054c822-a534-4dd4-8344-86ee8cb6ebd9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.34:39
Kudossokeri: 7.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:21c6819d-acbf-5c0a-8969-6c3418e2645c

```

-------

Entry 202 - fullUrl = urn:uuid:9a44887b-1bc8-4740-a1f7-d677ecd7d8a1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.37:35 - 03.42:34
Lyhytvaikutteinen insuliini 0.16 ky (1.95 ky/t, 2.60 % = 5.06 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:37169145-359d-58e7-ae1f-bfce72b09732

```

-------

Entry 203 - fullUrl = urn:uuid:8d56b96a-5994-4726-b575-01e54be73542

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.39:34
Kudossokeri: 7.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:189e63e8-7da8-5e2c-94c6-97488a9a3ed1

```

-------

Entry 204 - fullUrl = urn:uuid:39ec9f70-a91d-4022-8789-20aa3dd94b89

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.42:34 - 03.47:35
Lyhytvaikutteinen insuliini 0.19 ky (2.23 ky/t, 2.98 % = 6.64 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cb228915-9514-5012-ba9f-f8cfab4e7997

```

-------

Entry 205 - fullUrl = urn:uuid:7bb5edaa-6782-41b8-bccf-5874bd00730c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.44:36
Kudossokeri: 7.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c96159d0-69f6-578d-b8be-9bee824fb66b

```

-------

Entry 206 - fullUrl = urn:uuid:41997ae8-d419-4967-acb6-72bf077d502b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.47:35 - 03.52:35
Lyhytvaikutteinen insuliini 0.16 ky (1.98 ky/t, 2.64 % = 5.21 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:daaa6fb3-5cb0-54d0-9839-d5d31b544924

```

-------

Entry 207 - fullUrl = urn:uuid:a4945d8e-9943-435e-87b1-3ee931254674

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.49:33
Kudossokeri: 7.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:edf93328-e278-5828-9149-cc99d659ed74

```

-------

Entry 208 - fullUrl = urn:uuid:7aaf8516-0b51-4c10-9624-27c33278c424

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.52:35 - 03.57:38
Lyhytvaikutteinen insuliini 0.15 ky (1.76 ky/t, 2.35 % = 4.13 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7d2e3e2b-2f0c-5023-8a3b-3dd6956b998e

```

-------

Entry 209 - fullUrl = urn:uuid:1c76411a-f538-4a67-988b-932a029e4ac1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.54:33
Kudossokeri: 7.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fab558ed-cb33-5a1a-9ddc-f9cb059f136a

```

-------

Entry 210 - fullUrl = urn:uuid:a88be164-0fbf-4e32-bbf3-4616dd653002

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 03.57:38 - 04.55:37
Lyhytvaikutteinen insuliini 0.72 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1748de0b-3c68-555a-8c0f-9ae985aab7bc

```

-------

Entry 211 - fullUrl = urn:uuid:97ed60d3-8a10-432b-bad2-ffbc45c5660a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 03.59:34
Kudossokeri: 7.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3919eda-994f-5753-b488-12a1667a8136

```

-------

Entry 212 - fullUrl = urn:uuid:1b9e82a0-d226-4ea4-bbaf-912a075cefb9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.04:33
Kudossokeri: 7.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b0e4a0d6-b29a-55ca-9b2e-54e13e6ec0a6

```

-------

Entry 213 - fullUrl = urn:uuid:228edcf0-c31d-4f16-b8f9-e4ddddbafc77

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.09:35
Kudossokeri: 7.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eaceaca7-1101-5672-abab-bef88745d8a8

```

-------

Entry 214 - fullUrl = urn:uuid:c1738c63-091f-4936-80d8-26539f54b3a5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.14:35
Kudossokeri: 7.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3a46719-03d1-5437-9317-70376be8c1ea

```

-------

Entry 215 - fullUrl = urn:uuid:fd78d1b1-62c6-4406-8116-5314bcb1be72

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.19:35
Kudossokeri: 7.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c7fb2a6f-a5ea-5483-a006-1f01d56c294c

```

-------

Entry 216 - fullUrl = urn:uuid:1933ff36-b734-4cc3-82ce-b9efec20afe2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.24:34
Kudossokeri: 6.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:24a33d3d-997c-50e0-a998-31f91a8cc669

```

-------

Entry 217 - fullUrl = urn:uuid:a52e9178-cdd2-4896-82d4-b2bc1e350ed6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.29:35
Kudossokeri: 6.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f8db12a0-910f-5a65-b0e1-494ff70f1661

```

-------

Entry 218 - fullUrl = urn:uuid:0b8e71fd-8f60-4cc8-8123-70d90c84ac60

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.34:34
Kudossokeri: 6.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:25748572-9353-53ca-9c88-57c8ab965c18

```

-------

Entry 219 - fullUrl = urn:uuid:c1f6ac20-f15a-47e8-b331-7372a73fb8ea

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.39:33
Kudossokeri: 6.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f3ba7b06-39d4-5315-8f0f-b066b52add87

```

-------

Entry 220 - fullUrl = urn:uuid:06b6e8c2-40b0-4afe-96fb-3dbee1a2b85a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.44:33
Kudossokeri: 6.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1abbac42-9787-54ae-934a-1401d66a5114

```

-------

Entry 221 - fullUrl = urn:uuid:85e04261-8379-4bb0-ab3f-55ca3cb8e84b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.49:33
Kudossokeri: 6.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3ede0494-612f-54d4-b5e7-157c19b62a94

```

-------

Entry 222 - fullUrl = urn:uuid:48e67f58-fc33-42ec-a740-e4a0e6aa7907

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.54:33
Kudossokeri: 6.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:14f07031-34b7-5e56-b7be-6768ea41f777

```

-------

Entry 223 - fullUrl = urn:uuid:27406c66-00a0-478d-a9dc-69a38298e92f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 04.55:37 - 05.00:36
Lyhytvaikutteinen insuliini 0.06 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a12cb023-206a-5cc7-96a4-e9b5d48e2eb1

```

-------

Entry 224 - fullUrl = urn:uuid:a14af912-cfa7-40c6-98cd-19ee035e1021

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 04.59:33
Kudossokeri: 6.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8550c4c8-d2d3-5577-b8a0-c930077b0d79

```

-------

Entry 225 - fullUrl = urn:uuid:59593750-03e4-433a-98de-4d35842b308d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.00:36 - 05.02:46
Lyhytvaikutteinen insuliini 0.03 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:04d2b04c-14fb-5343-8bc2-e94623812a4b

```

-------

Entry 226 - fullUrl = urn:uuid:c5e5e7d9-c59a-4cf9-ba02-c1fc75f08e65

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.02:46 - 05.07:47
Lyhytvaikutteinen insuliini 0.05 ky (0.65 ky/t, 0.86 % = 0.56 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:660fbf12-e4e9-5dea-bb24-2248292218a4

```

-------

Entry 227 - fullUrl = urn:uuid:5970918c-8ba6-42f2-a190-878ce5b10437

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.04:33
Kudossokeri: 6.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3aa02cca-bae5-5206-96cc-65509765a99d

```

-------

Entry 228 - fullUrl = urn:uuid:9e067678-2c89-4e2b-bb00-e0dfec7a721e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.07:47 - 05.12:48
Lyhytvaikutteinen insuliini 0.03 ky (0.35 ky/t, 0.46 % = 0.16 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b01c93fd-d38b-5a15-bc8d-3860037990f8

```

-------

Entry 229 - fullUrl = urn:uuid:cdf8d540-5020-4852-907a-1378db77d8b6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.09:33
Kudossokeri: 6.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:25fd19cc-5d69-50da-a8be-e6fccd087a89

```

-------

Entry 230 - fullUrl = urn:uuid:7f689cdf-a794-4131-9fff-32b0c478ebec

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.12:48 - 05.17:48
Lyhytvaikutteinen insuliini 0.05 ky (0.56 ky/t, 0.75 % = 0.42 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4237b73f-7b22-595b-a3cf-2adf02077694

```

-------

Entry 231 - fullUrl = urn:uuid:d9684086-bb70-4059-8334-f825d6307e7f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.14:33
Kudossokeri: 6.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:950f7d02-aa30-5a3c-beec-7ec1ab20298b

```

-------

Entry 232 - fullUrl = urn:uuid:712ddf5a-68ae-4541-8012-9380ce3ec7ad

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.17:48 - 05.22:49
Lyhytvaikutteinen insuliini 0.06 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:946693e7-5737-5b33-96ae-bc100ad22fe1

```

-------

Entry 233 - fullUrl = urn:uuid:0fbe5dbb-71e2-43d0-8a79-0afef8945d02

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.19:33
Kudossokeri: 6.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b381505a-b1bf-58c5-abb5-6b12d1cb475e

```

-------

Entry 234 - fullUrl = urn:uuid:31e49369-4fc7-40fb-8705-04ac6c193547

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.22:49 - 05.27:50
Lyhytvaikutteinen insuliini 0.11 ky (1.36 ky/t, 1.82 % = 2.48 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f085cc03-ae70-5dfe-a932-1493bae5d665

```

-------

Entry 235 - fullUrl = urn:uuid:2c28e5c5-51ca-4294-88d2-56d401f5b094

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.24:33
Kudossokeri: 6.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1ae33f5d-4739-5b72-acb3-64436ef20604

```

-------

Entry 236 - fullUrl = urn:uuid:f75aff92-2755-48c8-9542-ef0829e2395c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.27:50 - 05.32:50
Lyhytvaikutteinen insuliini 0.12 ky (1.41 ky/t, 1.88 % = 2.64 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ae84c9bb-0e66-5beb-948a-1b740b23a67c

```

-------

Entry 237 - fullUrl = urn:uuid:1b7652c5-04bb-4170-84d5-1e62765cbed9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.29:33
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fb7348eb-09da-52e1-aed9-5dd875c26b9c

```

-------

Entry 238 - fullUrl = urn:uuid:c52c7141-4a9b-49b8-9937-d65004f1d55e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.32:50 - 05.37:51
Lyhytvaikutteinen insuliini 0.08 ky (0.92 ky/t, 1.08 % = 0.99 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4852bbaa-e8dd-5782-8585-98271e4743b3

```

-------

Entry 239 - fullUrl = urn:uuid:eacf4c1e-93db-4f4e-94f0-168c5c921958

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.34:33
Kudossokeri: 6.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5804a2f0-c58a-5252-b56f-42c1f26fc24c

```

-------

Entry 240 - fullUrl = urn:uuid:3a2549c9-e77c-4ad0-97d5-bfcbed0718fc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.37:51 - 05.42:52
Lyhytvaikutteinen insuliini 0.07 ky (0.85 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0f9275d5-863b-5303-9cfb-f67ada06f76a

```

-------

Entry 241 - fullUrl = urn:uuid:c986d090-4075-4c7b-bb56-723ba31d29bf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.39:33
Kudossokeri: 6.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:97f96d7f-3919-56a8-a667-4eaffbe5fbba

```

-------

Entry 242 - fullUrl = urn:uuid:e5c4b8f7-ad1c-40fd-a6ca-cbc848b5079e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.42:52 - 05.47:52
Lyhytvaikutteinen insuliini 0.05 ky (0.55 ky/t, 0.64 % = 0.35 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cdfe648e-c4e8-5c75-a384-c26e5a320bbd

```

-------

Entry 243 - fullUrl = urn:uuid:b9ea169f-ffb0-483c-93e1-9789d2209a15

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.44:33
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5578d49d-86d4-53bb-b724-fb29c05da63f

```

-------

Entry 244 - fullUrl = urn:uuid:9636c413-ce36-402d-a1b1-d2ff1bf093e0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.47:52 - 05.52:53
Lyhytvaikutteinen insuliini 0.02 ky (0.30 ky/t, 0.35 % = 0.10 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bd4e78e9-9612-5df5-a2a9-72e83de8cf67

```

-------

Entry 245 - fullUrl = urn:uuid:1a21941e-b893-4529-aba4-d77607c52cca

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.49:33
Kudossokeri: 6.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:908d6eff-72cc-586f-b42c-5bd3440b7466

```

-------

Entry 246 - fullUrl = urn:uuid:24edf6f5-da43-4824-b7af-9a796dd6fa2f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.52:53 - 05.57:54
Lyhytvaikutteinen insuliini 0.03 ky (0.34 ky/t, 0.40 % = 0.13 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3861da19-25eb-5187-b6bb-3a494589f743

```

-------

Entry 247 - fullUrl = urn:uuid:ccf964cd-2e09-4ffd-a217-97586f1387c1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.54:33
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1bca37e9-603b-5240-b4a8-6c359c261d30

```

-------

Entry 248 - fullUrl = urn:uuid:1a904bf5-0245-47b0-9f03-a19bea2a6722

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 05.57:54 - 06.02:54
Lyhytvaikutteinen insuliini 0.03 ky (0.36 ky/t, 0.42 % = 0.15 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:61e254b0-5e8d-5467-b5e0-5de54b9804a8

```

-------

Entry 249 - fullUrl = urn:uuid:9ebf9e34-d671-4853-8e6d-4ab936a07973

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 05.59:33
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1f1346bf-f5a2-5264-825b-41fe5c3b3543

```

-------

Entry 250 - fullUrl = urn:uuid:fa9ea0a2-e7b0-4709-8d00-9bb7823901a4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.02:54 - 06.07:55
Lyhytvaikutteinen insuliini 0.02 ky (0.28 ky/t, 0.33 % = 0.09 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:663f4db5-4f80-5af6-9428-b050bd236fbc

```

-------

Entry 251 - fullUrl = urn:uuid:356094c5-9b8f-4f25-8d3b-5c570031aaf8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.04:33
Kudossokeri: 5.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e97c889f-556a-5f32-bdc7-f972fcfb0793

```

-------

Entry 252 - fullUrl = urn:uuid:9fd114b2-a7f1-4c7f-addc-69c6ec2a1c92

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.07:55 - 06.12:56
Lyhytvaikutteinen insuliini 0.02 ky (0.20 ky/t, 0.23 % = 0.05 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:db8c0a06-6c95-59c9-b8ad-873946d87d9d

```

-------

Entry 253 - fullUrl = urn:uuid:005d376a-f894-4efd-a8a0-39c34144cf92

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.09:34
Kudossokeri: 5.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:79e45970-10d7-571c-83d5-b73740ce4bea

```

-------

Entry 254 - fullUrl = urn:uuid:2c7110b9-8225-4342-8cd0-ea7a00e0324a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.12:56 - 06.17:58
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1afc2f55-be5f-5c39-8936-685d8c269656

```

-------

Entry 255 - fullUrl = urn:uuid:bf9e9371-fcdd-455e-a6a9-69cb274d9520

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.14:33
Kudossokeri: 5.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1b289de6-8488-5030-b7a2-e0e79841f4b2

```

-------

Entry 256 - fullUrl = urn:uuid:1c1fbcd3-924c-4017-ab55-dcba7e9df32d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.17:58 - 06.22:57
Lyhytvaikutteinen insuliini 0.02 ky (0.28 ky/t, 0.32 % = 0.09 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:476f92a1-2d76-5dd2-86fa-15156cd219f8

```

-------

Entry 257 - fullUrl = urn:uuid:be04dc0b-f060-4797-8587-5760d3f8b940

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.19:34
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a5c78654-1b00-5af8-8349-a402a0acf174

```

-------

Entry 258 - fullUrl = urn:uuid:7b68cf91-aab6-4121-8ee0-aa0433ebe8f1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.22:57 - 06.27:57
Lyhytvaikutteinen insuliini 0.11 ky (1.26 ky/t, 1.48 % = 1.87 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8eb28a76-eab9-5da1-9caa-644c87250e2d

```

-------

Entry 259 - fullUrl = urn:uuid:7664e842-31a4-4ab1-88cd-379ddd01e1f9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.24:37
Kudossokeri: 6.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aadad9a8-fd65-5262-86e4-098fa947068c

```

-------

Entry 260 - fullUrl = urn:uuid:ce31242d-436f-43de-a2f7-caec9ed633c1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.27:57 - 06.32:58
Lyhytvaikutteinen insuliini 0.14 ky (1.62 ky/t, 1.90 % = 3.08 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:39685701-38a6-57c9-a766-60657c54f3b1

```

-------

Entry 261 - fullUrl = urn:uuid:103a3940-d0c3-45bc-a510-7b87b269f6bb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.29:34
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c6580456-5824-5dcb-ab65-6a8dc5d42092

```

-------

Entry 262 - fullUrl = urn:uuid:5c1787d7-7a83-4db6-aee3-ce7a59c5bf56

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.32:58 - 06.38:00
Lyhytvaikutteinen insuliini 0.10 ky (1.14 ky/t, 1.34 % = 1.54 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:671a10bb-2d5f-5e18-835e-5b2231528954

```

-------

Entry 263 - fullUrl = urn:uuid:a7212da2-1949-4f30-a224-83b8d48ab979

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.34:36
Kudossokeri: 6.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c9efa39a-f601-5683-bbce-b5e45854ce6d

```

-------

Entry 264 - fullUrl = urn:uuid:3e241227-fa9e-4ebf-b75b-fcaad4b232b8

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.38:00 - 06.42:59
Lyhytvaikutteinen insuliini 0.07 ky (0.85 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f7011634-b287-5cb2-bcf6-3ad1b76a70fa

```

-------

Entry 265 - fullUrl = urn:uuid:68d0d35b-7c2d-467e-8163-2af5b7fb8453

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.39:33
Kudossokeri: 5.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7d4e8941-af8f-5a02-809f-51de253f8e9a

```

-------

Entry 266 - fullUrl = urn:uuid:e2f48e30-56bc-43d3-a082-afb79ebc225b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.42:59 - 06.48:00
Lyhytvaikutteinen insuliini 0.02 ky (0.20 ky/t, 0.23 % = 0.05 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7a9dd841-d524-528b-8a4e-ac8405c8ea55

```

-------

Entry 267 - fullUrl = urn:uuid:f9a0ad64-58d4-41f6-8270-6c668f688094

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.44:33
Kudossokeri: 5.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a5300e7d-dc09-559c-87fd-11e90dc819e0

```

-------

Entry 268 - fullUrl = urn:uuid:4d630edc-df1e-4c6e-8855-df943e79d534

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 06.48:00 - 07.03:02
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6fd33b6e-1daf-510d-875b-f5c683c67765

```

-------

Entry 269 - fullUrl = urn:uuid:68b5400d-db5f-4634-9a64-f18d5ef2e2c4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.49:33
Kudossokeri: 5.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:83febd7d-ddfc-5ab0-b922-2671e359eea5

```

-------

Entry 270 - fullUrl = urn:uuid:8be98ae6-522a-4097-b6c8-f083c508d643

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.54:33
Kudossokeri: 5.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7df36803-d301-5b45-8557-ab45198c5968

```

-------

Entry 271 - fullUrl = urn:uuid:3f46f816-aa2e-44a7-ad33-0ca2f4b8f3dc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 06.59:32
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:70957ecf-55ca-5f8f-b6e4-6fa7005d82aa

```

-------

Entry 272 - fullUrl = urn:uuid:24f4d4fd-aa44-4195-a34e-d29ae9741fdc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.03:02 - 07.08:03
Lyhytvaikutteinen insuliini 0.08 ky (0.95 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d74c28df-f4a6-505d-9a7c-f4b3d7830756

```

-------

Entry 273 - fullUrl = urn:uuid:712d51f3-c160-4dff-b400-9b3cfe6e35a9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.04:33
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c46d230d-eb58-53da-b7b8-ead1a70a9e70

```

-------

Entry 274 - fullUrl = urn:uuid:695aa500-b393-43e0-8fd6-a9d273844df1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.08:03 - 07.13:04
Lyhytvaikutteinen insuliini 0.09 ky (1.12 ky/t, 1.18 % = 1.32 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b9480ea6-8e53-5faf-82fb-fac04af1f031

```

-------

Entry 275 - fullUrl = urn:uuid:9e8604dc-b9cb-4d6c-95c8-fae8b77adf5d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.09:32
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:969269ad-ece0-5201-8151-c0bf8c0f2ccc

```

-------

Entry 276 - fullUrl = urn:uuid:7d469c3c-688e-4712-9f78-f527a396d775

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.13:04 - 07.23:05
Lyhytvaikutteinen insuliini 0.16 ky (0.95 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e9869ada-3d60-5f3a-a3c3-5810e19c4a5a

```

-------

Entry 277 - fullUrl = urn:uuid:40060dfe-16c3-4fff-84db-a796e9b81ef7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.14:32
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:17fbd04c-02dd-5fb0-a9b9-b258121355e3

```

-------

Entry 278 - fullUrl = urn:uuid:e1f68ab8-d8e1-4d31-9dfd-201aca4a36eb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.19:32
Kudossokeri: 6.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0895e436-d475-5e31-a199-0aa30988f9c2

```

-------

Entry 279 - fullUrl = urn:uuid:9f0e0a94-0e43-4f75-b60b-f9531c526fe3

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.23:05 - 07.28:06
Lyhytvaikutteinen insuliini 0.08 ky (0.95 ky/t, 1.00 % = 0.94 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a59afbea-cc48-52fc-97b4-59d3a83ad218

```

-------

Entry 280 - fullUrl = urn:uuid:6aea7948-ffec-4e72-b3b1-28aeb3e8236b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.24:33
Kudossokeri: 6.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c976aaed-e7a7-5b6d-b6a8-57add5d0ac6d

```

-------

Entry 281 - fullUrl = urn:uuid:56763a6c-12e0-46ef-b963-054dfb371ef5

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.28:06 - 07.38:08
Lyhytvaikutteinen insuliini 0.16 ky (0.95 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0c6a5d4e-e50e-5677-96e3-fec9c8be58c3

```

-------

Entry 282 - fullUrl = urn:uuid:c6b5e3b6-08ad-437d-a3d2-fcb933c24938

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.29:33
Kudossokeri: 6.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e88b7c2a-6f3b-5edf-b01a-321a8191078f

```

-------

Entry 283 - fullUrl = urn:uuid:c132926b-4a5a-4f6b-8fdb-85d6b1371c77

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.34:33
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1e816236-8168-5a19-beba-83560b1fe236

```

-------

Entry 284 - fullUrl = urn:uuid:97039ee8-b55f-4940-9c4a-64e04fbab0ef

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.38:08 - 07.43:07
Lyhytvaikutteinen insuliini 0.18 ky (2.21 ky/t, 2.33 % = 5.16 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2f374202-3d3a-59ae-9038-16eafddec017

```

-------

Entry 285 - fullUrl = urn:uuid:e60cb9a1-aee1-4f9c-9177-456af0225b84

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.39:32
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6099c9a6-272f-5fa7-a0e8-cefb25dfb8d7

```

-------

Entry 286 - fullUrl = urn:uuid:21ab85f3-f2d7-4d8b-b537-5da72043f2fd

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.43:07 - 07.48:08
Lyhytvaikutteinen insuliini 0.13 ky (1.60 ky/t, 1.69 % = 2.70 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7eb9dc77-d1f8-51d4-b7ac-82050fcbe429

```

-------

Entry 287 - fullUrl = urn:uuid:b590bccb-eb8b-4b8a-bb7d-7a0ccd5bde14

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.44:32
Kudossokeri: 7.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6484781c-81da-5e6c-b695-55633e087a6c

```

-------

Entry 288 - fullUrl = urn:uuid:415d550b-1091-4618-b3d4-8b49ac99926c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.48:08 - 07.53:09
Lyhytvaikutteinen insuliini 0.12 ky (1.44 ky/t, 1.51 % = 2.18 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fb86cffb-1c18-5a04-8858-b50c1c4482e7

```

-------

Entry 289 - fullUrl = urn:uuid:b9cd6ecb-f9cd-4ab7-a078-761e0e3aaa40

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.49:33
Kudossokeri: 7.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56f9a305-8978-5816-ad74-d4a26d899d3f

```

-------

Entry 290 - fullUrl = urn:uuid:022dd2db-8582-4f78-a040-d414499254f2

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.53:09 - 07.58:11
Lyhytvaikutteinen insuliini 0.09 ky (1.06 ky/t, 1.11 % = 1.18 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c3c83b7f-7134-521c-af51-618a42ee6625

```

-------

Entry 291 - fullUrl = urn:uuid:5e4c20ac-11c8-48d7-9521-71d4f790baa2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.54:33
Kudossokeri: 7.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4a257c47-2205-56cc-abf1-a8e00d980df0

```

-------

Entry 292 - fullUrl = urn:uuid:d969979a-93bf-4f81-8949-168d6db16248

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 07.58:11 - 08.03:11
Lyhytvaikutteinen insuliini 0.08 ky (0.95 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:486ebc5d-6480-5d61-a8ca-224b0a74addc

```

-------

Entry 293 - fullUrl = urn:uuid:c46c5450-451f-447c-854e-9b347de26224

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 07.59:32
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:38f58523-281f-5806-92a8-8be1ba8d481c

```

-------

Entry 294 - fullUrl = urn:uuid:829f7f52-a2d2-457f-b59b-c9d7ddaf599e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 08.03:11 - 08.08:12
Lyhytvaikutteinen insuliini 0.08 ky (0.96 ky/t, 1.01 % = 0.97 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c0917226-9830-58c8-bb17-c1ebf61555a8

```

-------

Entry 295 - fullUrl = urn:uuid:5486d474-348c-45f9-a447-d4d8766ff4bf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.04:32
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:09a5ef03-73f4-5819-bc96-2deb6d8cca93

```

-------

Entry 296 - fullUrl = urn:uuid:978ce6d2-0323-43c7-888a-c47928fc9e5c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 08.08:12 - 08.13:13
Lyhytvaikutteinen insuliini 0.11 ky (1.36 ky/t, 1.44 % = 1.96 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:eb1091e4-57f7-519c-9c1f-f7669455c604

```

-------

Entry 297 - fullUrl = urn:uuid:1cefb496-f862-45e1-9d89-e94a52102ecf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.09:33
Kudossokeri: 8.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1d37af39-2279-5b36-825b-c932b89115a1

```

-------

Entry 298 - fullUrl = urn:uuid:46c29d55-8c22-4eee-9567-271b00446684

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 08.13:13 - 08.18:13
Lyhytvaikutteinen insuliini 0.16 ky (1.94 ky/t, 2.04 % = 3.95 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0d8b5336-36f4-51b2-8017-5418d27ba2d4

```

-------

Entry 299 - fullUrl = urn:uuid:d98409ed-a3d1-457d-b8f0-08f8895367d8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.14:32
Kudossokeri: 8.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:04720163-eae9-5100-8045-c2eb0f4c1f1a

```

-------

Entry 300 - fullUrl = urn:uuid:0cb1aa6c-c378-4436-8496-b8e3a7eacc43

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 08.18:13 - 08.23:14
Lyhytvaikutteinen insuliini 0.14 ky (1.73 ky/t, 1.82 % = 3.14 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0f2c7201-944b-5112-bba6-9b421c4839d2

```

-------

Entry 301 - fullUrl = urn:uuid:1b3dc291-4541-4d97-800f-1ea134cd1872

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.19:32
Kudossokeri: 8.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e1c01466-cd9b-5a64-a20f-259dfd6a79af

```

-------

Entry 302 - fullUrl = urn:uuid:8be3bd44-c95a-4a65-b3ae-5e5c309c566b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 08.23:14 - 08.28:15
Lyhytvaikutteinen insuliini 0.11 ky (1.28 ky/t, 1.35 % = 1.74 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:69c0bcd8-1ccf-58f7-a956-5fae8707e863

```

-------

Entry 303 - fullUrl = urn:uuid:c13b1b2c-db1e-4585-88bb-6d749dd3c7be

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.24:32
Kudossokeri: 8.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b372610c-5822-55d2-a154-f1b2f0313541

```

-------

Entry 304 - fullUrl = urn:uuid:340c2dfb-1821-41df-ac00-3c14229085bb

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 08.28:15 - 09.03:21
Lyhytvaikutteinen insuliini 0.56 ky (0.95 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:15919eb4-8d6c-5e8e-a86f-9808ebdbe109

```

-------

Entry 305 - fullUrl = urn:uuid:7dd967f4-baa2-4ac5-8992-ffb11f91a5b8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.29:32
Kudossokeri: 8.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:07f61f99-b04c-5269-a477-be6d85971dfd

```

-------

Entry 306 - fullUrl = urn:uuid:899526e9-f6b2-4a43-9da3-534c9d184f19

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.34:32
Kudossokeri: 8.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e13d7e8f-e214-5cee-9721-76cbccbdd649

```

-------

Entry 307 - fullUrl = urn:uuid:f15eac3f-1064-4539-b96b-605ecb5772a3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.39:32
Kudossokeri: 8.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3f66a2dc-6e1a-5318-a4ec-0ad2c166e6c2

```

-------

Entry 308 - fullUrl = urn:uuid:3b69ffee-e491-45a4-b49d-037fc1784d8e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.44:32
Kudossokeri: 8.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:272a3294-aa06-5c32-9b3f-799d6b364a3c

```

-------

Entry 309 - fullUrl = urn:uuid:cd6fbbe1-4345-4865-9a0e-a7a3c00f56b2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.49:32
Kudossokeri: 8.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:133ad7c3-9880-5eb2-8890-d4bd71ac40a0

```

-------

Entry 310 - fullUrl = urn:uuid:566fd92a-52b4-49fc-bfd6-0b11a73d20ba

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.54:32
Kudossokeri: 8.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b30cc0da-c29e-5ef7-93d2-56545011d851

```

-------

Entry 311 - fullUrl = urn:uuid:384ecaf3-12fe-48d5-a902-328d62d6b47a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 08.59:32
Kudossokeri: 8.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5ac166a2-190c-5091-a8b3-612535803538

```

-------

Entry 312 - fullUrl = urn:uuid:0825c04c-50f1-4ae6-b1c2-25f771a077ea

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 09.03:21 - 09.45:16
Lyhytvaikutteinen insuliini 0.49 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:57a208cf-a03c-5df0-81b5-4420226607b8

```

-------

Entry 313 - fullUrl = urn:uuid:964ac843-3baa-4b66-bf09-271a7d7d85a2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.04:32
Kudossokeri: 8.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9bd0951b-8180-510c-b997-b5885b48ba47

```

-------

Entry 314 - fullUrl = urn:uuid:17b65a3a-933b-4c50-ba07-93e62074d319

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.09:32
Kudossokeri: 8.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:45f70873-3ce5-5fe2-b52c-042f38ee619e

```

-------

Entry 315 - fullUrl = urn:uuid:6c21dbec-5d85-44e5-95cb-1f08ed64160f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.14:32
Kudossokeri: 8.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b5a7b2ad-b9c4-53a1-a49f-3e0001d1b0e0

```

-------

Entry 316 - fullUrl = urn:uuid:6bd78994-ca80-411f-84dc-f0b016533c95

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.19:32
Kudossokeri: 8.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:086d0bcf-8071-5b1d-9b86-13e055446dfa

```

-------

Entry 317 - fullUrl = urn:uuid:42229e19-d019-40e7-95ef-ca519601cf24

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.24:32
Kudossokeri: 8.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1aaa1e86-de4a-5d38-947c-4dd0f204ad18

```

-------

Entry 318 - fullUrl = urn:uuid:87471d0f-bc6c-4d29-a067-fe91c7a4fb50

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.29:32
Kudossokeri: 8.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:291c591e-178d-5797-aadb-006e2b82ff5e

```

-------

Entry 319 - fullUrl = urn:uuid:233c5ae6-dd29-4552-b45d-89bee58adca4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.34:34
Kudossokeri: 8.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:068201e5-4c27-552a-9a84-a6e1e9a1f8a5

```

-------

Entry 320 - fullUrl = urn:uuid:809bd487-e134-4f1e-b1c8-e7fde1ab2b4d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.39:32
Kudossokeri: 8.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9c37f146-44bd-53c1-bfe4-be0efd79273d

```

-------

Entry 321 - fullUrl = urn:uuid:c777eb90-e45c-4465-9333-a9bb5d7920f0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.44:32
Kudossokeri: 8.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e4316fc2-0b85-570d-84cc-0d11adc3e4ee

```

-------

Entry 322 - fullUrl = urn:uuid:fefd0a58-2bc4-4c9b-96a8-c7ff2c0c46a9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 09.45:16 - 10.28:20
Lyhytvaikutteinen insuliini 0.00 ky (0 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:067dc30c-19b1-5824-821c-76b5d0c2c8fb

```

-------

Entry 323 - fullUrl = urn:uuid:a06e6569-8039-449b-8713-57e15d6c961d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.49:33
Kudossokeri: 8.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:87cf164b-4e3c-5c25-aa1e-9ba6bb3354d6

```

-------

Entry 324 - fullUrl = urn:uuid:179dc577-392c-41c2-ae31-89ecda5d66dc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.54:35
Kudossokeri: 7.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9b24dff6-942c-5321-8d3c-e7d4ae5f8f57

```

-------

Entry 325 - fullUrl = urn:uuid:d91b6218-7a98-47bd-bb88-661051bcf3e9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 09.59:35
Kudossokeri: 7.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c29f8a4-005e-5332-921f-3c976dec036d

```

-------

Entry 326 - fullUrl = urn:uuid:3ed01305-bb2f-45a6-be71-60e2b0946d84

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.04:35
Kudossokeri: 6.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3c5a63b0-cb36-5059-b0fa-41924f6adefa

```

-------

Entry 327 - fullUrl = urn:uuid:8553bb21-7f71-4b56-8748-1508e23f4194

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.09:33
Kudossokeri: 5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:42ae0446-fd74-59c1-b044-ed7d84f0a6c2

```

-------

Entry 328 - fullUrl = urn:uuid:10717478-f1ff-4bba-b4b9-eeaa59cdb113

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.14:35
Kudossokeri: 5.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:122b91bb-d917-5417-b859-5863cc575632

```

-------

Entry 329 - fullUrl = urn:uuid:dbcc7e50-167a-4961-8211-8f64cc28fca0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.19:32
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c5ea02f5-5a22-54d6-980b-8c64c9b0345b

```

-------

Entry 330 - fullUrl = urn:uuid:fb7798f5-475d-4326-ac67-f063ef11660b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.24:33
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:772ff517-ca60-5ae1-9496-5e6ef9efe8b2

```

-------

Entry 331 - fullUrl = urn:uuid:1feb7675-5b05-4438-9cbe-d0f817c38c7e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 10.28:20 - 10.33:20
Lyhytvaikutteinen insuliini 0.06 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:94f4e448-7502-5059-8c45-575a62cc225c

```

-------

Entry 332 - fullUrl = urn:uuid:586eab05-27f6-4053-b29a-bfe17b3bd12b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.29:33
Kudossokeri: 7.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0e25574b-f4a4-5489-8563-b1e3c9fea5b2

```

-------

Entry 333 - fullUrl = urn:uuid:a3061ee4-e055-48e6-bd22-bd6efb4551f6

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 10.33:20 - 10.38:21
Lyhytvaikutteinen insuliini 0.18 ky (2.17 ky/t, 3.10 % = 6.75 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7d87c68c-f232-59e2-ae4f-0fb2ce34e942

```

-------

Entry 334 - fullUrl = urn:uuid:2341832a-b789-402c-a798-c1acd1638f1d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 10.33:56
Lyhytvaikutteinen insuliini 1.61 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8a61a6bd-ac0b-5807-ad71-2ccf4c1fd4d9

```

-------

Entry 335 - fullUrl = urn:uuid:ab578d8c-28da-4467-a1d0-750ee05d05d0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.34:35
Kudossokeri: 7.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:372686cf-314d-5673-b616-6fba6381e8d9

```

-------

Entry 336 - fullUrl = urn:uuid:3c484795-a3a4-4f7b-83dc-124d49c588dc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 10.38:21 - 11.43:32
Lyhytvaikutteinen insuliini 0.76 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8e279439-111c-54cb-97c4-f7df8a4bbe51

```

-------

Entry 337 - fullUrl = urn:uuid:34f5b70b-b12a-405a-8f64-f2e017045d88

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.39:34
Kudossokeri: 8.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3588e1b0-3024-5840-af0c-7f41dac7ab6b

```

-------

Entry 338 - fullUrl = urn:uuid:42c8ff53-164c-45b9-b3f9-0d65b6dc500b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.44:32
Kudossokeri: 8.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:13a7842e-9664-5e67-9235-614059955188

```

-------

Entry 339 - fullUrl = urn:uuid:a1be428d-83fe-48c1-b362-52e79f47c264

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.49:34
Kudossokeri: 8.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d671809e-cca2-534c-8c20-c0440ca908ef

```

-------

Entry 340 - fullUrl = urn:uuid:a52a877c-82ae-4877-b30d-6e718020fae8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.54:32
Kudossokeri: 8.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:34cd2e14-ea9c-5c5f-9ac5-b44ff5be3fe0

```

-------

Entry 341 - fullUrl = urn:uuid:1ec5f57d-7bc1-49f6-b218-a96d94a4ea8f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 10.59:32
Kudossokeri: 8.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b9cbcadd-e330-5bc4-ad17-eafff8358e9b

```

-------

Entry 342 - fullUrl = urn:uuid:29ac34c6-fe04-4855-8bf1-3227aaea9293

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.04:32
Kudossokeri: 8.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:28a424c6-5837-51d5-8782-5e4d19e56f91

```

-------

Entry 343 - fullUrl = urn:uuid:79260a99-4e1d-4a6c-8495-76fc78138a7b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 11.04:50
Lyhytvaikutteinen insuliini 9.58 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0c0bb164-5163-5517-a206-6f065cad6e30

```

-------

Entry 344 - fullUrl = urn:uuid:8376c6cb-1dd8-4f2d-a780-b0567ca8533c

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 5.9.2021 11.04:50
Arvioitu hiilihydraattimäärä: 95 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3da1d392-6ad3-5845-afa1-e6862f01c204

```

-------

Entry 345 - fullUrl = urn:uuid:f519f08f-7362-4dff-8c75-965fba90ba17

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.09:33
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7ae9ef7f-55c4-5b59-907a-66f8cb408e35

```

-------

Entry 346 - fullUrl = urn:uuid:f1c87de1-21e7-4953-8d95-92216bb901e2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.14:33
Kudossokeri: 7.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:249b2cdd-af0b-500e-a6c7-fff011612edc

```

-------

Entry 347 - fullUrl = urn:uuid:7906e27f-0a97-496a-a9c8-5101c25683aa

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.19:36
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2792bde9-a598-5e11-af46-310c4e4717d9

```

-------

Entry 348 - fullUrl = urn:uuid:42ffdc6b-8151-4119-94b4-d80ecf65c958

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.24:34
Kudossokeri: 7.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dbcaff77-9c04-5337-abc0-f011ea074aa9

```

-------

Entry 349 - fullUrl = urn:uuid:07597900-7744-454b-b93c-a4c5f36c3ed3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.29:32
Kudossokeri: 7.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5d769446-cfda-5e45-a763-62ccac01d7fc

```

-------

Entry 350 - fullUrl = urn:uuid:641db669-72d0-4723-9a72-6271f37c2751

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.34:33
Kudossokeri: 7.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:baf53e33-4207-5d1b-addb-11a6db0b0aac

```

-------

Entry 351 - fullUrl = urn:uuid:347daf65-c6f7-4b81-b84f-598e8d1d1ed6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.39:33
Kudossokeri: 7.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4761dd82-6fd3-530c-b579-31e977b9a6cb

```

-------

Entry 352 - fullUrl = urn:uuid:f68652f2-927f-4e75-a6ea-e59d690a8de6

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 11.43:32 - 11.48:32
Lyhytvaikutteinen insuliini 0.05 ky (0.65 ky/t, 0.93 % = 0.61 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c34cdefd-0681-57df-808d-0077b9ba0ab6

```

-------

Entry 353 - fullUrl = urn:uuid:6752db5e-d19f-4972-824f-6823e172682e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.44:32
Kudossokeri: 6.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9ab8fb44-6091-52e1-b43e-dbb4089ff5a7

```

-------

Entry 354 - fullUrl = urn:uuid:f3f71edd-7420-4061-b709-1f92c06ddb30

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 11.48:32 - 11.53:34
Lyhytvaikutteinen insuliini 0.02 ky (0.23 ky/t, 0.34 % = 0.08 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7670058e-060a-5c59-82cc-b1f485f5e7d1

```

-------

Entry 355 - fullUrl = urn:uuid:0b305d83-9f32-4ec3-ba80-b9070c6215a0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.49:32
Kudossokeri: 6.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:20e78e9f-3d40-5789-a2c4-ad147b03f979

```

-------

Entry 356 - fullUrl = urn:uuid:aa8b109e-0746-4200-8b32-147bd75fef64

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 11.53:34 - 11.58:35
Lyhytvaikutteinen insuliini 0.01 ky (0.13 ky/t, 0.18 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4fc86b84-af52-51dd-b184-94ae2f9f4440

```

-------

Entry 357 - fullUrl = urn:uuid:568e52dd-2d5b-4112-9d6e-ec3136c19a0c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.54:32
Kudossokeri: 6.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a06e7ef3-861a-5f34-8f5a-9f5dd3992157

```

-------

Entry 358 - fullUrl = urn:uuid:a3a63d97-ff97-4cf0-b705-4bb845026004

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 11.58:35 - 12.03:34
Lyhytvaikutteinen insuliini 0.02 ky (0.23 ky/t, 0.33 % = 0.07 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6ce6135f-2069-53e6-af6b-68a2a0b8c271

```

-------

Entry 359 - fullUrl = urn:uuid:b3f6473c-8f36-4ae3-8cc6-ea337182d5c1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 11.59:34
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2c96e2c7-683a-5b1e-b408-5b237059bfe1

```

-------

Entry 360 - fullUrl = urn:uuid:fb3495c3-7921-44f1-ac28-782e1656be06

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 12.03:34 - 12.08:35
Lyhytvaikutteinen insuliini 0.06 ky (0.70 ky/t, 1.00 % = 0.70 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6baa1b71-e5b8-5218-a1e3-70a9e51e3c75

```

-------

Entry 361 - fullUrl = urn:uuid:abca8742-89e3-4bb5-ae2f-d9351e8ce44a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.04:36
Kudossokeri: 7.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bd77bcb7-0938-5311-b4bd-4fe87a99d5e5

```

-------

Entry 362 - fullUrl = urn:uuid:7cdf9d90-1b33-4099-88b5-f57f7d4f42d1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 12.08:35 - 14.03:52
Lyhytvaikutteinen insuliini 1.34 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e69a37cd-7c27-5354-b0f6-598b2381589c

```

-------

Entry 363 - fullUrl = urn:uuid:27be3fe5-f3ce-46a3-ad7c-4de58df21082

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.09:32
Kudossokeri: 7.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2237560a-c71d-57e9-bd3b-bbd5f7fcac6e

```

-------

Entry 364 - fullUrl = urn:uuid:adc3c115-32ec-4d66-8da1-8413a6ebf4ed

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.14:32
Kudossokeri: 8.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:793b0bdb-f8f7-5ea5-a370-b38421517d07

```

-------

Entry 365 - fullUrl = urn:uuid:1ca5ff71-c1ce-417d-8010-ba264b2df8dc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.19:33
Kudossokeri: 9.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9621456e-6c4f-5215-846e-8ad861b2d6fb

```

-------

Entry 366 - fullUrl = urn:uuid:6971c678-e695-4b51-accf-9fea105a67e1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.24:32
Kudossokeri: 9.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7c875f90-5b52-57a3-be01-2435dd585224

```

-------

Entry 367 - fullUrl = urn:uuid:077c6d5d-7f56-477f-976b-3d24cdf861ea

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.29:33
Kudossokeri: 9.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b38dfa78-632f-5e67-a75c-2a20c2ece7d9

```

-------

Entry 368 - fullUrl = urn:uuid:a222f548-5cff-46e2-bb7a-c16068a92437

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.34:32
Kudossokeri: 9.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9ed06595-3e47-51ad-83f5-8d72103aed8a

```

-------

Entry 369 - fullUrl = urn:uuid:64a663cb-8e65-4dab-b6ce-f4210497ef82

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.39:36
Kudossokeri: 9.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fa16494c-16e4-5fa2-a87c-738ff0c3565d

```

-------

Entry 370 - fullUrl = urn:uuid:1b74c811-f2b6-436b-81dd-1c2e878c5247

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.44:32
Kudossokeri: 9.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:88d52bb7-5404-5403-9f8e-b446fab4644e

```

-------

Entry 371 - fullUrl = urn:uuid:9a268f5e-9add-4bb4-b338-8094ed690b38

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.49:33
Kudossokeri: 9.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:431a4679-4317-5268-8ff9-3764c7b1a8c7

```

-------

Entry 372 - fullUrl = urn:uuid:98ae02e8-80a0-4da2-849a-2f9a14178378

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.54:32
Kudossokeri: 9.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cb1454bf-5904-5295-8138-bfe2c4d584ae

```

-------

Entry 373 - fullUrl = urn:uuid:757e4085-c30b-4bd1-bab2-7cd4a3d09661

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 12.59:32
Kudossokeri: 9.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d37221f7-0b47-59c2-8637-dedb483559c6

```

-------

Entry 374 - fullUrl = urn:uuid:094b2aca-8b1a-4f69-9b36-0513dda563cf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.04:32
Kudossokeri: 9.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d17d1291-e486-57fc-ae73-37296ef13786

```

-------

Entry 375 - fullUrl = urn:uuid:1703b4be-7dc0-4727-a7ce-88fc43afdb11

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.09:32
Kudossokeri: 9.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:016be24c-cbb0-52bf-a40e-77f3a64880f3

```

-------

Entry 376 - fullUrl = urn:uuid:7231047f-acf9-4a03-b342-79ac8c8b2279

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.14:32
Kudossokeri: 9.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e6bcc00d-c6b1-50ff-9a3f-adfa6f5ff951

```

-------

Entry 377 - fullUrl = urn:uuid:642703e3-8779-42e6-bb78-29d68bd0dc44

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.19:32
Kudossokeri: 9.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:86b5792e-d8d6-5d5a-a970-dc639ae8f77f

```

-------

Entry 378 - fullUrl = urn:uuid:862f8a82-88a2-4a3c-bbe0-772c8f5ea3d9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 13.24:00
Lyhytvaikutteinen insuliini 0.68 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1dce97aa-5c1e-530f-ae90-fb557cc62448

```

-------

Entry 379 - fullUrl = urn:uuid:73b6bd3d-faab-47b7-9445-611724ba4ade

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.24:32
Kudossokeri: 10.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ae2fb876-15aa-5d93-80bf-8f4d2b2c5e15

```

-------

Entry 380 - fullUrl = urn:uuid:8d25b137-58ec-42cb-89e0-c7280f47d85a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.29:34
Kudossokeri: 10.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:81bc6e0c-8e19-588e-9d25-aeec57c1e861

```

-------

Entry 381 - fullUrl = urn:uuid:be2c7431-c406-4b85-bee5-26a4ade0f128

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.34:34
Kudossokeri: 10.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8b9ee205-9f34-5cef-9fbc-d5bf5cd86ef6

```

-------

Entry 382 - fullUrl = urn:uuid:72e76e5b-7e20-46b9-b47c-be96af6d6421

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.39:33
Kudossokeri: 10.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:abe2e155-617c-5ec5-b740-6089cdb493be

```

-------

Entry 383 - fullUrl = urn:uuid:91160002-a322-4e0b-b0e4-6ac045f3d01a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.44:32
Kudossokeri: 10.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:122517e2-b05e-51dc-8184-805dae5c1d5c

```

-------

Entry 384 - fullUrl = urn:uuid:f97b6d1f-3017-4271-8a43-16143eeb31a0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.49:32
Kudossokeri: 10.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6768b0cf-610c-5eee-8e92-4d40038064a2

```

-------

Entry 385 - fullUrl = urn:uuid:0dcca5ef-8701-4091-b7c7-5eda150d6dd2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.54:33
Kudossokeri: 10.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:63e9beb3-d5e7-5bc9-b795-1f88126c7508

```

-------

Entry 386 - fullUrl = urn:uuid:ab9d5d52-70e3-44c0-b00f-f1ba202de77c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 13.59:32
Kudossokeri: 10.93 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f538fd30-e98e-5a2a-a148-987d37b39384

```

-------

Entry 387 - fullUrl = urn:uuid:cdb20cf3-5de0-4860-ac63-1fad2f9e780b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.03:52 - 14.08:53
Lyhytvaikutteinen insuliini 0.11 ky (1.29 ky/t, 1.84 % = 2.37 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:097a6d77-9df2-57fb-9227-7a9f6a2133f6

```

-------

Entry 388 - fullUrl = urn:uuid:318badcd-29b0-48ec-b74f-5abca395fda9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.04:32
Kudossokeri: 11.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:79e0fcc8-1aac-5a40-b757-0ab20ee45207

```

-------

Entry 389 - fullUrl = urn:uuid:4ad2187d-f6b7-4025-9317-159510d7c62b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.08:53 - 14.13:54
Lyhytvaikutteinen insuliini 0.17 ky (2.02 ky/t, 2.89 % = 5.83 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:36a3e568-b2c3-5c2e-83b1-118d6ec18bb4

```

-------

Entry 390 - fullUrl = urn:uuid:e1b44893-459a-43f3-97a2-ad4382c90bbf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.09:32
Kudossokeri: 11.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f30c3199-d108-5e4a-9d15-b849a1adf50b

```

-------

Entry 391 - fullUrl = urn:uuid:96741d2a-8894-42f6-8a50-3002150b18a4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.13:54 - 14.18:55
Lyhytvaikutteinen insuliini 0.17 ky (2.00 ky/t, 2.85 % = 5.69 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0416311a-9100-5772-8d44-82b9d7156dad

```

-------

Entry 392 - fullUrl = urn:uuid:be835e3d-5a8e-479c-a672-285a93b240ec

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.14:34
Kudossokeri: 10.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2331e04-1664-5de5-8767-6a75aba8bd25

```

-------

Entry 393 - fullUrl = urn:uuid:ef73a22d-0363-4e25-bdcd-8d344becece4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.18:55 - 14.23:56
Lyhytvaikutteinen insuliini 0.06 ky (0.71 ky/t, 1.02 % = 0.72 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9edcb066-dc3a-55b3-8f5a-6998b20599d2

```

-------

Entry 394 - fullUrl = urn:uuid:292c1b66-d65f-4240-8672-8b3577c8f700

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.19:32
Kudossokeri: 11.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b22af262-85c4-576a-81d7-9c999ec551b8

```

-------

Entry 395 - fullUrl = urn:uuid:785ad1a5-5d7c-4d1e-a27d-c52fa531faaa

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.23:56 - 14.28:58
Lyhytvaikutteinen insuliini 0.08 ky (0.93 ky/t, 1.32 % = 1.23 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ead55ce8-3e34-5b99-9e65-02d8a2a19370

```

-------

Entry 396 - fullUrl = urn:uuid:67308749-af58-4d35-bc04-81e5ba36b45c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.24:33
Kudossokeri: 11.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0f369c4d-4b93-59b5-a750-3519e448ca54

```

-------

Entry 397 - fullUrl = urn:uuid:be9c23c3-cdbd-4feb-8d2d-55c01035a363

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.28:58 - 14.33:59
Lyhytvaikutteinen insuliini 0.09 ky (1.04 ky/t, 1.48 % = 1.53 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b12b7e95-2b90-5ef1-bd5f-07a5c0d2b6d7

```

-------

Entry 398 - fullUrl = urn:uuid:6e409884-9617-49c2-a6d5-37a0e7b92ab6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.29:32
Kudossokeri: 11.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1f326ca6-b7d8-52a0-a5c7-1bd3c0cb6ed1

```

-------

Entry 399 - fullUrl = urn:uuid:3da2011d-d514-4e49-aa87-e86a5b47ad31

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.29:33
Lyhytvaikutteinen insuliini 0.98 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:86191c37-ba79-5fce-98c9-3abc823e8397

```

-------

Entry 400 - fullUrl = urn:uuid:0b744c04-28c6-44d6-a772-c3d213b65d6c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.33:59 - 14.43:59
Lyhytvaikutteinen insuliini 0.12 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:be4c11e3-2075-5bcf-9313-4791f250e10e

```

-------

Entry 401 - fullUrl = urn:uuid:a7d08e66-d5ac-4be1-a754-d8f858e7c468

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.34:35
Kudossokeri: 11.32 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:849ef370-ad34-5001-bfd5-f32251452f0d

```

-------

Entry 402 - fullUrl = urn:uuid:3b785eef-603f-4845-82a6-d16ea731d968

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.39:32
Kudossokeri: 11.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f8981696-8e14-553f-9b52-380776dbea41

```

-------

Entry 403 - fullUrl = urn:uuid:73f66a76-62f7-4d91-98dd-c76c9d5864db

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.43:59 - 14.49:01
Lyhytvaikutteinen insuliini 0.06 ky (0.77 ky/t, 1.11 % = 0.86 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cbf104d8-21bf-52c3-91a9-eee27d22e740

```

-------

Entry 404 - fullUrl = urn:uuid:0f35cf90-2b78-40de-b4ed-037881de13ea

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.44:34
Kudossokeri: 11.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e408777f-2c4a-50a9-844a-4dbf67460353

```

-------

Entry 405 - fullUrl = urn:uuid:3bb27e91-7a31-44a0-861f-de35d498c825

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.49:01 - 14.54:00
Lyhytvaikutteinen insuliini 0.11 ky (1.38 ky/t, 1.97 % = 2.72 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6af4c8c4-7d68-5484-85e7-8706ddfdca9b

```

-------

Entry 406 - fullUrl = urn:uuid:d19e22a5-0a18-4f4c-a80f-e22556efeca1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.49:32
Kudossokeri: 11.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e0eb7d50-315e-5176-9074-f08347fa010f

```

-------

Entry 407 - fullUrl = urn:uuid:090cd0a7-0dd4-44fa-84b3-f1856d1dcc0b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.54:00 - 14.59:03
Lyhytvaikutteinen insuliini 0.15 ky (1.80 ky/t, 2.58 % = 4.64 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d7b53c26-ab7b-5cf5-8b5b-6336884f97ae

```

-------

Entry 408 - fullUrl = urn:uuid:7db3de05-a2a6-4c42-9b0f-145446bd73e6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.54:32
Kudossokeri: 12.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:213b287d-184d-53f5-98df-addd2db7adbb

```

-------

Entry 409 - fullUrl = urn:uuid:d1b8bac0-3b45-4044-93c5-0277d0ddde56

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 14.59:03 - 15.04:03
Lyhytvaikutteinen insuliini 0.19 ky (2.22 ky/t, 3.17 % = 7.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ae5e6e08-1b4e-5d7a-a42d-918320e5dca2

```

-------

Entry 410 - fullUrl = urn:uuid:24666f64-663b-4411-bb5a-099f7154dc2e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 14.59:32
Kudossokeri: 12.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc2ccaf5-e1ba-53c7-9ab3-1b03f824df8d

```

-------

Entry 411 - fullUrl = urn:uuid:09fb11e0-0700-47fd-90c7-377883df4655

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 15.04:03 - 15.39:09
Lyhytvaikutteinen insuliini 1.48 ky (2.53 ky/t, 3.62 % = 9.17 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:eff05526-c629-5144-abba-ac649ac357bc

```

-------

Entry 412 - fullUrl = urn:uuid:f5b084a0-75ed-4057-bf22-ef78a8edfea5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.04:31
Kudossokeri: 12.93 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:58100d2b-d7b2-53d0-b99e-38231a8b9cd2

```

-------

Entry 413 - fullUrl = urn:uuid:f4b0778b-d6c7-44f8-a902-84109f5f236f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.09:32
Kudossokeri: 13.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:43ddc395-dd2b-534a-b6a4-1b82830291f5

```

-------

Entry 414 - fullUrl = urn:uuid:b182ba93-f530-438d-a368-1a21952493f6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.14:32
Kudossokeri: 13.43 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3db8b185-29bd-59ac-88b1-87f6a83be431

```

-------

Entry 415 - fullUrl = urn:uuid:4a1984f6-f412-4453-a020-fbab7a024ca1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.19:31
Kudossokeri: 13.65 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:69273e6d-39d4-5097-9fd9-fd9c3bf2f24b

```

-------

Entry 416 - fullUrl = urn:uuid:8f32bced-1b3a-4dad-9797-e89aaf44669f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.24:32
Kudossokeri: 13.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c4236277-a912-5e0f-bb80-f939d34b07eb

```

-------

Entry 417 - fullUrl = urn:uuid:1240f7e2-56c9-4e35-9958-3ede13f9396c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.29:32
Kudossokeri: 13.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f8045c3c-c041-50c4-937a-a59df8860170

```

-------

Entry 418 - fullUrl = urn:uuid:1cbfb7b0-7e37-413c-8396-e5c38a4485ce

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 15.34:21
Lyhytvaikutteinen insuliini 1.55 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:60462f0d-06e8-57e0-abdb-5400be059b13

```

-------

Entry 419 - fullUrl = urn:uuid:70f5d46f-fa17-466c-a072-8e2cb3572536

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.34:32
Kudossokeri: 13.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8e6af323-5773-5860-95fc-cbd8242a95bb

```

-------

Entry 420 - fullUrl = urn:uuid:e8394f34-5b1b-4e73-9fb7-2980a99cb63d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 15.39:09 - 16.09:12
Lyhytvaikutteinen insuliini 0.35 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a67c3601-7e7a-5f24-ae9f-5d1255d918a2

```

-------

Entry 421 - fullUrl = urn:uuid:d17c2945-4c2c-4e0f-af4e-0b8330250290

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.39:32
Kudossokeri: 14.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fd1d7d53-6f42-51b7-9944-7b45072539b1

```

-------

Entry 422 - fullUrl = urn:uuid:a35b968c-2c73-4b4b-8b72-20545fb002aa

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.44:33
Kudossokeri: 14.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ad19627d-f262-59eb-bba1-24bc8ee95ec0

```

-------

Entry 423 - fullUrl = urn:uuid:b0f7928f-64bd-4686-a570-dc81641f88fa

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.49:33
Kudossokeri: 14.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:da56b3e6-562e-59bc-be21-3a970605725a

```

-------

Entry 424 - fullUrl = urn:uuid:fd46c98e-cc71-4236-826f-26536da8fb3e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.54:33
Kudossokeri: 14.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7af4ca2e-0483-5956-a5d2-17ced6dd131b

```

-------

Entry 425 - fullUrl = urn:uuid:61d7aab0-b178-4c2e-adea-014f63d8ff02

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 15.59:33
Kudossokeri: 14.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:06a931ab-0d30-5215-bffd-5b562320ac6f

```

-------

Entry 426 - fullUrl = urn:uuid:f9a729ec-b22a-413b-8b8a-7dc13ada070e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.04:33
Kudossokeri: 13.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:858d8b38-572e-522b-b430-fb0a7b9ec94f

```

-------

Entry 427 - fullUrl = urn:uuid:9fa8cee0-d070-42b5-89be-5aaa750e2b08

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 16.09:12 - 16.14:14
Lyhytvaikutteinen insuliini 0.08 ky (0.91 ky/t, 1.30 % = 1.18 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:72a7449b-1efd-56af-958d-f4bcce9290bc

```

-------

Entry 428 - fullUrl = urn:uuid:46052dd0-e8ca-4441-875a-133fd5149866

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.09:32
Kudossokeri: 13.43 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ee1ae76b-fb8f-5541-af9f-0990bf3cb583

```

-------

Entry 429 - fullUrl = urn:uuid:30add544-6126-4c85-8e13-053e356dc4c1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 16.14:14 - 18.04:31
Lyhytvaikutteinen insuliini 1.29 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:33e12170-7565-5d81-a79e-9acdb576dc11

```

-------

Entry 430 - fullUrl = urn:uuid:fb6b00cc-fb33-419c-9656-255b7c99ccf2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.14:38
Kudossokeri: 13.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80e6465f-3ada-5d07-a79e-6b4f5def8a52

```

-------

Entry 431 - fullUrl = urn:uuid:14c2611d-8d83-412d-b7d1-d38297ee4263

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.19:31
Kudossokeri: 12.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7c0f685f-92a2-5f02-902b-6ed0d6c70d49

```

-------

Entry 432 - fullUrl = urn:uuid:119ce041-6fc2-478b-90de-1587a203cf53

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 16.21:46
Lyhytvaikutteinen insuliini 6.04 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4b6debf2-6411-5f1a-9658-ac2922a008dd

```

-------

Entry 433 - fullUrl = urn:uuid:43cdf944-45ea-4985-a7ee-8a1434200a1f

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 5.9.2021 16.21:46
Arvioitu hiilihydraattimäärä: 65 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c9df4ac2-ec94-5f1a-87e2-1bcd7659d2a7

```

-------

Entry 434 - fullUrl = urn:uuid:1be2756a-3689-47b4-ad39-19d5cf1d0d27

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.24:32
Kudossokeri: 12.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4fd1f298-7dfb-56ec-b9ac-69edbe84142e

```

-------

Entry 435 - fullUrl = urn:uuid:80eab4c8-4a67-4a14-87c6-e685d605a81c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.29:32
Kudossokeri: 11.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bff7915f-17ce-56e8-be7f-7b08f6117a33

```

-------

Entry 436 - fullUrl = urn:uuid:b88b47d8-fb8f-4ee4-a177-a0f90f484be7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.34:32
Kudossokeri: 11.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:67715b31-d27b-5165-843c-203dd77359d1

```

-------

Entry 437 - fullUrl = urn:uuid:14aa0a1c-db98-4eb3-a3c1-a73526e70a77

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.39:31
Kudossokeri: 10.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4a92a53b-a195-5996-98ea-433e71efe1f5

```

-------

Entry 438 - fullUrl = urn:uuid:29c3ddcc-a14b-4767-bd14-75d9678ba509

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.44:33
Kudossokeri: 10.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:499dd06d-7f82-548d-84fe-98a888dd191f

```

-------

Entry 439 - fullUrl = urn:uuid:38d4bbb8-7f41-4ea2-984e-55c352627c15

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.49:32
Kudossokeri: 9.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8533b9fb-9910-5788-bf9c-65e74de69b6f

```

-------

Entry 440 - fullUrl = urn:uuid:e0873686-5997-4da3-9cd8-2c4540063dd2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.54:33
Kudossokeri: 9.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3ac0f5d7-4648-5305-8ca5-621fb5de120d

```

-------

Entry 441 - fullUrl = urn:uuid:1138c77a-453a-46ab-b805-af5c85de9699

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 16.59:31
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3755ccb5-5b67-5791-98c6-d54c754310d0

```

-------

Entry 442 - fullUrl = urn:uuid:98b7a4ae-85f6-4678-a0df-1005f4489c6e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.04:31
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dbb86221-300c-56f0-bca9-bea64aac16b8

```

-------

Entry 443 - fullUrl = urn:uuid:75a7c37c-8d2f-42bd-bb52-1bd9d4065894

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.09:31
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6c4d90af-4e82-528f-9a7d-e62d39759438

```

-------

Entry 444 - fullUrl = urn:uuid:d26c05f8-a502-4a6a-8c52-46c69f14442e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.14:32
Kudossokeri: 9.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7a6ba2f8-4b7d-5685-a9c4-4d4895336aee

```

-------

Entry 445 - fullUrl = urn:uuid:e872ee09-ea4f-4472-8c46-73c07b0969ca

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.19:32
Kudossokeri: 9.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9d48ed35-74e6-586a-8a9c-f37cb1b4cfa9

```

-------

Entry 446 - fullUrl = urn:uuid:20aa04cd-5f29-408d-9201-8adb24178589

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.24:31
Kudossokeri: 9.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ace31ce5-1123-5308-ba92-c40ace81878d

```

-------

Entry 447 - fullUrl = urn:uuid:feac4c31-9290-46bd-bcef-57b4c50294d4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.29:32
Kudossokeri: 9.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:28bf9a19-d645-5d2d-8bb7-3cb18a533492

```

-------

Entry 448 - fullUrl = urn:uuid:481469b1-21a2-433b-aba4-49ee111873b2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.34:38
Kudossokeri: 8.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:02e76ca4-97c2-5bd7-adf3-2a8ef09c8406

```

-------

Entry 449 - fullUrl = urn:uuid:5f710336-3b13-485e-a98e-823cf1de99e0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.39:34
Kudossokeri: 8.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0e737f8d-ac5c-555d-857e-f9966c8b874a

```

-------

Entry 450 - fullUrl = urn:uuid:2b87c238-710a-44d5-bf4a-e83605ff6862

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.44:33
Kudossokeri: 8.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c87c8272-5c48-53e9-a9b4-d74d56d6df66

```

-------

Entry 451 - fullUrl = urn:uuid:9226dbb4-3440-45a4-b620-f5ebb7e572b5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.49:36
Kudossokeri: 8.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7c5ce7ce-0272-5f68-a441-3237d51c49be

```

-------

Entry 452 - fullUrl = urn:uuid:406257ff-0d52-4783-a7d7-205745759ea9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.54:35
Kudossokeri: 7.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:17fe92eb-e091-5116-a5c8-c7f490d65ea6

```

-------

Entry 453 - fullUrl = urn:uuid:e730827e-c924-4462-b514-8d8d1f80d2fe

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 17.59:35
Kudossokeri: 7.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:05490a9c-2b21-50b6-a1f5-666ca3124204

```

-------

Entry 454 - fullUrl = urn:uuid:52eb462a-4d30-436a-9fa7-01ce327a1ffc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.04:31
Kudossokeri: 6.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d27e2b3e-ed0c-57bd-a407-7345f2825534

```

-------

Entry 455 - fullUrl = urn:uuid:aec27275-8bd8-4693-818c-c935a3cb6d38

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.04:31 - 18.09:33
Lyhytvaikutteinen insuliini 0.04 ky (0.44 ky/t, 0.62 % = 0.27 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:50e76eb1-c729-5a36-9cde-53104e12d229

```

-------

Entry 456 - fullUrl = urn:uuid:929f909d-2792-4f16-9773-3a5f49b1eeaa

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.09:33
Kudossokeri: 6.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0f6998ce-8bbb-58cc-ac9e-b1cf91af477d

```

-------

Entry 457 - fullUrl = urn:uuid:78117fcb-bb4e-45d5-be30-4ceb93facd9d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.09:33 - 18.14:33
Lyhytvaikutteinen insuliini 0.01 ky (0.15 ky/t, 0.22 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c20bf9a6-fc17-502a-89e2-998d084ead57

```

-------

Entry 458 - fullUrl = urn:uuid:253c4373-194d-499f-93f8-b72fc6a51c19

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.14:31
Kudossokeri: 6.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:662a3162-a0d8-5550-8856-79971ebf94d7

```

-------

Entry 459 - fullUrl = urn:uuid:5ef83bd7-adac-422d-ba0a-77ec0fbd8afc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.14:33 - 18.19:34
Lyhytvaikutteinen insuliini 0.01 ky (0.15 ky/t, 0.21 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:97079fa7-0d61-5bd5-bb73-799af607a39d

```

-------

Entry 460 - fullUrl = urn:uuid:8a289423-38be-4405-b739-cf7479c1f39c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.19:31
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aabe1e13-c912-549a-b83e-a48bf240d674

```

-------

Entry 461 - fullUrl = urn:uuid:1c42c2ba-ee8e-4796-aa34-361484e4e460

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.19:34 - 18.24:35
Lyhytvaikutteinen insuliini 0.01 ky (0.14 ky/t, 0.20 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0d2808a5-74db-5ce0-9547-9bdc18cd937f

```

-------

Entry 462 - fullUrl = urn:uuid:9337e754-9ecf-4c44-ac3a-61499b1470d5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.24:31
Kudossokeri: 6.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9820d9ec-6865-5a2c-9efb-41c7bd09009e

```

-------

Entry 463 - fullUrl = urn:uuid:8443dca3-b3d5-43b7-942a-873c8ffa581b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.24:35 - 18.29:35
Lyhytvaikutteinen insuliini 0.01 ky (0.14 ky/t, 0.21 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7d1c4df7-f462-54be-b7c3-74c36cc3653d

```

-------

Entry 464 - fullUrl = urn:uuid:5d1b9d46-8092-4898-9cc0-8a7dc1ded3ee

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.29:31
Kudossokeri: 5.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bd0c8f94-dbd5-5fbf-a7fe-c02cb8ea9951

```

-------

Entry 465 - fullUrl = urn:uuid:1ccbdf40-bbd4-4155-956f-e9d1c2467c09

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.29:35 - 18.34:36
Lyhytvaikutteinen insuliini 0.01 ky (0.13 ky/t, 0.19 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:490442df-577f-5f46-a228-5c0e8c194e21

```

-------

Entry 466 - fullUrl = urn:uuid:631aaf4f-9421-405e-986a-1ea23627bab7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.34:31
Kudossokeri: 5.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ca2c2fa3-cac1-5577-bf74-1b456d1ea507

```

-------

Entry 467 - fullUrl = urn:uuid:5bcc3f3e-ae4d-4bf6-aee6-60cb5d2eea35

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.34:36 - 18.39:42
Lyhytvaikutteinen insuliini 0.01 ky (0.11 ky/t, 0.16 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ef65128f-b740-5cf5-9ee8-885cef3eb576

```

-------

Entry 468 - fullUrl = urn:uuid:8c576167-db7b-4b2a-9631-840129207783

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.37:43
Lyhytvaikutteinen insuliini 4.92 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3b29507f-4131-52ec-8a28-1f02c911e620

```

-------

Entry 469 - fullUrl = urn:uuid:b67001dd-1969-4818-85eb-503deb3f176f

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 5.9.2021 18.37:43
Arvioitu hiilihydraattimäärä: 80 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:768f8390-8491-5d4d-8729-c58735a83dad

```

-------

Entry 470 - fullUrl = urn:uuid:14b15072-13ae-4cbb-93b5-6008523d6a66

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.39:32
Kudossokeri: 5.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f9175aeb-ab11-5a95-b60c-e672e55478ff

```

-------

Entry 471 - fullUrl = urn:uuid:2d46db0b-19e0-48f1-8186-1a937586f3b3

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.39:42 - 18.44:38
Lyhytvaikutteinen insuliini 0.01 ky (0.12 ky/t, 0.17 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a9034c9e-1c8a-573a-a658-0aad2ef6722b

```

-------

Entry 472 - fullUrl = urn:uuid:206c5922-422b-4e20-bf77-945c68fa85cc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.44:31
Kudossokeri: 5.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2632cea0-4863-5e1b-a03c-60e5e6ccbb44

```

-------

Entry 473 - fullUrl = urn:uuid:f0f14ed7-93f3-4a89-bd04-ceefbde1731c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.44:38 - 18.49:39
Lyhytvaikutteinen insuliini 0.02 ky (0.27 ky/t, 0.38 % = 0.10 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b8075f80-7ae0-5ab0-9e6d-6c7ecb207258

```

-------

Entry 474 - fullUrl = urn:uuid:b4b63b1e-e9cb-4cb0-8551-17fa56f0789d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.49:33
Kudossokeri: 5.5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:734fc5fb-1fdd-571f-8cad-a450e1c01cce

```

-------

Entry 475 - fullUrl = urn:uuid:e2fd6054-6c8b-4cee-afc1-e5b5aed70855

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.49:39 - 18.54:40
Lyhytvaikutteinen insuliini 0.05 ky (0.60 ky/t, 0.85 % = 0.51 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4cbc4d0c-0513-50ba-b5aa-04594b19593d

```

-------

Entry 476 - fullUrl = urn:uuid:e4366d0e-a678-4400-a2ef-aec3c0a19ff0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.54:32
Kudossokeri: 5.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f20a4b3f-ce1c-5511-9169-3fef94d8c619

```

-------

Entry 477 - fullUrl = urn:uuid:5a0dcb60-e984-429a-980b-de502cac97fa

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.54:40 - 18.58:56
Lyhytvaikutteinen insuliini 0.05 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8fe8cd66-9891-52cd-9efd-e4ee3327bd61

```

-------

Entry 478 - fullUrl = urn:uuid:bd7a3383-5a34-4736-bbf8-ea3102c4e885

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 18.58:56 - 20.54:58
Lyhytvaikutteinen insuliini 0.00 ky (0 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5a42d5fd-dea9-538c-aca2-79abdcbdc3b9

```

-------

Entry 479 - fullUrl = urn:uuid:32e8da7a-25d9-4d41-8b56-1bedff0b51bc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 18.59:31
Kudossokeri: 5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:47df81ec-e33d-5e5f-ae80-58cd42bd4f32

```

-------

Entry 480 - fullUrl = urn:uuid:e633d660-5dd7-4e4e-87f8-8de800cc8db3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.04:32
Kudossokeri: 4.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3e3343f-97c0-5ce7-8d8c-5341292c9117

```

-------

Entry 481 - fullUrl = urn:uuid:fa05660d-c08e-4fc6-beee-54f0e706ce03

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.09:33
Kudossokeri: 4.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dd29c87b-a3ed-59cd-96f3-149b620221a8

```

-------

Entry 482 - fullUrl = urn:uuid:996eb580-9a8f-488b-a568-fdf8c3fbb22d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.14:31
Kudossokeri: 4.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:08b5db9f-6afe-5881-8ad4-2e46a98ca922

```

-------

Entry 483 - fullUrl = urn:uuid:65efea27-183f-4c24-9c30-3ec44ae1c9db

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.19:31
Kudossokeri: 4.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:870e19d6-e67c-55eb-9623-4b7700c7613d

```

-------

Entry 484 - fullUrl = urn:uuid:f0ee1efd-a781-4019-92d9-fc6c441cac94

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.24:31
Kudossokeri: 4.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:21a9314a-1cd2-5042-8a78-63e818198c3d

```

-------

Entry 485 - fullUrl = urn:uuid:7e3b3278-6643-4a8b-879a-28bfed5e114e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.29:31
Kudossokeri: 4.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a88efa4f-a90f-59ed-8167-d293c7e31a92

```

-------

Entry 486 - fullUrl = urn:uuid:bcc21442-66b4-4ada-a9ef-a22d6523d7a5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.34:31
Kudossokeri: 4.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a94ee29a-5b3f-5da5-a8bb-c974aa488a3d

```

-------

Entry 487 - fullUrl = urn:uuid:18bfd1af-f387-4df1-b604-4f181fecd9ba

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.39:31
Kudossokeri: 4.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1e170395-1be9-55e4-943e-88a5e0f427e7

```

-------

Entry 488 - fullUrl = urn:uuid:c4cbbfae-6cd1-486b-a032-f0e9c9b06391

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.44:31
Kudossokeri: 4.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:22cdc875-2e58-51ec-bb7e-3d6f26306869

```

-------

Entry 489 - fullUrl = urn:uuid:b60ec200-7d7f-427b-93b9-aba76a0f7dbe

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.49:31
Kudossokeri: 4.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8f453a5-cce5-5fa9-815b-138d381cd574

```

-------

Entry 490 - fullUrl = urn:uuid:3aae2be6-4fd0-4d30-bbc9-148c29fe2658

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.54:31
Kudossokeri: 4.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5809d1b2-f11b-502d-bce5-b0af3f928b4a

```

-------

Entry 491 - fullUrl = urn:uuid:c53a2602-8cef-456b-a56f-2899f00ddb22

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 19.59:31
Kudossokeri: 4.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ee3ef982-2e45-5e85-a8ad-b9a509430984

```

-------

Entry 492 - fullUrl = urn:uuid:18dc936d-57ed-4614-acb9-e84af5765a32

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.04:31
Kudossokeri: 3.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8cf48b83-f0a8-5c8e-9aff-7bb3f8465210

```

-------

Entry 493 - fullUrl = urn:uuid:a9c04667-2550-49bc-9675-ccb0e0cc81fe

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.09:31
Kudossokeri: 3.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:46e8a834-ad52-503d-b525-aa56af9c3d51

```

-------

Entry 494 - fullUrl = urn:uuid:52bea678-7d1c-411e-8e80-ae90b6f68ad3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.14:31
Kudossokeri: 3.39 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eb50f155-fa73-5f4d-91a2-929d6e4757be

```

-------

Entry 495 - fullUrl = urn:uuid:a60f9e16-25ab-48ca-b47c-e38d1f3e507a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.19:31
Kudossokeri: 3.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bae73364-5e5d-52f9-8d81-fa9b364066f9

```

-------

Entry 496 - fullUrl = urn:uuid:5591bf37-26bb-4173-be04-27d71d79ef4b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.24:31
Kudossokeri: 3.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:656592a4-9992-54a1-ae39-64062c649149

```

-------

Entry 497 - fullUrl = urn:uuid:72aed133-5971-4a01-9598-8cd3ad967178

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.29:31
Kudossokeri: 3.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aaad0a3e-c472-54a3-8410-2e5c0c62962d

```

-------

Entry 498 - fullUrl = urn:uuid:1bb7df2c-8f14-4343-95b0-42312e4139a2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.34:31
Kudossokeri: 3.89 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:46d9d8fe-5325-5e2b-b647-72b58bc01ad1

```

-------

Entry 499 - fullUrl = urn:uuid:4db95193-bbc3-4854-a548-c8835bfdad34

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.39:31
Kudossokeri: 4.5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:55aaccef-2386-50dc-beb7-5be8fec4ac66

```

-------

Entry 500 - fullUrl = urn:uuid:896c304f-75b4-4734-b86b-1a759e9bc780

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.44:31
Kudossokeri: 4.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8107b88-ea11-5572-b8bd-299b90a95151

```

-------

Entry 501 - fullUrl = urn:uuid:cd4d1237-214c-414e-8f6a-7afd667ca152

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.49:31
Kudossokeri: 5.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:31968f86-ef0b-5cb2-a049-4690a75337da

```

-------

Entry 502 - fullUrl = urn:uuid:3d7c4313-0932-4aba-95b9-ba5e6826fc45

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.54:31
Kudossokeri: 5.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:44f442cf-4821-5038-a480-6ff8b2eacf96

```

-------

Entry 503 - fullUrl = urn:uuid:8cafebfe-00a0-4a95-ba39-bb41b0413bc9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 20.54:58 - 20.57:37
Lyhytvaikutteinen insuliini 0.00 ky (0.10 ky/t, 0.15 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4d670687-fbc2-5bd4-a199-fde6f184e876

```

-------

Entry 504 - fullUrl = urn:uuid:94135733-fbcb-4d98-91a7-46cb2a497d13

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 20.55:18
Lyhytvaikutteinen insuliini 2.20 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fc5e8bc8-3007-50bb-b6f0-99bd31e73f11

```

-------

Entry 505 - fullUrl = urn:uuid:ef5c35ad-72a2-49f5-814d-debd8c4d094c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 20.57:37 - 21.40:29
Lyhytvaikutteinen insuliini 0.00 ky (0 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e33ed74b-bff3-57e9-a5ff-8ca006cfabd9

```

-------

Entry 506 - fullUrl = urn:uuid:e2fa7482-17d9-42f4-8389-766031f49305

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 20.59:31
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:78627f78-1210-57a7-a633-17bfedd86b63

```

-------

Entry 507 - fullUrl = urn:uuid:1967c54d-5a62-4fde-b827-adc1d56ed1e3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.04:31
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:67efc7a2-a176-539c-aa4a-a54bb0f390e9

```

-------

Entry 508 - fullUrl = urn:uuid:6a21bacf-4df4-46e5-a75b-b0166d9eb799

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.09:31
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:16013324-bd83-55f1-8d08-c11ef6965c3e

```

-------

Entry 509 - fullUrl = urn:uuid:ca63028a-752d-45dc-81af-50a0ae7d3b39

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.14:31
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9b0c1113-2b82-5dfb-94fc-a061030c0635

```

-------

Entry 510 - fullUrl = urn:uuid:4162ffed-5116-4690-ac5c-8cf998f0a145

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.19:31
Kudossokeri: 6.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9342c747-065f-5759-b806-d37a8431d31e

```

-------

Entry 511 - fullUrl = urn:uuid:64703193-1d4c-4c4b-ad32-b94fd04b294c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.24:31
Kudossokeri: 6.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2e589b61-9077-5ba4-8599-784698177a9c

```

-------

Entry 512 - fullUrl = urn:uuid:ea051925-144e-48bd-a1aa-9edbd10a56a0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.29:31
Kudossokeri: 6.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0702f651-6680-57c7-b2aa-576e74f11c08

```

-------

Entry 513 - fullUrl = urn:uuid:54613acb-fbfc-4ac0-b776-0d25776cf186

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.34:31
Kudossokeri: 6.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:92231924-1853-5d74-9080-c12c44648a48

```

-------

Entry 514 - fullUrl = urn:uuid:59925213-809a-4875-924d-1113d1c6b1c8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.39:31
Kudossokeri: 6.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6677b0b5-1d35-537c-ae3f-08dd613b9ef9

```

-------

Entry 515 - fullUrl = urn:uuid:c21c1e5f-bc09-414b-8ad7-d6bb1f465a68

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 21.40:29 - 21.41:33
Lyhytvaikutteinen insuliini 0.01 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:61a8182f-827f-5d17-bfe0-147ca1e87a62

```

-------

Entry 516 - fullUrl = urn:uuid:28883aa0-7cc7-4bdb-ba57-d709bf8c13f3

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 21.40:46
Lyhytvaikutteinen insuliini 0.85 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:642fb9ee-3ee0-5a85-8aa2-fd285870b896

```

-------

Entry 517 - fullUrl = urn:uuid:b2460f7a-fca3-427d-b8ff-5d55e7b9b033

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 5.9.2021 21.40:46
Arvioitu hiilihydraattimäärä: 25 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a683d9e8-6f4b-594a-a6c0-fd190d214041

```

-------

Entry 518 - fullUrl = urn:uuid:cc66adbf-5a41-495b-9d90-07ca12591033

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 21.41:33 - 22.46:35
Lyhytvaikutteinen insuliini 0.00 ky (0 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9b4a47e3-00b1-5a81-bb58-59be7779eaf0

```

-------

Entry 519 - fullUrl = urn:uuid:d2930fe4-6532-445a-aad4-6aa9f2c200df

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.44:31
Kudossokeri: 6.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc84f8ef-ba90-579b-9abf-9618edffdb7c

```

-------

Entry 520 - fullUrl = urn:uuid:98bba24e-4ef9-4903-95a3-ae07bb959c53

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.49:31
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dc5b133a-d087-5e40-aad1-33dda5effc6b

```

-------

Entry 521 - fullUrl = urn:uuid:942c6fc4-938b-4f94-a72b-159829db2b0e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.54:31
Kudossokeri: 5.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3e358558-76fa-5d0f-9aef-c1758a5f08b8

```

-------

Entry 522 - fullUrl = urn:uuid:341fd67b-ec77-4e6d-a15d-3544b680bbef

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 21.59:30
Kudossokeri: 5.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a64ec02c-fe75-5135-949e-7458a6e5587a

```

-------

Entry 523 - fullUrl = urn:uuid:633f4532-6055-4cf9-a0e9-58e53ecaea33

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.04:30
Kudossokeri: 4.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c029bf65-e48b-5d1f-b589-7895980fa558

```

-------

Entry 524 - fullUrl = urn:uuid:11e95a69-4158-45ff-b400-99689b47bfcb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.09:30
Kudossokeri: 4.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f8a785aa-85ce-5a6f-a66a-1db5c7bd5a55

```

-------

Entry 525 - fullUrl = urn:uuid:5a58bad0-375a-4253-ae84-f312d9992314

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.14:30
Kudossokeri: 4.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d6b9c767-9d9a-5433-b5dc-3afa35442a49

```

-------

Entry 526 - fullUrl = urn:uuid:d96b27ac-b7a4-4e61-8764-6c5da78c1b90

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.19:30
Kudossokeri: 4.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:748b23ab-7d80-5442-aebe-dc81d72c0086

```

-------

Entry 527 - fullUrl = urn:uuid:ece51eca-410b-4c90-ba6a-eb31cb022791

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.24:30
Kudossokeri: 4.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6896ff95-b225-550c-9333-1524cd365a47

```

-------

Entry 528 - fullUrl = urn:uuid:049907b2-0e01-4e45-b399-06920aa1f638

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.29:30
Kudossokeri: 4.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:baf382e0-7bc2-580e-894d-ef6dd550320e

```

-------

Entry 529 - fullUrl = urn:uuid:db710c91-a481-4813-9fd9-0613920fa388

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.34:32
Kudossokeri: 4.39 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:775d24ec-e2b4-5a4e-9250-0bf81b623780

```

-------

Entry 530 - fullUrl = urn:uuid:ad496cc5-5b5a-4fe5-a49f-bef6d27c57a9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.39:31
Kudossokeri: 4.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:716e5387-797d-5448-8a47-e09935c751e1

```

-------

Entry 531 - fullUrl = urn:uuid:0cbbfc17-6412-4de7-8f24-7df0351b0c4d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.44:32
Kudossokeri: 4.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:72f233ab-48cf-55a3-9eb6-e11d20c50230

```

-------

Entry 532 - fullUrl = urn:uuid:e82413f1-f5d0-4fea-8a84-d6aaff4ef98f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 22.46:35 - 23.01:56
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3a56b34f-b486-5e0b-960b-4c09b07eee6a

```

-------

Entry 533 - fullUrl = urn:uuid:9824a304-f82c-4a53-889d-2cb5a4b156ee

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.49:30
Kudossokeri: 3.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a5f27722-b88e-5ea5-aa3c-75a501a614c4

```

-------

Entry 534 - fullUrl = urn:uuid:226ad97d-7ff1-4746-a6e2-eae1e0ceb68f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 22.49:45
Lyhytvaikutteinen insuliini 2.68 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a215777c-0c98-5629-a6ed-e3a6d1174451

```

-------

Entry 535 - fullUrl = urn:uuid:ddfb8dbb-51dd-4d72-b682-07d3060fc271

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 5.9.2021 22.49:45
Arvioitu hiilihydraattimäärä: 50 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:02388d37-ac14-599c-8e07-8282d196c1fb

```

-------

Entry 536 - fullUrl = urn:uuid:63b0e9ba-7a58-47d4-8b54-ac104f249a2c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.54:30
Kudossokeri: 3.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:93ac7374-6bfd-5569-aaf4-91563f9d11f2

```

-------

Entry 537 - fullUrl = urn:uuid:3a858701-6ec9-4522-8e99-efb0ff4463a8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 22.59:31
Kudossokeri: 2.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:451d013c-6b2c-5351-a8f6-b73d62806458

```

-------

Entry 538 - fullUrl = urn:uuid:8e170d89-9523-4e08-b90c-dfd891d94f7d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 23.01:56 - 23.16:57
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:60436da7-388d-5a59-9631-1fd715acff76

```

-------

Entry 539 - fullUrl = urn:uuid:51ef5e0d-e3a7-4d28-b0cf-4c12b8c5ae69

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.04:31
Kudossokeri: 2.89 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e423b816-27cc-53a9-9b98-8b9015dcf408

```

-------

Entry 540 - fullUrl = urn:uuid:14ebf99b-9267-40e6-b254-995aa7235e62

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.09:31
Kudossokeri: 3.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3c4a947c-e764-59da-a9b7-de251460b6e7

```

-------

Entry 541 - fullUrl = urn:uuid:7cd3bf2f-9de1-4f31-9016-5a9ca5a5a43e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.14:31
Kudossokeri: 3.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ca02e712-66ff-566e-a2f9-2e6c9dc5eb4d

```

-------

Entry 542 - fullUrl = urn:uuid:1128e2ac-9255-4968-aab4-252288873e9c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 23.16:57 - 23.21:59
Lyhytvaikutteinen insuliini 0.04 ky (0.45 ky/t, 0.59 % = 0.27 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ce018242-cb78-5501-a5ae-9fdcfa2e8803

```

-------

Entry 543 - fullUrl = urn:uuid:4f7ee2de-3605-4617-abea-632fc36ff5a5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.19:30
Kudossokeri: 4.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3cd4239f-cfaa-533f-b07b-02f050294c4b

```

-------

Entry 544 - fullUrl = urn:uuid:5a2c238d-3d4a-4971-b8eb-03b85dd82800

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 23.21:59 - 23.27:00
Lyhytvaikutteinen insuliini 0.06 ky (0.75 ky/t, 0.99 % = 0.74 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e3cebe9b-d781-5e7d-bd5a-8af5b23e052d

```

-------

Entry 545 - fullUrl = urn:uuid:2f5edcbc-3954-4513-b824-3441cbeae9c0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.24:30
Kudossokeri: 4.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f6c14e5d-e304-5999-b432-1c78a729a9fa

```

-------

Entry 546 - fullUrl = urn:uuid:7f4df255-9a16-49a5-8c99-806d15d17715

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 23.27:00 - 23.32:00
Lyhytvaikutteinen insuliini 0.05 ky (0.57 ky/t, 0.76 % = 0.44 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fcf28fb9-f882-5bf1-895c-e232628776bf

```

-------

Entry 547 - fullUrl = urn:uuid:104b4de4-d3c7-4cae-8d93-d5ce5ebd5a91

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.29:37
Kudossokeri: 5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:20d2a788-29ba-5a93-b30b-39b28f5a1965

```

-------

Entry 548 - fullUrl = urn:uuid:df7311f9-daca-44ea-8f7e-1406e2266756

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 5.9.2021 23.32:00 - 6.9.2021 00.00:00
Lyhytvaikutteinen insuliini 0.35 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7c6dea4c-0c74-50be-be95-3e8baf12ba03

```

-------

Entry 549 - fullUrl = urn:uuid:51870deb-2cc5-471e-8f63-fddb6330d435

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.34:30
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5373ae73-83aa-502f-81eb-3df985ec3cf7

```

-------

Entry 550 - fullUrl = urn:uuid:5544cab5-13d9-478e-8d16-cc8ecf59a99a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.39:30
Kudossokeri: 6.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7cf7975f-c652-56cc-8139-013d69b82fe0

```

-------

Entry 551 - fullUrl = urn:uuid:ea1a1cdf-dd9c-44c5-9c65-d22636091518

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.44:30
Kudossokeri: 6.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fdbf7a47-1fd8-5449-ac5d-69862c9d99f9

```

-------

Entry 552 - fullUrl = urn:uuid:959a5c78-b8c9-48cc-88d2-f71d7f9fb0ac

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.49:30
Kudossokeri: 6.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56e1940f-4049-5c65-9c5e-5b4cfa235c99

```

-------

Entry 553 - fullUrl = urn:uuid:a61a261d-cc69-4be6-8a32-10f4821d997d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.54:30
Kudossokeri: 7.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ab6ebb7e-1670-5998-a0b1-648d33244290

```

-------

Entry 554 - fullUrl = urn:uuid:3578d148-d347-4c3a-a196-506c40644cfb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 5.9.2021 23.59:30
Kudossokeri: 7.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dd31ea1a-3d4d-5ac1-b539-af6bc76d0de4

```

-------

Entry 555 - fullUrl = urn:uuid:8322be84-1c91-43ff-9720-50c6b95a08f0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.00:00 - 00.17:07
Lyhytvaikutteinen insuliini 0.21 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:afa08b13-42e5-54ad-9da0-2d4b5cfbdbf3

```

-------

Entry 556 - fullUrl = urn:uuid:9f95a821-822d-456a-9131-9cdd4de159bf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.04:30
Kudossokeri: 7.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8df6b47-3e66-58d8-9e24-d14eed89b241

```

-------

Entry 557 - fullUrl = urn:uuid:16d24674-5bf2-4936-b7a6-7c8e7d11b1a2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.09:30
Kudossokeri: 7.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:305281a1-93ab-5ff5-8270-02faf62a95ac

```

-------

Entry 558 - fullUrl = urn:uuid:774e2fa2-ceda-4b93-a4e6-af81a586c377

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.14:32
Kudossokeri: 7.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:04c6b559-f260-52a6-96d0-109446d3f67a

```

-------

Entry 559 - fullUrl = urn:uuid:4ce912e3-e158-441d-a969-070fbd1af106

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.17:07 - 00.22:08
Lyhytvaikutteinen insuliini 0.08 ky (0.99 ky/t, 1.32 % = 1.31 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b0636196-044f-5d99-a637-6187913caaf9

```

-------

Entry 560 - fullUrl = urn:uuid:94603a46-6ea1-4107-808d-950dfb27b681

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.19:32
Kudossokeri: 8.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:35c12d74-b992-51d2-a72a-ed0634515c4b

```

-------

Entry 561 - fullUrl = urn:uuid:d945b734-6321-4b4d-aa5c-5f460a235fa3

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.22:08 - 00.27:09
Lyhytvaikutteinen insuliini 0.12 ky (1.42 ky/t, 1.89 % = 2.67 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:594ce37f-2ec6-5d34-940f-f5603a6e1705

```

-------

Entry 562 - fullUrl = urn:uuid:7ba8de09-9be7-44ad-a933-757fd17b0c9f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.24:33
Kudossokeri: 8.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1cbeed44-f427-5e07-94ff-557ba8cf3ae4

```

-------

Entry 563 - fullUrl = urn:uuid:5b316a88-a6b1-4c88-9d99-ed411d90040c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.27:09 - 00.32:09
Lyhytvaikutteinen insuliini 0.14 ky (1.72 ky/t, 2.29 % = 3.93 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:33530a2f-2bd2-5fd4-ad06-8504de18a9a6

```

-------

Entry 564 - fullUrl = urn:uuid:b48d6ae0-9c48-40a4-8dd6-5f74bc5ef72e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.29:31
Kudossokeri: 8.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4ba8cad9-7fbd-5521-bd37-b4d99aadb29d

```

-------

Entry 565 - fullUrl = urn:uuid:02d829df-80b0-4a96-ae98-3ebe9a0efd18

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.32:09 - 00.37:11
Lyhytvaikutteinen insuliini 0.18 ky (2.17 ky/t, 2.89 % = 6.27 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b705a189-ab76-5185-9f02-5baf60cc17dd

```

-------

Entry 566 - fullUrl = urn:uuid:346649aa-5632-4e1f-81de-7dc201bc71ac

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.34:32
Kudossokeri: 8.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:55a9c28c-a514-5244-8640-198b4338c52d

```

-------

Entry 567 - fullUrl = urn:uuid:73aaa76b-0856-4024-bb3c-1f9855092aab

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.37:11 - 00.42:11
Lyhytvaikutteinen insuliini 0.20 ky (2.39 ky/t, 3.19 % = 7.63 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f0ba65d6-423d-5b1a-b524-a7675b2033d1

```

-------

Entry 568 - fullUrl = urn:uuid:a12ccaa0-f627-4692-9cc3-a17f8838bbce

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.39:32
Kudossokeri: 9.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d82931d5-f691-5c8a-b422-7cdb27e18692

```

-------

Entry 569 - fullUrl = urn:uuid:109404e6-97ba-4cc9-99bf-b50a33511f2e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.42:11 - 00.47:12
Lyhytvaikutteinen insuliini 0.21 ky (2.50 ky/t, 3.33 % = 8.30 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:adb07765-f4c5-5ae1-94f5-e81e1d64cba3

```

-------

Entry 570 - fullUrl = urn:uuid:884cfad1-bc53-4d64-8ff5-591baf630d9a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.44:35
Kudossokeri: 9.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e7d31fb6-118a-5f74-90a5-0ff68b02fa74

```

-------

Entry 571 - fullUrl = urn:uuid:eb60e389-c28b-406f-8dc3-872e77a9a2b4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.47:12 - 00.52:13
Lyhytvaikutteinen insuliini 0.20 ky (2.42 ky/t, 3.23 % = 7.80 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3a6dc9e0-508b-552c-8642-af571231752a

```

-------

Entry 572 - fullUrl = urn:uuid:20e1c593-6a59-488d-9872-c67a36a3e4d0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.49:31
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0886449b-16f0-527d-8fdf-b8d4fc68432d

```

-------

Entry 573 - fullUrl = urn:uuid:9453af7a-66d2-4b17-bae9-762995eb5aee

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.52:13 - 00.57:15
Lyhytvaikutteinen insuliini 0.17 ky (2.05 ky/t, 2.73 % = 5.60 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8bd0b87b-7d8e-5ba2-9398-4add49ab0f06

```

-------

Entry 574 - fullUrl = urn:uuid:5cf5d660-4447-412b-84df-6c957db3ba67

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.54:31
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3e468256-a9ac-5f01-b4b1-f86df1e09f54

```

-------

Entry 575 - fullUrl = urn:uuid:04bcb8d4-fadc-4791-b853-74652c8cf174

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 00.57:15 - 01.02:16
Lyhytvaikutteinen insuliini 0.16 ky (1.90 ky/t, 2.53 % = 4.79 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3df641b7-9488-5508-b168-fc6323dd73d9

```

-------

Entry 576 - fullUrl = urn:uuid:8c11143d-8ec0-450a-b31f-d77d7cb810b3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 00.59:31
Kudossokeri: 9.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:159804ec-eca5-5862-9168-35d25091f751

```

-------

Entry 577 - fullUrl = urn:uuid:043819cd-95bf-4acc-a89d-c2b7be730c36

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.02:16 - 01.07:15
Lyhytvaikutteinen insuliini 0.15 ky (1.82 ky/t, 2.43 % = 4.41 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ba4ca6d0-4ef7-5b85-b8bd-7ccdf192dc10

```

-------

Entry 578 - fullUrl = urn:uuid:b78c8046-a07c-478d-9908-56f243f8b648

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.04:31
Kudossokeri: 9.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1de91190-6138-5175-9570-99b3d6a4ac2d

```

-------

Entry 579 - fullUrl = urn:uuid:ae9bb777-8356-4bc0-9014-b6e3ea542298

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.07:15 - 01.12:16
Lyhytvaikutteinen insuliini 0.15 ky (1.76 ky/t, 2.35 % = 4.13 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ca50584f-d0cc-5c89-b840-027dc6035df8

```

-------

Entry 580 - fullUrl = urn:uuid:2ef7aa4c-408d-4f15-88c7-3547d27b922c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.09:31
Kudossokeri: 9.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ab57e6c9-05c0-5d4c-912a-068ba9fd9641

```

-------

Entry 581 - fullUrl = urn:uuid:4d86dbb1-5b07-43a0-aad2-a6b8d0bec1b8

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.12:16 - 01.15:26
Lyhytvaikutteinen insuliini 0.09 ky (1.72 ky/t, 2.29 % = 3.94 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c9c56dc9-a77b-5e85-b3df-52f9852c3e50

```

-------

Entry 582 - fullUrl = urn:uuid:5027d258-5544-4928-a054-3968c63f9135

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.14:31
Kudossokeri: 10.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8f6c5578-6984-5ad7-8cf4-4eb5571c83ee

```

-------

Entry 583 - fullUrl = urn:uuid:5cc22012-ffef-4df7-a5c5-1ad5e9aa4de9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.15:26 - 01.17:17
Lyhytvaikutteinen insuliini 0.05 ky (1.72 ky/t, 2.29 % = 3.94 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:02d970c2-37d0-5fd1-8f2f-04f9d9f7f800

```

-------

Entry 584 - fullUrl = urn:uuid:12a1b02c-fd51-4137-ab18-2afde2d64396

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.17:17 - 01.35:26
Lyhytvaikutteinen insuliini 0.23 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2de4bd0a-996e-50c6-9996-ee80a5842b88

```

-------

Entry 585 - fullUrl = urn:uuid:caa13032-619e-42b1-8fa6-a77dc49e38a7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.19:31
Kudossokeri: 10.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d373069a-5cdc-5294-840f-eb0346bc13ea

```

-------

Entry 586 - fullUrl = urn:uuid:a1c5f5b3-a2bd-4865-b8d1-935734a808ae

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.24:31
Kudossokeri: 10.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c6f20ef1-fddc-5151-97a7-3ad9a641d0d3

```

-------

Entry 587 - fullUrl = urn:uuid:84ac8a8e-d477-4bb6-a3a1-c3cec521b8af

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.29:31
Kudossokeri: 10.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:668b45f6-83d9-5706-916e-984727148d69

```

-------

Entry 588 - fullUrl = urn:uuid:35a4fb21-aaf8-4927-b5da-a205692289bf

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.34:31
Kudossokeri: 11.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:867ff902-769d-5419-a071-dd35f8f5c2dc

```

-------

Entry 589 - fullUrl = urn:uuid:2482d711-cd04-4b1d-8370-27fec6708c66

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.35:26 - 01.37:21
Lyhytvaikutteinen insuliini 0.02 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:45a4e40d-58a2-5284-868a-320431c57695

```

-------

Entry 590 - fullUrl = urn:uuid:b01e97d9-b9f1-41fc-83aa-b144db1f5357

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.37:21 - 01.42:21
Lyhytvaikutteinen insuliini 0.29 ky (3.50 ky/t, 4.67 % = 16.35 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:46ae9c42-4392-585a-88bb-58083d7e1c52

```

-------

Entry 591 - fullUrl = urn:uuid:57434763-1771-4271-bc8c-3dd3dd955f1f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.39:31
Kudossokeri: 11.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:88b9fffc-bf17-5974-9313-dcd28ced000b

```

-------

Entry 592 - fullUrl = urn:uuid:038dfec3-a6f3-4f68-8afb-52f3ebaca2f7

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.42:21 - 01.52:23
Lyhytvaikutteinen insuliini 0.59 ky (3.51 ky/t, 4.68 % = 16.45 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8ba39d02-c135-5f85-b6a9-51c673623cd4

```

-------

Entry 593 - fullUrl = urn:uuid:9a51b4cf-c630-4e5d-b1c4-fc3a2b8979b3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.44:35
Kudossokeri: 11.32 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bde5ddc7-33c7-54e8-a3ca-30b35060264d

```

-------

Entry 594 - fullUrl = urn:uuid:99e4aa8b-bc0d-4799-8131-6081640b2319

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.49:31
Kudossokeri: 11.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0b264d7e-cc30-5d34-a92d-f59a8569d5be

```

-------

Entry 595 - fullUrl = urn:uuid:3f565998-bf87-482d-aed4-b62214f57b48

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.52:23 - 01.57:25
Lyhytvaikutteinen insuliini 0.22 ky (2.59 ky/t, 3.46 % = 8.96 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ed9d7bda-0d49-55f7-a723-f69b6ccf0f4b

```

-------

Entry 596 - fullUrl = urn:uuid:7fa77be6-18af-438b-a56f-84a98b41cd5f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.54:30
Kudossokeri: 11.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b38f5086-33ef-5ad2-a41e-a96eeaee508f

```

-------

Entry 597 - fullUrl = urn:uuid:b7a429e7-986e-4795-bbba-f4b1c4f984a1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 01.57:25 - 02.02:26
Lyhytvaikutteinen insuliini 0.21 ky (2.55 ky/t, 3.40 % = 8.65 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e32c3ea1-ed6b-56a8-9ec2-928b66f173da

```

-------

Entry 598 - fullUrl = urn:uuid:02bb11aa-9850-44f8-9711-28c8ef8ab5d0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 01.59:30
Kudossokeri: 11.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d867303b-7461-5a9e-99d8-81f3d5d00de2

```

-------

Entry 599 - fullUrl = urn:uuid:e559accc-a7b0-47d0-be92-486d0046de2c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.02:26 - 02.07:26
Lyhytvaikutteinen insuliini 0.18 ky (2.12 ky/t, 2.83 % = 6.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d18fd70c-89ba-54c5-8580-7e61b04f2734

```

-------

Entry 600 - fullUrl = urn:uuid:e1bea4a7-9d2a-4096-a785-847c2fe6661d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.04:30
Kudossokeri: 11.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3997abe-90a6-59d2-912d-bb4d34c708d4

```

-------

Entry 601 - fullUrl = urn:uuid:d2bf4578-ecd1-4e72-a2e0-21edec74b32e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.07:26 - 02.12:27
Lyhytvaikutteinen insuliini 0.15 ky (1.78 ky/t, 2.37 % = 4.23 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ee3ed5b4-c144-59bb-bb2e-978314b7ac22

```

-------

Entry 602 - fullUrl = urn:uuid:98eb52d9-0b92-4e46-a3d8-0a6bcb575673

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.09:30
Kudossokeri: 11.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dda266e3-3f42-5418-9b16-79d5d71516a4

```

-------

Entry 603 - fullUrl = urn:uuid:ecb07a5d-df65-4a41-8f31-45440f604ea4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.12:27 - 02.17:28
Lyhytvaikutteinen insuliini 0.14 ky (1.70 ky/t, 2.27 % = 3.87 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a93dd585-07e3-5c53-b35f-eea175f47bc9

```

-------

Entry 604 - fullUrl = urn:uuid:8af1a8f6-9c09-4e36-9d97-9222617b9757

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.14:30
Kudossokeri: 10.93 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4a037d46-ea88-5c6a-933e-18e61a034df4

```

-------

Entry 605 - fullUrl = urn:uuid:0f73f702-4c3a-42b3-9051-e8ec4a0f0217

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.17:28 - 02.22:29
Lyhytvaikutteinen insuliini 0.13 ky (1.58 ky/t, 2.11 % = 3.35 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7a701111-8211-5f42-ae02-0e617377239a

```

-------

Entry 606 - fullUrl = urn:uuid:9ce8faf2-9d02-467f-b14e-20c7d07d6be4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.19:30
Kudossokeri: 10.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56704e99-1c53-5ac2-b02f-86d229a27f66

```

-------

Entry 607 - fullUrl = urn:uuid:42115878-e681-4974-9f4f-217422f26a5f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.22:29 - 02.27:30
Lyhytvaikutteinen insuliini 0.12 ky (1.48 ky/t, 1.98 % = 2.94 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d7d901d1-cf82-5bec-b8bd-a9e870189a29

```

-------

Entry 608 - fullUrl = urn:uuid:3ead7809-bf79-40c6-a3ed-0a197d514aa4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.24:30
Kudossokeri: 10.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:15889d71-b995-58dd-93f3-ac6c2f041a2d

```

-------

Entry 609 - fullUrl = urn:uuid:1162eae1-0036-4e2b-a016-5da52425bbfc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.27:30 - 02.32:29
Lyhytvaikutteinen insuliini 0.12 ky (1.42 ky/t, 1.89 % = 2.68 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c57090c6-8f0a-5f21-90d7-1fdd4898c777

```

-------

Entry 610 - fullUrl = urn:uuid:e8b08708-98c9-4dbd-a653-b4827fe2a0b2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.29:32
Kudossokeri: 10.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dfad3d7f-c06d-56f1-968f-1e191d78706f

```

-------

Entry 611 - fullUrl = urn:uuid:a01f41d1-da1d-44b5-9ee3-ebc8cc067729

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.32:29 - 02.37:31
Lyhytvaikutteinen insuliini 0.10 ky (1.25 ky/t, 1.66 % = 2.07 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:81f00143-c423-5bd6-bd60-00b8ece26be0

```

-------

Entry 612 - fullUrl = urn:uuid:670ee0cf-1772-410c-a943-a3362b5fde33

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.34:31
Kudossokeri: 10.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aac9d21a-bb72-5482-b047-fb3e456122de

```

-------

Entry 613 - fullUrl = urn:uuid:96242852-00a1-4c2c-b91d-b26f2dd51d2c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.37:31 - 02.42:32
Lyhytvaikutteinen insuliini 0.09 ky (1.10 ky/t, 1.47 % = 1.62 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5e5186bb-e93f-5c4d-8866-26d4fb12938d

```

-------

Entry 614 - fullUrl = urn:uuid:4ccd527c-da88-4ded-9102-1fd3977d7744

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.39:30
Kudossokeri: 10.32 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4390b3b8-1ce2-5e7a-82f4-10bf768ee7a6

```

-------

Entry 615 - fullUrl = urn:uuid:aab592dd-91ec-4f49-9547-e69eb28a9226

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.42:32 - 02.47:33
Lyhytvaikutteinen insuliini 0.11 ky (1.29 ky/t, 1.72 % = 2.21 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1a2f7590-148a-5dba-866c-056e76ac3df6

```

-------

Entry 616 - fullUrl = urn:uuid:c97e2d8c-a4d6-4e59-ac09-c269e9721d25

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.44:31
Kudossokeri: 10.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:18fd72d4-72f7-5525-b185-8b800a2322a4

```

-------

Entry 617 - fullUrl = urn:uuid:6ef298ed-b7bc-478c-b772-9e445bce59dd

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.47:33 - 02.52:33
Lyhytvaikutteinen insuliini 0.12 ky (1.49 ky/t, 1.99 % = 2.97 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2948628f-07d3-597a-98fe-28e6811ae3d3

```

-------

Entry 618 - fullUrl = urn:uuid:5c2cb6ab-f873-461f-a654-91aee69bb6f6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.49:30
Kudossokeri: 10.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f4d3dcc7-7a78-5609-9af8-3adb722e184b

```

-------

Entry 619 - fullUrl = urn:uuid:4e6b94cb-37a7-44aa-ba67-7f5e435438a9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.52:33 - 02.57:34
Lyhytvaikutteinen insuliini 0.13 ky (1.61 ky/t, 2.15 % = 3.47 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1f5a858d-7d48-5f04-863b-bc7ae5ecfff2

```

-------

Entry 620 - fullUrl = urn:uuid:1822931f-cead-4eef-be26-e3b8c3803da2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.54:30
Kudossokeri: 9.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f8e32900-d026-5fb9-b2ea-83724d9851d8

```

-------

Entry 621 - fullUrl = urn:uuid:7c5a5b55-3f1d-4924-9e1c-ab783cbcfc11

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 02.57:34 - 03.02:34
Lyhytvaikutteinen insuliini 0.08 ky (0.97 ky/t, 1.30 % = 1.27 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4fda682b-70d2-54c0-993a-960e07d9c10c

```

-------

Entry 622 - fullUrl = urn:uuid:47a15be8-548b-4426-ac3f-7581f12fa7ba

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 02.59:30
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b1d112ca-7eca-5072-9a3f-c964618c272e

```

-------

Entry 623 - fullUrl = urn:uuid:e128168a-15ae-4313-bdad-f803ecc28608

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.02:34 - 03.27:40
Lyhytvaikutteinen insuliini 0.31 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e067c139-4c1e-59af-9c02-b77c506b0901

```

-------

Entry 624 - fullUrl = urn:uuid:7baa73f8-70f1-42c8-9531-2640c86b4f85

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.04:36
Kudossokeri: 9.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5e875183-5a92-53e7-8e95-6d786b3f7dcc

```

-------

Entry 625 - fullUrl = urn:uuid:37fa1311-2c97-4968-9b60-419cc01dd9b3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.09:36
Kudossokeri: 9.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7138fcbc-d560-5436-97f5-18a45206ec91

```

-------

Entry 626 - fullUrl = urn:uuid:05526d4b-6e55-458e-b462-43324ece3944

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.14:35
Kudossokeri: 8.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c49260e6-4a91-5bb9-8989-b83e5a3f2b3b

```

-------

Entry 627 - fullUrl = urn:uuid:47ef8c9e-dd9e-4cb5-9683-a401e12bdf5e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.19:30
Kudossokeri: 8.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:709e5caf-fec2-5284-a7b4-5a77c3991ae1

```

-------

Entry 628 - fullUrl = urn:uuid:ff28268c-4ea3-47f3-8fa7-44ec2148461c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.24:30
Kudossokeri: 8.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:629798da-6dda-568d-868e-541898c3c53f

```

-------

Entry 629 - fullUrl = urn:uuid:83152bc3-9c14-4581-b6f6-80dd20e2398c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.27:40 - 03.32:39
Lyhytvaikutteinen insuliini 0.07 ky (0.82 ky/t, 1.10 % = 0.91 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8d79bd63-3978-5f22-a455-640885b8306c

```

-------

Entry 630 - fullUrl = urn:uuid:a33fdfc3-df1c-497f-bca9-34446769f9bc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.29:30
Kudossokeri: 8.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8a8c7a31-d732-5a50-883d-638c7bc4ee15

```

-------

Entry 631 - fullUrl = urn:uuid:b48242e5-524a-44c0-a37a-98e44f9e0e42

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.32:39 - 03.37:40
Lyhytvaikutteinen insuliini 0.08 ky (0.95 ky/t, 1.26 % = 1.20 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:16376626-62fe-507e-b471-c98b62bba66c

```

-------

Entry 632 - fullUrl = urn:uuid:71b5c6d2-2b57-4883-b656-503909252415

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.34:30
Kudossokeri: 8.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6dfb143e-64ae-5879-85ec-08420c0b5635

```

-------

Entry 633 - fullUrl = urn:uuid:49349c06-0676-46de-8403-bf67902d3c4f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.37:40 - 03.42:41
Lyhytvaikutteinen insuliini 0.06 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fc675b6d-7a73-5a89-b581-071575624f9c

```

-------

Entry 634 - fullUrl = urn:uuid:b2927ab2-a63e-4e19-9f00-be568e846795

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.39:30
Kudossokeri: 8.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6aabb97f-5af2-5aba-845b-9b949d029232

```

-------

Entry 635 - fullUrl = urn:uuid:9ce4318f-d785-4686-9482-f8f4b84a7e02

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.42:41 - 03.47:41
Lyhytvaikutteinen insuliini 0.07 ky (0.81 ky/t, 1.08 % = 0.87 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:57dcd3c8-2585-5e0e-8f23-4c3455bab855

```

-------

Entry 636 - fullUrl = urn:uuid:c3f83944-e1ca-440f-8fe2-ba87ecfcaed5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.44:30
Kudossokeri: 8.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:50980ec3-8fee-5df2-8138-19529c361a7c

```

-------

Entry 637 - fullUrl = urn:uuid:7c5d1c2c-f21d-43a5-865c-91e74198c5e7

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.47:41 - 03.52:42
Lyhytvaikutteinen insuliini 0.07 ky (0.87 ky/t, 1.15 % = 1.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4e138295-f227-5d66-bc1d-b4a8b3454c0b

```

-------

Entry 638 - fullUrl = urn:uuid:bca3c148-a506-4f9d-a3fa-498dd9dcb722

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.49:30
Kudossokeri: 8.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d1ab6cc4-874d-5b04-965d-f5f8d26c4c2e

```

-------

Entry 639 - fullUrl = urn:uuid:1fda3a97-c4ea-436e-aa6f-bd9c97ec604a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.52:42 - 03.57:43
Lyhytvaikutteinen insuliini 0.07 ky (0.85 ky/t, 1.13 % = 0.96 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b66a4ef3-269a-5a69-ab52-63d4d9f25d15

```

-------

Entry 640 - fullUrl = urn:uuid:cdcd03b7-f865-4903-ba18-a8010c9e5bf0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.54:30
Kudossokeri: 7.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5c4a8932-62be-5973-9ac2-67870aab3d6c

```

-------

Entry 641 - fullUrl = urn:uuid:a9ff6f89-68da-4317-b219-9fccfc8a21ee

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 03.57:43 - 04.17:48
Lyhytvaikutteinen insuliini 0.25 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f27a9b35-9531-53e1-a81b-26a4aa8e560a

```

-------

Entry 642 - fullUrl = urn:uuid:7187b9d7-439d-402a-b911-9c2f1832e6ba

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 03.59:30
Kudossokeri: 7.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a5da45d6-5608-57d7-96fe-bd23e1fb74bd

```

-------

Entry 643 - fullUrl = urn:uuid:388877e7-c017-4dfc-af00-5426fb5e4122

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.04:31
Kudossokeri: 7.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f327a342-2162-5a9d-b17a-521407b49b0e

```

-------

Entry 644 - fullUrl = urn:uuid:463e85c2-6e45-4940-832f-967f15ca1606

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.09:30
Kudossokeri: 7.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:13cceca5-9487-56e8-b412-24ac5d6739f7

```

-------

Entry 645 - fullUrl = urn:uuid:dfa8fc6c-6098-482a-9a0f-78dd1175c078

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.14:30
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1b930586-9adf-5de9-8bcf-88ee3ce4372c

```

-------

Entry 646 - fullUrl = urn:uuid:9ebd9bfd-5391-414a-abfa-0408bbeb3ca3

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 04.17:48 - 04.22:48
Lyhytvaikutteinen insuliini 0.10 ky (1.17 ky/t, 1.57 % = 1.84 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1b6d114a-9393-5e51-9087-53de2225c658

```

-------

Entry 647 - fullUrl = urn:uuid:22f2bc1e-6eaf-4d73-87e3-b803f8c631b0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.19:30
Kudossokeri: 7.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d2b54d11-3563-5fae-b0d0-0af94495efd4

```

-------

Entry 648 - fullUrl = urn:uuid:34694dd5-76d2-4ae5-90d2-059093500718

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 04.22:48 - 04.27:48
Lyhytvaikutteinen insuliini 0.10 ky (1.16 ky/t, 1.55 % = 1.81 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5dadc5dc-6c8f-59c8-8cd3-96c46a8ab673

```

-------

Entry 649 - fullUrl = urn:uuid:49b0812c-ea37-44e0-bf2f-ddf9b5511331

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.24:30
Kudossokeri: 7.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2937f966-29ff-56d4-b07d-d51a07106acd

```

-------

Entry 650 - fullUrl = urn:uuid:7aa74d1a-b978-4009-9272-4656649374ac

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 04.27:48 - 04.32:49
Lyhytvaikutteinen insuliini 0.06 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9297585c-ecea-5bbe-b99c-2b30c1bf9d75

```

-------

Entry 651 - fullUrl = urn:uuid:1651c844-76cb-4eb4-9e03-d0bed535ced1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.29:32
Kudossokeri: 6.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:128ae33a-36f6-5542-8059-4eaf04b17aeb

```

-------

Entry 652 - fullUrl = urn:uuid:348e9016-cd86-4d3e-b657-bda1dd771a69

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 04.32:49 - 04.37:50
Lyhytvaikutteinen insuliini 0.04 ky (0.42 ky/t, 0.56 % = 0.24 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ee8366b1-f83a-59fa-9fd3-aaf9ee577fee

```

-------

Entry 653 - fullUrl = urn:uuid:b7affb57-6632-4b9e-ae28-e644cc8a5152

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.34:31
Kudossokeri: 7.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1c68ea6-4bda-5c4c-9e29-652fc0c64b70

```

-------

Entry 654 - fullUrl = urn:uuid:5aae961f-3d9d-4193-844d-27365facc6c0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 04.37:50 - 05.12:55
Lyhytvaikutteinen insuliini 0.44 ky (0.75 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4bec736b-49d1-5454-ac31-67c2be399f3f

```

-------

Entry 655 - fullUrl = urn:uuid:cdb06805-a50e-44c6-8d58-979ddb165aea

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.39:31
Kudossokeri: 7.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9d1cbf2c-96d9-5fef-948f-2e5083349d43

```

-------

Entry 656 - fullUrl = urn:uuid:a7189aab-fbcf-48ea-a8ff-b7b2a8be4c37

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.44:31
Kudossokeri: 7.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c3183e3-6a29-5ae4-8128-037f4efab8ff

```

-------

Entry 657 - fullUrl = urn:uuid:29896a52-87f5-4817-aeaf-757c1551427c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.49:32
Kudossokeri: 6.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3879e4f2-da63-513f-8654-25a06b095786

```

-------

Entry 658 - fullUrl = urn:uuid:6293813e-4b3a-407e-86b3-9573b5bd9819

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.54:30
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:db9a68ae-f5a6-57e8-b466-51ab1d442f8f

```

-------

Entry 659 - fullUrl = urn:uuid:679248e7-aede-4466-9503-34694fe670c4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 04.59:30
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d89cbbd7-5227-597a-b169-7218c81aafa6

```

-------

Entry 660 - fullUrl = urn:uuid:d9fed14e-c5bc-4120-8d6f-4cbfade65214

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.04:29
Kudossokeri: 6.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9aa6453c-35b4-5001-b2d7-ae9d57baf218

```

-------

Entry 661 - fullUrl = urn:uuid:f51be5f6-7f0a-4914-9fbd-e40f4d3454a3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.09:29
Kudossokeri: 6.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:170b731a-f272-57c5-adb1-0b549ffcea26

```

-------

Entry 662 - fullUrl = urn:uuid:48af57df-e040-4336-a746-c3c0f3ff3d15

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.12:55 - 05.17:55
Lyhytvaikutteinen insuliini 0.03 ky (0.34 ky/t, 0.46 % = 0.16 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1c769226-69c0-5857-91f6-6473f9550dc1

```

-------

Entry 663 - fullUrl = urn:uuid:c0cd4031-8e89-494e-8136-df0a3f19b572

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.14:29
Kudossokeri: 6.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ae12133f-ce26-5f5e-a014-a201ceb06eb7

```

-------

Entry 664 - fullUrl = urn:uuid:0f5184e8-d87c-4c7f-a1b6-d31c5a465a9e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.17:55 - 05.22:56
Lyhytvaikutteinen insuliini 0.03 ky (0.37 ky/t, 0.49 % = 0.18 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:86765bba-1c3b-5a08-82d1-19798377c616

```

-------

Entry 665 - fullUrl = urn:uuid:3d79d64a-744a-4d35-8c59-8fc2e9811ff8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.19:29
Kudossokeri: 6.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:32cd34f8-356a-555d-bb2e-3885e6c45351

```

-------

Entry 666 - fullUrl = urn:uuid:d9bdad6c-650d-4892-9022-b6fc7f727043

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.22:56 - 05.27:56
Lyhytvaikutteinen insuliini 0.03 ky (0.32 ky/t, 0.42 % = 0.13 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:05d536c1-0039-5c23-ab59-bf420e4799cf

```

-------

Entry 667 - fullUrl = urn:uuid:2f200b21-51e7-4eb4-b62e-d2f3fcf9bb57

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.24:30
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:826d0259-346f-554a-afec-bf3d4f080992

```

-------

Entry 668 - fullUrl = urn:uuid:9410ac19-e8f0-4611-9aed-ce41833141a4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.27:56 - 05.32:58
Lyhytvaikutteinen insuliini 0.03 ky (0.37 ky/t, 0.49 % = 0.18 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:64fe6be6-63d4-5862-80bc-e32595b12ca3

```

-------

Entry 669 - fullUrl = urn:uuid:ba4ff472-a4b6-4a43-bf6a-91b9ab2967fe

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.29:29
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f513facf-d83c-5b13-87a0-a225fb4ae857

```

-------

Entry 670 - fullUrl = urn:uuid:79ba0c09-aa08-49a5-90f0-0093b56e1f1e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.32:58 - 05.37:58
Lyhytvaikutteinen insuliini 0.05 ky (0.60 ky/t, 0.70 % = 0.42 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5b06b2eb-65ca-5d82-9ade-585390728843

```

-------

Entry 671 - fullUrl = urn:uuid:bbfb3a6e-f093-4468-95c4-bcc03df7efbc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.34:29
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2f9c9dff-d322-52f6-b51b-cdc0e740545f

```

-------

Entry 672 - fullUrl = urn:uuid:2117f599-9482-4cc6-84f4-b45e683297dd

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.37:58 - 05.43:00
Lyhytvaikutteinen insuliini 0.06 ky (0.75 ky/t, 0.88 % = 0.66 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:339ced28-9ab7-56cf-bbe6-51d76372c0fd

```

-------

Entry 673 - fullUrl = urn:uuid:97da8687-3055-4329-b447-aa2716698046

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.39:29
Kudossokeri: 6.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1ba6d91c-0a73-5337-a78b-caf1e2da0198

```

-------

Entry 674 - fullUrl = urn:uuid:8e895dc2-29ec-4cf6-88a4-5aeba3c80ec6

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.43:00 - 05.48:01
Lyhytvaikutteinen insuliini 0.06 ky (0.72 ky/t, 0.85 % = 0.61 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8f07e792-bf89-58f8-89bb-356ceed1f887

```

-------

Entry 675 - fullUrl = urn:uuid:086a6d0d-d5bd-4894-9e87-2faf8eedb121

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.44:30
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:561620e9-918f-5488-a34c-a7840689e948

```

-------

Entry 676 - fullUrl = urn:uuid:255c3741-165a-4b93-a0d0-cbfb8a9ec819

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.48:01 - 05.53:01
Lyhytvaikutteinen insuliini 0.05 ky (0.63 ky/t, 0.74 % = 0.47 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a5d23768-d481-5181-abb8-2ac8bd89905f

```

-------

Entry 677 - fullUrl = urn:uuid:281384a7-bd52-42b0-b46b-0a33b37d1144

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.49:29
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:91fbe986-5a0f-53c2-9769-0755322ff80c

```

-------

Entry 678 - fullUrl = urn:uuid:7f1b9af3-dc54-42b1-b38c-e3b73b59ed6f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.53:01 - 05.58:01
Lyhytvaikutteinen insuliini 0.05 ky (0.54 ky/t, 0.64 % = 0.34 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:90c5c5b5-3858-5a50-8248-15a82051ba0d

```

-------

Entry 679 - fullUrl = urn:uuid:6c7609ad-7f47-461f-b890-a29747f693ad

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.54:29
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e5836092-6936-59fd-a54a-b47655ed5217

```

-------

Entry 680 - fullUrl = urn:uuid:3687d77b-99f7-437c-933c-2278d985cebc

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 05.58:01 - 06.03:02
Lyhytvaikutteinen insuliini 0.04 ky (0.47 ky/t, 0.56 % = 0.26 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:061284a0-1f8f-5e63-8131-3a0e815ea805

```

-------

Entry 681 - fullUrl = urn:uuid:1b7dd1b3-56ff-40d4-83b4-7955fefe0fab

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 05.59:29
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:83751204-fd18-563c-93d1-84b53d89524f

```

-------

Entry 682 - fullUrl = urn:uuid:d13b840f-ea45-4e68-a66c-969ca9a1b320

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.03:02 - 06.08:03
Lyhytvaikutteinen insuliini 0.04 ky (0.52 ky/t, 0.62 % = 0.32 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e2d9221d-5cdd-5848-88f2-b8afb1dc11f7

```

-------

Entry 683 - fullUrl = urn:uuid:2efcc87e-33a5-44bc-884b-2fadfe731ba3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.04:29
Kudossokeri: 5.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ae55224e-9f2d-5674-b44e-d212e37fe58e

```

-------

Entry 684 - fullUrl = urn:uuid:f37bfa0e-89f3-4f30-a168-00c2d91272a4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.08:03 - 06.13:04
Lyhytvaikutteinen insuliini 0.04 ky (0.49 ky/t, 0.57 % = 0.28 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0d551976-0fda-5c9e-905a-a7dbad0aa917

```

-------

Entry 685 - fullUrl = urn:uuid:4c4bafba-915b-4177-8331-f72939fef6c8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.09:29
Kudossokeri: 5.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0d4fabf3-45de-57c9-bcae-f01731c8c5ae

```

-------

Entry 686 - fullUrl = urn:uuid:d392334c-71ea-4c9e-b8c2-288341fbcee0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.13:04 - 06.18:05
Lyhytvaikutteinen insuliini 0.04 ky (0.43 ky/t, 0.50 % = 0.22 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e42ca53b-615a-5095-afea-1d08237c649b

```

-------

Entry 687 - fullUrl = urn:uuid:87ef74a6-3e10-4f68-83f3-7c1e60118188

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.14:29
Kudossokeri: 5.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ea83f04a-b7ee-5286-be5f-67b90ec7c3f4

```

-------

Entry 688 - fullUrl = urn:uuid:57065e9e-1dde-46df-95ad-7d7bbeb16208

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.18:05 - 06.23:07
Lyhytvaikutteinen insuliini 0.03 ky (0.38 ky/t, 0.44 % = 0.17 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:854cb5aa-e8bb-5ac7-8fcb-202921523c35

```

-------

Entry 689 - fullUrl = urn:uuid:c9c097b2-34a9-43e1-9e0e-57c0ad90b589

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.19:29
Kudossokeri: 5.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:19926454-f6c4-5d7b-8264-31d16ddc7f3a

```

-------

Entry 690 - fullUrl = urn:uuid:f36228e8-0624-48e6-bf8f-fbac02116bb4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.23:07 - 06.28:07
Lyhytvaikutteinen insuliini 0.05 ky (0.62 ky/t, 0.73 % = 0.45 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:121e70c9-8de2-5def-8352-8157d4cfcc2b

```

-------

Entry 691 - fullUrl = urn:uuid:dba30253-d7eb-46e4-87fe-2d796b48a42b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.24:29
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a0fcc0ea-212c-595d-b863-48d84f2c6dbe

```

-------

Entry 692 - fullUrl = urn:uuid:45f2f6d6-d10f-43eb-87c8-17d5366e6036

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.28:07 - 06.33:08
Lyhytvaikutteinen insuliini 0.07 ky (0.84 ky/t, 0.99 % = 0.84 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b058ce15-9751-579f-a4aa-0bf7caaf3e0d

```

-------

Entry 693 - fullUrl = urn:uuid:47fc07e2-746b-4c14-8fc8-c07034f840df

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.29:29
Kudossokeri: 5.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9cefe83f-f2c7-59e9-806f-892f958ed746

```

-------

Entry 694 - fullUrl = urn:uuid:919606cc-7b86-4458-a604-2f9d67a03ae8

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.33:08 - 06.38:09
Lyhytvaikutteinen insuliini 0.07 ky (0.85 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c67c464e-7e9d-5783-a6b9-be6067584ddb

```

-------

Entry 695 - fullUrl = urn:uuid:11254bd5-e760-4425-8309-e2544b0c4eee

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.34:31
Kudossokeri: 5.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d7621d2d-b463-568c-b364-21d524ae6168

```

-------

Entry 696 - fullUrl = urn:uuid:b3fc60f8-c85e-4c89-90af-379499875c62

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.38:09 - 06.43:09
Lyhytvaikutteinen insuliini 0.05 ky (0.64 ky/t, 0.75 % = 0.48 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:78845c97-e5a4-58e4-90fe-e6aca91be6be

```

-------

Entry 697 - fullUrl = urn:uuid:e9cdb2d2-d410-424e-b442-e519eedd32a5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.39:29
Kudossokeri: 5.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5f3f3155-8842-5001-8274-8ed3eaf907ce

```

-------

Entry 698 - fullUrl = urn:uuid:c628bca5-fa63-4dbc-a72d-097640465a34

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.43:09 - 06.48:11
Lyhytvaikutteinen insuliini 0.03 ky (0.34 ky/t, 0.40 % = 0.13 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:91de13ff-928d-5bb5-b536-a7a3efe0215e

```

-------

Entry 699 - fullUrl = urn:uuid:73625f92-86fe-4179-8ecb-248a880bf164

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.44:29
Kudossokeri: 5.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:74e25bc3-b751-5caf-ac0f-7b7b42cd3e9f

```

-------

Entry 700 - fullUrl = urn:uuid:b1b566fe-76cf-4392-a57a-3a1a5a7c9756

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.48:11 - 06.53:11
Lyhytvaikutteinen insuliini 0.03 ky (0.41 ky/t, 0.48 % = 0.19 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2c696858-3249-580b-a81e-38a2a292392c

```

-------

Entry 701 - fullUrl = urn:uuid:d22f79ba-3c46-48a9-b0d2-8e96da98112c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.49:31
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:50e37bce-01d6-50d9-85da-cc74c9049f67

```

-------

Entry 702 - fullUrl = urn:uuid:a594ed69-ad19-4c69-b6a7-c5b01b0fa620

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.53:11 - 06.58:13
Lyhytvaikutteinen insuliini 0.06 ky (0.71 ky/t, 0.84 % = 0.59 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:296ad615-e6cb-50c2-b6b7-7a4cf1c7ecc1

```

-------

Entry 703 - fullUrl = urn:uuid:6a21d698-62d3-4f7c-bf5d-2d603684f3ff

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.53:48
Lyhytvaikutteinen insuliini 7.38 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:22e3f8c9-1e3a-5bb7-af2d-a53320033c86

```

-------

Entry 704 - fullUrl = urn:uuid:6b3f2cfc-8564-48e7-ac6e-b6aa2b690f33

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 6.9.2021 06.53:48
Arvioitu hiilihydraattimäärä: 75 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d97c8817-50f6-596b-ac45-4c470bb11b7a

```

-------

Entry 705 - fullUrl = urn:uuid:127501c2-e89c-43d5-ac24-f5405a134f01

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.54:31
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d64912d0-993c-5357-98a7-e170bb23a801

```

-------

Entry 706 - fullUrl = urn:uuid:2be4b61d-29a7-48df-a20c-e5a81bf41e48

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 06.58:13 - 07.03:14
Lyhytvaikutteinen insuliini 0.07 ky (0.84 ky/t, 0.99 % = 0.83 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cc23a9fc-1e13-5f24-a3f6-d8e111113510

```

-------

Entry 707 - fullUrl = urn:uuid:67a93d21-7c91-46c3-9d35-fd9d561304a9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 06.59:31
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9cb17ffa-5e46-555a-b5ac-fe46ce6925b2

```

-------

Entry 708 - fullUrl = urn:uuid:5063c9d2-7ef1-41e8-8ca5-fcc102affeb6

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 07.03:14 - 07.28:18
Lyhytvaikutteinen insuliini 0.40 ky (0.95 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a09f23fc-bb01-50fe-8eb3-c35a2f863e6b

```

-------

Entry 709 - fullUrl = urn:uuid:0e9b7dc0-c403-4b58-b157-e266d84aa48b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.04:29
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f03758b1-42ea-5a33-9f0f-22590e2c617c

```

-------

Entry 710 - fullUrl = urn:uuid:d4b6486b-ba8d-46d2-a8e1-0e7a277e7148

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.09:31
Kudossokeri: 6.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c5c020e3-97d0-537e-84bd-6f313fd510ad

```

-------

Entry 711 - fullUrl = urn:uuid:9d2a5149-3a60-4085-9c5d-3b5c9300b29b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.14:29
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:976f8bf3-0068-5362-b8a5-d7c3691e9ddf

```

-------

Entry 712 - fullUrl = urn:uuid:67ac727b-0e9b-4d81-9469-e2bcecf651eb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.19:29
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8ae1068a-50a2-58c1-afd6-81ff8cd62e2f

```

-------

Entry 713 - fullUrl = urn:uuid:d0b9670b-cd7e-49cd-a580-2dabfb0b3d09

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.24:29
Kudossokeri: 6.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d4bc9979-5dd3-58fd-bb41-2db57d8d6550

```

-------

Entry 714 - fullUrl = urn:uuid:b705f8ac-c40e-4b0f-bce2-8012cf2a31d4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 07.28:18 - 07.33:18
Lyhytvaikutteinen insuliini 0.08 ky (0.95 ky/t, 1.00 % = 0.94 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:785a0bed-4939-58d1-b146-11b012337340

```

-------

Entry 715 - fullUrl = urn:uuid:8ef6f58c-3b4e-4548-a5ce-a98de493dc36

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.29:29
Kudossokeri: 6.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ed2c170c-9418-57ca-80aa-cde8a2f96b87

```

-------

Entry 716 - fullUrl = urn:uuid:ccdf48c4-dd8c-4c99-8cc1-fb0f6ef932d4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 07.33:18 - 08.28:28
Lyhytvaikutteinen insuliini 0.87 ky (0.95 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e70f27b7-c1f4-5033-b604-e79e854233c8

```

-------

Entry 717 - fullUrl = urn:uuid:ef067116-a7a2-414c-b57f-244d899f93a4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.34:31
Kudossokeri: 6.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ca5dbf11-063c-5e5c-8d5f-6e45a8ad0664

```

-------

Entry 718 - fullUrl = urn:uuid:97334253-64da-4b9d-aa31-9e2a1e54ace2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.39:30
Kudossokeri: 7.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:18924305-10b2-5da0-9dd1-3cd78eb6a2cf

```

-------

Entry 719 - fullUrl = urn:uuid:8e31f848-d8da-4790-a873-cb1642d97d96

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.44:29
Kudossokeri: 7.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a156e830-f805-5b45-8498-242733158137

```

-------

Entry 720 - fullUrl = urn:uuid:670be43e-b6cb-467a-8f56-cca86f0a2667

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.49:29
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:689c51b0-876a-511b-ba48-ff60519a5b6b

```

-------

Entry 721 - fullUrl = urn:uuid:eb16f320-681f-44c4-ac69-ca4703c7cc2f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.54:29
Kudossokeri: 8.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:64f1d03e-b439-54cf-ba23-779a64c0a950

```

-------

Entry 722 - fullUrl = urn:uuid:0db58af2-0335-429e-9b42-8e9542bb48d8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 07.59:29
Kudossokeri: 8.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b3fb3d4c-a519-5b1b-af93-e922c0ede737

```

-------

Entry 723 - fullUrl = urn:uuid:e688f834-fe91-45f6-990e-876b1cd65c2b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.04:29
Kudossokeri: 7.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bc387efe-aceb-5772-957b-46c4255cde4d

```

-------

Entry 724 - fullUrl = urn:uuid:db9ad921-8e08-4e34-85e6-7b64ad195468

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.09:30
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:84590fe3-c1da-5f42-ae30-86d1bb6b33f0

```

-------

Entry 725 - fullUrl = urn:uuid:9063cfc2-4597-4fb7-8684-375c7f585a4c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.14:31
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f3f20967-ca83-5d44-a203-c26b8f6fd245

```

-------

Entry 726 - fullUrl = urn:uuid:1eb1f314-a576-479d-8dc5-b26f94670cee

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.19:29
Kudossokeri: 7.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cb5ad064-98a6-506d-b54a-2934f6109e8d

```

-------

Entry 727 - fullUrl = urn:uuid:6ce92aca-13d2-4120-9625-d36a1c1e16de

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.24:29
Kudossokeri: 7.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0642b3dd-640b-5a05-b8d6-fe022f58d052

```

-------

Entry 728 - fullUrl = urn:uuid:b70f4dfd-0b5e-4f81-8e38-37b209b4233b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 08.28:28 - 08.33:28
Lyhytvaikutteinen insuliini 0.08 ky (0.94 ky/t, 0.99 % = 0.94 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6cb24407-8269-5817-916f-f7e7f9761459

```

-------

Entry 729 - fullUrl = urn:uuid:248f31c3-5093-4822-8f60-b2bd74bf168c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.29:29
Kudossokeri: 6.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4ab24c66-d13f-5c1e-ba63-9c2b61ad2dda

```

-------

Entry 730 - fullUrl = urn:uuid:514b1fa3-c22d-4856-b609-b679239f558e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 08.33:28 - 08.38:28
Lyhytvaikutteinen insuliini 0.02 ky (0.20 ky/t, 0.21 % = 0.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1bd2121e-594c-54ba-af54-22cd9726ddb3

```

-------

Entry 731 - fullUrl = urn:uuid:125627ce-748b-42e9-a202-6fb02b52752d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.34:29
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b96193be-c6b9-5176-b48f-2cbd4e558861

```

-------

Entry 732 - fullUrl = urn:uuid:5b144af0-e094-4026-ad36-e653bfb81bbd

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 08.38:28 - 09.03:33
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f081440e-25dc-5683-96b5-69a4ca822435

```

-------

Entry 733 - fullUrl = urn:uuid:8f1dda4a-6f60-4ff4-a907-349808b6398e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.39:29
Kudossokeri: 5.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5b930e88-c521-50a3-a835-86995933006f

```

-------

Entry 734 - fullUrl = urn:uuid:e7d138e8-83af-439e-b29e-d8cfd5e6ea3d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.44:29
Kudossokeri: 4.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1c1f82f-b250-594b-94c0-9055b95d76d3

```

-------

Entry 735 - fullUrl = urn:uuid:b0e9a520-08d8-4fb0-b030-080279acf7e8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.49:30
Kudossokeri: 4.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2af1f07b-e657-5899-ae24-5927bc6efb24

```

-------

Entry 736 - fullUrl = urn:uuid:a499c0c6-a206-44a5-b510-c98a4d68e076

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.54:29
Kudossokeri: 5.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6248e1ac-c5e0-5390-834b-5cacf848673f

```

-------

Entry 737 - fullUrl = urn:uuid:dbf4a7a4-5de5-46c6-814b-cdd2bc2d316e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 08.59:29
Kudossokeri: 5.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8a9fcc38-9160-596d-80fd-1670283254f8

```

-------

Entry 738 - fullUrl = urn:uuid:63ab8a38-4dfb-44f0-b443-2058604531e8

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.03:33 - 09.08:33
Lyhytvaikutteinen insuliini 0.01 ky (0.14 ky/t, 0.20 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7d1d811e-e1af-51cf-9948-43e31ed05589

```

-------

Entry 739 - fullUrl = urn:uuid:f3d6b43e-55c3-451d-ac57-809b93c2cef3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.04:29
Kudossokeri: 5.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ed05ff79-9612-53fd-893c-30d11a9b2fe2

```

-------

Entry 740 - fullUrl = urn:uuid:ea67a4ff-7b09-41e5-8569-bcc0e47d90d3

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.08:33 - 09.13:34
Lyhytvaikutteinen insuliini 0.06 ky (0.66 ky/t, 0.95 % = 0.63 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:28774a44-998a-5857-867c-4ad7c6c47d57

```

-------

Entry 741 - fullUrl = urn:uuid:f7c56448-ec13-46d3-a38c-00d9efe56c95

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.09:29
Kudossokeri: 6.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fbc604c6-b6bd-5210-97ac-c89539145a2f

```

-------

Entry 742 - fullUrl = urn:uuid:b6f10eaf-191e-497a-9bef-aa601ddc3330

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.13:34 - 09.18:35
Lyhytvaikutteinen insuliini 0.06 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8accc68d-fdb6-5717-af79-5cda0e28413a

```

-------

Entry 743 - fullUrl = urn:uuid:073299bd-4aa8-42f5-8082-59cf97c119cc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.14:29
Kudossokeri: 7.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7a61cbaf-41be-5cef-8b41-56b9d9afedfa

```

-------

Entry 744 - fullUrl = urn:uuid:15e21f88-146a-4d17-914c-7fab7f26eb76

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.18:35 - 09.23:36
Lyhytvaikutteinen insuliini 0.09 ky (1.06 ky/t, 1.52 % = 1.61 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:eed9c9a3-9e54-51ea-a976-3ddda0bb6e2b

```

-------

Entry 745 - fullUrl = urn:uuid:d39d5dfa-dd16-4d2f-a922-f2c494eff974

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.19:31
Kudossokeri: 7.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8512fee2-56b6-5f97-bd84-83944707a0f1

```

-------

Entry 746 - fullUrl = urn:uuid:419fc0fe-51df-4237-b9a7-9fb0942d7fae

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.23:36 - 09.28:36
Lyhytvaikutteinen insuliini 0.18 ky (2.21 ky/t, 3.16 % = 6.97 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:23b1aac4-84a2-5b0b-9e92-7772bc66dac0

```

-------

Entry 747 - fullUrl = urn:uuid:83502004-1c0e-4e02-ae85-7b85d276f108

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.23:50
Lyhytvaikutteinen insuliini 1.62 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:27ce4b5d-7ddb-5553-8136-0c06c129d94c

```

-------

Entry 748 - fullUrl = urn:uuid:67cf9fde-1a13-466b-8353-f13bb4ef7c08

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.24:31
Kudossokeri: 7.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dc7eba4f-51e9-5f56-a3a1-7e5c2648ed81

```

-------

Entry 749 - fullUrl = urn:uuid:3f5c229c-4c5a-45aa-b43f-3125caa8c485

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.28:36 - 09.58:40
Lyhytvaikutteinen insuliini 0.35 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c7652db2-6885-540c-a659-5e72dd4cf7d9

```

-------

Entry 750 - fullUrl = urn:uuid:9d7dc69f-ce3c-49ca-b041-f685e5c2ff7f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.29:29
Kudossokeri: 8.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:76e0a32b-229a-5e65-b54f-ad3c59facdd8

```

-------

Entry 751 - fullUrl = urn:uuid:5d406fb3-4bef-44b9-98af-d3dc9b3fb5d3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.34:29
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2f00f3ff-63a8-560c-bdba-bf9c656afb61

```

-------

Entry 752 - fullUrl = urn:uuid:fd81cf8d-b4c9-4769-9f5e-1c3b8a12128f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.39:29
Kudossokeri: 7.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:00d0bfd7-b77c-5a91-b77e-d240e2db190e

```

-------

Entry 753 - fullUrl = urn:uuid:33df357d-bb73-4a57-97ee-7ccbba0ab463

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.44:29
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:72f791c7-c4a1-59a1-8802-0fce1e2c0e02

```

-------

Entry 754 - fullUrl = urn:uuid:705d92ba-3847-4938-98ff-ab58992b5e74

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.49:29
Kudossokeri: 7.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:91118cd5-5d3e-5d55-898b-71f5ff30a2de

```

-------

Entry 755 - fullUrl = urn:uuid:26f2c994-a3ed-4b14-9e88-ba57f2734be0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.54:29
Kudossokeri: 7.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8340519a-6e57-5b53-999b-a3a7a38b7573

```

-------

Entry 756 - fullUrl = urn:uuid:95a057b2-657a-4b29-9714-5de839108575

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 09.58:40 - 10.03:43
Lyhytvaikutteinen insuliini 0.05 ky (0.64 ky/t, 0.91 % = 0.59 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:924ee8be-753c-5fec-8e5c-9f3041719da7

```

-------

Entry 757 - fullUrl = urn:uuid:1626e702-f88f-441e-8ba5-1e8397add88a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 09.59:29
Kudossokeri: 7.22 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:00d33eda-b78d-5033-b508-b9edba564457

```

-------

Entry 758 - fullUrl = urn:uuid:d7c71f43-be65-4640-a3a0-39104d2027ef

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.03:43 - 10.08:43
Lyhytvaikutteinen insuliini 0.05 ky (0.63 ky/t, 0.90 % = 0.57 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7d98f4f8-e99e-5c53-9112-e9bbaaeab4c7

```

-------

Entry 759 - fullUrl = urn:uuid:81d0cb88-0fea-453c-ae1a-623f43408149

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.04:29
Kudossokeri: 7.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b5ebcfa7-d07f-5dc4-bef1-5295a8b9d8d0

```

-------

Entry 760 - fullUrl = urn:uuid:5f287433-ca47-4b32-a5f9-c79a303d8d27

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.08:43 - 10.18:44
Lyhytvaikutteinen insuliini 0.12 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:75c5ac89-2007-5f86-8bdb-8cbfb1e45878

```

-------

Entry 761 - fullUrl = urn:uuid:d5c1745c-5330-41e7-9fd4-6562dca180d5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.09:29
Kudossokeri: 7.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c3104c73-82fc-5cd4-81a0-6795149803c3

```

-------

Entry 762 - fullUrl = urn:uuid:ba953486-ea2c-415a-93ac-8cf19c30c333

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.14:30
Kudossokeri: 6.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:90c88001-4744-5ac5-9850-1c03f38a7853

```

-------

Entry 763 - fullUrl = urn:uuid:ffb91d57-47d3-40fc-8dbf-12b719c71add

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.18:44 - 10.23:45
Lyhytvaikutteinen insuliini 0.06 ky (0.68 ky/t, 0.97 % = 0.66 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ca841f2a-733b-54ff-9179-cde1ce672826

```

-------

Entry 764 - fullUrl = urn:uuid:e6ba234a-b8c0-4541-8b57-26c55f4c2151

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.19:29
Kudossokeri: 6.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ea6aa186-e52c-58a7-816d-2f9830fabf33

```

-------

Entry 765 - fullUrl = urn:uuid:da2b957f-3651-431b-8f2d-b309a2cf3532

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.23:45 - 10.28:46
Lyhytvaikutteinen insuliini 0.05 ky (0.63 ky/t, 0.90 % = 0.57 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e278b361-c973-5d2b-893f-1cfeeb2532e6

```

-------

Entry 766 - fullUrl = urn:uuid:a78e52d5-af49-443d-9cc2-343034eb05b5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.24:29
Kudossokeri: 6.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9002f95b-153d-5d41-b63a-c08400dc2a8a

```

-------

Entry 767 - fullUrl = urn:uuid:9fa016bd-2736-4ae9-b52e-7aaf8034a91b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.28:46 - 10.33:46
Lyhytvaikutteinen insuliini 0.05 ky (0.58 ky/t, 0.83 % = 0.48 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fd244b4d-ed48-59ed-a85a-556a80afc53b

```

-------

Entry 768 - fullUrl = urn:uuid:6eeeeada-ea75-4f41-8de2-69edcccfa845

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.29:29
Kudossokeri: 6.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8552af84-cda7-5974-bdcd-b072501dc6fc

```

-------

Entry 769 - fullUrl = urn:uuid:7f565c58-5bca-4d45-8ffe-e998d0285213

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.33:46 - 10.38:48
Lyhytvaikutteinen insuliini 0.04 ky (0.44 ky/t, 0.62 % = 0.27 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a792e164-8e2b-5551-8140-8019927e3bec

```

-------

Entry 770 - fullUrl = urn:uuid:d2225008-e157-4489-af13-99d12028fcfd

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.34:32
Kudossokeri: 6.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d8f12e4c-9f18-5f50-b9d5-7c7d1432c09d

```

-------

Entry 771 - fullUrl = urn:uuid:efb2c9a5-58f7-4142-980f-11b0d0acc561

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.38:48 - 10.43:48
Lyhytvaikutteinen insuliini 0.04 ky (0.45 ky/t, 0.64 % = 0.29 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e0634ec1-abeb-58a0-b350-4a002c424876

```

-------

Entry 772 - fullUrl = urn:uuid:c9b75538-1c0f-4291-b67b-5b9595f0675f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.39:32
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80a93b19-2289-56c7-8987-bcde5aa6dcdc

```

-------

Entry 773 - fullUrl = urn:uuid:94c9faf1-503d-4d31-b6d1-a72bc2f8a9f0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.43:48 - 10.48:49
Lyhytvaikutteinen insuliini 0.01 ky (0.18 ky/t, 0.26 % = 0.05 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b0176aed-7ee9-5dea-89ec-74be3466d11d

```

-------

Entry 774 - fullUrl = urn:uuid:20551eb8-6c6c-4ed4-8c8b-6fd2b34131b7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.44:29
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bafff913-069f-5e3d-80f3-d9cd23e6f4ba

```

-------

Entry 775 - fullUrl = urn:uuid:6edba8e0-916e-4676-a397-83268072bc64

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.48:49 - 10.53:51
Lyhytvaikutteinen insuliini 0.01 ky (0.14 ky/t, 0.21 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:21bcc226-af0b-5283-bad0-32492e45db9a

```

-------

Entry 776 - fullUrl = urn:uuid:1bebe348-9152-489d-861c-0a167a764a45

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.49:31
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:31d05f4b-399f-5087-84c7-bf2e0a0ebcf9

```

-------

Entry 777 - fullUrl = urn:uuid:1c8b02d8-f063-40c4-ac96-1db5244de176

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.53:51 - 10.58:51
Lyhytvaikutteinen insuliini 0.01 ky (0.15 ky/t, 0.21 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:11ef80d9-8a6e-55f1-8ac0-c6086407f92e

```

-------

Entry 778 - fullUrl = urn:uuid:eb0006c7-6616-423e-a319-8dd9a863377c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.54:31
Kudossokeri: 5.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d8841649-353f-5e27-a6b7-e38fffccc12c

```

-------

Entry 779 - fullUrl = urn:uuid:fe1eb51b-edcd-45e7-9a99-5629ecfd9b54

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 10.58:51 - 11.03:51
Lyhytvaikutteinen insuliini 0.02 ky (0.28 ky/t, 0.40 % = 0.11 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6dbadff7-609f-5ae0-b436-2772b7c36e1b

```

-------

Entry 780 - fullUrl = urn:uuid:6087ae09-195f-4010-9959-873233bff3ce

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 10.59:29
Kudossokeri: 5.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dd49a506-4f96-5f39-ba1e-cea7c703825c

```

-------

Entry 781 - fullUrl = urn:uuid:bc1a2f68-4c42-41a4-92a7-2abf91263f55

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.03:51 - 11.08:52
Lyhytvaikutteinen insuliini 0.02 ky (0.26 ky/t, 0.38 % = 0.10 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2efd0faa-28af-54cc-80b6-1c99613a0a29

```

-------

Entry 782 - fullUrl = urn:uuid:e912f437-a4e9-44ff-b215-d073967a80dc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.04:29
Kudossokeri: 5.61 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1cd1c10-9f42-5300-ab2d-26692e16f261

```

-------

Entry 783 - fullUrl = urn:uuid:8802e855-90d1-42f0-ae35-463120b1381e

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.08:52 - 11.13:54
Lyhytvaikutteinen insuliini 0.01 ky (0.17 ky/t, 0.24 % = 0.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ce26c1e8-74d9-58e7-99c7-65ba97f833bc

```

-------

Entry 784 - fullUrl = urn:uuid:d76fc79e-fa59-42fb-882f-cd82b58ff133

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.09:29
Kudossokeri: 5.5 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5275a567-caec-579c-a97d-75256d3e68ae

```

-------

Entry 785 - fullUrl = urn:uuid:8bc0c638-75bf-42bd-8516-6738276d67ca

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.13:54 - 11.18:54
Lyhytvaikutteinen insuliini 0.01 ky (0.17 ky/t, 0.24 % = 0.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:62959f1c-5eeb-55af-b29d-bbddfd0d20a2

```

-------

Entry 786 - fullUrl = urn:uuid:2eed8160-7a67-41f9-8f84-3dc57ce7e8fa

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.14:29
Kudossokeri: 5.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:50afdd8e-e462-5e91-b9da-07bcd8ff1868

```

-------

Entry 787 - fullUrl = urn:uuid:3cef967b-291c-45f3-8511-e6994f6928a4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.18:54 - 11.23:56
Lyhytvaikutteinen insuliini 0.01 ky (0.13 ky/t, 0.19 % = 0.02 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1614f91f-f3ab-5ef0-a3fc-24bcf36c3a72

```

-------

Entry 788 - fullUrl = urn:uuid:21476031-195d-42ab-9809-9ab04b0a7549

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.19:29
Kudossokeri: 5.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c59b208c-7c36-588f-9295-8eb14c9c35d9

```

-------

Entry 789 - fullUrl = urn:uuid:9de8fb06-5cf9-4561-89d8-8933c3d2136a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.23:56 - 11.28:56
Lyhytvaikutteinen insuliini 0.01 ky (0.13 ky/t, 0.19 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:64fe18ef-6e0b-50da-9efb-15896c147b40

```

-------

Entry 790 - fullUrl = urn:uuid:2d9eda00-1e4d-48cb-9e0a-438e3f98e827

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.24:29
Kudossokeri: 5.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f1be96d7-fc01-584e-8fb4-b770356ffade

```

-------

Entry 791 - fullUrl = urn:uuid:b937fdda-afa6-4229-958a-4e062b0a0b7a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.28:56 - 11.33:56
Lyhytvaikutteinen insuliini 0.01 ky (0.15 ky/t, 0.21 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e72f5fb4-6770-5e75-ab84-cfe11c950a53

```

-------

Entry 792 - fullUrl = urn:uuid:50f49b40-20ae-4a79-a901-a1d891c93e29

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.29:30
Kudossokeri: 5.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e968d326-061e-5266-a8c6-c0401398636e

```

-------

Entry 793 - fullUrl = urn:uuid:8c333d92-83dd-400c-9117-0c74231332b9

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.33:56 - 11.38:58
Lyhytvaikutteinen insuliini 0.01 ky (0.14 ky/t, 0.21 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d5846d79-307b-5dd8-bc1d-47edd9b9ad03

```

-------

Entry 794 - fullUrl = urn:uuid:440ec73e-2c56-4c76-b023-98ccf6defef6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.34:31
Kudossokeri: 5.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:432e391e-c4b3-5f31-ada7-a5a5db9054b5

```

-------

Entry 795 - fullUrl = urn:uuid:cd418192-3a6b-4b4d-af6d-5e58fef304c4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.38:58 - 11.43:58
Lyhytvaikutteinen insuliini 0.02 ky (0.20 ky/t, 0.29 % = 0.06 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:196284c9-5ea6-503b-9e92-4b2965f73c48

```

-------

Entry 796 - fullUrl = urn:uuid:e8fefffc-1159-45e9-95b1-2298556b9bf8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.39:28
Kudossokeri: 5.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3165daf-b98e-58e9-85fa-8d8e21190ba2

```

-------

Entry 797 - fullUrl = urn:uuid:eb53c9d8-7b13-453f-9476-648874d2f5cf

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.43:58 - 11.48:59
Lyhytvaikutteinen insuliini 0.02 ky (0.24 ky/t, 0.34 % = 0.08 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cacf2de9-4673-5837-9da0-6382348634c8

```

-------

Entry 798 - fullUrl = urn:uuid:fb04f257-632a-4736-b238-35cd833f3b9e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.44:29
Kudossokeri: 5.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7a5cbf36-ed9c-5a15-bcfc-064ba5b2232c

```

-------

Entry 799 - fullUrl = urn:uuid:30c7715c-6bf0-4b85-9155-72f62ffb791d

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.48:59 - 11.53:59
Lyhytvaikutteinen insuliini 0.03 ky (0.31 ky/t, 0.44 % = 0.14 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:980e774b-4916-5539-94ce-c947c5c1edb9

```

-------

Entry 800 - fullUrl = urn:uuid:b0ae1d60-2b4d-475c-89e9-de671cd48ed3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.49:31
Kudossokeri: 5.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2a1cd173-6b7c-5563-a820-420c5b25c43e

```

-------

Entry 801 - fullUrl = urn:uuid:319fa81c-b49c-409e-a55a-e796458ef538

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.53:59 - 11.59:01
Lyhytvaikutteinen insuliini 0.05 ky (0.56 ky/t, 0.81 % = 0.45 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:226088a0-729b-533e-a9e7-68db741a574d

```

-------

Entry 802 - fullUrl = urn:uuid:83767a52-0715-49ee-acf5-b2b258f1cf7d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.54:29
Kudossokeri: 5.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e937614f-26e3-51b8-beb1-563d9fa4404d

```

-------

Entry 803 - fullUrl = urn:uuid:acc5af17-3a4f-4727-b2ac-79c3d21cf77f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 11.59:01 - 13.29:15
Lyhytvaikutteinen insuliini 1.05 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9e17b041-45e8-5fbe-9ce8-ec4f7979083d

```

-------

Entry 804 - fullUrl = urn:uuid:f5e03f6b-abea-452e-bb97-5a1f771dc1b9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 11.59:29
Kudossokeri: 5.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e2978703-1aa7-52c9-bee6-c15d0b157565

```

-------

Entry 805 - fullUrl = urn:uuid:d8669d24-e346-4f64-aa75-574541187cc8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.04:29
Kudossokeri: 5.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7538c4e2-3069-535d-be7e-c0a05746cf9f

```

-------

Entry 806 - fullUrl = urn:uuid:268a7b5f-421b-4729-99f6-1bee1bffad3c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.09:28
Kudossokeri: 6.11 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:47d56542-43f6-5414-b83d-90ac3d201eb9

```

-------

Entry 807 - fullUrl = urn:uuid:29c0c76a-00f7-4199-9f3a-2f02fb26dfcc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.14:28
Kudossokeri: 6.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:083736d3-074c-540c-b90e-f79dc426ca21

```

-------

Entry 808 - fullUrl = urn:uuid:12d907ac-5625-4ca5-a609-74229c9fb613

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.19:29
Kudossokeri: 6.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3264bc28-05da-51c3-b1a1-f14d21c5457b

```

-------

Entry 809 - fullUrl = urn:uuid:4b473efd-0562-40ef-b3e8-5d6f25e484bc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.24:28
Kudossokeri: 6.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9d86b788-8845-5dcc-a153-6a79404c7342

```

-------

Entry 810 - fullUrl = urn:uuid:f33509b0-647d-43a8-8b55-92060bf7ede0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.29:29
Kudossokeri: 7.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5018d365-8829-5dcd-a87b-5e40009e0678

```

-------

Entry 811 - fullUrl = urn:uuid:8ddd020f-3bfc-4655-b648-ae2225d4fa24

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.34:29
Kudossokeri: 7.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0a9c2e96-36a2-52ab-b6cc-0d6509d19243

```

-------

Entry 812 - fullUrl = urn:uuid:04ed81c4-46dd-4479-ae22-aece65a91cd8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.39:29
Kudossokeri: 7.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:de3e85d3-298c-5e21-938b-3a63ca33bfe5

```

-------

Entry 813 - fullUrl = urn:uuid:60359d91-d772-4c77-9c36-703dcf2737ba

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.44:29
Kudossokeri: 7.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2ff7a36c-506b-5529-a4e9-2c5806fa1cff

```

-------

Entry 814 - fullUrl = urn:uuid:2c9e868b-ca08-45ce-ba2f-3fe3b78ac913

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.49:29
Kudossokeri: 7.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aea4ee98-6894-591b-ace3-c50d48db0d94

```

-------

Entry 815 - fullUrl = urn:uuid:14dcfb4e-becc-4225-8305-44a889a339f6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.54:29
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9ba503b5-be05-5f9a-aa03-d300a0078897

```

-------

Entry 816 - fullUrl = urn:uuid:1afde1bd-3601-4e58-b587-d56609f06151

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 12.59:28
Kudossokeri: 7.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:374fd4f6-2c45-59fc-832a-02bf7c204103

```

-------

Entry 817 - fullUrl = urn:uuid:fc7faa3f-1c05-4abd-b945-0dc0db1643dd

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.04:28
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3b0b4f3-cfcf-5fed-a402-db763fbc0507

```

-------

Entry 818 - fullUrl = urn:uuid:b197382d-a4c1-477d-82a2-fec37af7facd

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.09:29
Kudossokeri: 8.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:906cfccb-7968-5516-b1c0-0a3fc8404257

```

-------

Entry 819 - fullUrl = urn:uuid:4df3c3ca-7951-4eff-a121-c56331304787

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.14:28
Kudossokeri: 8.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7f3bc822-b025-55bd-bb3d-75e3a122685d

```

-------

Entry 820 - fullUrl = urn:uuid:5e6fce70-08ac-4a00-9e64-a8002a1e3ced

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.19:29
Kudossokeri: 8.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:15641576-1542-52de-a1a1-e8ca8ee0ca47

```

-------

Entry 821 - fullUrl = urn:uuid:87d469df-95e2-4332-bd6e-cf51290a6ca4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.24:29
Kudossokeri: 8.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:17e8ad0a-b4e7-5f89-9525-464986b83767

```

-------

Entry 822 - fullUrl = urn:uuid:b9cafd90-216b-4912-9c43-1daed2bbd213

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 13.29:15 - 13.34:16
Lyhytvaikutteinen insuliini 0.06 ky (0.78 ky/t, 1.11 % = 0.86 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ccaed0ba-28bd-5acc-bb11-3972ccaa4859

```

-------

Entry 823 - fullUrl = urn:uuid:0e3a8b99-9815-400e-98ca-cb4ea513e789

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.29:29
Kudossokeri: 8.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a8460d34-a48e-58c9-89d1-d9d89686d992

```

-------

Entry 824 - fullUrl = urn:uuid:42521bb8-ebfa-47af-b1a0-5a2bd13b4041

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 13.34:16 - 13.39:16
Lyhytvaikutteinen insuliini 0.08 ky (1.00 ky/t, 1.43 % = 1.43 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d183187b-843e-5f84-ab35-1bc71bcfeb03

```

-------

Entry 825 - fullUrl = urn:uuid:d4b81ee4-f225-40c2-8253-53c36e798188

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.34:28
Kudossokeri: 8.83 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8b911efd-7596-5702-b315-e8ff3bbfca42

```

-------

Entry 826 - fullUrl = urn:uuid:6be2751f-4b01-4536-9a6d-ce1183979a9b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 13.39:16 - 13.44:17
Lyhytvaikutteinen insuliini 0.09 ky (1.10 ky/t, 1.57 % = 1.72 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3dd9f6c8-ff63-50c1-8101-016e011e1477

```

-------

Entry 827 - fullUrl = urn:uuid:0328e220-8cf8-47b5-ab71-d7d4891d57c7

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.39:29
Kudossokeri: 8.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dec795fc-0458-5e26-acbf-1ff6718fa4d9

```

-------

Entry 828 - fullUrl = urn:uuid:79baea3e-056a-40cf-9464-68f3764e2449

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 13.44:17 - 13.50:52
Lyhytvaikutteinen insuliini 0.13 ky (1.14 ky/t, 1.63 % = 1.86 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:30de7d31-ec2f-5a0c-a4b8-2ad2121685d5

```

-------

Entry 829 - fullUrl = urn:uuid:38c31b3a-5d07-4375-9919-9d5a7fc7b308

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.44:29
Kudossokeri: 9.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0a3bf700-d967-58ff-8793-f90b83241018

```

-------

Entry 830 - fullUrl = urn:uuid:3100a132-775b-44e4-b009-8eb9f9d7e9d2

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 13.47:16
Lyhytvaikutteinen insuliini 9.50 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3b42bb92-44c1-5afe-8d56-a15a9031f834

```

-------

Entry 831 - fullUrl = urn:uuid:30f1a023-120d-442b-ad80-22dae23ca84f

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 6.9.2021 13.47:16
Arvioitu hiilihydraattimäärä: 95 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2e6fea3-3ccb-5952-8cdb-e5a49fb612a6

```

-------

Entry 832 - fullUrl = urn:uuid:ef24ecd4-cc07-4e8c-92d6-dc05afff341f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.49:29
Kudossokeri: 9.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:169f2c94-8fef-50bb-a711-1f9ecd949abe

```

-------

Entry 833 - fullUrl = urn:uuid:ce9fc8cb-a784-4a15-88fb-dc8613beabef

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 13.50:52 - 13.55:51
Lyhytvaikutteinen insuliini 0.11 ky (1.33 ky/t, 1.90 % = 2.53 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4b4c661e-ec19-5bbc-af10-0c18d30f8785

```

-------

Entry 834 - fullUrl = urn:uuid:a6bb5e3c-ed78-40f7-b17c-7f0bcbd37ff4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.54:30
Kudossokeri: 9.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2fab46dc-880a-5fc4-8361-12ae442c7bf5

```

-------

Entry 835 - fullUrl = urn:uuid:541c286d-36dd-4c4c-b049-8ee39850c3ea

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 13.55:51 - 15.56:11
Lyhytvaikutteinen insuliini 1.40 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3079d34e-f275-5b2b-a850-d0720a5c9347

```

-------

Entry 836 - fullUrl = urn:uuid:956a5210-39d5-421d-9c19-950470f41467

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 13.59:31
Kudossokeri: 9.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4ba66721-27f9-5297-8a4d-5599d26ea4b6

```

-------

Entry 837 - fullUrl = urn:uuid:0d7cb0c6-c5b0-43c7-aff5-bec2d712dc54

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.04:28
Kudossokeri: 9.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b75fc926-52e8-5ac3-8037-f866c47b9451

```

-------

Entry 838 - fullUrl = urn:uuid:d4529d84-02ae-4020-8e2d-2777734f12f6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.09:29
Kudossokeri: 9.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7c50bd2e-0d0e-555c-b94b-bb703821daa3

```

-------

Entry 839 - fullUrl = urn:uuid:44c3996b-8650-49cb-8987-264403d45c71

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.14:29
Kudossokeri: 9.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7d7d6a4a-dd3f-5169-bbe8-12cab8fc2fb7

```

-------

Entry 840 - fullUrl = urn:uuid:a5dbd06b-8ba8-44c0-9497-b13e55f3f88c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.19:29
Kudossokeri: 9.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:373bcb04-e63e-568c-8495-ea62547e03db

```

-------

Entry 841 - fullUrl = urn:uuid:2e228c4e-2b44-4960-9a0a-d2b4b9315348

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.24:28
Kudossokeri: 9.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eb9d5a10-9de9-593f-aed8-7ee55a057538

```

-------

Entry 842 - fullUrl = urn:uuid:7013802b-002f-4e89-9cb3-3042434602b5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.29:28
Kudossokeri: 9.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c63fabdb-3dbc-563a-bebd-0a0935578120

```

-------

Entry 843 - fullUrl = urn:uuid:2d7e1d54-441d-4f54-ae73-b30ee68c04c4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.34:28
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9585e538-96ca-503b-b56f-f7876991468b

```

-------

Entry 844 - fullUrl = urn:uuid:196e3390-d6fd-4290-b972-08de4ce19fab

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.39:28
Kudossokeri: 9.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:445f9e67-3a1a-5a78-bd75-80641930f129

```

-------

Entry 845 - fullUrl = urn:uuid:87eab342-ba97-4c89-8969-19ea39a6e8f2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.44:28
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1aa9a5d8-b9c1-5cfa-9895-f878a1c7dd7b

```

-------

Entry 846 - fullUrl = urn:uuid:159ad5c7-4f30-418d-ac90-77e373f8cdf0

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.49:28
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:143527b6-eb14-5318-8c34-8e455ccee487

```

-------

Entry 847 - fullUrl = urn:uuid:c0818d1b-4bc5-4e1f-ab2c-b40012b2e229

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.54:28
Kudossokeri: 9.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:23f7df77-319d-50cb-bb9f-deaacfb2508f

```

-------

Entry 848 - fullUrl = urn:uuid:946a24cb-cd9d-4fa3-b45c-fb3cca7c819c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 14.59:28
Kudossokeri: 9.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b165b495-a31d-56b6-a694-0d8acc7d6f56

```

-------

Entry 849 - fullUrl = urn:uuid:fc4c56aa-d218-48a4-a82c-3009bcf7dad6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.04:28
Kudossokeri: 9.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f6cf84e0-13a1-5a1e-b1db-c4edc4e0c543

```

-------

Entry 850 - fullUrl = urn:uuid:a2269e83-4256-49c1-91c7-c99cbd28f5cc

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.09:28
Kudossokeri: 8.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fc229e94-cf25-5260-8a29-c46c17523872

```

-------

Entry 851 - fullUrl = urn:uuid:d8cf7fdd-bc92-47e5-affb-d9c89224a3fb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.14:28
Kudossokeri: 8.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:04fa2671-28c8-54ee-9b64-402861129bf7

```

-------

Entry 852 - fullUrl = urn:uuid:5c462da1-8b35-4b8d-85a6-49d4ec5ac359

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.19:28
Kudossokeri: 9.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8fa0caea-fbc1-5449-84db-c99ca402dbf1

```

-------

Entry 853 - fullUrl = urn:uuid:f0c2457c-7f9e-45a9-9564-bd3f5d586c93

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.24:28
Kudossokeri: 9.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1613ef10-cb17-5f3c-bedc-e9b94f042b13

```

-------

Entry 854 - fullUrl = urn:uuid:28d3df7a-2f2b-48f0-8fde-1991d22b3b0a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.29:28
Kudossokeri: 9.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5ab60039-ac12-5ad1-a222-f363876809e2

```

-------

Entry 855 - fullUrl = urn:uuid:b38e79a9-bf95-4c2d-96fa-7ab41c43e41a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.34:28
Kudossokeri: 9.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e17d0729-410b-5a94-a012-f7f0d5f001da

```

-------

Entry 856 - fullUrl = urn:uuid:08addca4-990c-4832-975c-e69d077970ab

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.39:30
Kudossokeri: 8.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bee95712-13a1-509f-be65-92c4a7f03f57

```

-------

Entry 857 - fullUrl = urn:uuid:d0c6a598-b2be-474d-8844-0a7964a8e3b4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.44:28
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:33813aae-3df0-5f2a-847c-0bd32b851190

```

-------

Entry 858 - fullUrl = urn:uuid:45b47728-563b-4caa-b918-7acf4a2fcb8b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.49:28
Kudossokeri: 7.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1705ddaf-ac4b-515a-9cde-6245224f3582

```

-------

Entry 859 - fullUrl = urn:uuid:ca3e4c0a-557c-471e-92f2-4bf0bf8f20da

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.54:28
Kudossokeri: 7.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:533dbb4a-72c2-5488-9379-8f982c8509c8

```

-------

Entry 860 - fullUrl = urn:uuid:606d872d-8047-4cc9-ab86-9373566c3f75

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 15.56:11 - 16.01:12
Lyhytvaikutteinen insuliini 0.03 ky (0.34 ky/t, 0.48 % = 0.16 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2e8eb007-3566-5b17-bcba-3092d0017049

```

-------

Entry 861 - fullUrl = urn:uuid:b3236a61-6b4d-49ac-95f5-2d10f9249642

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 15.59:29
Kudossokeri: 7.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:048d972c-86db-5fc2-ab2f-4280f4f5ac22

```

-------

Entry 862 - fullUrl = urn:uuid:7c584ad5-d886-4132-86f6-069d8dbad52f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 16.01:12 - 16.06:12
Lyhytvaikutteinen insuliini 0.02 ky (0.26 ky/t, 0.37 % = 0.10 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:082084a6-d8ce-5c60-addd-c1591f2684a7

```

-------

Entry 863 - fullUrl = urn:uuid:19acb74b-f39e-4b25-8418-8155030cd9b4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.04:28
Kudossokeri: 7.72 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:da1df470-301e-5875-ab19-94ab92a0ee91

```

-------

Entry 864 - fullUrl = urn:uuid:bbd19a67-e732-4915-8cca-4658c95d6293

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 16.06:12 - 16.26:15
Lyhytvaikutteinen insuliini 0.23 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7913cfb7-c499-5702-a20a-728667a69326

```

-------

Entry 865 - fullUrl = urn:uuid:5ea5a3a1-5956-4111-9216-a06784a6d21c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.09:28
Kudossokeri: 8.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6bd9ce5c-f9fc-5a4e-b649-0d28b3b09452

```

-------

Entry 866 - fullUrl = urn:uuid:4cfef963-f2f3-48dc-a29b-cda55c2daae5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.14:28
Kudossokeri: 8.55 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c49d7617-e4f6-5f2e-8b5c-0b0472c659c0

```

-------

Entry 867 - fullUrl = urn:uuid:ea53df70-46c0-48d8-ae75-505bd2e2819d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.19:28
Kudossokeri: 8.94 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ad814ecc-8e57-52b8-b345-a1bc4f171532

```

-------

Entry 868 - fullUrl = urn:uuid:c66bb76a-366a-42ca-8674-a12179ef48e9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.24:28
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:37ef9c54-7893-5072-9a11-e39f7dbaf287

```

-------

Entry 869 - fullUrl = urn:uuid:2f0a3ad8-f3af-40e7-926b-4f588504b942

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 16.26:15 - 16.31:16
Lyhytvaikutteinen insuliini 0.11 ky (1.29 ky/t, 1.84 % = 2.36 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:364080a0-0646-5a90-bb10-00ff17a4d0b2

```

-------

Entry 870 - fullUrl = urn:uuid:68c53590-893c-47a1-97b3-6c874ec3c4a7

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 16.26:29
Lyhytvaikutteinen insuliini 1.06 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b87c184b-4cb9-571f-84d2-9ffbb3cd5002

```

-------

Entry 871 - fullUrl = urn:uuid:d9cf6b26-5104-4e28-806d-998ffd2e2332

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.29:28
Kudossokeri: 9.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:31eea8b6-c238-52c6-8f90-13bda15f88cb

```

-------

Entry 872 - fullUrl = urn:uuid:5c8ff0e2-9069-4f3d-b9d1-c683f3454acb

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 16.31:16 - 16.51:19
Lyhytvaikutteinen insuliini 0.23 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9b86d207-e579-5e04-a210-8b9ac161a855

```

-------

Entry 873 - fullUrl = urn:uuid:0c1b8609-1a5d-428f-90ce-795f243db3b1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.34:28
Kudossokeri: 10.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aed20616-6de3-5fbb-8892-e675fdc975de

```

-------

Entry 874 - fullUrl = urn:uuid:9b9756ba-2315-42b2-a887-35e2ac72dfd4

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.39:28
Kudossokeri: 10.32 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f159e4b9-84dd-5f0c-9775-d6284a8ec6b3

```

-------

Entry 875 - fullUrl = urn:uuid:ca4dec36-bd49-49b3-b9a9-ea4d200099d1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.44:28
Kudossokeri: 10.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:66b987e1-f162-54f5-af09-b7f9c84f0f7f

```

-------

Entry 876 - fullUrl = urn:uuid:0877983d-2045-4396-b88e-941040729bd2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.49:28
Kudossokeri: 10.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e8ad8390-f182-55fb-a893-eba232f9d11b

```

-------

Entry 877 - fullUrl = urn:uuid:dd5b316b-f1bd-42b2-aaff-6f10024a417c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 16.51:19 - 16.56:20
Lyhytvaikutteinen insuliini 0.08 ky (0.92 ky/t, 1.32 % = 1.21 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b178e73f-b95f-5384-a339-686959e56e68

```

-------

Entry 878 - fullUrl = urn:uuid:f6b7b2ba-4d88-46e2-8f7d-49785441447e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.54:28
Kudossokeri: 11.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6a2db95d-9cd9-5384-bd0b-1992e9cc236b

```

-------

Entry 879 - fullUrl = urn:uuid:d2e642cf-24be-429a-b24d-79b5bf6bcd8f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 16.56:20 - 17.01:21
Lyhytvaikutteinen insuliini 0.13 ky (1.58 ky/t, 2.26 % = 3.57 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:21f9245d-8be8-5890-805b-eff21d1f60f3

```

-------

Entry 880 - fullUrl = urn:uuid:dbd39b9a-ea32-4929-b1d9-5c6d307f13d9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 16.59:28
Kudossokeri: 11.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d92129c6-e98a-5f4e-8c21-5a3a6a4166bb

```

-------

Entry 881 - fullUrl = urn:uuid:54d66d2c-fcc4-4c1b-b7bb-a8d50d019679

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.01:21 - 17.06:23
Lyhytvaikutteinen insuliini 0.19 ky (2.21 ky/t, 3.16 % = 6.97 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:11b75245-4ea7-5292-943c-3528fc10fbf1

```

-------

Entry 882 - fullUrl = urn:uuid:d46bc4b4-52cb-47f8-abc6-db04f6e42496

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.04:29
Kudossokeri: 11.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:52fcbf61-5f96-5252-9caa-761a28a7c347

```

-------

Entry 883 - fullUrl = urn:uuid:f889e521-6373-4068-9d57-b6ec47ae7ec0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.06:23 - 17.11:23
Lyhytvaikutteinen insuliini 0.20 ky (2.41 ky/t, 3.45 % = 8.32 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cd537fd7-5c71-5aed-a64b-b7f72261eb04

```

-------

Entry 884 - fullUrl = urn:uuid:c747f065-0642-4e7f-9ab0-a77889a030ea

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.09:28
Kudossokeri: 11.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e6ca2d15-b42e-5c5b-afb0-2a81f138b511

```

-------

Entry 885 - fullUrl = urn:uuid:eec05804-b185-4288-8722-213aa1fd8361

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.11:23 - 17.16:23
Lyhytvaikutteinen insuliini 0.19 ky (2.31 ky/t, 3.30 % = 7.63 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b1f23697-be34-5388-b60c-3d641e5a03c6

```

-------

Entry 886 - fullUrl = urn:uuid:5feff190-af1e-4fec-b551-ac186ce8e48c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.14:29
Kudossokeri: 12.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2fd84280-4950-5041-a9cd-7473c64b278f

```

-------

Entry 887 - fullUrl = urn:uuid:2613315c-fb8a-4302-a9fe-983fdc388262

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.16:23 - 17.21:24
Lyhytvaikutteinen insuliini 0.15 ky (1.78 ky/t, 2.54 % = 4.51 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ccc45c2c-feca-52a0-9a38-ff2eb6ac39e1

```

-------

Entry 888 - fullUrl = urn:uuid:6ce14f0c-4527-481b-9ccf-262b8e36c589

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.19:28
Kudossokeri: 12.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b4594787-2a45-5b5e-a954-7314dfbe21ab

```

-------

Entry 889 - fullUrl = urn:uuid:56cd6f20-7353-4b05-976a-015284d00d20

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.21:24 - 17.26:25
Lyhytvaikutteinen insuliini 0.14 ky (1.73 ky/t, 2.46 % = 4.25 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a181f25d-0319-560e-8bc4-30bd6f7baae6

```

-------

Entry 890 - fullUrl = urn:uuid:ad64f6d2-95c0-4a98-b8d5-ab3680044ae9

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.24:28
Kudossokeri: 12.54 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3d291435-9c1b-5094-92db-9c8436afcec9

```

-------

Entry 891 - fullUrl = urn:uuid:017c69ec-b2af-427d-8408-daf2a8ad18b1

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.26:25 - 17.31:27
Lyhytvaikutteinen insuliini 0.17 ky (2.04 ky/t, 2.91 % = 5.93 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8881f810-ffa0-5e11-971d-ad3e9c01516a

```

-------

Entry 892 - fullUrl = urn:uuid:c0ed1031-12a7-4961-b5ee-af8b91919100

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.29:30
Kudossokeri: 12.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a1afe353-8a2b-5820-8152-2f0cb3979515

```

-------

Entry 893 - fullUrl = urn:uuid:c81dc953-b838-44df-a529-0c94d87f191b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.31:27 - 17.36:27
Lyhytvaikutteinen insuliini 0.21 ky (2.52 ky/t, 3.59 % = 9.04 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:de568c9a-0018-546b-85c1-23e60aa12c8e

```

-------

Entry 894 - fullUrl = urn:uuid:cd6377cd-4f1a-4df5-8dad-61528be33bc0

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.31:41
Lyhytvaikutteinen insuliini 1.43 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:42f49bf2-5c04-5e1b-8872-c66077854e0b

```

-------

Entry 895 - fullUrl = urn:uuid:9b5f545d-301f-413c-9292-7be2781c8f9e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.34:29
Kudossokeri: 13.04 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c21c0656-0c48-53bf-aa1a-8a9b200848bc

```

-------

Entry 896 - fullUrl = urn:uuid:2995ad76-2eaf-49e6-becf-72ae36f7569f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.36:27 - 17.46:27
Lyhytvaikutteinen insuliini 0.12 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c45b35d5-73d7-5524-9513-984ac0233c3c

```

-------

Entry 897 - fullUrl = urn:uuid:8a3ad935-0830-49e7-a7c1-495589d826ad

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.39:28
Kudossokeri: 13.32 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1e50311a-4452-5cfe-bbf3-69770e8629a7

```

-------

Entry 898 - fullUrl = urn:uuid:be45ad8d-0907-4ea9-b91a-6715e268435e

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.44:31
Kudossokeri: 13.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:522c85ef-d2fc-5a53-b954-7188cd5a81e3

```

-------

Entry 899 - fullUrl = urn:uuid:dec96f1d-bed8-4354-ad3c-2cc4264fa89c

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.46:27 - 17.51:29
Lyhytvaikutteinen insuliini 0.09 ky (1.12 ky/t, 1.60 % = 1.79 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:81507d17-7a80-579d-8dc4-4c91b01b65c8

```

-------

Entry 900 - fullUrl = urn:uuid:27ab56ab-6cdd-4fff-803c-1ab32ed11db8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.49:28
Kudossokeri: 13.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:16efaf07-ef84-599a-96ad-cb0d473051a8

```

-------

Entry 901 - fullUrl = urn:uuid:eb8998e6-a0d6-401b-9cca-c5e9948fbf0f

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.51:29 - 17.56:30
Lyhytvaikutteinen insuliini 0.09 ky (1.10 ky/t, 1.57 % = 1.73 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5447514f-d6d7-582f-ba55-d1f04d25d670

```

-------

Entry 902 - fullUrl = urn:uuid:92f8662e-81f8-4f18-8bb1-c95637f02a72

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.54:28
Kudossokeri: 13.04 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:37b35004-7a82-5efd-a240-4ccbe25a921c

```

-------

Entry 903 - fullUrl = urn:uuid:1c91c95b-698c-4792-ab4d-92f5e406a89b

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 17.56:30 - 18.36:35
Lyhytvaikutteinen insuliini 0.47 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8e400abf-9108-5e28-bd43-f40a83a9a3e2

```

-------

Entry 904 - fullUrl = urn:uuid:5ed87fdd-aa22-459a-ab06-ab903f60baf6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 17.59:30
Kudossokeri: 12.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4ab8300c-e6b9-5ae0-bf52-d97d00bf2693

```

-------

Entry 905 - fullUrl = urn:uuid:9d581a92-9e26-4f54-beff-f7f8f18e6a4a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.04:28
Kudossokeri: 12.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f3ccbb16-076c-595b-a85a-57a224d0efb4

```

-------

Entry 906 - fullUrl = urn:uuid:a60f229d-509f-4c27-85c0-fa7b1cd936ad

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.09:28
Kudossokeri: 12.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1e67a6a1-9899-5ab0-aca3-2cf5223debbd

```

-------

Entry 907 - fullUrl = urn:uuid:6fc38d86-a4b8-4a2b-b2fb-98ec88134442

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.14:28
Kudossokeri: 12.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:79fd3800-a249-54a9-94d9-7b643062d479

```

-------

Entry 908 - fullUrl = urn:uuid:4d87c426-3896-4249-bba6-1ab083141912

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.19:28
Kudossokeri: 12.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e2a8f902-748b-53dc-aeed-9d6e611831e2

```

-------

Entry 909 - fullUrl = urn:uuid:2749cbde-421b-4a11-8e6c-baea8460a8ff

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.24:28
Kudossokeri: 11.99 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:46201847-b54c-5bdf-a12a-1a15ca2a20ec

```

-------

Entry 910 - fullUrl = urn:uuid:716fb3bd-d537-44b3-90ef-cd1252931b7d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.29:28
Kudossokeri: 11.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:96cbb9e0-9ac0-5a83-b16f-437f65fe1e53

```

-------

Entry 911 - fullUrl = urn:uuid:5c20c8d6-ea85-4e23-8d5d-c28cea5d06de

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.34:28
Kudossokeri: 11.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2e1eb994-2830-59c0-ac6b-4ce3c730232c

```

-------

Entry 912 - fullUrl = urn:uuid:c1d20f42-3b46-41ca-b1d9-539bd75c121a

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 18.36:35 - 18.41:38
Lyhytvaikutteinen insuliini 0.07 ky (0.86 ky/t, 1.23 % = 1.06 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6cd78f60-9a0a-56d3-a69a-650917e82a3f

```

-------

Entry 913 - fullUrl = urn:uuid:fc17cc02-427b-444e-a470-df099ae79f33

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 18.37:12
Lyhytvaikutteinen insuliini 0.93 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:98588785-2e69-5e56-a0b5-e26fa11a3b04

```

-------

Entry 914 - fullUrl = urn:uuid:378ef845-bdbc-4a43-852a-faea66f2e039

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.39:28
Kudossokeri: 11.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a040cf60-51f8-5803-8da8-982870b11363

```

-------

Entry 915 - fullUrl = urn:uuid:545a9a85-bb4b-42e4-9a6b-ae24aa1dc197

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 18.41:38 - 21.12:01
Lyhytvaikutteinen insuliini 1.75 ky (0.7 [iU]/h)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1f916b21-9b04-5d5f-aed7-7b1c55649149

```

-------

Entry 916 - fullUrl = urn:uuid:d5128bd6-cd03-417b-ac9b-9d03222fe161

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.44:29
Kudossokeri: 11.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c31a5692-e9f3-57f5-8ae8-bda5334b6c1a

```

-------

Entry 917 - fullUrl = urn:uuid:07be051a-453a-48b0-90fd-76f4605f1c24

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.49:28
Kudossokeri: 11.6 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b524ed32-6324-5f58-aa17-396e4daf48e6

```

-------

Entry 918 - fullUrl = urn:uuid:b9f165eb-0ffe-4a1f-8002-2a0936e7a3e8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.54:28
Kudossokeri: 11.43 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0eac73ba-217e-5739-821a-58703bef0817

```

-------

Entry 919 - fullUrl = urn:uuid:28f8ef1c-7827-421d-911d-f1234a075252

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 18.59:28
Kudossokeri: 11.1 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:edfbe12e-73ab-5772-901e-b4cb446541ce

```

-------

Entry 920 - fullUrl = urn:uuid:f782ffcb-da03-41e0-8983-9220bb5951c5

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.04:27
Kudossokeri: 10.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8e748b87-565e-5fec-ac31-145c6f8c15e5

```

-------

Entry 921 - fullUrl = urn:uuid:dcdc2bf6-3fa9-4c53-835d-583305ed7abb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.09:28
Kudossokeri: 10.82 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f08898a6-25fa-5af0-a9b2-4cfb2ae95df7

```

-------

Entry 922 - fullUrl = urn:uuid:ba1c3997-03bd-4317-8d95-e7573517430f

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.14:27
Kudossokeri: 10.71 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:df321cc9-fffb-5be4-88be-703a668d503f

```

-------

Entry 923 - fullUrl = urn:uuid:bb375237-a341-49f0-9d77-a7a1b94e966c

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.19:28
Kudossokeri: 10.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:20b9cfd9-9848-50b5-843e-9934cf022293

```

-------

Entry 924 - fullUrl = urn:uuid:5716a033-0259-417d-977d-1d38c757024b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.24:27
Kudossokeri: 10.32 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cb058558-2c6f-561b-aa20-0de7a82de0a6

```

-------

Entry 925 - fullUrl = urn:uuid:0bf50863-220a-4062-8980-a82ce8c6b286

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.29:27
Kudossokeri: 10.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3d35105a-d2ec-5604-a4e7-b04761f49a7d

```

-------

Entry 926 - fullUrl = urn:uuid:2e59519b-5a5c-4a82-a5fd-27b3bfe2e610

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.34:28
Kudossokeri: 10.05 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d415d8eb-f84d-5b4e-942e-393bf91466b1

```

-------

Entry 927 - fullUrl = urn:uuid:3048f64d-6dea-4a3d-a008-72ca7dde6838

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.39:28
Kudossokeri: 9.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4daae936-0e09-5449-b8ba-51ccf188d267

```

-------

Entry 928 - fullUrl = urn:uuid:37f97976-66ca-4d6e-bda4-be5a21a6f67b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.44:28
Kudossokeri: 9.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f80be942-8970-542f-a06a-ba18d804426b

```

-------

Entry 929 - fullUrl = urn:uuid:0cbc7840-b787-433b-b8fd-fa63c43b295b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.49:27
Kudossokeri: 9.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5903f1b6-0ad0-5d38-b7ca-f15ff68dd774

```

-------

Entry 930 - fullUrl = urn:uuid:9804494d-8e8d-48b9-9dfe-5526c8667ee2

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.54:31
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3ab3925d-dd2f-58a8-9bc8-49bc018a4320

```

-------

Entry 931 - fullUrl = urn:uuid:0281c403-8680-4bcd-b874-fb2c2ea3989d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 19.59:27
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:55c0215a-2b84-56ba-baf4-d9d5b37bc0b7

```

-------

Entry 932 - fullUrl = urn:uuid:45c2b4e7-27d0-463d-ae72-2252755fd185

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.04:27
Kudossokeri: 9.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:935d1823-319f-51b1-b660-cb2c4a751df5

```

-------

Entry 933 - fullUrl = urn:uuid:56c6e6f9-6033-4cac-af1a-877bee38c050

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.09:27
Kudossokeri: 9.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:76ef650e-1513-571c-af55-36d44e3f2fb1

```

-------

Entry 934 - fullUrl = urn:uuid:6e6b7bac-4fb4-4b7d-a20c-e6cff2105c14

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 20.12:18
Lyhytvaikutteinen insuliini 7.06 ky
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5308c1a3-1499-579f-8559-547cf98e6e5e

```

-------

Entry 935 - fullUrl = urn:uuid:626fa469-1f68-4cbd-b7b5-a5157f9d403e

Resource Observation:

> Koodi: LOINC 9059-7 (Carbohydrate intake Estimated)
Aika: 6.9.2021 20.12:18
Arvioitu hiilihydraattimäärä: 75 g
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2655430f-ecd1-5a53-80dd-0784a4327f24

```

-------

Entry 936 - fullUrl = urn:uuid:0e1afeef-e078-483a-a8a7-94c71ec0e6eb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.14:34
Kudossokeri: 9.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5214617d-411e-5613-90da-af085c6bb9d9

```

-------

Entry 937 - fullUrl = urn:uuid:073dc598-f788-45b8-9d0a-f65be0fa34b8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.19:29
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e9747d06-641d-582e-a164-b0f5a36b32c0

```

-------

Entry 938 - fullUrl = urn:uuid:85f205f6-5925-4811-ad98-e5a4ba9df787

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.24:27
Kudossokeri: 9.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3468a881-5adc-5cd0-9e21-343b73898692

```

-------

Entry 939 - fullUrl = urn:uuid:d927c80a-b58b-4581-9454-deff342e94f6

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.29:28
Kudossokeri: 9.38 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1662979a-6ef3-548e-8e0d-6f0ee58b77a4

```

-------

Entry 940 - fullUrl = urn:uuid:2d87a630-33c8-4928-8435-f045a17c90f3

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.34:27
Kudossokeri: 9.16 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8646a1b9-9692-5939-9dee-cc8e611f7f29

```

-------

Entry 941 - fullUrl = urn:uuid:c1e4e50d-45e4-4e66-bb0c-8cdf91f4eccb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.39:28
Kudossokeri: 9.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fb822f63-190f-560a-a82e-aa302369e140

```

-------

Entry 942 - fullUrl = urn:uuid:4c681e24-8bdd-42bb-980f-dfe66a8b74bb

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.44:28
Kudossokeri: 9.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c529c348-16c3-55f4-9a7b-f83e96b82b73

```

-------

Entry 943 - fullUrl = urn:uuid:32f0b96d-cf58-4e15-ba11-8e206fc46cd1

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.49:29
Kudossokeri: 9.21 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cc7f55ff-8e07-56c1-b87a-729392a4bfc9

```

-------

Entry 944 - fullUrl = urn:uuid:c392d9e8-c439-4253-84ba-995a596325df

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.54:27
Kudossokeri: 8.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f0bac1d2-986c-5fd3-880e-79f427b7cc35

```

-------

Entry 945 - fullUrl = urn:uuid:aa69a1d8-6c5d-4852-8687-86eb2a77cc7a

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 20.59:27
Kudossokeri: 8.33 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b2aebb57-5531-5179-81e8-cac91be602cd

```

-------

Entry 946 - fullUrl = urn:uuid:d71c6f51-0b36-4921-840f-9a9b5ed90873

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.04:27
Kudossokeri: 7.77 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8ef19692-c86c-5feb-a4f3-e57d56ac7440

```

-------

Entry 947 - fullUrl = urn:uuid:7224400f-db79-49c4-85cf-fbf75b9d2e4d

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.09:32
Kudossokeri: 7.27 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a4c540a0-6a29-5f9f-b0bc-85df1b99f542

```

-------

Entry 948 - fullUrl = urn:uuid:10419cb9-e54f-4fb9-b71d-e5a1d5ff3565

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 21.12:01 - 21.17:02
Lyhytvaikutteinen insuliini 0.02 ky (0.28 ky/t, 0.41 % = 0.12 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9809a14b-752a-5beb-8e1f-6b508cc62607

```

-------

Entry 949 - fullUrl = urn:uuid:ceb1eca7-1bba-4eac-bd93-f25c9fc8f699

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.14:27
Kudossokeri: 6.88 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7302da05-8157-5a01-a433-96df57f9870d

```

-------

Entry 950 - fullUrl = urn:uuid:27114f23-60a9-4ba1-977b-1f61c43e0f59

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 21.17:02 - 21.32:03
Lyhytvaikutteinen insuliini 0.00 ky (0.00 ky/t, 1.00 % = 0.00 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:485d98c2-d0f1-5e13-968e-44f01e3651b1

```

-------

Entry 951 - fullUrl = urn:uuid:6be7aa19-1273-4dfd-b11f-7717835fd130

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.19:27
Kudossokeri: 6.66 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:14aad0f7-e4d1-56fa-bc27-d081e102b487

```

-------

Entry 952 - fullUrl = urn:uuid:c73300af-775f-47c0-832a-2dc9c356af51

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.24:27
Kudossokeri: 6.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2e34f66a-3ebe-5ef8-8380-8cc447728820

```

-------

Entry 953 - fullUrl = urn:uuid:a11034a5-9256-4166-b4ee-525b171f5835

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.29:29
Kudossokeri: 6.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:06181071-bd53-5f09-bcb8-6dc89573e47a

```

-------

Entry 954 - fullUrl = urn:uuid:f0104ce8-151a-4138-bce8-1756e273f7a4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 21.32:03 - 21.37:05
Lyhytvaikutteinen insuliini 0.01 ky (0.14 ky/t, 0.19 % = 0.03 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ddd1a6a5-c2d8-5bff-a5ee-2dc5df125431

```

-------

Entry 955 - fullUrl = urn:uuid:e2406508-3ac5-4779-80cb-fa296ceb4ee8

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.34:27
Kudossokeri: 6.44 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0bcab799-8698-58ea-95f6-e53ad77aaf66

```

-------

Entry 956 - fullUrl = urn:uuid:8b24eb0d-8d6c-421c-a205-938ca4da2cb2

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 21.37:05 - 21.42:06
Lyhytvaikutteinen insuliini 0.02 ky (0.27 ky/t, 0.39 % = 0.11 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:04d0169a-0917-5e3f-bfdd-5f2e2b0f87b9

```

-------

Entry 957 - fullUrl = urn:uuid:a209d3d9-369e-433c-87ad-cf8d0b6bab1b

Resource Observation:

> Koodi: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Aika: 6.9.2021 21.39:28
Kudossokeri: 6.49 mmol/l
Laite: tandemCIQ1002717799999

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:27b4cdae-c3e5-50ba-b3a1-d7b5140c9519

```

-------

Entry 958 - fullUrl = urn:uuid:bbec5b0a-672a-4cd0-b843-25a3775da3d4

Resource MedicationAdministration:

> Insuliinin tyyppi: Lyhytvaikutteinen insuliini
Koodi: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Lyhytvaikutteinen insuliini), SNOMED 67866001 (Insulin (substance))
Aika: 6.9.2021 21.42:06 - 21.47:06
Lyhytvaikutteinen insuliini 0.04 ky (0.53 ky/t, 0.76 % = 0.41 ky/t)
Laite: tandemCIQ1002717799999

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8a1492f8-3c84-5ea6-8279-5a076a4f8789

```

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

