# Table of Contents - Finnish Base Profiles v2.0.0-ci

* **Table of Contents**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

## Table of Contents

| |
| :--- |
| [0 Table of Contents](toc.md) |
| [1 Home](index.md) |
| [2 Profiles](profiles.md) |
| [3 Extensions](extensions.md) |
| [4 Terminology](terminology.md) |
| [5 Examples](examples.md) |
| [6 Downloads](downloads.md) |
| [7 Version History](versions.md) |
| [8 Artifacts Summary](artifacts.md) |
| [8.1 FI Base InformationCustodian](StructureDefinition-fi-base-information-custodian.md) |
| [8.2 FI Base Appointment](StructureDefinition-fi-base-appointment.md) |
| [8.3 FI Base Condition](StructureDefinition-fi-base-condition.md) |
| [8.4 FI Base Encounter](StructureDefinition-fi-base-encounter.md) |
| [8.5 FI Base EpisodeOfCare](StructureDefinition-fi-base-episode-of-care.md) |
| [8.6 FI Base HealthcareService](StructureDefinition-fi-base-healthcare-service.md) |
| [8.7 Fi Base Immunization](StructureDefinition-fi-base-immunization.md) |
| [8.8 FI Base Information Custodian (Individual Provider)](StructureDefinition-fi-base-information-custodian-individual.md) |
| [8.9 FI Base Information Custodian (Private Organization)](StructureDefinition-fi-base-information-custodian-private.md) |
| [8.10 FI Base Information Custodian (Public Organization)](StructureDefinition-fi-base-information-custodian-public.md) |
| [8.11 FI Base Location](StructureDefinition-fi-base-location.md) |
| [8.12 FI Base Medication](StructureDefinition-fi-base-medication.md) |
| [8.13 FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md) |
| [8.14 FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md) |
| [8.15 FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md) |
| [8.16 FI Base Observation](StructureDefinition-fi-base-observation.md) |
| [8.17 FI Base Organization](StructureDefinition-fi-base-organization.md) |
| [8.18 FI Base Patient](StructureDefinition-fi-base-patient.md) |
| [8.19 FI Base Practitioner](StructureDefinition-fi-base-practitioner.md) |
| [8.20 FI Base PractitionerRole](StructureDefinition-fi-base-practitioner-role.md) |
| [8.21 Fi Base Procedure](StructureDefinition-fi-base-procedure.md) |
| [8.22 FI Base Provenance](StructureDefinition-fi-base-provenance.md) |
| [8.23 FI Base Reason for Care (encounter-diagnosis and reason for visit)](StructureDefinition-fi-base-reason-for-care.md) |
| [8.24 FI Base Schedule](StructureDefinition-fi-base-schedule.md) |
| [8.25 FI Base Slot](StructureDefinition-fi-base-slot.md) |
| [8.26 An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile](StructureDefinition-kanta-document-metadata-profile.md) |
| [8.27 An imaginary profile for Kanta system, specifying things apart from the information custodian](StructureDefinition-kanta-document-other-metadata-profile.md) |
| [8.28 Categorization of the type of accident](StructureDefinition-condition-categorization-of-accident.md) |
| [8.29 Cause of an adverse effect](StructureDefinition-condition-cause-of-adverse-effect.md) |
| [8.30 Endocrinological disorder](StructureDefinition-condition-endocrinological-disorder.md) |
| [8.31 External cause for diagnosis](StructureDefinition-condition-external-cause.md) |
| [8.32 Medication that caused this condition](StructureDefinition-condition-caused-by-medication.md) |
| [8.33 Municipality Code](StructureDefinition-municipality-code.md) |
| [8.34 Patient Profession Extension](StructureDefinition-patient-profession.md) |
| [8.35 Permanence of condition](StructureDefinition-condition-permanence.md) |
| [8.36 Primary condition for encounter](StructureDefinition-condition-primary.md) |
| [8.37 ReleaseDateForPatientViewing](StructureDefinition-ReleaseDateForPatientViewing.md) |
| [8.38 RestrictionParent](StructureDefinition-RestrictionParent.md) |
| [8.39 ServiceEvent](StructureDefinition-service-event.md) |
| [8.40 Type of physical exercise during which injury occurred.](StructureDefinition-condition-physical-excercise.md) |
| [8.41 Vaccination Recorder](StructureDefinition-vaccination-recorder.md) |
| [8.42 fi-base-restriction-parent-vs](ValueSet-fi-base-restriction-parent-vs.md) |
| [8.43 Finnish ValueSet for security labels in accordance with finnish authorities](ValueSet-fi-base-security-label-vs.md) |
| [8.44 Finnish ValueSet for systems of registry specifiers](ValueSet-fi-base-register-identifier.md) |
| [8.45 Example value set for provenance roles](ValueSet-kanta-provenance-agent-role.md) |
| [8.46 Finnish CodeSystem for security labels](CodeSystem-fi-base-security-label-cs.md) |
| [8.47 Tiedon näyttäminen kansalaiselle viivästetty.](CodeSystem-fi-base-release-for-patient-viewing-cs.md) |
| [8.48 1 tabletti 2 kertaa päivässä](MedicationRequest-medicationrequestesim1.md) |
| [8.49 1 tabletti 2 kertaa päivässä 5 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7A.md) |
| [8.50 1 tabletti 2 kertaa päivässä 5-7 päivän ajan 15.1.2021 alkaen](MedicationRequest-medicationrequestesim7B.md) |
| [8.51 1-2 tablettia 1-3 kertaa päivässä](MedicationRequest-medicationrequestesim4.md) |
| [8.52 1-2 tablettia kerran päivässä](MedicationRequest-medicationrequestesim3.md) |
| [8.53 2 tablettia aamulla ja 1 tabletti illalla 6 päivän ajan](MedicationRequest-medicationrequestesim2.md) |
| [8.54 A high level organization](Organization-1.2.246.10.31045308.10002.0.md) |
| [8.55 A named bed](Location-id-for-bed-3.md) |
| [8.56 A simple practitioner role](PractitionerRole-practitionerRoleesim1.md) |
| [8.57 A simple provenance example](Provenance-id-for-provenance-1.md) |
| [8.58 A test example demonstrating that validation works](Provenance-kanta-document-metadata-profile-test-example-1.md) |
| [8.59 An imaginary example of a Provenance resource instance conforming to the imaginary metadata profile for Kanta system](Provenance-kanta-document-metadata-profile-example.md) |
| [8.60 An imaginary example of a Provenance resource instance conforming to the imaginary metadata profile for Kanta system, using the kanta code also for the custodian agent](Provenance-kanta-document-metadata-profile-example-2.md) |
| [8.61 Another Encounter that is part of palvelutapahtuma](Encounter-id-for-child-encounter-2.md) |
| [8.62 Another test example demonstrating that validation works](Provenance-kanta-document-metadata-profile-test-example-2.md) |
| [8.63 Biopsy of Colon procedure example](Procedure-ColonBiopsy.md) |
| [8.64 Codified healthcare service](HealthcareService-healthcareService-example.md) |
| [8.65 Condition - an example diagnosis](Condition-id-for-diagnosis-1.md) |
| [8.66 Condition - an example diagnosis with an adverse effect.](Condition-id-for-diagnosis-3.md) |
| [8.67 Condition - an example diagnosis with external cause, accident and medication information.](Condition-id-for-diagnosis-2.md) |
| [8.68 Custodian of information (rekisterinpitäjä), an individual provider](Provenance-custodian-individual.md) |
| [8.69 Custodian of information (rekisterinpitäjä), private occupational healthcare](Provenance-custodian-occupational-healthcare.md) |
| [8.70 Custodian of information (rekisterinpitäjä), public healthcare](Provenance-custodian-public-healthcare.md) |
| [8.71 Encounter - example primary care organization](Organization-1.2.246.10.8286189.10.100012.md) |
| [8.72 Encounter - patient is currently receiving care at a ward treating surgical patients](Encounter-id-for-ward-encounter.md) |
| [8.73 Encounter - patient primary care visit](Encounter-id-for-visit.md) |
| [8.74 Encounter that is a palvelutapahtuma in Kanta registry](Encounter-id-for-palvelutapahtuma.md) |
| [8.75 Encounter that is part of palvelutapahtuma](Encounter-id-for-child-encounter.md) |
| [8.76 Episode of care - with provenance](EpisodeOfCare-id-for-episode-1.md) |
| [8.77 Free slot (kertakäynti yleislääkärillä)](Slot-FreeSlot.md) |
| [8.78 GP appointment](Appointment-appointment-general-practitioner.md) |
| [8.79 Kanta PHR - blood glucose mandatory](Observation-bloodglucose-min.md) |
| [8.80 Kanta PHR - blood glucose optional](Observation-bloodglucose-max.md) |
| [8.81 Kanta PHR - blood glucose result as text](Observation-bloodglucose-as-text.md) |
| [8.82 Kanta PHR - blood glucose with data absent](Observation-bloodglucose-data-absent.md) |
| [8.83 Kanta PHR - blood pressure mandatory](Observation-bloodpressure-min.md) |
| [8.84 Kanta PHR - blood pressure optional](Observation-bloodpressure-max.md) |
| [8.85 Kanta PHR - body height optional](Observation-1153859e-0c86-1000-abb8-511d0000b222.md) |
| [8.86 Kanta PHR - body weight mandatory](Observation-bodyweight-min.md) |
| [8.87 Kanta PHR - body weight optional](Observation-bodyweight-max.md) |
| [8.88 Kanta PHR - calorie intake mandatory](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f7.md) |
| [8.89 Kanta PHR - calorie intake optional](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f8.md) |
| [8.90 Kanta PHR - carbohydrate intake mandatory](Observation-2894b2e6-7ebf-4c33-93e4-31935effff21.md) |
| [8.91 Kanta PHR - carbohydrate intake optional](Observation-2894b2e6-7ebf-4c33-93e4-31935effff22.md) |
| [8.92 Kanta PHR - exercise tracking mandatory](Observation-71831b54-1a80-47c5-ba84-0180a5eb784a.md) |
| [8.93 Kanta PHR - exercise tracking optional](Observation-71831b54-1a80-47c5-ba84-0180a5eb784b.md) |
| [8.94 Kanta PHR - Insulin dosage mandatory](MedicationAdministration-a4d97476-39fa-46c6-bf2e-1fb153a7bbe2.md) |
| [8.95 Kanta PHR - Insulin dosage optional](MedicationAdministration-a4d97476-39fa-46c6-bf2e-1fb153a7bbe3.md) |
| [8.96 Kanta PHR - MET measurement mandatory](Observation-48983b8b-ead3-4206-9583-fcdd40d762b6.md) |
| [8.97 Kanta PHR - MET measurement optional](Observation-48983b8b-ead3-4206-9583-fcdd40d762b7.md) |
| [8.98 Kanta PHR - patient 3](Patient-36749a02-1710-44e7-aa76-0e934eb7860a.md) |
| [8.99 Kanta PHR - physical activity mandatory](Observation-mtvpa-min.md) |
| [8.100 Kanta PHR - physical activity optional](Observation-mtvpa-max.md) |
| [8.101 Kanta PHR - step count mandatory](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f8.md) |
| [8.102 Kanta PHR - step count optional](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f9.md) |
| [8.103 Karen van der Hentenryck](Patient-patientesim1.md) |
| [8.104 Lars van der Knaapi](Practitioner-practitioneresim1.md) |
| [8.105 Licenced physician](Practitioner-practitioner-licensed-physician.md) |
| [8.106 Licenced physician in primary care](PractitionerRole-PractitionerRoleGP.md) |
| [8.107 Lääke tauolla 1.3.2020 - 30.6.2020. Taukoa edeltävä annostus: 25 mg klo 08:00 10 päivän ajan ihon alle](MedicationRequest-medicationrequestesim6.md) |
| [8.108 Maanantaisin 1 tabletti ja tarvittaessa keskiviikkoisin 0,5 tablettia 01.06.2020 - 31.12.2020](MedicationRequest-medicationrequestesim5.md) |
| [8.109 MedicationAdministration example of insulin basal dose](MedicationAdministration-medication-administration-insulin-basal-dose-kanta-stu3-sv.md) |
| [8.110 MedicationAdministration example of insulin dose](MedicationAdministration-medication-administration-insulin-bolus-dose-fi.md) |
| [8.111 MedicationAdministration example of temporary basal rate](MedicationAdministration-medication-administration-insulin-dose-temp-basal-rate-kanta-en.md) |
| [8.112 Myyntiluvallinen lääkevalmiste](Medication-medicationesim1.md) |
| [8.113 Myyntiluvallinen lääkevalmiste, joka on PKV-lääke](Medication-medicationesim2.md) |
| [8.114 Organization - example of a parent organization](Organization-1.2.246.10.2085212.10.1306.md) |
| [8.115 Organization - example primary care organization](Organization-1.2.246.10.2085212.10.1314.md) |
| [8.116 Outpatient clinic](Location-LocationExample.md) |
| [8.117 Patient - with the MunicipalityCode extension.](Patient-patient-of-municipality.md) |
| [8.118 Patient generated glucose observations and insulin administrations as a bundle, in English](Bundle-diabetes-data-bundle-kantaphr-r4-en.md) |
| [8.119 Patient generated glucose observations and insulin administrations as a bundle, in Finnish](Bundle-diabetes-data-bundle.md) |
| [8.120 Patient generated glucose observations and insulin administrations as a bundle, in Swedish](Bundle-diabetes-data-bundle-kantaphr-sv.md) |
| [8.121 Patient with a TURVAKIELTO security label.](Patient-patient-with-turvakielto.md) |
| [8.122 Procedure Colotomy example](Procedure-ProcedureColotomy.md) |
| [8.123 Provenance example for Kanta](Provenance-custodian-public-healthcare-kela.md) |
| [8.124 Provenance example with registy information in reason field](Provenance-ESE-289490.md) |
| [8.125 Simple medication statement example](MedicationStatement-medication-statement-insulin.md) |
| [8.126 Simple Organization example](Organization-organizationesim2.md) |
| [8.127 SNOMED CT coded Schedule](Schedule-ScheduleExample.md) |
| [8.128 Tarvittaessa 1-2 tippaa 3-4 tunnin välein](MedicationRequest-medicationrequestesim9.md) |
| [8.129 Tarvittaessa 2 tablettia 3 kertaa viikossa 16.2.2021 alkaen](MedicationRequest-medicationrequestesim8.md) |
| [8.130 Testi terveysasema](Organization-organizationesim1.md) |
| [8.131 Vaccination for TBE](Immunization-ImmunizationVaccinationExample.md) |
| [8.132 A dummy patient entry](Patient-bb13623e-2673-4b3e-85d6-5c42f5333cde.md) |
| [8.133 A dummy patient entry](Patient-daf8ca40-b46c-4c6b-99d5-d3a1b77074ad.md) |
| [8.134 A dummy patient entry](Patient-f1fa0b52-eccf-44af-96c7-84a3251bb22c.md) |
| [8.135 A dummy patient entry](Patient-25a53703-27f9-4354-8f1b-a8b2f8f3ee86.md) |
| [8.136 A dummy patient entry](Patient-36749a02-1710-44e7-aa76-0e934eb4321a.md) |
| [8.137 A dummy patient entry](Patient-7257379.md) |
| [8.138 A dummy patient entry](Patient-cafbe8e7-38fe-4807-b995-6770e5390365.md) |
| [8.139 A dummy patient entry](Patient-77c2c8d2-11ce-41d5-8150-75489f8b0b0a.md) |
| [8.140 Parameters for Terminology selection of Finnish edition of SNOMED CT](Parameters-exp-params.md) |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

