# Profiles - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* **Profiles**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

## Profiles

* [Global Profiles](#global-profiles)
* [Finnish Base Profiles](#finnish-base-profiles)
* [Other Finnish Profiles](#other-finnish-profiles)

Profiles set additional constraints for the FHIR base resources and help tighter interoperability between systems. Read more in the [Profiling](https://hl7.org/fhir/profiling.html) section of the FHIR specification.

### Global Profiles

*There are no Global profiles defined*

### Finnish Base Profiles

This is the list of base profiles for FHIR resources for use in Finland, published and maintained by HL7 Finland.

* This is the Finnish base profile for the Appointment resource.
* This is the Finnish base profile for the Condition resource.
* This is the Finnish base profile for the Encounter resource.
* This is the Finnish base profile for the EpisodeOfCare resource.
* This is the Finnish base profile for the HealthcareService resource.
* This is a base profile for Finnish Immunization resource.
* This is the Finnish base profile for the Provenance resource, used to communicate an individual practitioner as the custodian of information (*rekisterinpitäjä*).
* This is the Finnish base profile for the Provenance resource, used to communicate a private organization as the custodian of information (*rekisterinpitäjä*).
* This is the Finnish base profile for the Provenance resource, used to communicate a public organization as the custodian of information (*rekisterinpitäjä*).
* This is a Finnish abstract base profile for the Provenance resource, used to communicate the custodian of information (*rekisterinpitäjä*).
* This is the Finnish base profile for the Location resource.
* This is the Finnish base profile for the MedicationAdministration resource.
* This is the Finnish base profile for the MedicationRequest resource, for other than patient access use cases.
* This is the Finnish base profile for the MedicationStatement resource.
* This is the Finnish base profile for the Medication resource for other than patient access use cases.
* This is the Finnish base profile for the Observation resource.
* This is the Finnish base profile for the Organization resource.
* This is the Finnish base profile for the Patient resource.
* This is the Finnish base profile for the PractitionerRole resource.
* This is the Finnish base profile for the Practitioner resource.
* The Base profile for Finnish Procedure resource.
* This is the Finnish base profile for the Provenance resource.
* This is the Finnish base profile for the encounter-diagnosis and (nurse asserted) reason for visit Conditions.
* This is the Finnish base profile for the Schedule resource.
* This is the Finnish base profile for the Slot resource.

### Other Finnish Profiles

There are other, more use case specific profiles defined in other implementation guides. For instance:

* The [Finnish Scheduling](https://hl7.fi/fhir/finnish-scheduling/) IG for scheduling
* The [Finnish SMART App Launch](https://hl7.fi/fhir/finnish-scheduling/) IG for patient-facing apps and for provider-facing apps specific to a patient
* Both the [Finnish PHR STU3](https://simplifier.net/FinnishPHR) and the [Finnish PHR R4](https://simplifier.net/FinnishPHRR4) for health and wellbeing data in the national Personal Health Record platform Kanta PHR
* The [Kanta FHIR Prescription R4](https://simplifier.net/PrescriptionR4) for prescriptions
* The [Kanta sosiaalihuolto R4](https://simplifier.net/Kanta-sosiaalihuolto-R4) for welfare and social affairs

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

