# Extensions - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* **Extensions**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

## Extensions

* [Extensions for Finnish Base Profiles](#extensions-for-finnish-base-profiles)
* [Extensions in other Finnish Implementation Guides](#extensions-in-other-finnish-implementation-guides)
* [Other Extensions](#other-extensions)

The primary way to adapt the FHIR specification to specific requirements of a jurisdiction is through [extensions](http://hl7.org/fhir/R4/extensibility.html).

### Extensions for Finnish Base Profiles

This list includes the extensions for base profiles defined by HL7 Finland.

* The extension indicates the end date of the delay, i.e. the first day when the delayed appointment information can be displayed (e.g Omakanta) / **Laajennuksella ilmoitetaan viivästämisen päättymispäivä eli ensimmäinen päivä, jolloin viivästetty asiakirja voidaan näyttää (esim. Omakannassa)**.
* The extension informs, using the THL - Release of minor's patient information to guardians classification, whether guardians have the right to see their minor child's appointment information (e.g. in Omakanta) and whether the disclosure of appointment information to them is permitted in healthcare services. / **Laajennuksella ilmoitetaan THL - Alaikäisen potilastietojen luovuttaminen huoltajille -luokitusta käyttäen, onko huoltajilla oikeus nähdä alaikäisen lapsensa ajanvaraustiedot (esim. Omakannassa) ja onko ajanvaraustietojen luovuttaminen heille sallittu terveydenhuollon palveluissa**.
* Encoded categorization of the type of accident leading to injury, illness or death.
* Encoded information on the cause of an adverse effect, when involving a procedure or medication
* Encoded information of medication that caused this condition. Uses ATC-coding.
* Code for Endocrinological disorder.
* External cause for diagnosis.
* Encoded information of whether this is the permanent.
* Encoded information of the type of physical exercise during which injury occurred.
* Encoded information of whether this is the primary/main condition for encounter.
* Extension for home municipality. Home municipality is relevant for ex. in billing and listing available healthcare services, and for statistical purposes. It it not necessarily the place where a patient lives, rather closer to where they pay their taxes.
* Extension for presenting patient profession.
* Extension for service event id (**palvelutapahtuman tunniste**).
* Vaccination recorder may not be the same person who performed the addministration.

### Extensions in other Finnish Implementation Guides

There are other, more use case specific extensions defined in other implementation guides. For instance:

* The [Finnish Scheduling](https://hl7.fi/fhir/finnish-scheduling/) IG for scheduling
* Both the [Finnish PHR STU3](https://simplifier.net/FinnishPHR) and the [Finnish PHR R4](https://simplifier.net/FinnishPHRR4) for health and wellbeing data in the national Personal Health Record platform Kanta PHR
* The [Kanta FHIR Prescription R4](https://simplifier.net/PrescriptionR4) for prescriptions
* The [Kanta sosiaalihuolto R4](https://simplifier.net/Kanta-sosiaalihuolto-R4) for welfare and social affairs

### Other Extensions

In addition to above, a [registry of standard extensions](http://hl7.org/fhir/R4/extensibility-registry.html) can be found in the FHIR specification and additional extensions may be registered on the HL7 FHIR registry at [http://hl7.org/fhir/registry](http://hl7.org/fhir/registry).

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

