# Downloads - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* **Downloads**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

## Downloads

* [This Implementation Guide](#this-implementation-guide)
* [NPM Package](#npm-package)
* [Resources](#resources)
* [Examples](#examples)
* [FHIR Tools](#fhir-tools)

Download automatically generated assets for offline use.

### This Implementation Guide

This full IG as a single package:

* [full-ig.zip](full-ig.zip)

The ImplementationGuide resource:

* Javascript Object Notation (JSON) format: [ImplementationGuide-hl7.fhir.fi.base.json](ImplementationGuide-hl7.fhir.fi.base.json)
* Terse RDF Triple Language (TTL) format: [ImplementationGuide-hl7.fhir.fi.base.ttl](ImplementationGuide-hl7.fhir.fi.base.ttl)
* Extensible Markup Language (XML) format: [ImplementationGuide-hl7.fhir.fi.base.xml](ImplementationGuide-hl7.fhir.fi.base.xml)

### NPM Package

Profiles, valuesets, examples, and other assets used in this IG in npm format:

* FHIR version R4 [package.tgz](package.tgz)
* FHIR version R4B [package.r4b.tgz](package.r4b.tgz)

### Resources

Profiles, valuesets, and other definitions included in this IG in different file formats:

* Comma separated values (CSV) format: [csvs.zip](csvs.zip)
* Excel spreadsheet files: [excels.zip](excels.zip)
* Schematron XML validation language: [schematrons.zip](schematrons.zip)

OpenAPI (a.k.a. Swagger) Definition Files of all Profiles and Extensions:

* Javascript Object Notation (JSON) format: [definitions.json.zip](definitions.json.zip)
* Terse RDF Triple Language (TTL) format: [definitions.ttl.zip](definitions.ttl.zip)
* Extensible Markup Language (XML) format: [definitions.xml.zip](definitions.xml.zip)

### Examples

All example files included in this IG in different file formats:

* JSON [examples.json.zip](examples.json.zip)
* TTL [examples.ttl.zip](examples.ttl.zip)
* XML [examples.xml.zip](examples.xml.zip)

### FHIR Tools

For generic FHIR tools, frameworks, and supported programming languages, see [https://hl7.org/fhir/downloads.html](https://hl7.org/fhir/downloads.html)

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

