# Example value set for provenance roles - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example value set for provenance roles**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-kanta-provenance-agent-role.xml.md) 
*  [JSON](ValueSet-kanta-provenance-agent-role.json.md) 
*  [TTL](ValueSet-kanta-provenance-agent-role.ttl.md) 

## ValueSet: Example value set for provenance roles 

| | |
| :--- | :--- |
| *Official URL*:http://gen.kanta.fi/kanta-provenance-agent-role | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*: |

 
This example value set contains the systems that can be used for agent roles in Kanta profiles 

 **References** 

* [An imaginary profile for Kanta system, specifying things apart from the information custodian](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-kanta-document-other-metadata-profile.html)
* [An imaginary profile for Kanta system, specifying things apart from the information custodian](StructureDefinition-kanta-document-other-metadata-profile.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include these codes as defined in `urn:ietf:rfc:3986` version Not Stated (use latest from terminology server)
* Include these codes as defined in `urn:ietf:rfc:3986` version Not Stated (use latest from terminology server) 

 

### Expansion

Expansion from tx.fhir.org based on codesystem unknown version n/a

This value set expansion contains 2 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

