# An imaginary profile for Kanta system, specifying things apart from the information custodian - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **An imaginary profile for Kanta system, specifying things apart from the information custodian**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-kanta-document-other-metadata-profile-definitions.md) 
*  [Mappings](StructureDefinition-kanta-document-other-metadata-profile-mappings.md) 
*  [XML](StructureDefinition-kanta-document-other-metadata-profile.profile.xml.md) 
*  [JSON](StructureDefinition-kanta-document-other-metadata-profile.profile.json.md) 
*  [TTL](StructureDefinition-kanta-document-other-metadata-profile.profile.ttl.md) 

## Resource Profile: An imaginary profile for Kanta system, specifying things apart from the information custodian 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/kanta-document-other-metadata-profile | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:KantaDocumentOtherMetadata |

 
This is one way in which a system might use the Finnish Base Information Custodian profile. This profile defines other constraints. The profile KantaDocumentMetadata combines the requirements. 

**Usages:**

* Impose this profile Profile: [An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile](StructureDefinition-kanta-document-metadata-profile.md) and [An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-kanta-document-metadata-profile.html)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/kanta-document-other-metadata-profile)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

**Summary**

Mandatory: 2 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Provenance.agent.role

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

**Summary**

Mandatory: 2 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Provenance.agent.role

 

Other representations of profile: [CSV](StructureDefinition-kanta-document-other-metadata-profile.csv), [Excel](StructureDefinition-kanta-document-other-metadata-profile.xlsx), [Schematron](StructureDefinition-kanta-document-other-metadata-profile.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

