# An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-kanta-document-metadata-profile-definitions.md) 
*  [Mappings](StructureDefinition-kanta-document-metadata-profile-mappings.md) 
*  [Examples](StructureDefinition-kanta-document-metadata-profile-examples.md) 
*  [XML](StructureDefinition-kanta-document-metadata-profile.profile.xml.md) 
*  [JSON](StructureDefinition-kanta-document-metadata-profile.profile.json.md) 
*  [TTL](StructureDefinition-kanta-document-metadata-profile.profile.ttl.md) 

## Resource Profile: An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/kanta-document-metadata-profile | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:KantaDocumentMetadata |

 
This is one way in which a system might use the Finnish Base Information Custodian profile. Kanta has expressed the wish to have only one big Provenance resource containing all document metadata. This can be accomplished by creating a profile based on the Finnish Base Provenance profile and[imposing](http://hl7.org/fhir/extensions/StructureDefinition-structuredefinition-imposeProfile.html)the Finnish Base Information Custodian profile. 

**Usages:**

* Examples for this Profile: [Provenance/kanta-document-metadata-profile-example-2](Provenance-kanta-document-metadata-profile-example-2.md), [Provenance/kanta-document-metadata-profile-example](Provenance-kanta-document-metadata-profile-example.md), [Provenance/kanta-document-metadata-profile-test-example-1](Provenance-kanta-document-metadata-profile-test-example-1.md) and [Provenance/kanta-document-metadata-profile-test-example-2](Provenance-kanta-document-metadata-profile-test-example-2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/kanta-document-metadata-profile)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

**Summary**

 **Key Elements View** 

#### Constraints

 **Differential View** 

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseProvenance](StructureDefinition-fi-base-provenance.md) 

**Summary**

 

Other representations of profile: [CSV](StructureDefinition-kanta-document-metadata-profile.csv), [Excel](StructureDefinition-kanta-document-metadata-profile.xlsx), [Schematron](StructureDefinition-kanta-document-metadata-profile.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

