# FI Base Provenance - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Provenance**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-provenance-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-provenance-mappings.md) 
*  [XML](StructureDefinition-fi-base-provenance.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-provenance.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-provenance.profile.ttl.md) 

## Resource Profile: FI Base Provenance 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-provenance | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseProvenance |

 
This is the Finnish base profile for the Provenance resource. 

**Usages:**

* Derived from this Profile: [FI Base InformationCustodian](StructureDefinition-fi-base-information-custodian.md), [An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile](StructureDefinition-kanta-document-metadata-profile.md), [An imaginary profile for Kanta system, specifying things apart from the information custodian](StructureDefinition-kanta-document-other-metadata-profile.md), [FI Base InformationCustodian](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-information-custodian.html)...Show 2 more,[An imaginary profile for Kanta system, utilizing the Finnish Base Information Custodian profile](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-kanta-document-metadata-profile.html)and[An imaginary profile for Kanta system, specifying things apart from the information custodian](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-kanta-document-other-metadata-profile.html)
* Refer to this Profile: [FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md), [FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md), [FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html), [FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html) and [FI Base Patient MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication-request.html)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-provenance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Constraints

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)

 **Key Elements View** 

#### Constraints

 **Differential View** 

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-provenance.csv), [Excel](StructureDefinition-fi-base-provenance.xlsx), [Schematron](StructureDefinition-fi-base-provenance.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

