# Fi Base Procedure - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Fi Base Procedure**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-procedure-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-procedure-mappings.md) 
*  [Examples](StructureDefinition-fi-base-procedure-examples.md) 
*  [XML](StructureDefinition-fi-base-procedure.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-procedure.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-procedure.profile.ttl.md) 

## Resource Profile: Fi Base Procedure 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseProcedure |

 
The Base profile for Finnish Procedure resource. 

### Scope and Usage

This profile sets minimum expectations for the Procedure resource to search and fetch current or historical procedures performed on or for a patient. It identifies which elements, code systems and value sets SHALL be present in the resource when using this profile.

#### Main procedure and sub-procedures

In many cases more than one procedure are being performed during one encounter. Usually this means that one of the procedures is the main procedure and others are sub-procedures. Latter ones could be performed in supporting or assisting purpose (e.g. Anaesthesia) or their task is to describe how the main procedure was performed (e.g. using robot for performing the procedure). This conjunction between different procedures is done by using `partOf` reference. The main procedure does not have `partOf` reference. Examples of this can be found from [Examples](./examples.md#Procedure) page.

#### Code systems

Code systems that are associated with this profile are listed in a table below. It is not required to use these code systems in every situation, but rather to choose correct code systems depending on a use case if nessecary. Some explanation of using these code systems can be found from the website behind the link. The Use column descripes the element in which that particular code system can be used in Procedure resource.

| | | | |
| :--- | :--- | :--- | :--- |
| THL - toimenpideluokitus | 1.2.246.537.6.2.2007 | [https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=57&versionKey=119](https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=57&versionKey=119) | `Procedure.code` |
| THL - Suun terveydenhuollon toimenpideluokitus | 1.2.246.537.6.33 | [https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=58&versionKey=79](https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=58&versionKey=79) | `Procedure.code` |
| AR/YDIN - Toimenpiteen tyyppi | 1.2.246.537.6.601 | [https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=763&versionKey=903](https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=763&versionKey=903) | `Procedure.code` |
| Kuntaliitto - Radiologinen tutkimus- ja toimenpideluokitus | 1.2.246.537.6.4 | [https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=44&versionKey=118](https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=44&versionKey=118) | `Procedure.code` |

> **NOTE:**While writing this profile SNOMED code system is not widely used in Finland since adopting the code system is still in progess. More information about the subject can be found on[Terminology](./terminology.md#snomed-ct)page. Nevertheless SNOMED codes SHOULD be used if possible in a faced use case.THL toimenpideluokitus is based on[Nordic Classification of Surgical Procedures](https://norden.diva-portal.org/smash/get/diva2:970547/FULLTEXT01.pdf)(NCSP).

**Usages:**

* Refer to this Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md), [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md), [FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md)...Show 8 more,[FI Base Observation](StructureDefinition-fi-base-observation.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Appointment](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-appointment.html),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html),[FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html)and[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html)
* Examples for this Profile: [Procedure/ColonBiopsy](Procedure-ColonBiopsy.md) and [Procedure/ProcedureColotomy](Procedure-ProcedureColotomy.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-procedure)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base MedicationAdministration(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-administration)](StructureDefinition-fi-base-medication-administration.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Medication(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication)](StructureDefinition-fi-base-medication.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base MedicationAdministration(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-administration)](StructureDefinition-fi-base-medication-administration.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Medication(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication)](StructureDefinition-fi-base-medication.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-procedure.csv), [Excel](StructureDefinition-fi-base-procedure.xlsx), [Schematron](StructureDefinition-fi-base-procedure.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

