# FI Base Practitioner - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Practitioner**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-practitioner-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-practitioner-mappings.md) 
*  [Examples](StructureDefinition-fi-base-practitioner-examples.md) 
*  [XML](StructureDefinition-fi-base-practitioner.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-practitioner.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-practitioner.profile.ttl.md) 

## Resource Profile: FI Base Practitioner 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBasePractitioner |

 
This is the Finnish base profile for the Practitioner resource. 

**Usages:**

* Refer to this Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md), [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [FI Base EpisodeOfCare](StructureDefinition-fi-base-episode-of-care.md), [Fi Base Immunization](StructureDefinition-fi-base-immunization.md)...Show 25 more,[FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md),[FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md),[FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md),[FI Base Observation](StructureDefinition-fi-base-observation.md),[FI Base Patient](StructureDefinition-fi-base-patient.md),[FI Base PractitionerRole](StructureDefinition-fi-base-practitioner-role.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Provenance](StructureDefinition-fi-base-provenance.md),[FI Base Schedule](StructureDefinition-fi-base-schedule.md),[Vaccination Recorder](StructureDefinition-vaccination-recorder.md),[FI Base Appointment](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-appointment.html),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[FI Base EpisodeOfCare](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-episode-of-care.html),[Fi Base Immunization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-immunization.html),[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html),[FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html),[FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html),[FI Base Patient MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication-request.html),[FI Base Patient](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient.html),[FI Base PractitionerRole](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-practitioner-role.html),[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html),[FI Base Provenance](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-provenance.html),[FI Base Schedule](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-schedule.html)and[Vaccination Recorder](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-vaccination-recorder.html)
* Examples for this Profile: [Practitioner/practitioner-licensed-physician](Practitioner-practitioner-licensed-physician.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

**Summary**

Mandatory: 0 element(3 nested mandatory elements)

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Practitioner.identifier

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

**Summary**

Mandatory: 0 element(3 nested mandatory elements)

**Structures**

This structure refers to these other structures:

* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Practitioner.identifier

 

Other representations of profile: [CSV](StructureDefinition-fi-base-practitioner.csv), [Excel](StructureDefinition-fi-base-practitioner.xlsx), [Schematron](StructureDefinition-fi-base-practitioner.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

