# FI Base Observation - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Observation**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-observation-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-observation-mappings.md) 
*  [Examples](StructureDefinition-fi-base-observation-examples.md) 
*  [XML](StructureDefinition-fi-base-observation.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-observation.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-observation.profile.ttl.md) 

## Resource Profile: FI Base Observation 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseObservation |

 
This is the Finnish base profile for the Observation resource. 

### Scope and Usage

The FI Base Observation profile requires that references from the Observation resource to other resources are to resources that also conform to the Finnish Base Profiles.

This profile can be used to ensure greater compatibility, but it should not be expected that all Observations within the Finnish healthcare IT ecosystem conform to this profile.

**Usages:**

* Refer to this Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md), [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [Fi Base Immunization](StructureDefinition-fi-base-immunization.md), [FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md)...Show 13 more,[FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md),[FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md),[FI Base Observation](StructureDefinition-fi-base-observation.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Appointment](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-appointment.html),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[Fi Base Immunization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-immunization.html),[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html),[FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html),[FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html),[FI Base Patient MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication-request.html)and[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base MedicationRequest(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-request)](StructureDefinition-fi-base-medication-request.md)
* [FI Base MedicationAdministration(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-administration)](StructureDefinition-fi-base-medication-administration.md)
* [FI Base MedicationStatement(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-statement)](StructureDefinition-fi-base-medication-statement.md)
* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [Fi Base Immunization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-immunization)](StructureDefinition-fi-base-immunization.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base MedicationRequest(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-request)](StructureDefinition-fi-base-medication-request.md)
* [FI Base MedicationAdministration(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-administration)](StructureDefinition-fi-base-medication-administration.md)
* [FI Base MedicationStatement(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-medication-statement)](StructureDefinition-fi-base-medication-statement.md)
* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [Fi Base Immunization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-immunization)](StructureDefinition-fi-base-immunization.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-observation.csv), [Excel](StructureDefinition-fi-base-observation.xlsx), [Schematron](StructureDefinition-fi-base-observation.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

