# FI Base Observation - Examples - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Observation**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](StructureDefinition-fi-base-observation.md) 
*  [Detailed Descriptions](StructureDefinition-fi-base-observation-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-observation-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-fi-base-observation.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-observation.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-observation.profile.ttl.md) 

## Resource Profile: FiBaseObservation - Examples

| |
| :--- |
| Draft as of 2025-10-05 |

Examples for the fi-base-observation Profile.

| |
| :--- |
| [Patient generated glucose observations and insulin administrations as a bundle, in English](Bundle-diabetes-data-bundle-kantaphr-r4-en.md) |
| [Patient generated glucose observations and insulin administrations as a bundle, in Swedish](Bundle-diabetes-data-bundle-kantaphr-sv.md) |
| [Patient generated glucose observations and insulin administrations as a bundle, in Finnish](Bundle-diabetes-data-bundle.md) |
| [Kanta PHR - body height optional](Observation-1153859e-0c86-1000-abb8-511d0000b222.md) |
| [Kanta PHR - carbohydrate intake mandatory](Observation-2894b2e6-7ebf-4c33-93e4-31935effff21.md) |
| [Kanta PHR - carbohydrate intake optional](Observation-2894b2e6-7ebf-4c33-93e4-31935effff22.md) |
| [Kanta PHR - step count mandatory](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f8.md) |
| [Kanta PHR - step count optional](Observation-4137d1c4-1e87-4e86-8c15-344ad086e3f9.md) |
| [Kanta PHR - MET measurement mandatory](Observation-48983b8b-ead3-4206-9583-fcdd40d762b6.md) |
| [Kanta PHR - MET measurement optional](Observation-48983b8b-ead3-4206-9583-fcdd40d762b7.md) |
| [Kanta PHR - calorie intake mandatory](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f7.md) |
| [Kanta PHR - calorie intake optional](Observation-542ae72e-c3b0-404f-8c06-8f77441e89f8.md) |
| [Kanta PHR - exercise tracking mandatory](Observation-71831b54-1a80-47c5-ba84-0180a5eb784a.md) |
| [Kanta PHR - exercise tracking optional](Observation-71831b54-1a80-47c5-ba84-0180a5eb784b.md) |
| [Kanta PHR - blood glucose result as text](Observation-bloodglucose-as-text.md) |
| [Kanta PHR - blood glucose with data absent](Observation-bloodglucose-data-absent.md) |
| [Kanta PHR - blood glucose optional](Observation-bloodglucose-max.md) |
| [Kanta PHR - blood glucose mandatory](Observation-bloodglucose-min.md) |
| [Kanta PHR - blood pressure optional](Observation-bloodpressure-max.md) |
| [Kanta PHR - blood pressure mandatory](Observation-bloodpressure-min.md) |
| [Kanta PHR - body weight optional](Observation-bodyweight-max.md) |
| [Kanta PHR - body weight mandatory](Observation-bodyweight-min.md) |
| [Kanta PHR - physical activity optional](Observation-mtvpa-max.md) |
| [Kanta PHR - physical activity mandatory](Observation-mtvpa-min.md) |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

