# FI Base Information Custodian (Private Organization) - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Information Custodian (Private Organization)**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-information-custodian-private-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-information-custodian-private-mappings.md) 
*  [Examples](StructureDefinition-fi-base-information-custodian-private-examples.md) 
*  [XML](StructureDefinition-fi-base-information-custodian-private.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-information-custodian-private.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-information-custodian-private.profile.ttl.md) 

## Resource Profile: FI Base Information Custodian (Private Organization) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-information-custodian-private | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseInformationCustodianPrivate |

 
This is the Finnish base profile for the Provenance resource, used to communicate a private organization as the custodian of information (**rekisterinpitäjä**). 

**Usages:**

* Examples for this Profile: [Provenance/custodian-occupational-healthcare](Provenance-custodian-occupational-healthcare.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-information-custodian-private)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

**Summary**

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

**Summary**

 

Other representations of profile: [CSV](StructureDefinition-fi-base-information-custodian-private.csv), [Excel](StructureDefinition-fi-base-information-custodian-private.xlsx), [Schematron](StructureDefinition-fi-base-information-custodian-private.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

