# FI Base Information Custodian (Individual Provider) - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Information Custodian (Individual Provider)**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-information-custodian-individual-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-information-custodian-individual-mappings.md) 
*  [Examples](StructureDefinition-fi-base-information-custodian-individual-examples.md) 
*  [XML](StructureDefinition-fi-base-information-custodian-individual.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-information-custodian-individual.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-information-custodian-individual.profile.ttl.md) 

## Resource Profile: FI Base Information Custodian (Individual Provider) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-information-custodian-individual | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseInformationCustodianIndividual |

 
This is the Finnish base profile for the Provenance resource, used to communicate an individual practitioner as the custodian of information (**rekisterinpitäjä**). 

**Usages:**

* Examples for this Profile: [Provenance/custodian-individual](Provenance-custodian-individual.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-information-custodian-individual)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

**Summary**

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [FiBaseInformationCustodian](StructureDefinition-fi-base-information-custodian.md) 

**Summary**

 

Other representations of profile: [CSV](StructureDefinition-fi-base-information-custodian-individual.csv), [Excel](StructureDefinition-fi-base-information-custodian-individual.xlsx), [Schematron](StructureDefinition-fi-base-information-custodian-individual.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

