# Fi Base Immunization - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Fi Base Immunization**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-immunization-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-immunization-mappings.md) 
*  [Examples](StructureDefinition-fi-base-immunization-examples.md) 
*  [XML](StructureDefinition-fi-base-immunization.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-immunization.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-immunization.profile.ttl.md) 

## Resource Profile: Fi Base Immunization 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-immunization | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseImmunization |

 
This is a base profile for Finnish Immunization resource. 

### Scope and usage

This profile sets minimum expectations for the Immunization resource. It identifies which core elements, extensions, vocabularies, and value sets could be present in the resource when using this profile. It provides the floor for standards development for specific use cases.

#### Vaccination Recorder extension

In some cases the practitioner who performed the addministration is not be the same person who recorded the action. For these cases the vaccinationRecorder extension is created. Recorder is not required information when recording vaccination to the Kanta's Patient Data Repository or [Hilmo system](https://thl.fi/fi/tilastot-ja-data/ohjeet-tietojen-toimittamiseen/hoitoilmoitusjarjestelma-hilmo) but it may be an essential information for EHR.

#### Finnish National Vaccination Register

All vaccinations in Finland are recorded into Kanta's Patient Data Repository and Hilmo system. Eventually these system determine the required information, at least when recording vaccination. It is highly recommended to familiarize onself with the [specification](https://koodistopalvelu.kanta.fi/codeserver/pages/classification-view-page.xhtml?classificationKey=644&versionKey=1572) when applying this profile although all of the fields may not be relevant in given use case.

#### ATC and VNR codes

See also the terminology section of [Medication Codes](terminology.md#medication-codes) in this guide.

**Usages:**

* Refer to this Profile: [FI Base Observation](StructureDefinition-fi-base-observation.md) and [FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html)
* Examples for this Profile: [Immunization/ImmunizationVaccinationExample](Immunization-ImmunizationVaccinationExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-immunization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

**Summary**

Mandatory: 0 element(5 nested mandatory elements)

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)

**Extensions**

This structure refers to these extensions:

* [https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/vaccination-recorder](StructureDefinition-vaccination-recorder.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Immunization.vaccineCode.coding
* The element 1 is sliced based on the value of Immunization.site.coding
* The element 1 is sliced based on the value of Immunization.route.coding
* The element 1 is sliced based on the value of Immunization.protocolApplied.targetDisease.coding

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

**Summary**

Mandatory: 0 element(5 nested mandatory elements)

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)

**Extensions**

This structure refers to these extensions:

* [https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/vaccination-recorder](StructureDefinition-vaccination-recorder.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Immunization.vaccineCode.coding
* The element 1 is sliced based on the value of Immunization.site.coding
* The element 1 is sliced based on the value of Immunization.route.coding
* The element 1 is sliced based on the value of Immunization.protocolApplied.targetDisease.coding

 

Other representations of profile: [CSV](StructureDefinition-fi-base-immunization.csv), [Excel](StructureDefinition-fi-base-immunization.xlsx), [Schematron](StructureDefinition-fi-base-immunization.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

